/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.shr.base.syssetting.IBaseItemRelationHR;
import com.kingdee.shr.base.syssetting.PreBaseInfoOrgRefCollection;
import com.kingdee.shr.base.syssetting.PreBaseInfoOrgRefEnum;
import com.kingdee.shr.base.syssetting.PreBaseInfoOrgRefInfo;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.app.AbstractPreBaseInfoOrgRefControllerBean;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import org.apache.log4j.Logger;

public class PreBaseInfoOrgRefControllerBean
extends AbstractPreBaseInfoOrgRefControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.PreBaseInfoOrgRefControllerBean");

    @Override
    protected BatchMessageTipsHeader _disatributeBaseItems(Context ctx, String entityName, boolean isByShrBaseItemId) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("userId", (Object)HRFilterUtils.getCurrentUserId(ctx), CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseItemNumber"));
        selector.add(new SelectorItemInfo("baseItemName"));
        selector.add(new SelectorItemInfo("shrBaseItemId"));
        selector.add(new SelectorItemInfo("useHrOrgUnit.id"));
        selector.add(new SelectorItemInfo("useHrOrgUnit.name"));
        selector.add(new SelectorItemInfo("useHrOrgUnit.number"));
        selector.add(new SelectorItemInfo("resultDesc"));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("shrBaseItemId"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(selector);
        view.setSorter(sorter);
        PreBaseInfoOrgRefCollection coll = this.getPreBaseInfoOrgRefCollection(ctx, view);
        int success = 0;
        int failure = 0;
        BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
        String billId = "";
        if (null != coll && coll.size() > 0) {
            SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
            IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, shrBasicItemInfo);
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                PreBaseInfoOrgRefInfo model = coll.get(i);
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                body.setId(model.getShrBaseItemId());
                if (isByShrBaseItemId) {
                    iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, model.getShrBaseItemId());
                }
                if (PreBaseInfoOrgRefEnum.ALLOW_DIASTRIBUTE.equals((Object)model.getResultDesc())) {
                    iBaseItemRelationHR.saveByBaseIdAndHRBUId(model.getShrBaseItemId(), model.getUseHrOrgUnit().getId().toString(), 100);
                    ++success;
                    body.setMuitTipsState(Boolean.TRUE);
                    body.setMuitTipsMessage(SHRSysSettingResourceUtil.getResource("baseitem_distribute_success", ctx, model.getBaseItemName(), model.getUseHrOrgUnit().getName()));
                } else {
                    ++failure;
                    body.setMuitTipsState(Boolean.FALSE);
                    body.setMuitTipsMessage(SHRSysSettingResourceUtil.getResource("baseitem_distribute_fail", ctx, model.getBaseItemName(), model.getUseHrOrgUnit().getName()));
                }
                batchMessageTipsHeader.addResult(body);
                if (i > 0) {
                    billId = billId + ",";
                }
                billId = billId + model.getShrBaseItemId();
            }
        }
        batchMessageTipsHeader.setBillId(billId);
        batchMessageTipsHeader.setFailureCount(failure);
        batchMessageTipsHeader.setSuccessCount(success);
        return batchMessageTipsHeader;
    }

    @Override
    protected void _saveByBaseItemAndHROIds(Context ctx, String[] shrBaseItemIds, String[] hrOrgUnitIds, String entityName, boolean isByShrBaseItemId) throws BOSException, EASBizException {
        if (null == shrBaseItemIds || null == hrOrgUnitIds || shrBaseItemIds.length <= 0 || hrOrgUnitIds.length <= 0) {
            return;
        }
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
        LinkPropertyInfo relationProperty = SysSettingSHRBasicItemUtil.getRelationProperty(ctx, shrBasicItemInfo);
        IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHRByEntityName(ctx, shrBasicItemInfo.getRelationHREntity());
        int total = shrBaseItemIds.length;
        for (int i = 0; i < total; ++i) {
            int subTotal = hrOrgUnitIds.length;
            for (int j = 0; j < subTotal; ++j) {
                this.savePreBaseInfoOrgRef(ctx, shrBaseItemIds[i], hrOrgUnitIds[j], iBaseItemRelationHR, isByShrBaseItemId, relationProperty);
            }
        }
    }

    private void savePreBaseInfoOrgRef(Context ctx, String shrBaseItemId, String hrOrgUnitId, IBaseItemRelationHR iBaseItemRelationHR, boolean isByShrBaseItemId, LinkPropertyInfo relationProperty) throws BOSException, EASBizException {
        SHRBaseItemInfo shrBaseItemInfo = null;
        if (relationProperty == null) {
            shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, shrBaseItemId);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo(relationProperty.getName() + ".*"));
            shrBaseItemInfo = SysSettingSHRBaseItemUtil.getSHRBaseItemInfo(ctx, shrBaseItemId, selector);
        }
        HROrgUnitInfo hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitId));
        PreBaseInfoOrgRefEnum preBaseInfoOrgRefEnum = PreBaseInfoOrgRefEnum.getEnum(10);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("baseInfoId", (Object)shrBaseItemId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)hrOrgUnitId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)100, CompareType.EQUALS));
        IBaseItemRelationHR newIBaseItemRelationHR = null;
        if (isByShrBaseItemId) {
            newIBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, shrBaseItemId);
            if (newIBaseItemRelationHR.exists(filter)) {
                preBaseInfoOrgRefEnum = PreBaseInfoOrgRefEnum.getEnum(20);
            }
        } else if (iBaseItemRelationHR.exists(filter)) {
            preBaseInfoOrgRefEnum = PreBaseInfoOrgRefEnum.getEnum(20);
        }
        PreBaseInfoOrgRefInfo model = new PreBaseInfoOrgRefInfo();
        if (relationProperty == null) {
            model.setBaseItemNumber(shrBaseItemInfo.getNumber());
            model.setBaseItemName(shrBaseItemInfo.getName());
        } else {
            DataBaseInfo d = (DataBaseInfo)shrBaseItemInfo.get(relationProperty.getName().toLowerCase());
            model.setBaseItemNumber(d.getNumber());
            model.setBaseItemName(d.getName());
        }
        model.setShrBaseItemId(shrBaseItemId);
        model.setCreateHrOrgUnit(shrBaseItemInfo.getHrOrgUnit());
        model.setUseHrOrgUnit(hrOrgUnitInfo);
        model.setResultDesc(preBaseInfoOrgRefEnum);
        model.setUserId(HRFilterUtils.getCurrentUserId(ctx));
        this.save(ctx, (CoreBaseInfo)model);
    }
}

