/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseDataChangeType;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemReviseFactory;
import com.kingdee.shr.base.syssetting.BaseItemReviseInfo;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.HandleState;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.app.AbstractSHRBaseItemControllerBean;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.BaseInfoChangeUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHRBaseItemControllerBean
extends AbstractSHRBaseItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.SHRBaseItemControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SHRBaseItemInfo model = null;
        try {
            model = this.getSHRBaseItemInfo(ctx, (IObjectPK)pk, this.getShrBaseItemSelector());
        }
        catch (ObjectNotFoundException e) {
            throw new BaseItemException(BaseItemException.BASEITEM_DELETE_ENABLE_FAIL);
        }
        this.doState(ctx, model, BaseItemStateEnum.ENABLE);
        model.setState(BaseItemStateEnum.ENABLE);
        this._enableOrgRefBaseInfo(ctx, (IObjectValue)model);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id);
        SHRBaseItemInfo model = null;
        try {
            model = this.getSHRBaseItemInfo(ctx, (IObjectPK)pk, this.getShrBaseItemSelector());
        }
        catch (ObjectNotFoundException e) {
            throw new BaseItemException(BaseItemException.BASEITEM_DELETE_DISABLE_FAIL);
        }
        this.doState(ctx, model, BaseItemStateEnum.DISABLE);
        model.setState(BaseItemStateEnum.DISABLE);
        this._disableOrgRefBaseInfo(ctx, (IObjectValue)model);
    }

    private SelectorItemCollection getShrBaseItemSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("shrBasicItem.id"));
        selector.add(new SelectorItemInfo("usePolicy"));
        selector.add(new SelectorItemInfo("isSysPreset"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.number"));
        selector.add(new SelectorItemInfo("hrOrgUnit.name"));
        return selector;
    }

    private void doState(Context ctx, SHRBaseItemInfo model, BaseItemStateEnum state) throws BOSException, EASBizException {
        if (null == model) {
            throw new BaseItemException(BaseItemException.NO_SUCH_BASEITEM);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && !BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_ENABLED_CAN_DISABLE);
        }
        if (BaseItemStateEnum.ENABLE.equals((Object)state) && BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_OTHER_CAN_ENABLE);
        }
        if (null == model.getHrOrgUnit() || StringUtils.isEmpty((String)model.getHrOrgUnit().getNumber())) {
            throw new BaseItemException(BaseItemException.BIZORG_NOT_EXIST);
        }
        SHRBaseItemInfo updateModel = new SHRBaseItemInfo();
        updateModel.setId(model.getId());
        updateModel.setState(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, (CoreBaseInfo)updateModel, selector);
    }

    @Override
    protected IObjectPK[] _beforeDeleteOperation(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo model = (SHRBaseItemInfo)shrBaseItem;
        if (null == model) {
            throw new BaseItemException(BaseItemException.NO_SUCH_BASEITEM);
        }
        if (model.isIsSysPreset()) {
            throw new BaseItemException(BaseItemException.DEFAULT_NOT_DELETE, new Object[]{model.getNumber()});
        }
        IObjectPK[] baseInfoOrgRefPK = null;
        if (BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_UNENABLE_CAN_DELETE);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)model.getState())) {
            throw new BaseItemException(BaseItemException.ONLY_UNENABLE_CAN_DELETE);
        }
        return baseInfoOrgRefPK;
    }

    @Override
    protected void _enableOrgRefBaseInfo(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        this.doOrgRefBaseInfoState(ctx, shrBaseItem);
    }

    @Override
    protected void _disableOrgRefBaseInfo(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        this.doOrgRefBaseInfoState(ctx, shrBaseItem);
    }

    private void doOrgRefBaseInfoState(Context ctx, IObjectValue shrBaseItem) throws EASBizException, BOSException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)shrBaseItem;
        IObjectPK baseInfoChangePK = BaseInfoChangeUtil.addBaseInfoChangeInfo(ctx, newModel.getId().toString(), newModel.getHrOrgUnit().getId().toString(), BaseDataChangeType.HRORG, HandleState.DOING, newModel.getUsePolicy());
        BaseInfoChangeUtil.handlerBaseInfoOrgRefState(ctx, baseInfoChangePK, newModel.getState());
    }

    @Override
    protected IObjectPK _beforeSaveOperation(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)shrBaseItem;
        IObjectPK baseInfoChangePK = null;
        if (null != newModel.getId()) {
            SHRBaseItemInfo oldModel = this.getSHRBaseItemInfo(ctx, (IObjectPK)new ObjectUuidPK(newModel.getId()));
            if (!BaseItemStateEnum.NEW.equals((Object)newModel.getState()) && !newModel.getUsePolicy().equals((Object)oldModel.getUsePolicy())) {
                baseInfoChangePK = BaseInfoChangeUtil.addBaseInfoChangeInfo(ctx, newModel.getId().toString(), newModel.getHrOrgUnit().getId().toString(), BaseDataChangeType.HRORG, HandleState.DOING, oldModel.getUsePolicy());
            }
        }
        return baseInfoChangePK;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)model;
        boolean isAddNew = null == newModel.getId();
        this._verifyData(ctx, model);
        IObjectPK shrBaseItemPK = null;
        IObjectPK[] baseInfoOrgRefPKs = null;
        IObjectPK baseInfoChangePK = null;
        if (BaseItemStateEnum.NEW.equals((Object)newModel.getState())) {
            shrBaseItemPK = super._save(ctx, model);
        } else {
            baseInfoChangePK = this._beforeSaveOperation(ctx, model);
            shrBaseItemPK = super._save(ctx, model);
            if (BaseItemStateEnum.ENABLE.equals((Object)newModel.getState())) {
                if (null != baseInfoChangePK) {
                    baseInfoOrgRefPKs = this._updateSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                } else if (isAddNew && null != (baseInfoChangePK = this._afterSaveOperation(ctx, shrBaseItemPK.toString(), model))) {
                    baseInfoOrgRefPKs = this._addSHRBaseItemToOrgRef(ctx, baseInfoChangePK);
                }
            }
        }
        SHRBaseItemInfo shrBaseItemPKmodel = this.getSHRBaseItemInfo(ctx, shrBaseItemPK);
        if (null != model.get("customFields")) {
            shrBaseItemPKmodel.put("customFields", model.get("customFields"));
        }
        this._writeReviseLog(ctx, (IObjectValue)shrBaseItemPKmodel);
        return shrBaseItemPK;
    }

    @Override
    protected void _writeReviseLog(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (null == model) {
            throw new BaseItemException(BaseItemException.MODEL_NOT_NULL);
        }
        SHRBaseItemInfo info = (SHRBaseItemInfo)model;
        if (null == info.getId() || StringUtils.isEmpty((String)info.getId().toString())) {
            throw new BaseItemException(BaseItemException.MODEL_ID_NOT_NULL);
        }
        String content = this._fillReviseLogContent(ctx, model);
        BaseItemReviseInfo newModel = new BaseItemReviseInfo();
        newModel.setShrBaseItemId(info.getId().toString());
        newModel.setContent(content);
        IObjectPK pk = BaseItemReviseFactory.getLocalInstance(ctx).save((CoreBaseInfo)newModel);
    }

    @Override
    protected IObjectPK _afterSaveOperation(Context ctx, String shrBaseItemId, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)shrBaseItem;
        IObjectPK addChangePK = null;
        if (null == newModel.getId()) {
            newModel.setId(BOSUuid.read((String)shrBaseItemId));
        }
        if (!BaseItemStateEnum.NEW.equals((Object)newModel.getState())) {
            addChangePK = BaseInfoChangeUtil.addBaseInfoChangeInfo(ctx, newModel.getId().toString(), newModel.getHrOrgUnit().getId().toString(), BaseDataChangeType.HRORG, HandleState.DOING, newModel.getUsePolicy());
        }
        return addChangePK;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (null == pk) {
            throw new BaseItemException(BaseItemException.DELETE_BASEITEM_ID_NOT_NULL);
        }
        SHRBaseItemInfo model = this.getSHRBaseItemInfo(ctx, pk);
        this._beforeDeleteOperation(ctx, (IObjectValue)model);
        try {
            super._delete(ctx, pk);
        }
        catch (ObjectReferedException e) {
            throw new BaseItemException(BaseItemException.CITED_BASEITEM_NOT_DELETE, new Object[]{model.getNumber()});
        }
    }

    @Override
    protected IObjectPK[] _addSHRBaseItemToOrgRef(Context ctx, IObjectPK baseInfoChangePK) throws BOSException, EASBizException {
        return BaseInfoChangeUtil.handlerAddChangeSHRBaseItemInfo(ctx, baseInfoChangePK);
    }

    @Override
    protected IObjectPK[] _updateSHRBaseItemToOrgRef(Context ctx, IObjectPK baseInfoChangePK) throws BOSException, EASBizException {
        return BaseInfoChangeUtil.handlerUpdateChangeSHRBaseItemInfo(ctx, baseInfoChangePK);
    }

    private SelectorItemCollection getBaseItemInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        return selector;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)dataBaseInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (dataBaseInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)dataBaseInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = this._getPropertyAlias(ctx, dataBaseInfo, "number") + " : " + dataBaseInfo.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected boolean isVerifyNameDump() {
        return false;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DataBaseInfo dataBaseInfo = (DataBaseInfo)model;
        List<Map<String, String>> list = BOSConfigUtil.getLanguageMapingList();
        if (list.size() == 1) {
            super._checkNameDup(ctx, model);
            return;
        }
        StringBuilder sql = new StringBuilder("select count(*) cc from ");
        sql.append(BaseMetaDataUtil.getEntityObjectInfo(ctx, dataBaseInfo.getBOSType()).getTable().getName());
        sql.append(" where FName_{0} = ? ");
        if (dataBaseInfo.getId() != null) {
            sql.append(" and ").append("FID <> ?");
        }
        for (Map<String, String> l : list) {
            String realSql = MessageFormat.format(sql.toString(), l.get("lang"));
            Object[] param = null;
            String name = dataBaseInfo.getName(LocaleUtils.getLocale(l.get("lang")));
            param = dataBaseInfo.getId() != null ? new Object[]{name, dataBaseInfo.getId().toString()} : new Object[]{name};
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)realSql, (Object[])param);
            try {
                while (rs.next()) {
                    if (rs.getInt("cc") <= 0) continue;
                    throw new BaseItemException(BaseItemException.BASE_ITEM_NAME_DUMP, new Object[]{name, l.get("text")});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _verifyData(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)shrBaseItem;
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, BaseMetaDataUtil.getEntityObjectInfo(ctx, this.getBOSType()).getFullName());
        ISHRBasicItem iSHRBasicItem = SHRBasicItemFactory.getLocalInstance(ctx);
        if (null == shrBasicItemInfo) {
            throw new BaseItemException(BaseItemException.BASEITEM_CTRLSTRA_NOT_MAINTAIN);
        }
        SHRBaseItemInfo oldModel = null;
        boolean existsPolicy = false;
        boolean existsCreate = false;
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
            this._checkNumberDup(ctx, shrBaseItem);
            if (StringUtils.isEmpty((String)newModel.getName())) {
                throw new BaseItemException(BaseItemException.BASEITEM_ENTITY_NAME_NULL);
            }
            if (this.isVerifyNameDump()) {
                this._checkNameDup(ctx, shrBaseItem);
            }
        }
        if (null == newModel.getUsePolicy()) {
            throw new BaseItemException(BaseItemException.CTRLSTRA_NOT_NULL);
        }
        if (null == newModel.getShrBasicItem() || null == newModel.getShrBasicItem().getId()) {
            newModel.setShrBasicItem(shrBasicItemInfo);
        }
        if (null == newModel.getState()) {
            newModel.setState(BaseItemStateEnum.NEW);
        }
        if (null == newModel.getHrOrgUnit() || null == newModel.getHrOrgUnit().getId()) {
            throw new BaseItemException(BaseItemException.CREATEORG_ID_NOT_NULL);
        }
        if (null != newModel.getId()) {
            oldModel = this.getSHRBaseItemInfo(ctx, (IObjectPK)new ObjectUuidPK(newModel.getId()), this.getBaseItemInfoSelector());
            if (!newModel.getHrOrgUnit().getId().equals((Object)oldModel.getHrOrgUnit().getId())) {
                throw new BaseItemException(BaseItemException.ORG_NOT_MATCH, new Object[]{newModel.getNumber()});
            }
        }
        if (StringUtils.isEmpty((String)newModel.getHrOrgUnit().getName())) {
            HROrgUnitInfo info = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(newModel.getHrOrgUnit().getId()));
            newModel.getHrOrgUnit().setName(info.getName());
        }
        if (!(existsPolicy = iSHRBasicItem.verifiUsePolicyCreated(newModel.getShrBasicItem().getId().toString(), newModel.getUsePolicy()))) {
            throw new BaseItemException(BaseItemException.PERMSSION_DENY_MAINTAIN, new Object[]{newModel.getUsePolicy().getAlias()});
        }
        existsCreate = iSHRBasicItem.verifiHROrgIsCreationById(newModel.getHrOrgUnit().getId().toString(), newModel.getShrBasicItem().getId().toString());
        if (!existsCreate) {
            throw new BaseItemException(BaseItemException.BIZORG_NO_ACCESS);
        }
    }

    private String getKey(String key, String lan) {
        return MessageFormat.format("{0}_{1}", key, lan);
    }

    @Override
    protected String _fillReviseLogContent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        HashMap<String, String> booleanMap = new HashMap<String, String>();
        SHRBaseItemInfo info = (SHRBaseItemInfo)model;
        UserInfo ouserInfo = null;
        if (null != info.getCreator() && null != info.getCreator().getId()) {
            ouserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getCreator().getId()));
        }
        UserInfo cuserInfo = null;
        if (null != info.getLastUpdateUser() && null != info.getLastUpdateUser().getId()) {
            cuserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getLastUpdateUser().getId()));
        }
        SHRBasicItemInfo shrBasicItemInfo = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemInfo((IObjectPK)new ObjectUuidPK(info.getShrBasicItem().getId()));
        HROrgUnitInfo hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getHrOrgUnit().getId()));
        if (null != info.getHrOrgUnit() && null != info.getHrOrgUnit().getId()) {
            hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getHrOrgUnit().getId()));
        }
        StringBuffer sb = null;
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, info.getBOSType());
        HashMap<String, String> result = new HashMap<String, String>(3);
        ArrayList<Locale> langs = new ArrayList<Locale>(3);
        langs.add(LocaleUtils.locale_l1);
        langs.add(LocaleUtils.locale_l2);
        langs.add(LocaleUtils.locale_l3);
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l1)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l1));
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l2)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l2));
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l3)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l3));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l1)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l1));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l2)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l2));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l3)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l3));
        CoreBaseInfo realInfo = null;
        String originalData = null;
        EntityObjectInfo realentityObjectInfo = null;
        if (!StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
            Map<String, LinkPropertyInfo> links = BaseMetaDataUtil.getLinkProperties(ctx, shrBasicItemInfo.getEntityName());
            for (Map.Entry<String, LinkPropertyInfo> entry : links.entrySet()) {
                realentityObjectInfo = entry.getValue().getRelationship().getSupplierObject();
                if (!realentityObjectInfo.getFullName().equals(shrBasicItemInfo.getRealEntityName())) continue;
                originalData = entry.getKey();
                break;
            }
            CoreBaseInfo originalDataInfo = (CoreBaseInfo)info.get(originalData);
            realInfo = BaseMetaDataUtil.getBizInterface(ctx, shrBasicItemInfo.getRealEntityName()).getValue((IObjectPK)new ObjectUuidPK(originalDataInfo.getId()));
        }
        String isTrue = null;
        String isFalse = null;
        Map systemFormat = UserNantionalUtil.getSystemSolutionNationalFormat(ctx);
        for (Locale l : langs) {
            isTrue = (String)booleanMap.get(this.getKey("true", LocaleUtils.getShortCode(l)));
            isFalse = (String)booleanMap.get(this.getKey("false", LocaleUtils.getShortCode(l)));
            sb = new StringBuffer();
            if (null != realInfo && null != realentityObjectInfo) {
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("name").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("name", l))).append("\n");
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("number").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("number"))).append("\n");
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("description").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("description", l))).append("\n");
            } else {
                sb.append(entityObjectInfo.getPropertyByNameRuntime("name").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getName(l))).append("\n");
                sb.append(entityObjectInfo.getPropertyByNameRuntime("number").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getNumber())).append("\n");
                sb.append(entityObjectInfo.getPropertyByNameRuntime("description").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getDescription(l))).append("\n");
            }
            sb.append(entityObjectInfo.getPropertyByNameRuntime("shrBasicItem").getAlias(l)).append(":").append(StringUtils.cnulls((String)shrBasicItemInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("hrOrgUnit").getAlias(l)).append(":").append(StringUtils.cnulls(hrOrgUnitInfo == null ? null : hrOrgUnitInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("usePolicy").getAlias(l)).append(":").append(info.getUsePolicy().getAlias(l)).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("isSysPreset").getAlias(l)).append(":").append(info.isIsSysPreset() ? isTrue : isFalse).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("state").getAlias(l)).append(":").append(info.getState().getAlias(l)).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("creator").getAlias(l)).append(":").append(StringUtils.cnulls(ouserInfo == null ? null : ouserInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("createTime").getAlias(l)).append(":").append(DateUtils.paseTimestamp2String(info.getCreateTime(), ((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("lastUpdateUser").getAlias(l)).append(":").append(StringUtils.cnulls(cuserInfo == null ? null : cuserInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("lastUpdateTime").getAlias(l)).append(":").append(DateUtils.paseTimestamp2String(info.getLastUpdateTime(), ((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())).append("\n");
            if (null != info.get("customfields")) {
                String[] customfields = ((String)info.get("customfields")).split(",");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("customfields:" + customfields));
                }
                if (null == customfields || customfields.length <= 0) continue;
                for (String field : customfields) {
                    if (StringUtils.isEmpty((String)field)) continue;
                    if (!StringUtils.isEmpty((String)originalData) && field.startsWith(originalData)) {
                        String realField = field.replace(originalData + ".", "");
                        sb.append(this.customFieldLogHandler(ctx, realInfo, realField, realentityObjectInfo, l, booleanMap));
                        continue;
                    }
                    sb.append(this.customFieldLogHandler(ctx, (CoreBaseInfo)info, field, entityObjectInfo, l, booleanMap));
                }
            }
            result.put(l.getDisplayName(), sb.toString());
        }
        return JSONUtils.convertObjectToJson(ctx, result);
    }

    private String customFieldLogHandler(Context ctx, CoreBaseInfo model, String field, EntityObjectInfo entityObjectInfo, Locale l, Map<String, String> booleanMap) throws EASBizException, BOSException {
        if ("id".equals(field)) {
            return "";
        }
        if (field.indexOf(".") != -1) {
            String lf = field.substring(0, field.indexOf("."));
            if ("id".equals(lf)) {
                return "";
            }
            PropertyInfo p1 = entityObjectInfo.getPropertyByNameRuntime(lf);
            if (p1 instanceof LinkPropertyInfo) {
                LinkPropertyInfo lp = (LinkPropertyInfo)p1;
                if (!(model.get(lf) instanceof CoreBaseInfo)) {
                    return "";
                }
                return this.customFieldLogHandler(ctx, (CoreBaseInfo)model.get(lf), field.replace(lf + ".", ""), lp.getRelationship().getSupplierObject(), l, booleanMap);
            }
            return "";
        }
        PropertyInfo p0 = entityObjectInfo.getPropertyByNameRuntime(field);
        if (p0 instanceof LinkPropertyInfo) {
            return this.customFieldLogLinkHandler(ctx, model, (LinkPropertyInfo)p0, entityObjectInfo, l);
        }
        if (p0 instanceof OwnPropertyInfo) {
            return this.customFieldLogOwnHandler(ctx, model, (OwnPropertyInfo)p0, entityObjectInfo, l, booleanMap);
        }
        return "";
    }

    private String customFieldLogOwnHandler(Context ctx, CoreBaseInfo model, OwnPropertyInfo p0, EntityObjectInfo entityObjectInfo, Locale l, Map<String, String> booleanMap) {
        String value = null;
        DataType dataType = p0.getDataType();
        if (DataType.STRING.equals((Object)dataType)) {
            value = p0.isMultilingual() ? (String)model.get(p0.getName(), l) : (String)model.get(p0.getName());
        } else if (DataType.BOOLEAN.equals((Object)dataType)) {
            boolean bv = model.getBoolean(p0.getName());
            value = bv ? booleanMap.get(this.getKey("true", LocaleUtils.getShortCode(l))) : booleanMap.get(this.getKey("false", LocaleUtils.getShortCode(l)));
        } else if (DataType.ENUM.equals((Object)dataType)) {
            if (model.get(p0.getName()) instanceof Enum) {
                Enum objEnum = (Enum)model.get(p0.getName());
                value = objEnum.getAlias(l);
            } else {
                value = "";
            }
        } else {
            value = String.valueOf(model.get(p0.getName()));
        }
        return MessageFormat.format("{0}:{1}\n", p0.getAlias(l), value);
    }

    private String customFieldLogLinkHandler(Context ctx, CoreBaseInfo model, LinkPropertyInfo p0, EntityObjectInfo entityObjectInfo, Locale l) throws EASBizException, BOSException {
        if (model.get(p0.getName()) instanceof CoreBaseInfo) {
            CoreBaseInfo pInfo = (CoreBaseInfo)model.get(p0.getName());
            String value = (String)pInfo.get("name", l);
            if (StringUtils.isEmpty((String)value)) {
                pInfo = BaseMetaDataUtil.getBizInterface(ctx, pInfo.getBOSType()).getValue((IObjectPK)new ObjectUuidPK(pInfo.getId()));
                value = (String)pInfo.get("name", l);
            }
            return MessageFormat.format("{0}:{1}\n", p0.getAlias(l), value);
        }
        return "";
    }

    @Override
    protected boolean _verifyHrOrgUnitRange(Context ctx, String userId, String permItemId, String hrOrgUnitId) throws BOSException, EASBizException {
        return SHRUserOrgPermissionApi.containsHROrgRange((Context)ctx, (String)userId, (String)permItemId, (String)hrOrgUnitId);
    }

    @Override
    protected void _updateSHRBasicItemId(Context ctx, String shrBasicItemId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)shrBasicItemId)) {
            throw new BaseItemException(BaseItemException.CTRLSTRA_ID_NOT_NULL);
        }
        EntityObjectInfo enetiyInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, this.getBOSType());
        String tableName = enetiyInfo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set FShrBasicItemID ='").append(shrBasicItemId).append("'").append(" where FShrBasicItemID <> '").append(shrBasicItemId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _batchEnable(Context ctx) throws BOSException, EASBizException {
        EntityObjectInfo enetiyInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, this.getBOSType());
        String tableName = enetiyInfo.getTable().getName();
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, enetiyInfo.getFullName());
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getRelationHREntity());
        String relationTable = baseItemRelationEntity.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set fstate  ='").append(1).append("'").append(" where fstate  <> '").append(1).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getGloballyShareBatchGenerateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getGloballyShareBatchUpdateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getDownShareBatchGenerateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getDownShareBatchUpdateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getDistributeShareBatchGenerateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
        DbUtil.execute((Context)ctx, (String)SHRBaseItemControllerBean.getDistributeShareBatchUpdateSql(tableName, enetiyInfo.getType().toString(), relationTable, baseItemRelationEntity.getType().toString()));
    }

    @Override
    protected void _batchDisable(Context ctx) throws BOSException, EASBizException {
        EntityObjectInfo enetiyInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, this.getBOSType());
        String tableName = enetiyInfo.getTable().getName();
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, enetiyInfo.getFullName());
        EntityObjectInfo baseItemRelationEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getRelationHREntity());
        String relationTable = baseItemRelationEntity.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set fstate  =").append(2);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        StringBuffer relationSql = new StringBuffer();
        relationSql.append("update ").append(relationTable).append(" set FState  =").append(200).append(" where FState = ").append(100).append(" and exists (SELECT 1 FROM ").append(tableName).append(" baseItem where FBaseInfoId = baseItem.fid)");
        DbUtil.execute((Context)ctx, (String)relationSql.toString());
    }

    @Override
    protected String _fillReviseLogContentNew(Context ctx, IObjectValue model, IObjectValue shrBasicItemModel) throws BOSException, EASBizException {
        HashMap<String, String> booleanMap = new HashMap<String, String>();
        SHRBaseItemInfo info = (SHRBaseItemInfo)model;
        UserInfo ouserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getCreator().getId()));
        UserInfo cuserInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(info.getLastUpdateUser().getId()));
        SHRBasicItemInfo shrBasicItemInfo = (SHRBasicItemInfo)shrBasicItemModel;
        HROrgUnitInfo hrOrgUnitInfo = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getHrOrgUnit().getId()));
        StringBuffer sb = null;
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, info.getBOSType());
        HashMap<String, String> result = new HashMap<String, String>(3);
        ArrayList<Locale> langs = new ArrayList<Locale>(3);
        langs.add(LocaleUtils.locale_l1);
        langs.add(LocaleUtils.locale_l2);
        langs.add(LocaleUtils.locale_l3);
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l1)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l1));
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l2)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l2));
        booleanMap.put(this.getKey("true", LocaleUtils.getShortCode(LocaleUtils.locale_l3)), SHRSysSettingResourceUtil.getResource("true", LocaleUtils.locale_l3));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l1)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l1));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l2)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l2));
        booleanMap.put(this.getKey("false", LocaleUtils.getShortCode(LocaleUtils.locale_l3)), SHRSysSettingResourceUtil.getResource("false", LocaleUtils.locale_l3));
        CoreBaseInfo realInfo = null;
        String originalData = null;
        EntityObjectInfo realentityObjectInfo = null;
        if (!StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
            Map<String, LinkPropertyInfo> links = BaseMetaDataUtil.getLinkProperties(ctx, shrBasicItemInfo.getEntityName());
            for (Map.Entry<String, LinkPropertyInfo> entry : links.entrySet()) {
                realentityObjectInfo = entry.getValue().getRelationship().getSupplierObject();
                if (!realentityObjectInfo.getFullName().equals(shrBasicItemInfo.getRealEntityName())) continue;
                originalData = entry.getKey();
                break;
            }
            CoreBaseInfo originalDataInfo = (CoreBaseInfo)info.get(originalData);
            realInfo = BaseMetaDataUtil.getBizInterface(ctx, shrBasicItemInfo.getRealEntityName()).getValue((IObjectPK)new ObjectUuidPK(originalDataInfo.getId()));
        }
        String isTrue = null;
        String isFalse = null;
        Map systemFormat = UserNantionalUtil.getSystemSolutionNationalFormat(ctx);
        for (Locale l : langs) {
            isTrue = (String)booleanMap.get(this.getKey("true", LocaleUtils.getShortCode(l)));
            isFalse = (String)booleanMap.get(this.getKey("false", LocaleUtils.getShortCode(l)));
            sb = new StringBuffer();
            if (null != realInfo && null != realentityObjectInfo) {
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("name").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("name", l))).append("\n");
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("number").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("number"))).append("\n");
                sb.append(realentityObjectInfo.getPropertyByNameRuntime("description").getAlias(l)).append(":").append(StringUtils.cnulls((Object)realInfo.get("description", l))).append("\n");
            } else {
                sb.append(entityObjectInfo.getPropertyByNameRuntime("name").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getName(l))).append("\n");
                sb.append(entityObjectInfo.getPropertyByNameRuntime("number").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getNumber())).append("\n");
                sb.append(entityObjectInfo.getPropertyByNameRuntime("description").getAlias(l)).append(":").append(StringUtils.cnulls((String)info.getDescription(l))).append("\n");
            }
            sb.append(entityObjectInfo.getPropertyByNameRuntime("shrBasicItem").getAlias(l)).append(":").append(StringUtils.cnulls((String)shrBasicItemInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("hrOrgUnit").getAlias(l)).append(":").append(StringUtils.cnulls((String)hrOrgUnitInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("usePolicy").getAlias(l)).append(":").append(info.getUsePolicy().getAlias(l)).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("isSysPreset").getAlias(l)).append(":").append(info.isIsSysPreset() ? isTrue : isFalse).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("state").getAlias(l)).append(":").append(info.getState().getAlias(l)).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("creator").getAlias(l)).append(":").append(StringUtils.cnulls(ouserInfo == null ? null : ouserInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("createTime").getAlias(l)).append(":").append(DateUtils.paseTimestamp2String(info.getCreateTime(), ((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("lastUpdateUser").getAlias(l)).append(":").append(StringUtils.cnulls(cuserInfo == null ? null : cuserInfo.getName(l))).append("\n");
            sb.append(entityObjectInfo.getPropertyByNameRuntime("lastUpdateTime").getAlias(l)).append(":").append(DateUtils.paseTimestamp2String(info.getLastUpdateTime(), ((SimpleDateFormat)systemFormat.get("dateTimeFormat")).toPattern())).append("\n");
            if (null != info.get("customfields")) {
                String[] customfields = ((String)info.get("customfields")).split(",");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("customfields:" + customfields));
                }
                if (null == customfields || customfields.length <= 0) continue;
                for (String field : customfields) {
                    if (StringUtils.isEmpty((String)field)) continue;
                    if (!StringUtils.isEmpty((String)originalData) && field.startsWith(originalData)) {
                        String realField = field.replace(originalData + ".", "");
                        sb.append(this.customFieldLogHandler(ctx, realInfo, realField, realentityObjectInfo, l, booleanMap));
                        continue;
                    }
                    sb.append(this.customFieldLogHandler(ctx, (CoreBaseInfo)info, field, entityObjectInfo, l, booleanMap));
                }
            }
            result.put(l.getDisplayName(), sb.toString());
        }
        return JSONUtils.convertObjectToJson(ctx, result);
    }

    private static String getGloballyShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on 1=1 ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(100).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        return sb.toString();
    }

    private static String getDownShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex,").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on 1=1 ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(200).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        sb.append(" and hr.flongNumber like (SELECT hr1.flongNumber||'%' FROM t_org_hro hr1 where hr1.fid = baseItem.fhrorgunitid and hr1.FISSEALUP = 0)");
        return sb.toString();
    }

    private static String getDistributeShareBatchGenerateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRInsertSql(baseItemRelationTableName));
        sb.append(" SELECT 0 FIsDefaultValue,baseItem.fid FBaseInfoId, hr.fid FHrOrgUseId, 1 FIsComUse,'0' FIndex, ").append(100).append(" FState, ").append(100).append(" FChangeType,");
        sb.append(" '").append(baseItemBosType).append("' FBosTypeId,baseItem.FCreatorID FCreatorID,now() FCreateTime,baseItem.FLastUpdateUserID FLastUpdateUserID,now() FLastUpdateTime,baseItem.FControlUnitID FControlUnitID,");
        sb.append(" newbosid('").append(baseItemRelationBosType).append("') fid");
        sb.append(" FROM ").append(baseItemTableName).append(" baseItem ");
        sb.append(" inner join t_org_hro hr on baseItem.fhrorgunitid=hr.fid ");
        sb.append(" where baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(300).append(" and hr.FISSEALUP = 0");
        sb.append(" and not exists(SELECT 1 FROM ").append(baseItemRelationTableName).append(" relation where relation.FBaseInfoId = baseItem.fid and relation.FHrOrgUseId = hr.fid)");
        return sb.toString();
    }

    public static String getBaseItemRelationHRInsertSql(String baseItemRelationTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into ").append(baseItemRelationTableName);
        sb.append(" (FIsDefaultValue, FBaseInfoId, FHrOrgUseId, FIsComUse, FIndex, FState, FChangeType, FBosTypeId, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FID)");
        return sb.toString();
    }

    private static String getGloballyShareBatchUpdateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRUpdateSql(baseItemRelationTableName));
        sb.append("(SELECT 1 FROM ").append(baseItemTableName).append(" baseItem where ").append(baseItemRelationTableName).append(".FBaseInfoId = baseItem.fid and baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(100).append(")");
        return sb.toString();
    }

    private static String getDownShareBatchUpdateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRUpdateSql(baseItemRelationTableName));
        sb.append("(SELECT 1 FROM ").append(baseItemTableName).append(" baseItem inner join t_org_hro t0 on baseItem.fhrorgunitid=t0.fid inner join ").append(baseItemRelationTableName).append(" t1 on t1.FBaseInfoId= baseItem.fid and baseItem.fstate =").append(1).append(" and baseItem.fusepolicy = ").append(200).append(" and t1.FState = ").append(200).append(" inner join t_org_hro t2 on t1.FHrOrgUseId = t2.FID where ").append(baseItemRelationTableName).append(".fid = t1.fid and CHARINDEX(t0.FLONGNUMBER,t2.flongNumber) >= 1)");
        return sb.toString();
    }

    private static String getDistributeShareBatchUpdateSql(String baseItemTableName, String baseItemBosType, String baseItemRelationTableName, String baseItemRelationBosType) {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRBaseItemControllerBean.getBaseItemRelationHRUpdateSql(baseItemRelationTableName));
        sb.append("(SELECT 1 FROM ").append(baseItemTableName).append(" baseItem where ").append(baseItemRelationTableName).append(".FBaseInfoId = baseItem.fid and baseItem.fstate = ").append(1).append(" and baseItem.fusepolicy = ").append(300).append(" and ").append(baseItemRelationTableName).append(".FHrOrgUseId = baseItem.fhrorgunitid )");
        return sb.toString();
    }

    public static String getBaseItemRelationHRUpdateSql(String baseItemRelationTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(baseItemRelationTableName);
        sb.append(" set FState = ").append(100).append(" where FState = ").append(200).append(" and exists");
        return sb.toString();
    }
}

