/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud;

import com.kingdee.bos.BOSException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpClientUtil {
    private static Logger logger = Logger.getLogger(HttpClientUtil.class);

    public static String postForwarnMessageToClould(String url, JSONObject data) throws BOSException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String entityStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entityParam = new StringEntity(data.toString(), "UTF-8");
            httpPost.setEntity((HttpEntity)entityParam);
            httpPost.addHeader("Content-Type", "application/json");
            httpPost.addHeader("Accept-Charset", "UTF-8");
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            entityStr = response.getStatusLine().getStatusCode() + ":" + EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("url:" + url));
                logger.debug((Object)("data:" + data.toString()));
                logger.debug((Object)("response:" + entityStr));
            }
        }
        catch (ClientProtocolException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return entityStr;
    }

    public static Map<String, String> postForwarnMessageToReport(String url) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String entityStr = null;
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            httpGet.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpGet.addHeader("Accept-Charset", "UTF-8");
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            String statusCode = String.valueOf(response.getStatusLine().getStatusCode());
            entityStr = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            result.put("statusCode", statusCode);
            result.put("entityStr", entityStr);
        }
        catch (ClientProtocolException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (ParseException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return result;
    }
}

