/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud.http;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.cloud.http.MyHttpClient;
import com.kingdee.shr.base.syssetting.cloud.http.ResultVo;
import com.kingdee.shr.base.syssetting.util.URLUtil;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRClient {
    private static Logger logger = LoggerFactory.getLogger(SHRClient.class);
    private static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";

    public static ResultVo doGet(String url, Map<String, Object> params) throws BOSException {
        MyHttpClient httpClient = null;
        GetMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            method = URLUtil.getGetMethod(url, params);
            int status = httpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                String data = method.getResponseBodyAsString();
                resultVo = new ResultVo("0", data, "request success!");
            } else {
                resultVo = new ResultVo("1", null, "request fail!");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    public static ResultVo doPost(String url, Map<String, Object> params) throws BOSException {
        MyHttpClient httpClient = null;
        PostMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            method = URLUtil.getPostMethod(url, params);
            int status = httpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                String data = method.getResponseBodyAsString();
                resultVo = new ResultVo("0", data, "request success!");
            } else {
                resultVo = new ResultVo("1", null, "request fail!");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }

    public static ResultVo doPostJson(String url, String json) throws BOSException {
        MyHttpClient httpClient = null;
        PostMethod method = null;
        ResultVo resultVo = null;
        try {
            httpClient = new MyHttpClient();
            httpClient.getParams().setParameter(ALLOW_CIRCULAR_REDIRECTS, (Object)true);
            httpClient.getParams().setIntParameter("http.socket.timeout", 60000);
            httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
            httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
            method = URLUtil.getPostMethod(url, null);
            StringRequestEntity requestEntity = new StringRequestEntity(json, "application/json", "UTF-8");
            method.setRequestEntity((RequestEntity)requestEntity);
            method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
            int status = httpClient.executeMethod((HttpMethod)method);
            if (status == 200) {
                String data = method.getResponseBodyAsString();
                resultVo = new ResultVo("0", data, "request success!");
            } else {
                resultVo = new ResultVo("1", null, "request fail!");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BOSException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        return resultVo;
    }
}

