/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.cloud.inf.impl;

import com.kingdee.shr.base.syssetting.cloud.inf.HttpPostMessageProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class HttpPostMessageProviderImpl
implements HttpPostMessageProvider {
    private static final String XT_CLOUD_URL = "https://kingdee.yunzhijia.com/pubacc/pubsend";
    private static volatile HttpPostMessageProviderImpl httpPostMessageProviderImpl;
    private static Logger l;

    private HttpPostMessageProviderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpPostMessageProviderImpl getInstance() {
        if (null != httpPostMessageProviderImpl) return httpPostMessageProviderImpl;
        Class<HttpPostMessageProviderImpl> clazz = HttpPostMessageProviderImpl.class;
        synchronized (HttpPostMessageProviderImpl.class) {
            if (null != httpPostMessageProviderImpl) return httpPostMessageProviderImpl;
            httpPostMessageProviderImpl = new HttpPostMessageProviderImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpPostMessageProviderImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postMessage(String message) throws Exception {
        long startTime = System.currentTimeMillis();
        HttpURLConnection httpConn = this.initHttpURLConnection(XT_CLOUD_URL);
        OutputStreamWriter outputStream = null;
        BufferedReader responseReader = null;
        InputStreamReader fis = null;
        InputStream input = null;
        OutputStream output = null;
        try {
            httpConn.setConnectTimeout(30000);
            httpConn.setReadTimeout(30000);
            output = httpConn.getOutputStream();
            outputStream = new OutputStreamWriter(output);
            outputStream.write(message);
            outputStream.close();
            int responseCode = httpConn.getResponseCode();
            if (200 == responseCode) {
                String readLine;
                StringBuffer sb = new StringBuffer();
                input = httpConn.getInputStream();
                fis = new InputStreamReader(input, "UTF-8");
                responseReader = new BufferedReader(fis);
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append("\n");
                }
                input.close();
                long endTimes = System.currentTimeMillis();
                l.info((Object)("~~~~~~~time:" + (endTimes - startTime) / 1000L + "s ~~~~~~~~~~~~~"));
            }
        }
        finally {
            try {
                if (responseReader != null) {
                    responseReader.close();
                }
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e3) {
                        l.error((Object)"resource not closed");
                    }
                }
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (output != null) {
                output.close();
            }
            httpConn.disconnect();
        }
    }

    private HttpURLConnection initHttpURLConnection(String url) throws IOException {
        URL reqUrl = new URL(url);
        HttpURLConnection httpConn = (HttpURLConnection)reqUrl.openConnection();
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setRequestMethod("POST");
        httpConn.setUseCaches(false);
        httpConn.setInstanceFollowRedirects(true);
        httpConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        httpConn.setRequestProperty("Accept-Charset", "utf-8");
        return httpConn;
    }

    static {
        l = Logger.getLogger(HttpPostMessageProviderImpl.class);
    }
}

