/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.FieldRuleFactory;
import com.kingdee.shr.base.syssetting.FieldRuleInfo;
import com.kingdee.shr.base.syssetting.IFieldRule;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRuleUtils {
    private static Logger logger = LoggerFactory.getLogger(FieldRuleUtils.class);
    private static String regexFormat = "\\b{0}\\(([^)]*)\\)";

    private FieldRuleUtils() {
    }

    public static String getFieldRuleIDByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        String oql = "select id where uiview.uipk = '" + uipk + "'";
        FieldRuleInfo fieldRuleInfo = null;
        IFieldRule iFieldRule = FieldRuleFactory.getLocalInstance(ctx);
        if (iFieldRule.exists(oql)) {
            fieldRuleInfo = iFieldRule.getFieldRuleInfo(oql);
        }
        return null != fieldRuleInfo ? fieldRuleInfo.getId().toString() : "";
    }

    public static Object getVariableValue(Context ctx, String variableName) {
        try {
            return VariableServiceFactory.getSystemVariableResult((Context)ctx, (String)variableName, new HashMap());
        }
        catch (BOSException | EASBizException e) {
            logger.error("GetVariableValue error, variableName : {}", (Object)variableName);
            e.printStackTrace();
            return null;
        }
    }

    public static Object getVariableValue(Context ctx, String variableName, String text) {
        Object result = null;
        try {
            if (StringUtils.isEmpty((String)text)) {
                return FieldRuleUtils.getVariableValue(ctx, variableName);
            }
            String regex = MessageFormat.format(regexFormat, variableName);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(text);
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            if (matcher.find()) {
                String parameters = matcher.group(1);
                String[] runParamValues = parameters.split(",");
                param.put("variableFunctionParams", runParamValues);
                result = VariableServiceFactory.getSystemVariableResult((Context)ctx, (String)variableName, param);
            } else {
                result = FieldRuleUtils.getVariableValue(ctx, variableName);
            }
        }
        catch (BOSException | EASBizException e) {
            logger.error("GetVariableValue error, variableName : {}, text : {}", (Object)variableName, (Object)text);
            e.printStackTrace();
        }
        return result;
    }

    public static String getLocalValue(Context ctx, Object value) {
        if (null == value) {
            return null;
        }
        try {
            if (value instanceof Map) {
                Map map = (Map)value;
                String alias = (String)map.get(ctx.getLocale().toString());
                if (StringUtils.isEmpty((String)alias)) {
                    alias = (String)map.get("l2");
                }
                return alias;
            }
            if (value instanceof Boolean) {
                if (Boolean.TRUE.equals(value)) {
                    return "true";
                }
                return "false";
            }
            return String.valueOf(value);
        }
        catch (Exception e) {
            logger.error("GetLocalValue error , value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean getBooleanFieldValue(Object value) {
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        Boolean v = Boolean.FALSE;
        try {
            if (!StringUtils.isEmpty((String)((String)value)) && ("1".equals(value) || "true".equals(value))) {
                v = Boolean.TRUE;
            }
        }
        catch (Exception e) {
            logger.error("GetBooleanFieldValue error , value : {}", value);
            e.printStackTrace();
        }
        return v;
    }

    public static Object getNumberFieldValue(String dataTypeName, Object value) {
        try {
            if (value instanceof String) {
                if (StringUtils.isEmpty((String)((String)value))) {
                    return null;
                }
                if (DataType.SHORT.toString().equalsIgnoreCase(dataTypeName)) {
                    return Short.valueOf((String)value);
                }
                if (DataType.INTEGER.toString().equalsIgnoreCase(dataTypeName)) {
                    return Integer.valueOf((String)value);
                }
                if (DataType.LONG.toString().equalsIgnoreCase(dataTypeName)) {
                    return Long.valueOf((String)value);
                }
                if (DataType.FLOAT.toString().equalsIgnoreCase(dataTypeName)) {
                    return Float.valueOf((String)value);
                }
                if (DataType.DOUBLE.toString().equalsIgnoreCase(dataTypeName)) {
                    return Double.valueOf((String)value);
                }
                if (DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName)) {
                    return new BigDecimal((String)value);
                }
            }
            return value;
        }
        catch (Exception e) {
            logger.error("GetNumberFieldValue error , dataTypeName : {} , value : {}", (Object)dataTypeName, value);
            e.printStackTrace();
            return null;
        }
    }

    public static Date getDateFieldValue(Object value) {
        try {
            if (value instanceof String) {
                return DateTimeUtils.parseDate((String)((String)value));
            }
            return (Date)value;
        }
        catch (Exception e) {
            logger.error("GetDateFieldValue error , value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static CoreBaseInfo getF7FieldValue(Context ctx, Object defaultValue, String entityNmae, String submitFormat) {
        String billid = "";
        try {
            if (defaultValue instanceof Map) {
                Map map = (Map)defaultValue;
                billid = (String)map.get("v");
                if (BOSUuid.isValid((String)billid, (boolean)true)) {
                    return FieldRuleUtils.getValue(ctx, billid, entityNmae);
                }
            } else {
                if (defaultValue instanceof String && BOSUuid.isValid((String)((String)defaultValue), (boolean)true)) {
                    billid = (String)defaultValue;
                    return FieldRuleUtils.getValue(ctx, billid, entityNmae);
                }
                if (defaultValue instanceof IObjectValue) {
                    return (CoreBaseInfo)defaultValue;
                }
                String defaultValueType = null;
                if (null != defaultValue) {
                    defaultValueType = defaultValue.getClass().getName();
                }
                logger.error("FieldRule fetF7FieldValue Error : defaultValueType[{}]", (Object)defaultValueType);
            }
        }
        catch (Exception e) {
            logger.error("GetF7FieldValue error, entityName : {}, value : {}", (Object)entityNmae, (Object)billid);
            e.printStackTrace();
        }
        return null;
    }

    public static Object getEnumFieldValue(String enumSource, Object value) {
        try {
            if (value instanceof Enum) {
                return value;
            }
            if (!StringUtils.isEmpty((String)enumSource) && null != value) {
                return MetaDataUtil.findEnumByValue(enumSource, value);
            }
            return value;
        }
        catch (Exception e) {
            logger.error("GetEnumFieldValue error, value : {}", value);
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean isNumberType(String dataTypeName) {
        return DataType.SHORT.toString().equalsIgnoreCase(dataTypeName) || DataType.INTEGER.toString().equalsIgnoreCase(dataTypeName) || DataType.LONG.toString().equalsIgnoreCase(dataTypeName) || DataType.FLOAT.toString().equalsIgnoreCase(dataTypeName) || DataType.DOUBLE.toString().equalsIgnoreCase(dataTypeName) || DataType.DECIMAL.toString().equalsIgnoreCase(dataTypeName);
    }

    private static CoreBaseInfo getValue(Context ctx, String modelID, String entityNmae) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        ICoreBase model = BaseMetaDataUtil.getBizInterface(ctx, entityNmae);
        return null != model ? model.getValue((IObjectPK)new ObjectUuidPK(modelID), sic) : null;
    }
}

