/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.processor;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.shr.base.syssetting.fieldrule.FieldRuleUtils;
import com.kingdee.shr.base.syssetting.fieldrule.IFieldRuleProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.model.Field;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterConfigItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.FilterRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FieldFilterValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FilterFieldItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.type.Type;
import com.microsoft.sqlserver.jdbc.StringUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldFilterProcessor
implements IFieldRuleProcessor {
    private Context ctx;
    private FilterRule filterRule;

    public FieldFilterProcessor(Context ctx, FilterRule filterRule) {
        this.ctx = ctx;
        this.filterRule = filterRule;
    }

    @Override
    public void exec(Map<String, Object> params) {
        HashMap<String, FieldFilterValue> fieldFilter = new HashMap<String, FieldFilterValue>();
        this.parseFieldFilterConfig(this.filterRule.getConfig(), fieldFilter);
        params.put("fieldFilter", fieldFilter);
    }

    private void parseFieldFilterConfig(List<FilterConfig> configs, Map<String, FieldFilterValue> fieldFilter) {
        for (FilterConfig filterRuleConfig : configs) {
            Field field = filterRuleConfig.getField();
            FieldFilterValue fieldFilterValue = new FieldFilterValue();
            this.parseFieldFilterValue(filterRuleConfig.getFilterConfig(), fieldFilterValue, field, FieldRuleUtils.getLocalValue(this.ctx, filterRuleConfig.getTips()));
            fieldFilter.put(field.getName(), fieldFilterValue);
        }
    }

    private void parseFieldFilterValue(List<FilterConfigItem> filterConfigs, FieldFilterValue fieldFilterValue, Field field, String tips) {
        HashMap<String, FilterFieldItem> filterItemMaping = new HashMap<String, FilterFieldItem>();
        int count = 1;
        StringBuilder condition = new StringBuilder();
        for (FilterConfigItem filterConfig : filterConfigs) {
            FilterFieldItem filterField = new FilterFieldItem();
            Field configField = filterConfig.getField();
            String dataType = configField.getDataType();
            Object value = filterConfig.getFilterValue();
            String compareType = filterConfig.getCompareType();
            this.assembleCondition(count, condition, filterConfig);
            String conditionKey = MessageFormat.format("t{0}", count);
            ++count;
            if (Type.VARIABLE.name().equalsIgnoreCase(compareType)) {
                value = FieldRuleUtils.getVariableValue(this.ctx, (String)value);
            }
            if (Type.DEPENDFIELD.name().equalsIgnoreCase(compareType) && value instanceof Map) {
                Map dependField = (Map)value;
                filterField.setEditGridField((Boolean)dependField.get("isEditGridField"));
                filterField.setDependField(true);
                filterField.setAlias(FieldRuleUtils.getLocalValue(this.ctx, dependField.get("alias")));
                value = dependField.get("name");
            }
            if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataType)) {
                if (!filterField.isDependField()) {
                    this.setFilterField(filterConfig, filterField, configField, FieldRuleUtils.getBooleanFieldValue(value));
                } else {
                    this.setFilterField(filterConfig, filterField, configField, value);
                }
            } else if (DataType.OBJECTVALUE.getName().equalsIgnoreCase(dataType)) {
                if (!filterField.isDependField()) {
                    this.setFilterField(filterConfig, filterField, configField, this.getF7FieldValue(value, configField));
                } else {
                    this.setFilterField(filterConfig, filterField, configField, value);
                }
            } else if (DataType.STRING.getName().equalsIgnoreCase(dataType)) {
                this.setFilterField(filterConfig, filterField, configField, FieldRuleUtils.getLocalValue(this.ctx, value));
            } else {
                this.setFilterField(filterConfig, filterField, configField, value);
            }
            filterItemMaping.put(conditionKey, filterField);
        }
        fieldFilterValue.setTips(tips);
        fieldFilterValue.setCondition(condition.toString());
        fieldFilterValue.setEditGridField(field.isEditGridField());
        fieldFilterValue.setFilterItemMaping(filterItemMaping);
    }

    private void assembleCondition(int count, StringBuilder condition, FilterConfigItem filterConfig) {
        condition.append(filterConfig.getLeftBracket()).append("t").append(count).append(filterConfig.getRightBracket());
        if (!StringUtils.isEmpty((CharSequence)filterConfig.getLogicSymbol())) {
            condition.append(" ").append(filterConfig.getLogicSymbol()).append(" ");
        }
    }

    private String getF7FieldValue(Object defaultValue, Field field) {
        field.setName(MessageFormat.format("{0}.id", field.getName()));
        return FieldRuleUtils.getF7FieldValue(this.ctx, defaultValue, field.getFullName(), field.getSubmitFormat()).getId().toString();
    }

    private void setFilterField(FilterConfigItem filterConfig, FilterFieldItem filterField, Field field, Object defaultValue) {
        if (null != defaultValue) {
            filterField.setName(field.getName());
            filterField.setValue(defaultValue);
            if (StringUtils.isEmpty((CharSequence)filterField.getType())) {
                filterField.setType(field.getDataType());
            }
            filterField.setCompareType(filterConfig.getCompareSymbol());
            filterField.setTip(filterConfig.isTip());
        }
    }
}

