/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.fieldrule.processor;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.fieldrule.IFieldRuleProcessor;
import com.kingdee.shr.base.syssetting.fieldrule.formula.FieldRuleFormulaEngine;
import com.kingdee.shr.base.syssetting.fieldrule.model.CalculateConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.Condition;
import com.kingdee.shr.base.syssetting.fieldrule.model.Field;
import com.kingdee.shr.base.syssetting.fieldrule.model.LinkConfig;
import com.kingdee.shr.base.syssetting.fieldrule.model.LinkRule;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.CalculateFieldValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.FieldItem;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.LinkFieldValue;
import com.kingdee.shr.base.syssetting.fieldrule.model.runtime.LinkItem;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkFieldProcessor
implements IFieldRuleProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LinkFieldProcessor.class);
    private Context ctx;
    private LinkRule linkRule;

    public LinkFieldProcessor(Context ctx, LinkRule linkRule) {
        this.ctx = ctx;
        this.linkRule = linkRule;
    }

    @Override
    public void exec(Map<String, Object> params) {
        HashMap<String, Object> linkRuleMap = new HashMap<String, Object>();
        List<LinkConfig> linkConfigs = this.linkRule.getLinkConfig();
        this.parseLinkConfig(linkConfigs, linkRuleMap);
        List<CalculateConfig> calculateConfigs = this.linkRule.getCalculateConfig();
        this.parseCalculateConfig(calculateConfigs, linkRuleMap);
        linkRuleMap.put("priority", this.linkRule.getPriority());
        linkRuleMap.put("layout", this.linkRule.getLayout());
        params.put("linkRule", linkRuleMap);
    }

    private void parseLinkConfig(List<LinkConfig> linkConfigs, Map<String, Object> linkRuleMap) {
        LinkedHashMap<String, LinkFieldValue> linkConfigValues = new LinkedHashMap<String, LinkFieldValue>();
        int index = 0;
        for (LinkConfig linkConfig : linkConfigs) {
            LinkFieldValue linkFieldValue = new LinkFieldValue();
            ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
            for (Field field : linkConfig.getFields()) {
                fields.add(this.assembleFieldItem(field));
            }
            ArrayList<FieldItem> targetFields = new ArrayList<FieldItem>();
            for (Field targetField : linkConfig.getTargetFields()) {
                targetFields.add(this.assembleFieldItem(targetField));
            }
            linkFieldValue.setFields(fields);
            linkFieldValue.setTargetFields(targetFields);
            linkFieldValue.setCondition(this.assembleCondition(linkFieldValue, linkConfig.getCondition()));
            linkFieldValue.setLinkType(linkConfig.getLinkType());
            linkConfigValues.put(MessageFormat.format("{0}_{1}", ++index, String.valueOf(linkFieldValue.hashCode())), linkFieldValue);
        }
        if (!linkConfigValues.isEmpty()) {
            linkRuleMap.put("linkField", linkConfigValues);
        }
    }

    private void parseCalculateConfig(List<CalculateConfig> calculateConfigs, Map<String, Object> linkRuleMap) {
        LinkedHashMap<String, CalculateFieldValue> calculateConfigValues = new LinkedHashMap<String, CalculateFieldValue>();
        int index = 0;
        for (CalculateConfig calculateConfig : calculateConfigs) {
            CalculateFieldValue calculateFieldValue = new CalculateFieldValue();
            ArrayList<FieldItem> fields = new ArrayList<FieldItem>();
            for (Field field : calculateConfig.getFields()) {
                fields.add(this.assembleFieldItem(field));
            }
            ArrayList<FieldItem> targetFields = new ArrayList<FieldItem>();
            for (Field targetField : calculateConfig.getTargetFields()) {
                targetFields.add(this.assembleFieldItem(targetField));
            }
            calculateFieldValue.setFields(fields);
            calculateFieldValue.setTargetFields(targetFields);
            calculateFieldValue.setCondition(this.assembleCondition(calculateFieldValue, calculateConfig.getCondition()));
            calculateFieldValue.setOperateType(calculateConfig.getOperateType());
            calculateConfigValues.put(MessageFormat.format("{0}_{1}", ++index, String.valueOf(calculateFieldValue.hashCode())), calculateFieldValue);
        }
        if (!calculateConfigValues.isEmpty()) {
            linkRuleMap.put("calculateField", calculateConfigValues);
        }
    }

    private FieldItem assembleFieldItem(Field field) {
        FieldItem fieldItem = new FieldItem();
        fieldItem.setName(field.getName());
        fieldItem.setFullName(field.getFullName());
        fieldItem.setType(field.getDataType());
        fieldItem.setEditGridField(field.isEditGridField());
        return fieldItem;
    }

    private Condition assembleCondition(LinkItem linkItem, Condition condition) {
        if (null != condition && !StringUtils.isEmpty((String)condition.getValue())) {
            linkItem.setConditionValue(true);
            linkItem.setVars(this.initParams(condition.getValue()));
            if (condition.getField() instanceof List) {
                condition.setField(condition.getField());
            }
        } else {
            linkItem.setConditionValue(false);
            linkItem.setVars(new HashMap<String, Object>());
            condition.setField(Collections.emptyList());
        }
        return condition;
    }

    private Map<String, Object> initParams(String value) {
        Map<String, Object> params = FieldRuleFormulaEngine.parseFormulaVariable(this.ctx, value);
        String mainKey = null;
        for (String key : params.keySet()) {
            if (key.indexOf("Main#") == -1) continue;
            mainKey = key;
        }
        if (!StringUtils.isEmpty(mainKey)) {
            String modelName = mainKey.substring(mainKey.indexOf("Main#") + 5);
            params.put(modelName, params.get(mainKey));
            params.remove(mainKey);
        }
        return params;
    }
}

