/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.access.ExtendPropertySelect;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.access.query.PropertyUnitSelect;
import com.kingdee.bos.metadata.access.query.QuerySelect;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnit;
import com.kingdee.bos.metadata.access.query.SimplePropertyUnitCollection;
import com.kingdee.bos.metadata.access.query.SimpleQuery;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseMetaDataUtil {
    private static Logger logger = Logger.getLogger(BaseMetaDataUtil.class);

    public static ICoreBase getBizInterface(Context ctx, String entityName) throws BOSException {
        if (null == ctx) {
            return (ICoreBase)BOSObjectFactory.createRemoteCommonBOSObject((IMetaDataPK)MetaDataPK.create((String)entityName));
        }
        return (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static BOSObjectType getBOSObjectTypeById(String id) {
        return BOSUuid.read((String)id).getType();
    }

    public static ICoreBase getBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, bosType);
        return BaseMetaDataUtil.getBizInterface(ctx, entityObjectInfo.getFullName());
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, BOSObjectType bosType) {
        if (null == ctx) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(bosType);
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
    }

    public static EntityObjectInfo getEntityObjectByEntityName(Context ctx, String entityName) {
        if (null == ctx) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static boolean isEntityNonExists(Context ctx, String entityName) {
        EntityObjectInfo info = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
        return null == info.getType();
    }

    public static QueryInfo getQueryInfo(Context ctx, String query) {
        if (null == ctx) {
            return MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)MetaDataPK.create((String)query));
        }
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)MetaDataPK.create((String)query));
    }

    public static boolean isInheritBaseClass(EntityObjectInfo superEntity, String baseClass) {
        if (null == superEntity) {
            return false;
        }
        if (baseClass.equals(superEntity.getFullName())) {
            return true;
        }
        return BaseMetaDataUtil.isInheritBaseClass(superEntity.getBaseEntity(), baseClass);
    }

    public static String getHrOrgUnitLinkPropertyInfoName(EntityObjectInfo entityObjectInfo) {
        LinkPropertyInfo linkPropertyInfo = BaseMetaDataUtil.getHrOrgUnitLinkPropertyInfo(entityObjectInfo);
        if (null != linkPropertyInfo) {
            return linkPropertyInfo.getName();
        }
        return null;
    }

    public static LinkPropertyInfo getHrOrgUnitLinkPropertyInfo(EntityObjectInfo entityObjectInfo) {
        PropertyCollection propertyCollection = entityObjectInfo.getDuplicatedEntityProperties();
        if (null == propertyCollection || propertyCollection.size() <= 0) {
            return null;
        }
        int total = propertyCollection.size();
        for (int i = 0; i < total; ++i) {
            LinkPropertyInfo realLinkPropertyInfo;
            RelationshipInfo relationshipInfo;
            EntityObjectInfo linkEntityObjectInfo;
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || !"com.kingdee.eas.basedata.org.app.HROrgUnit".equals((linkEntityObjectInfo = (relationshipInfo = (realLinkPropertyInfo = (LinkPropertyInfo)propertyInfo).getRelationship()).getSupplierObject()).getFullName())) continue;
            return realLinkPropertyInfo;
        }
        return null;
    }

    public static EntityObjectInfo getLinkPropertyRefEntityObjectInfo(EntityObjectInfo entityObjectInfo, String propertyName) {
        PropertyCollection propertyCollection = entityObjectInfo.getDuplicatedEntityProperties();
        if (null == propertyCollection || propertyCollection.size() <= 0) {
            return null;
        }
        int total = propertyCollection.size();
        for (int i = 0; i < total; ++i) {
            LinkPropertyInfo realLinkPropertyInfo;
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || !(realLinkPropertyInfo = (LinkPropertyInfo)propertyInfo).getName().equals(propertyName)) continue;
            RelationshipInfo relationshipInfo = realLinkPropertyInfo.getRelationship();
            return relationshipInfo.getSupplierObject();
        }
        return null;
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String fieldName) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        if (!fieldName.contains(".")) {
            MetaDataPK pk = MetaDataPK.create((String)entityName);
            if (null != pk) {
                EntityObjectInfo entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
                return entityInfo.getPropertyByNameRuntime(fieldName);
            }
            return null;
        }
        return BaseMetaDataUtil.getPropertyInfo(ctx, entityName, fieldName.split("\\."));
    }

    public static PropertyInfo getPropertyInfo(Context ctx, String entityName, String[] fieldNames) {
        String fieldName;
        if (fieldNames == null || StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        PropertyInfo propertyInfo = null;
        String[] stringArray = fieldNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, entityName, fieldName = stringArray[i])) != null; ++i) {
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            entityName = BaseMetaDataUtil.getEntityNameByPropertyInfo(ctx, entityName, propertyInfo);
        }
        if (propertyInfo != null) {
            propertyInfo.put("entityName", (Object)entityName);
        }
        return propertyInfo;
    }

    public static String getEntityNameByPropertyInfo(Context ctx, String entityName, PropertyInfo propertyInfo) {
        String subEntityName = null;
        if (propertyInfo instanceof LinkPropertyInfo) {
            if (((LinkPropertyInfo)propertyInfo).getRelationship() != null && ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject() != null) {
                subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName();
                if (entityName.equals(subEntityName)) {
                    subEntityName = ((LinkPropertyInfo)propertyInfo).getRelationship().getClientObject().getFullName();
                }
            } else {
                logger.info((Object)("property " + propertyInfo.getName() + " cannot find relationship or relationship's supplierObject"));
            }
        }
        return subEntityName;
    }

    public static DataType getQueryFiledDataType(Context ctx, String queryPK, String queryFieldName) {
        SimplePropertyUnit simplePropertyUnit = BaseMetaDataUtil.getSimplePropertyUnitCollection(ctx, queryPK, queryFieldName);
        DataType dataType = null;
        if (null == simplePropertyUnit) {
            return null;
        }
        if (simplePropertyUnit.isReturnTypeEnum()) {
            return DataType.ENUM;
        }
        ConstDataType returnType = simplePropertyUnit.getReturnType();
        if (returnType.equals((Object)ConstDataType.BOOLEAN)) {
            dataType = DataType.BOOLEAN;
        } else if (returnType.equals((Object)ConstDataType.DATE)) {
            dataType = DataType.DATE;
        } else if (returnType.equals((Object)ConstDataType.INT)) {
            dataType = DataType.INTEGER;
        } else if (returnType.equals((Object)ConstDataType.NUMBER)) {
            dataType = DataType.DECIMAL;
        } else if (returnType.equals((Object)ConstDataType.STRING)) {
            dataType = DataType.STRING;
        } else if (returnType.equals((Object)ConstDataType.TIME)) {
            dataType = DataType.TIME;
        } else if (returnType.equals((Object)ConstDataType.TIMESTAMP)) {
            dataType = DataType.TIMESTAMP;
        }
        return dataType;
    }

    public static SimplePropertyUnit getSimplePropertyUnitCollection(Context ctx, String queryPK, String queryFieldName) {
        SimplePropertyUnitCollection propertyUnitCollection = BaseMetaDataUtil.getSimplePropertyUnitCollection0(ctx, queryPK, queryFieldName);
        SimplePropertyUnit simplePropertyUnit = null;
        if (null != propertyUnitCollection && propertyUnitCollection.size() > 0) {
            simplePropertyUnit = propertyUnitCollection.get(0);
        }
        return simplePropertyUnit;
    }

    protected static SimplePropertyUnitCollection getSimplePropertyUnitCollection0(Context ctx, String queryPK, String queryFieldName) {
        QuerySelect select = new QuerySelect(queryPK);
        SimpleQuery query = null;
        QuerySelect querySelect = null;
        PropertyUnitSelect propertyUnitSelect = null;
        PropertyUnitSelect propertyUnitSelect0 = null;
        ExtendPropertySelect extendPropertySelect = null;
        String[] names = new String[]{queryFieldName};
        String[] attributes = new String[]{"displayName", "returnType", "isSelector", "isFilter", "isSorter"};
        try {
            querySelect = select.selectHeaderSelectorFields();
            if (null == querySelect) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1},querySelect is null ", queryPK, queryFieldName));
                }
                return null;
            }
            propertyUnitSelect = querySelect.propertyUnitSelect();
            if (null == propertyUnitSelect) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1},propertyUnitSelect is null ", queryPK, queryFieldName));
                }
                return null;
            }
            propertyUnitSelect0 = null == ctx || null == ctx.getOriginLocale() ? propertyUnitSelect.select(names, attributes) : propertyUnitSelect.select(names, attributes, ctx.getOriginLocale());
            if (null == propertyUnitSelect0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1},propertyUnitSelect0 is null ", queryPK, queryFieldName));
                }
                return null;
            }
            extendPropertySelect = propertyUnitSelect0.extendPropertySelect();
            if (null == extendPropertySelect) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1},extendPropertySelect is null ", queryPK, queryFieldName));
                }
                return null;
            }
            extendPropertySelect.select("*");
            query = null == ctx ? MetaDataAccessFactory.getRemoteInstance().select(select) : MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        catch (Exception e) {
            logger.error((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1}", queryPK, queryFieldName), (Throwable)e);
        }
        if (null == query) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("queryPK:{0},queryFieldName:{1},query is null ", queryPK, queryFieldName));
            }
            return null;
        }
        return query.propertyUnits();
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        return BaseMetaDataUtil.getProperties(BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName));
    }

    public static Map<String, PropertyInfo> getProperties(Context ctx, BOSObjectType bosType) {
        if (null == bosType) {
            return null;
        }
        return BaseMetaDataUtil.getProperties(BaseMetaDataUtil.getEntityObjectInfo(ctx, bosType));
    }

    private static Map<String, PropertyInfo> getProperties(EntityObjectInfo entityInfo) {
        PropertyCollection collection = entityInfo.getInheritedNoDuplicatedPropertiesRuntime();
        LinkedHashMap<String, PropertyInfo> map = new LinkedHashMap<String, PropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            map.put(propertyInfo.getName(), propertyInfo);
        }
        return map;
    }

    public static Map<String, LinkPropertyInfo> getLinkProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        return BaseMetaDataUtil.getLinkProperties(BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName));
    }

    public static Map<String, LinkPropertyInfo> getLinkProperties(Context ctx, BOSObjectType bosType) {
        if (null == bosType) {
            return null;
        }
        return BaseMetaDataUtil.getLinkProperties(BaseMetaDataUtil.getEntityObjectInfo(ctx, bosType));
    }

    private static Map<String, LinkPropertyInfo> getLinkProperties(EntityObjectInfo entityObjectInfo) {
        PropertyCollection collection = entityObjectInfo.getInheritedNoDuplicatedPropertiesRuntime();
        HashMap<String, LinkPropertyInfo> map = new HashMap<String, LinkPropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            map.put(propertyInfo.getName(), (LinkPropertyInfo)propertyInfo);
        }
        return map;
    }

    public static Map<String, LinkPropertyInfo> getCompositionLinkProperties(Context ctx, String entityName) {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        return BaseMetaDataUtil.getCompositionLinkProperties(BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName));
    }

    public static Map<String, LinkPropertyInfo> getCompositionLinkProperties(Context ctx, BOSObjectType bosType) {
        if (null == bosType) {
            return null;
        }
        return BaseMetaDataUtil.getCompositionLinkProperties(BaseMetaDataUtil.getEntityObjectInfo(ctx, bosType));
    }

    private static Map<String, LinkPropertyInfo> getCompositionLinkProperties(EntityObjectInfo entityObjectInfo) {
        PropertyCollection collection = entityObjectInfo.getInheritedNoDuplicatedPropertiesRuntime();
        HashMap<String, LinkPropertyInfo> map = new HashMap<String, LinkPropertyInfo>();
        PropertyInfo propertyInfo = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo lp;
            propertyInfo = collection.get(i);
            if (!(propertyInfo instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(lp = (LinkPropertyInfo)propertyInfo).getRelationship().getType())) continue;
            map.put(propertyInfo.getName(), (LinkPropertyInfo)propertyInfo);
        }
        return map;
    }

    public static Class getObjectValueClass(Context ctx, String entityName) throws BOSException {
        EntityObjectInfo entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
        String clazz = entityInfo.getObjectValueClass();
        try {
            return Class.forName(clazz);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BOSException(MessageFormat.format(SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "metadata_not_exist", ctx), entityName));
        }
    }

    public static IObjectValue newInstance(Context ctx, Class clazz, String entityName) {
        IObjectValue objectInfo = null;
        try {
            objectInfo = (IObjectValue)clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        if (!StringUtils.isEmpty((String)entityName)) {
            MetaDataPK metaDataPK = MetaDataPK.create((String)entityName);
            EntityObjectInfo entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
            if (entityInfo.isDynamic() && objectInfo instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)objectInfo;
                commonObject.setBOSType(entityInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
        }
        return objectInfo;
    }

    public static Type getMetadataValueType(Context ctx, IObjectValue objectValue, String property) throws EASBizException, BOSException {
        try {
            Object dataType;
            EntitySelect select = new EntitySelect(objectValue.getBOSType());
            select.propertySelect().select(new String[]{"*"}, new String[]{"dataType"});
            SimpleEntity entity = null;
            entity = null == ctx ? MetaDataAccessFactory.getRemoteInstance().select(select) : MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
            if (null == entity) {
                throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{SHRServerResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "get_meta_error", ctx)});
            }
            SimpleProperty propertyObject = entity.property(property);
            String strDataType = null;
            if (propertyObject == null) {
                SimplePropertyCollection simplePropertyCollection = entity.properties();
                for (int nIndex = 0; nIndex < simplePropertyCollection.size(); ++nIndex) {
                    SimpleProperty simpleProperty = simplePropertyCollection.get(nIndex);
                    if (!simpleProperty.getName().equalsIgnoreCase(property)) continue;
                    propertyObject = simpleProperty;
                    break;
                }
            }
            if (propertyObject == null) {
                strDataType = "java.lang.String";
            } else {
                dataType = propertyObject.getDataType();
                if (dataType == DataType.OBJECTVALUE || dataType == DataType.OBJECTCOLLECTION) {
                    EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectInfo(ctx, objectValue.getBOSType());
                    LinkPropertyInfo lp = (LinkPropertyInfo)entityObjectInfo.getPropertyByNameRuntime(property);
                    EntityObjectInfo supplierObject = lp.getRelationship().getSupplierObject();
                    strDataType = entityObjectInfo.getFullName().equals(supplierObject.getFullName()) ? lp.getRelationship().getClientObject().getObjectValueClass() : propertyObject.getRefTypeInfo();
                } else {
                    strDataType = dataType == DataType.ENUM ? propertyObject.getRefTypeInfo() : (dataType == DataType.STRING ? "java.lang.String" : (dataType == DataType.INTEGER ? "java.lang.Integer" : (dataType == DataType.FLOAT ? "java.lang.Float" : (dataType == DataType.DOUBLE ? "java.lang.Double" : (dataType == DataType.BOOLEAN ? "java.lang.Boolean" : dataType.getJavaTypeName())))));
                }
            }
            dataType = null;
            try {
                dataType = Class.forName(strDataType);
            }
            catch (ClassNotFoundException e) {
                try {
                    if (propertyObject != null) {
                        dataType = BaseMetaDataUtil.getDepEnumType(ctx, entity.toString(), property.toString(), propertyObject.getDataType().toString());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return dataType;
        }
        catch (BOSException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Type getDepEnumType(Context ctx, String entityName, String fieldName, String fieldDataType) throws ClassNotFoundException {
        Class<?> type = null;
        if (DataType.ENUM.toString().equalsIgnoreCase(fieldDataType)) {
            BizEnumInfo info = BaseMetaDataUtil.getBizEnumInfo(ctx, entityName, fieldName);
            BizEnumValueType dataType = info.getDataType();
            String dataTypeStr = dataType.toString().toLowerCase();
            dataTypeStr = dataTypeStr.substring(0, 1).toUpperCase() + dataTypeStr.substring(1);
            String typeString = "java.lang." + dataTypeStr;
            type = Class.forName(typeString);
        }
        return type;
    }

    public static BizEnumInfo getBizEnumInfo(Context ctx, String entityName, String fieldName) {
        PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, entityName, fieldName);
        return BaseMetaDataUtil.getBizEnumInfo(ctx, propertyInfo);
    }

    public static BizEnumInfo getBizEnumInfo(Context ctx, PropertyInfo propertyInfo) {
        BizEnumInfo bizEnum = null;
        if (propertyInfo instanceof OwnPropertyInfo) {
            String metadataRef = ((OwnPropertyInfo)propertyInfo).getMetaDataRef();
            String className = MetaDataUtils.getClassName((String)metadataRef);
            String packageName = MetaDataUtils.getPackageName((String)metadataRef);
            bizEnum = null == ctx ? MetaDataLoaderFactory.getRemoteMetaDataLoader().getEnum((IMetaDataPK)MetaDataPK.create((String)packageName, (String)className)) : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)packageName, (String)className));
        }
        return bizEnum;
    }

    public static String getEntityNameByFieldName(Context ctx, String entityName, String fieldName) {
        PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo(ctx, entityName, fieldName);
        return BaseMetaDataUtil.getEntityNameByPropertyInfo(ctx, entityName, propertyInfo);
    }

    public static boolean isUnionQuery(Context ctx, String query) {
        QueryInfo qi = BaseMetaDataUtil.getQueryInfo(ctx, query);
        return BaseMetaDataUtil.isUnionQuery(qi);
    }

    private static boolean isUnionQuery(QueryInfo qi) {
        if (qi instanceof UnionQueryInfo) {
            return true;
        }
        if (qi instanceof JoinQueryInfo) {
            JoinQueryInfo jqi = (JoinQueryInfo)qi;
            SubObjectCollection coll = jqi.getSubObjects();
            if (null == coll || coll.isEmpty()) {
                return false;
            }
            return BaseMetaDataUtil.isUnionQuery(coll);
        }
        return false;
    }

    private static boolean isUnionQuery(SubObjectCollection querySubObjects) {
        int total = querySubObjects.size();
        for (int i = 0; i < total; ++i) {
            SubQueryInfo sqi;
            QueryInfo qi;
            boolean isUnionQuery;
            SubObjectInfo sbi = querySubObjects.get(i);
            if (sbi instanceof SubEntityInfo || !(sbi instanceof SubQueryInfo) || !(isUnionQuery = BaseMetaDataUtil.isUnionQuery(qi = (sqi = (SubQueryInfo)sbi).getQueryRef()))) continue;
            return true;
        }
        return false;
    }
}

