/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import freemarker.cache.CacheStorage;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class FreemarkerUtils {
    private static final Logger logger = Logger.getLogger(FreemarkerUtils.class);
    private String templatePath = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/shr_web.war/WEB-INF/freemarker/lib/core";
    private static final String SHR_BILL_BASE_TEMPLATE = "com.kingdee.eas.hr.base.SHRBillBaseTemplate";
    private Configuration CONFIGURATION = new Configuration(Configuration.VERSION_2_3_22);

    public FreemarkerUtils(String path) {
        this.templatePath = path;
        try {
            this.CONFIGURATION.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(SHRCheck.checkFilePath(this.templatePath))));
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.CONFIGURATION.setDefaultEncoding("UTF-8");
        this.CONFIGURATION.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.CONFIGURATION.setCacheStorage((CacheStorage)NullCacheStorage.INSTANCE);
    }

    public Template getTemplate(String templateName) throws IOException {
        return this.CONFIGURATION.getTemplate(templateName);
    }

    public void clearCache() {
        this.CONFIGURATION.clearTemplateCache();
    }

    private static String getTemplateName(String viewType, boolean isAffairBizbill, boolean isEntry) {
        if (viewType.equals("list")) {
            if (isAffairBizbill) {
                return "AffairBizbillUiViewTemplateForList.ftl";
            }
            return "uiViewTemplateForList.ftl";
        }
        if (viewType.equals("form")) {
            if (isAffairBizbill) {
                return "AffairBizbillUiViewTemplateForForm.ftl";
            }
            return "uiViewTemplateForForm.ftl";
        }
        if (viewType.equals("core")) {
            return "uiViewTemplateForGeneralPage.ftl";
        }
        if (viewType.equals("search")) {
            if (isEntry) {
                return "uiViewTemplateForEntrySearch.ftl";
            }
            return "uiViewTemplateForSearch.ftl";
        }
        if (viewType.equals("F7")) {
            return "uiViewTemplateForF7.ftl";
        }
        if (viewType.equals("wizard")) {
            return "uiViewTemplateForWizard.ftl";
        }
        if (viewType.equals("dynamicList")) {
            return "uiViewTemplateForDynamicList.ftl";
        }
        if (viewType.equals("dynamicForm")) {
            return "uiViewTemplateForDynamicForm.ftl";
        }
        return null;
    }

    public static String generateUIViewTemplate(Context ctx, String viewType, String entityFullName) throws BOSException {
        String templatePath = FilenameUtils.normalize((String)System.getProperty("EAS_HOME")) + "/server/deploy/easweb.ear/shr_web.war/WEB-INF/freemarker/shr/base/view";
        StringWriter swriter = new StringWriter();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        boolean isAffairBizbill = false;
        if (!viewType.equals("dynamicForm") && !viewType.equals("dynamicList")) {
            Map<String, List<Map<String, Object>>> map = FreemarkerUtils.getEntityProperties(ctx, entityFullName);
            dataModel.put("ownProperty", map.get("ownProperty"));
            dataModel.put("inheritProperty", map.get("inheritProperty"));
            EntityObjectInfo entityObject = MetaDataUtil.getEntityObjectByEntityName((String)entityFullName);
            String businessImplName = entityObject.getBusinessImplName();
            if (!StringUtils.isEmpty((String)businessImplName) && businessImplName.equals(SHR_BILL_BASE_TEMPLATE) && entityObject.isDynamic()) {
                FreemarkerUtils.processEntry(ctx, dataModel, entityFullName);
            }
            String alias = entityObject.getAlias();
            dataModel.put("title", alias);
            dataModel.put("searchUipk", entityFullName + ".search");
            if (viewType.equals(UIType.form.getValue())) {
                dataModel.put("searchUipk", entityFullName + "Entry.search");
            }
            isAffairBizbill = FreemarkerUtils.isAffairBizbill(entityObject, null);
        }
        boolean isEntry = false;
        if (entityFullName.endsWith("Entry")) {
            isEntry = true;
        }
        String templateName = FreemarkerUtils.getTemplateName(viewType, isAffairBizbill, isEntry);
        try {
            Template template = new FreemarkerUtils(templatePath).getTemplate(templateName);
            template.process(dataModel, (Writer)swriter);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        String str = swriter.toString();
        try {
            swriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return str;
    }

    public static boolean isAffairBizbill(EntityObjectInfo entityObject, String entityFullName) {
        if (entityObject == null) {
            entityObject = MetaDataUtil.getEntityObjectByEntityName((String)entityFullName);
        }
        String businessImplName = entityObject.getBusinessImplName();
        return businessImplName.equals("com.kingdee.eas.hr.affair.HRAffairBizBillTemplate");
    }

    private static void processEntry(Context ctx, Map<String, Object> dataModel, String entityName) throws BOSException {
        dataModel.put("isDEPBill", true);
        Map<String, List<Map<String, Object>>> map = null;
        map = FreemarkerUtils.getEntityProperties(ctx, entityName + "Entry");
        dataModel.put("ownEntryProperty", map.get("ownProperty"));
        dataModel.put("inheritEntryProperty", map.get("inheritProperty"));
    }

    public static Map<String, List<Map<String, Object>>> getEntityProperties(Context ctx, String entityName) throws BOSException {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        ArrayList inheritPropertyList = new ArrayList();
        ArrayList ownPropertyList = new ArrayList();
        if (!StringUtils.isEmpty((String)entityName)) {
            EntityObjectInfo entityInfo = null;
            try {
                entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
            }
            catch (Exception e) {
                throw new BOSException(MessageFormat.format(SHRSysSettingResourceUtil.getResource("metas_entity_not_exist", ctx), entityName), (Throwable)e);
            }
            HashMap<String, Object> rowMap = null;
            String valias = "";
            Map<String, PropertyInfo> properties = BaseMetaDataUtil.getProperties(ctx, entityName);
            if (properties.size() <= 0) {
                throw new BOSException(MessageFormat.format(SHRSysSettingResourceUtil.getResource("metas_entity_not_exist", ctx), entityName));
            }
            for (Map.Entry<String, PropertyInfo> entry : properties.entrySet()) {
                OwnPropertyInfo own;
                DataType dataType;
                String key = entry.getKey();
                boolean isBasicItem = false;
                boolean isStringType = false;
                String fastBaseItemF7 = "";
                String defaultF7UIPK = "";
                PropertyInfo propertyInfo = entry.getValue();
                if (key.endsWith("_p") || key.endsWith("_h")) continue;
                if (propertyInfo instanceof LinkPropertyInfo) {
                    LinkPropertyInfo link = (LinkPropertyInfo)propertyInfo;
                    RelationshipInfo r = link.getRelationship();
                    EntityObjectInfo supplierObject = r.getSupplierObject();
                    if (r.getClientObject().getFullName().equals(entityName) && RelationshipType.COMPOSITION.equals((Object)r.getType())) continue;
                    isBasicItem = SysSettingSHRBaseItemUtil.isSHRBaseItem(ctx, supplierObject.getFullName());
                    fastBaseItemF7 = supplierObject.getFullName() + ".FastFilter.F7";
                    defaultF7UIPK = FreemarkerUtils.getDefaultF7UIPK(ctx, supplierObject.getFullName());
                }
                if (null == propertyInfo) continue;
                rowMap = new HashMap<String, Object>();
                valias = propertyInfo.getAlias(LocaleUtils.locale_zh_CN);
                if (StringUtils.isEmpty((String)valias)) {
                    valias = propertyInfo.getDescription(LocaleUtils.locale_zh_CN);
                }
                if (propertyInfo instanceof OwnPropertyInfo && (dataType = (own = (OwnPropertyInfo)propertyInfo).getDataType()).equals((Object)DataType.STRING)) {
                    isStringType = true;
                }
                rowMap.put("name", key);
                rowMap.put("title", valias);
                rowMap.put("index", inheritPropertyList.size() + 1);
                rowMap.put("isBasicItem", isBasicItem);
                rowMap.put("isStringType", isStringType);
                rowMap.put("defaultF7UIPK", defaultF7UIPK);
                if (isBasicItem) {
                    rowMap.put("fastBaseItemF7", fastBaseItemF7);
                }
                if (entityInfo.isDynamic()) {
                    if (propertyInfo.isConfigured()) {
                        ownPropertyList.add(rowMap);
                        continue;
                    }
                    if (!FreemarkerUtils.isNeed(key)) continue;
                    inheritPropertyList.add(rowMap);
                    continue;
                }
                ownPropertyList.add(rowMap);
            }
        }
        result.put("ownProperty", ownPropertyList);
        result.put("inheritProperty", inheritPropertyList);
        return result;
    }

    private static boolean isNeed(String key) {
        boolean isNeed = true;
        if (key.equals("creator") || key.equals("createTime") || key.equals("lastUpdateUser") || key.equals("lastUpdateTime") || key.equals("CU") || key.equals("id")) {
            isNeed = false;
        }
        return isNeed;
    }

    private static String getDefaultF7UIPK(Context ctx, String entityName) {
        String uipk = null;
        try {
            UIViewInfo uiViewInfo;
            if (StringUtils.isEmpty(uipk) && null == (uiViewInfo = UIViewUtil.getUIViewInfoByUIPK((Context)ctx, (String)(uipk = entityName + ".F7")))) {
                uipk = null;
            }
        }
        catch (SHRWebException e) {
            uipk = null;
        }
        if (StringUtils.isEmpty(uipk)) {
            uipk = entityName + ".list";
        }
        return uipk;
    }
}

