/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IHROrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.IBaseItemRelationHR;
import com.kingdee.shr.base.syssetting.ISHRBaseItem;
import com.kingdee.shr.base.syssetting.SHRBasicItemCollection;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.UsePolicy;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.BaseItemRelationHRUtil;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class SysSettingHrOrgUnitUtil {
    private static Logger logger = Logger.getLogger(SysSettingHrOrgUnitUtil.class);

    private SysSettingHrOrgUnitUtil() {
    }

    public static IObjectPK[] addBaseInfoAndHRBURefByAdd(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo model = coll.get(i);
                BaseItemRelationHRUtil.generateBaseItemToRelation(ctx, model);
            }
        }
        return null;
    }

    public static IObjectPK[] updateBaseInfoAndHRBURefBySealUp(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo model = coll.get(i);
                BaseItemRelationHRUtil.updateRelationDisableByHrOrgUnitId(ctx, model, hrOrgUnitId);
            }
        }
        return null;
    }

    public static IObjectPK[] updateBaseInfoAndHRBURefByUnSealUp(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo model = coll.get(i);
                BaseItemRelationHRUtil.updateRelationEnableByHrOrgUnitId(ctx, model, hrOrgUnitId);
            }
        }
        return null;
    }

    private static boolean isSHRBaseItem(Context ctx, SHRBasicItemInfo model) throws EASBizException {
        if (StringUtils.isEmpty((String)model.getEntityName())) {
            logger.error((Object)("baseItem: " + model.getName() + "has no entity found"));
            return Boolean.FALSE;
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getEntityName());
        if (null == entityObjectInfo.getType() || null == entityObjectInfo.getBaseEntity()) {
            logger.error((Object)("baseItem: " + model.getName() + "has no metadata found"));
            return Boolean.FALSE;
        }
        return SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity());
    }

    private static boolean isSHRBaseItemRelationHR(Context ctx, SHRBasicItemInfo model) throws EASBizException {
        if (StringUtils.isEmpty((String)model.getRelationHREntity())) {
            logger.error((Object)("baseItem: " + model.getName() + "entity (" + model.getEntityName() + ") usable related entity is null"));
            return Boolean.FALSE;
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getRelationHREntity());
        if (null == entityObjectInfo.getType() || null == entityObjectInfo.getBaseEntity()) {
            logger.error((Object)("baseItem usable related entity:" + model.getRelationHREntity() + " do not found metadata!"));
            return Boolean.FALSE;
        }
        return SysSettingHrOrgUnitUtil.isSHRBaseItem(ctx, model) && BaseItemRelationHRUtil.isSHRBaseItemRelationHR(entityObjectInfo.getBaseEntity());
    }

    public static IObjectPK[] deleteBaseInfoAndHRBURefByUnSealUp(Context ctx, String hrOrgUnitId) throws BOSException, EASBizException {
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemCollection();
        if (null != coll && coll.size() > 0) {
            ISHRBaseItem iSHRBaseItem = null;
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo model = coll.get(i);
                if (!SysSettingHrOrgUnitUtil.isSHRBaseItem(ctx, model)) continue;
                iSHRBaseItem = (ISHRBaseItem)BaseMetaDataUtil.getBizInterface(ctx, model.getEntityName());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrgUnitId, CompareType.EQUALS));
                if (!iSHRBaseItem.exists(filter)) continue;
                throw new BaseItemException(BaseItemException.BIZORG_SEALED_RELATED, new Object[]{model.getName()});
            }
        }
        return null;
    }

    public static IObjectPK[] dealMoveHrOrgUnitParent(Context ctx, String hrOrgUnitId, String oldParentId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)oldParentId)) {
            throw new BaseItemException(BaseItemException.ROOT_BIZORG_NOT_MOVE);
        }
        HashSet<String> oldUpHrOrgUnitIds = new HashSet<String>();
        oldUpHrOrgUnitIds.add(oldParentId);
        SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, oldParentId, oldUpHrOrgUnitIds, Boolean.FALSE);
        HashSet<String> newUpHrOrgUnitIds = new HashSet<String>();
        SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, hrOrgUnitId, newUpHrOrgUnitIds, Boolean.FALSE);
        HashSet<String> newDwonHrOrgUnitIds = new HashSet<String>();
        newDwonHrOrgUnitIds.add(hrOrgUnitId);
        SysSettingHrOrgUnitUtil.getHrOrgUnitSets(ctx, hrOrgUnitId, newDwonHrOrgUnitIds, Boolean.TRUE);
        SHRBasicItemCollection coll = SHRBasicItemFactory.getLocalInstance(ctx).getSHRBasicItemCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                SHRBasicItemInfo model = coll.get(i);
                if (!SysSettingHrOrgUnitUtil.isSHRBaseItemRelationHR(ctx, model)) continue;
                SysSettingHrOrgUnitUtil.batchDisable(ctx, model, oldUpHrOrgUnitIds, newDwonHrOrgUnitIds);
                SysSettingHrOrgUnitUtil.batchEnable(ctx, model, newUpHrOrgUnitIds, newDwonHrOrgUnitIds);
            }
        }
        return null;
    }

    private static EntityViewInfo getEntityViewInfo(Set<String> hrOrgUnitIds) {
        FilterInfo newFilter = new FilterInfo();
        newFilter.getFilterItems().add(new FilterItemInfo("usePolicy", (Object)200, CompareType.EQUALS));
        newFilter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", hrOrgUnitIds, CompareType.INCLUDE));
        newFilter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        EntityViewInfo newView = new EntityViewInfo();
        newView.setFilter(newFilter);
        return newView;
    }

    private static void batchDisable(Context ctx, SHRBasicItemInfo model, Set<String> hrOrgUnitIds, Set<String> newDwonHrOrgUnitIds) throws BOSException, EASBizException {
        CoreBaseCollection coll = BaseMetaDataUtil.getBizInterface(ctx, model.getEntityName()).getCollection(SysSettingHrOrgUnitUtil.getEntityViewInfo(hrOrgUnitIds));
        if (null != coll && coll.size() > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                CoreBaseInfo coreModel = coll.get(i);
                for (String id : newDwonHrOrgUnitIds) {
                    paramList.add(new Object[]{200, coreModel.getId().toString(), id});
                }
            }
            EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, model.getRelationHREntity());
            String sql = "update " + entityObjectInfo.getTable().getName() + " set FState = ? where FBaseInfoId = ? and FHrOrgUseId = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
        }
    }

    private static void batchEnable(Context ctx, SHRBasicItemInfo model, Set<String> newUpHrOrgUnitIds, Set<String> newDwonHrOrgUnitIds) throws BOSException, EASBizException {
        IBaseItemRelationHR iBaseItemRelationHR = BaseItemRelationHRUtil.getIBaseItemRelationHR(ctx, model);
        CoreBaseCollection coll = BaseMetaDataUtil.getBizInterface(ctx, model.getEntityName()).getCollection(SysSettingHrOrgUnitUtil.getEntityViewInfo(newUpHrOrgUnitIds));
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                CoreBaseInfo coreModel = coll.get(i);
                for (String id : newDwonHrOrgUnitIds) {
                    iBaseItemRelationHR.saveByBaseIdAndHRBUId(coreModel.getId().toString(), id, 100);
                }
            }
        }
    }

    public static HROrgUnitInfo getHrOrgUnitInfo(Context ctx, String hrOrgUnitId) throws EASBizException, BOSException {
        return HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(hrOrgUnitId));
    }

    public static void getHrOrgUnitSets(Context ctx, String hrOrgUnitId, Set<String> hrOrgUnitIds, boolean isDown) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid, fparentid from T_ORG_HRO where FIsSealUp = ?", (Object[])new Object[]{0});
        HashMap<String, String> map = new HashMap<String, String>();
        String localHrOrgUnitId = hrOrgUnitId;
        try {
            while (rs.next()) {
                map.put(rs.getString("fid"), rs.getString("fparentid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (isDown) {
            SysSettingHrOrgUnitUtil.getDownHrOrgUnitSets(map, localHrOrgUnitId, hrOrgUnitIds);
        } else {
            String parent;
            while (!StringUtils.isEmpty((String)(parent = (String)map.get(localHrOrgUnitId)))) {
                hrOrgUnitIds.add(parent);
                localHrOrgUnitId = parent;
            }
        }
    }

    private static void getDownHrOrgUnitSets(Map<String, String> map, String hrOrgUnitId, Set<String> hrOrgUnitIds) {
        HashSet<String> tempSet = new HashSet<String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isEmpty((String)value) || !hrOrgUnitId.equals(value) || hrOrgUnitIds.contains(key)) continue;
            hrOrgUnitIds.add(key);
            tempSet.add(key);
        }
        if (tempSet.size() <= 0) {
            return;
        }
        for (String tempHrOrgUnitId : tempSet) {
            SysSettingHrOrgUnitUtil.getDownHrOrgUnitSets(map, tempHrOrgUnitId, hrOrgUnitIds);
        }
    }

    public static void getHrOrgUnitsExcuteById(Context ctx, String id, Set<String> hrOrgUnitIds) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_ORG_HRO where FIsSealUp = ? and fid <> ? ", (Object[])new Object[]{0, id});
        try {
            while (rs.next()) {
                hrOrgUnitIds.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static HROrgUnitInfo getRootHrOrgUnit(Context ctx) throws BOSException, EASBizException {
        return HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo("select id where parent is null ");
    }

    public static void getAllHrOrgUnits(Context ctx, Set<String> hrOrgUnitIds) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid from T_ORG_HRO where FIsSealUp = ?", (Object[])new Object[]{0});
        try {
            while (rs.next()) {
                hrOrgUnitIds.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static HROrgUnitCollection queryHROrgUnitCollection(Context ctx, UsePolicy usePolicy, Set<String> hrOrgUnitIds) throws BOSException {
        IHROrgUnit iHROrgUnit = HROrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        if (UsePolicy.DOWN_SHARED.equals((Object)usePolicy)) {
            filter.getFilterItems().add(new FilterItemInfo("id", hrOrgUnitIds, CompareType.INCLUDE));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.setSelector(sic);
        return iHROrgUnit.getHROrgUnitCollection(view);
    }

    public static String getAvailableCreateBaseItemHrOrgUnitIdsSql(Context ctx, String entityName, String permItemId) {
        String userId = HRFilterUtils.getCurrentUserId(ctx);
        String userHROrgRangeSQL = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)permItemId);
        StringBuilder sb = new StringBuilder();
        sb.append(SysSettingHrOrgUnitUtil.genarateSql(userHROrgRangeSQL, "not", entityName, 100, 100));
        sb.append(" union ");
        sb.append(SysSettingHrOrgUnitUtil.genarateSql(null, "not", entityName, 100, 200));
        sb.append(" union ");
        sb.append(SysSettingHrOrgUnitUtil.genarateSql(userHROrgRangeSQL, "", entityName, 200, 100));
        sb.append(" union ");
        sb.append(SysSettingHrOrgUnitUtil.genarateSql(null, "", entityName, 200, 200));
        return sb.toString();
    }

    private static String genarateSql(String userHROrgRangeSQL, String emptyOrNot, String entityName, int managerPolicyValue, int maintainPolicyValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from T_ORG_HRO").append(" where").append(" fisSealUp = 0");
        if (!StringUtils.isEmpty((String)userHROrgRangeSQL)) {
            sb.append(" and fid in (").append(userHROrgRangeSQL).append(" )");
        }
        sb.append(" and ").append(emptyOrNot).append(" exists(").append(" SELECT 1 FROM T_BS_SHRBasicItem sci").append(" inner join T_HR_ControlPolicy cp on sci.FID = cp.fshrbasicitemid").append(" inner join T_HR_BaseInfoHRBU hr on sci.FID = hr.fshrbasicitemid").append(" where").append(" sci.FENTITYNAME = '").append(entityName).append("'").append(" and sci.fmanagepolicy = ").append(managerPolicyValue).append(" and cp.FMaintainPolicy = ").append(maintainPolicyValue).append(" and T_ORG_HRO.fid = hr.FHrOrgId").append(" )");
        return sb.toString();
    }

    public static Set<String> getSealUpHrOrg(Context ctx) throws BOSException {
        String hrOrgSeqlUpSql = "SELECT FID FROM T_ORG_HRO WHERE FISSEALUP = ?";
        HashSet<String> result = new HashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)hrOrgSeqlUpSql, (Object[])new Object[]{1});
        try {
            while (rs.next()) {
                result.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void removeSealUpHrOrgId(Set<String> hrOrgRangeIdSet, Set<String> hrOrgSealUpIdSet) {
        HashSet<String> needRemoveId = new HashSet<String>();
        for (String key : hrOrgRangeIdSet) {
            if (!hrOrgSealUpIdSet.contains(key)) continue;
            needRemoveId.add(key);
        }
        if (!needRemoveId.isEmpty()) {
            hrOrgRangeIdSet.removeAll(needRemoveId);
        }
    }
}

