/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.api.bean.BaseItemParam;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingHrOrgUnitUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class SysSettingSHRBaseItemUtil {
    private static Logger logger = Logger.getLogger(SysSettingSHRBaseItemUtil.class);
    public static final String HR_ORG_RANGE_INNER = "hrOrgInner";
    public static final String HR_ORG_RANGE_OUTER = "hrOrgOuter";

    private SysSettingSHRBaseItemUtil() {
    }

    public static SHRBaseItemInfo getSHRBaseItemInfo(Context ctx, String shrBaseItemId) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface(ctx, BaseMetaDataUtil.getBOSObjectTypeById(shrBaseItemId));
        if (iCoreBase.exists((IObjectPK)(pk = new ObjectUuidPK(shrBaseItemId)))) {
            return (SHRBaseItemInfo)iCoreBase.getValue((IObjectPK)pk);
        }
        return null;
    }

    public static SHRBaseItemInfo getSHRBaseItemInfo(Context ctx, String shrBaseItemId, SelectorItemCollection selector) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        ICoreBase iCoreBase = BaseMetaDataUtil.getBizInterface(ctx, BaseMetaDataUtil.getBOSObjectTypeById(shrBaseItemId));
        if (iCoreBase.exists((IObjectPK)(pk = new ObjectUuidPK(shrBaseItemId)))) {
            return (SHRBaseItemInfo)iCoreBase.getValue((IObjectPK)pk, selector);
        }
        return null;
    }

    public static int queryMaintainCount(Context ctx, BaseItemParam param) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)param.getEntityName()) && StringUtils.isEmpty((String)param.getRealEntityName())) {
            throw new BaseItemException(BaseItemException.NAME_BOTH_NOT_NULL);
        }
        SHRBasicItemInfo info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, param.getEntityName());
        if (null == info && null == (info = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, param.getRealEntityName()))) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_BASEITEM, new Object[]{param.getEntityName()});
        }
        if (StringUtils.isEmpty((String)param.getEntityName())) {
            param.setEntityName(info.getEntityName());
        }
        IRowSet rs = null;
        int count = 0;
        String sql = SysSettingSHRBaseItemUtil.getMaintainBaseInfoCountSql(ctx, param);
        if (StringUtils.isEmpty((String)sql)) {
            return count;
        }
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                count = rs.getInt("ct");
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            return 0;
        }
        return count;
    }

    public static String getMaintainBaseInfoCountSql(Context ctx, BaseItemParam param) throws EASBizException, BOSException {
        String sql = SysSettingSHRBaseItemUtil.getMaintainBaseInfoSql(ctx, param);
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        return "select count(*) ct from (" + sql + ") tt";
    }

    public static String getMaintainBaseInfoSql(Context ctx, BaseItemParam param) throws EASBizException, BOSException {
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, param.getEntityName());
        if (null == entityObjectInfo) {
            logger.error((Object)("no such entity found according to the entityName: " + param.getEntityName()));
            return null;
        }
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity())) {
            logger.error((Object)("entity " + param.getEntityName() + "do not extends SHRBaseItem\u3002"));
            return null;
        }
        DataTableInfo dataTableInfo = entityObjectInfo.getTable();
        if (null == dataTableInfo) {
            logger.error((Object)("no such table found according to the entityName: " + param.getEntityName()));
            return null;
        }
        String tableName = dataTableInfo.getName();
        String userId = HRFilterUtils.getCurrentUserId(ctx);
        String innerBaseSql = SysSettingSHRBaseItemUtil.getInnerMaintainBaseSql(tableName);
        String outerBaseSql = SysSettingSHRBaseItemUtil.getOuterMaintainBaseSql(tableName);
        String innerFilterSql = SysSettingSHRBaseItemUtil.getInnerFilterSql(ctx, param.getHrOrgUnitIds(), param.isPermItemRelationHR(), userId, param.getPermItemId(), param.isShowSealUpHrOrg());
        String outerFiltersql = SysSettingSHRBaseItemUtil.getOuterFilterSql(ctx, userId, param.getPermItemId(), param.isPermItemRelationHR(), param.isShowSealUpHrOrg());
        String usePolicyFilterSql = SysSettingSHRBaseItemUtil.getUsePolicyFilterSql(param.getUsePolicys());
        String useStateFilterSql = SysSettingSHRBaseItemUtil.getStateFtilterSql(param.getBaseItemStates());
        String innerMoreFilterSql = SysSettingSHRBaseItemUtil.getInnerMoreFilterSql(param.getInnerMoreFilter());
        String outerMoreFilterSql = SysSettingSHRBaseItemUtil.getOuterMoreFilterSql(param.getOuterMoreFilter());
        StringBuilder sqlAll = new StringBuilder();
        StringBuilder sqlInner = new StringBuilder();
        StringBuilder sqlOuter = new StringBuilder();
        StringBuilder sqlInnerFilter = null;
        StringBuilder sqlOuterFilter = null;
        sqlInner.append(innerBaseSql);
        sqlOuter.append(outerBaseSql);
        String[] hrOrgRanges = null;
        if (!StringUtils.isEmpty((String)param.getHrOrgRanges())) {
            hrOrgRanges = param.getHrOrgRanges().split(",");
        }
        if (null == hrOrgRanges || hrOrgRanges.length == 2) {
            sqlInnerFilter = new StringBuilder();
            sqlOuterFilter = new StringBuilder();
            sqlInnerFilter.append(innerFilterSql);
            sqlOuterFilter.append(outerFiltersql);
        } else if (hrOrgRanges.length == 1) {
            if (HR_ORG_RANGE_INNER.equals(hrOrgRanges[0])) {
                sqlInnerFilter = new StringBuilder();
                sqlInnerFilter.append(innerFilterSql);
            } else {
                sqlOuterFilter = new StringBuilder();
                sqlOuterFilter.append(outerFiltersql);
            }
        }
        if (null != sqlInnerFilter) {
            if (!StringUtils.isEmpty((String)usePolicyFilterSql)) {
                sqlInnerFilter.append(usePolicyFilterSql);
            }
            if (!StringUtils.isEmpty((String)useStateFilterSql)) {
                sqlInnerFilter.append(useStateFilterSql);
            }
            if (!StringUtils.isEmpty((String)innerMoreFilterSql)) {
                sqlInnerFilter.append(innerMoreFilterSql);
            }
            sqlInner.append((CharSequence)sqlInnerFilter);
        }
        if (null != sqlOuterFilter) {
            if (!StringUtils.isEmpty((String)usePolicyFilterSql)) {
                sqlOuterFilter.append(usePolicyFilterSql);
            }
            if (!StringUtils.isEmpty((String)useStateFilterSql)) {
                sqlOuterFilter.append(useStateFilterSql);
            }
            if (!StringUtils.isEmpty((String)outerMoreFilterSql)) {
                sqlOuterFilter.append(outerMoreFilterSql);
            }
            sqlOuter.append((CharSequence)sqlOuterFilter);
        }
        if (null != sqlInnerFilter && null != sqlOuterFilter) {
            sqlAll.append(sqlInner.toString()).append(" union ").append(sqlOuter.toString());
        } else if (null != sqlInnerFilter && null == sqlOuterFilter) {
            sqlAll.append(sqlInner.toString());
        } else if (null == sqlInnerFilter && null != sqlOuterFilter) {
            sqlAll.append(sqlOuter.toString());
        } else {
            sqlAll = null;
        }
        if (null == sqlAll) {
            return null;
        }
        return sqlAll.toString();
    }

    private static String getInnerMaintainBaseSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select baseItem.fid from ").append(tableName).append(" baseItem").append(" where 1 = 1");
        return sql.toString();
    }

    private static String getOuterMaintainBaseSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("select baseItem.fid from ").append(tableName).append(" baseItem").append(" inner join T_HR_ControlPolicy cp on baseItem.FShrBasicItemID = cp.FShrBasicItemID").append(" where 1 = 1");
        return sql.toString();
    }

    private static String getInnerFilterSql(Context ctx, String hrOrgUnitIds, boolean isPermItemRelationHR, String userId, String permitemId, boolean isShowSealUpHrOrg) throws BOSException {
        String[] hrOrgUnit = null;
        if (!StringUtils.isEmpty((String)hrOrgUnitIds)) {
            hrOrgUnit = hrOrgUnitIds.split(",");
        }
        StringBuilder sqlInnerFilter = new StringBuilder();
        if (null != hrOrgUnit) {
            sqlInnerFilter.append(" and baseItem.fhrorgunitid in (");
            sqlInnerFilter.append(DataValueTranslatorUtil.stringArray2String(hrOrgUnit));
            sqlInnerFilter.append(") ");
            return sqlInnerFilter.toString();
        }
        if (isPermItemRelationHR) {
            sqlInnerFilter.append(" and baseItem.fhrorgunitid in (");
            Set hrOrgRangeIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permitemId);
            HashSet<String> hrOrgRangeIdSetClone = new HashSet<String>();
            hrOrgRangeIdSetClone.addAll(hrOrgRangeIdSet);
            if (!isShowSealUpHrOrg) {
                Set<String> hrOrgSealUpIdSet = SysSettingHrOrgUnitUtil.getSealUpHrOrg(ctx);
                SysSettingHrOrgUnitUtil.removeSealUpHrOrgId(hrOrgRangeIdSetClone, hrOrgSealUpIdSet);
            }
            String hrOrgFilterSql = DataValueTranslatorUtil.hashSet2String(hrOrgRangeIdSetClone);
            sqlInnerFilter.append(hrOrgFilterSql);
            sqlInnerFilter.append(") ");
        }
        return sqlInnerFilter.toString();
    }

    private static String getOuterFilterSql(Context ctx, String userId, String permitemId, boolean isPermItemRelationHR, boolean isShowSealUpHrOrg) throws BOSException {
        StringBuilder sqlOuterFilter = new StringBuilder();
        if (isPermItemRelationHR) {
            Set hrOrgRangeIdSet = SHRUserOrgPermissionApi.getUserHROrgRangeIdSet((Context)ctx, (String)userId, (String)permitemId);
            HashSet<String> hrOrgRangeIdSetClone = new HashSet<String>();
            hrOrgRangeIdSetClone.addAll(hrOrgRangeIdSet);
            if (isShowSealUpHrOrg) {
                Set<String> hrOrgSealUpIdSet = SysSettingHrOrgUnitUtil.getSealUpHrOrg(ctx);
                SysSettingHrOrgUnitUtil.removeSealUpHrOrgId(hrOrgRangeIdSetClone, hrOrgSealUpIdSet);
            }
            String hrOrgFilterSql = DataValueTranslatorUtil.hashSet2String(hrOrgRangeIdSetClone);
            sqlOuterFilter.append(" and baseItem.fhrorgunitid not in (").append(hrOrgFilterSql).append(")");
        }
        sqlOuterFilter.append(" and baseItem.FUsePolicy = ").append(100);
        sqlOuterFilter.append(" and cp.FMaintainPolicy = ").append(200);
        return sqlOuterFilter.toString();
    }

    private static String getUsePolicyFilterSql(String usePolicys) {
        String[] usePolicy = null;
        if (!StringUtils.isEmpty((String)usePolicys)) {
            usePolicy = usePolicys.split(",");
        }
        if (null != usePolicy && usePolicy.length > 0) {
            StringBuilder sqlUsePolicyFilter = new StringBuilder();
            sqlUsePolicyFilter.append(" and baseItem.FUsePolicy in(");
            sqlUsePolicyFilter.append(DataValueTranslatorUtil.stringArray2Number(usePolicy));
            sqlUsePolicyFilter.append(" )");
            return sqlUsePolicyFilter.toString();
        }
        return null;
    }

    private static String getStateFtilterSql(String state) {
        String[] states = null;
        if (!StringUtils.isEmpty((String)state)) {
            states = state.split(",");
        }
        if (null != states && states.length > 0) {
            StringBuilder sqlStateFilter = new StringBuilder();
            sqlStateFilter.append(" and baseItem.FState in(");
            sqlStateFilter.append(DataValueTranslatorUtil.stringArray2Number(states));
            sqlStateFilter.append(" )");
            return sqlStateFilter.toString();
        }
        return null;
    }

    private static String getInnerMoreFilterSql(String innerMoreFilter) {
        if (!StringUtils.isEmpty((String)innerMoreFilter)) {
            StringBuilder sqlmoreFilter = new StringBuilder();
            sqlmoreFilter.append(" and (").append(innerMoreFilter).append(") ");
            return sqlmoreFilter.toString();
        }
        return null;
    }

    private static String getOuterMoreFilterSql(String outerMoreFilter) {
        if (!StringUtils.isEmpty((String)outerMoreFilter)) {
            StringBuilder sqlmoreFilter = new StringBuilder();
            sqlmoreFilter.append(" and (").append(outerMoreFilter).append(") ");
            return sqlmoreFilter.toString();
        }
        return null;
    }

    public static boolean existsEnableBaseItem(Context ctx, String tableName) throws BOSException {
        int count = -1;
        String countSql = "select count(*) ct from " + tableName + " where fstate <> " + 0;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)countSql);
        try {
            while (rs.next()) {
                count = rs.getInt("ct");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count > 0;
    }

    public static boolean isDeleteByBaseItemTable(Context ctx, String tableName) throws EASBizException, BOSException {
        return !SysSettingSHRBaseItemUtil.existsEnableBaseItem(ctx, tableName);
    }

    public static void deleteByBaseItemTable(Context ctx, String tableName) throws EASBizException, BOSException {
        String sql = "select fid from " + tableName;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                SysSettingSHRBaseItemUtil.deleteByBaseItemId(ctx, id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    public static void deleteByBaseItemId(Context ctx, String id) throws EASBizException, BOSException {
        BaseMetaDataUtil.getBizInterface(ctx, BaseMetaDataUtil.getBOSObjectTypeById(id)).delete((IObjectPK)new ObjectUuidPK(id));
    }

    public static void customBaseItemInit(Context ctx, SHRBasicItemInfo shrBasicItemInfo) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getEntityName())) {
            logger.error((Object)("SysSettingSHRBaseItemUtil.customBaseItemInit baseItem (" + shrBasicItemInfo.getName() + ") has empty metadataEntity, unable to upgrade."));
            return;
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, shrBasicItemInfo.getEntityName());
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity())) {
            logger.error((Object)("SysSettingSHRBaseItemUtil.customBaseItemInit baseItem (" + shrBasicItemInfo.getName() + ")'s metadataEntity(" + shrBasicItemInfo.getEntityName() + ") don't extends baseItem class(" + "com.kingdee.shr.base.syssetting.app.SHRBaseItem" + ") unable to upgrade."));
            return;
        }
        String tableName = entityObjectInfo.getTable().getName();
        SysSettingSHRBaseItemUtil.checkFields(ctx, tableName);
        StringBuilder sb = new StringBuilder();
        sb.append("select fid from ").append(tableName).append(" where FShrBasicItemId is null or FHrOrgUnitId is null");
        HROrgUnitInfo hrOrgUnitInfo = SysSettingHrOrgUnitUtil.getRootHrOrgUnit(ctx);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        StringBuilder updateSql = new StringBuilder();
        updateSql.append("update ").append(tableName).append(" set FShrBasicItemId = ?, FUsePolicy = ?, FIsSysPreset = ?, FState = ?, FHrOrgUnitId = ?, FLastUpdateTime = now(), FLastUpdateUserID = '256c221a-0106-1000-e000-10d7c0a813f413B7DE7F' where FID = ?");
        try {
            while (rs.next()) {
                params.add(new Object[]{shrBasicItemInfo.getId().toString(), shrBasicItemInfo.getDefPolicy().getValue(), 0, 1, hrOrgUnitInfo.getId().toString(), rs.getString("fid")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!params.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), params);
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tableName).append(" set FShrBasicItemID ='").append(shrBasicItemInfo.getId().toString()).append("'").append(" where FShrBasicItemID <> '").append(shrBasicItemInfo.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static Map<String, String> getFiledMap() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("FShrBasicItemID", "VARCHAR(44)");
        fields.put("FUsePolicy", "INT");
        fields.put("FIsSysPreset", "INT");
        fields.put("FState", "INT DEFAULT 0");
        fields.put("FIndex", "INT");
        fields.put("FHrOrgUnitId", "VARCHAR(44)");
        return fields;
    }

    private static void checkFields(Context ctx, String tableName) throws BOSException {
        Map<String, String> fields = SysSettingSHRBaseItemUtil.getFiledMap();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME = '").append(entry.getKey()).append("'").append(" and KSQL_COL_TABNAME= '").append(tableName).append("')").append(" alter table ").append(tableName).append(" add ").append(entry.getKey()).append(" ").append(entry.getValue());
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
    }

    public static void checkEntityNameValid(Context ctx, String entityName) throws EASBizException {
        if (StringUtils.isEmpty((String)entityName)) {
            throw new BaseItemException(BaseItemException.BASEITEM_ENTITY_NAME_NULL);
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, entityName);
        if (null == entityObjectInfo || null == entityObjectInfo.getType()) {
            throw new BaseItemException(BaseItemException.METADATA_INFO_NOT_FOUND, new Object[]{entityName});
        }
        if (!SysSettingSHRBaseItemUtil.isSHRBaseItem(entityObjectInfo.getBaseEntity())) {
            throw new BaseItemException(BaseItemException.ENTITY_NOT_SHR_BASEITEM, new Object[]{entityName});
        }
    }

    public static boolean isSHRBaseItem(EntityObjectInfo superEntity) {
        return BaseMetaDataUtil.isInheritBaseClass(superEntity, "com.kingdee.shr.base.syssetting.app.SHRBaseItem");
    }

    public static boolean isSHRBaseItem(Context ctx, String entityName) {
        if (ctx == null || StringUtils.isEmpty((String)entityName)) {
            return false;
        }
        try {
            SHRBasicItemInfo basicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
            if (null != basicItemInfo) {
                EntityObjectInfo relatoinEntity = BaseMetaDataUtil.getEntityObjectByEntityName(ctx, basicItemInfo.getEntityName());
                return SysSettingSHRBaseItemUtil.isSHRBaseItem(relatoinEntity.getBaseEntity());
            }
            return false;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isSHRBaseItemMaintainListView(Context ctx, String entityName, String uipk) {
        if (ctx == null || StringUtils.isEmpty((String)entityName)) {
            return false;
        }
        try {
            SHRBasicItemInfo basicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName(ctx, entityName);
            if (null != basicItemInfo && !StringUtils.isEmpty((String)basicItemInfo.getMaintainUipk()) && basicItemInfo.getMaintainUipk().equals(uipk)) {
                return true;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return false;
    }
}

