/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util.custom;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.DynamicMetadataFactory;
import com.kingdee.bos.config.IDynamicMetadata;
import com.kingdee.bos.dao.xml.XMLAccessEngine;
import com.kingdee.bos.db.DBUpdateInfo;
import com.kingdee.bos.db.DBUpdateInfoSet;
import com.kingdee.bos.metadata.AbstractMetaDataValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bizunit.BIMNameFactory;
import com.kingdee.bos.metadata.bizunit.BizUnitCtrl;
import com.kingdee.bos.metadata.bizunit.BizUnitHelper;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.data.AbstractTableInfo;
import com.kingdee.bos.metadata.data.ColumnCollection;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.management.SuffixCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.CustomizedItemFactory;
import com.kingdee.eas.ep.CustomizedItems;
import com.kingdee.eas.ep.ICustomizedItem;
import com.kingdee.eas.ep.IUpdateSql;
import com.kingdee.eas.ep.ReCreateException;
import com.kingdee.eas.ep.UpdateSqlFactory;
import com.kingdee.eas.ep.UpdateSqlInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.custom.SHRMetaDataGetter;
import com.kingdee.shr.base.syssetting.util.custom.SHRSqlBuilder;
import com.kingdee.shr.base.syssetting.util.custom.SHRUictUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SHRCopyCreator {
    private static final Logger logger = Logger.getLogger(SHRCopyCreator.class);
    private SuffixCollection suffixs;
    private TemplateInfo templateInfo = null;
    private String customizedSchemedID;
    private Project depend;
    private BizUnitInfo bizUnit = null;
    private AbstractMetaDataValue[] mds = null;
    private Context ctx = null;
    private Map<String, Object> oldMdsMap = null;

    public SHRCopyCreator(Context ctx, TemplateInfo templateInfo, String customizedSchemedID, Project depend, Map<String, Object> oldMdsMap) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        SolutionInfo solution = loader.getSolution();
        this.suffixs = solution.getSuffixes();
        this.templateInfo = templateInfo;
        this.customizedSchemedID = customizedSchemedID;
        this.depend = depend;
        this.ctx = ctx;
        this.oldMdsMap = oldMdsMap;
    }

    private void addMetaDataPK(CustomizedItems items, AbstractMetaDataValue meta) {
        if (meta != null) {
            items.addMetadataPK(meta.getRealFullName());
        }
    }

    private boolean isCustomized(AbstractMetaDataValue[] mds) throws Exception {
        if (mds == null) {
            return false;
        }
        ICustomizedItem iCustomizedItem = CustomizedItemFactory.getLocalInstance((Context)this.ctx);
        CustomizedItems items = new CustomizedItems();
        items.setSchemeID(this.customizedSchemedID);
        int total = mds.length;
        for (int i = 0; i < total; ++i) {
            if (iCustomizedItem.exists(" where schemeID = '" + this.customizedSchemedID + "' and metadata = '" + mds[i].getRealFullName() + "'")) continue;
            this.addMetaDataPK(items, mds[i]);
        }
        return iCustomizedItem.isCustomized(items);
    }

    public BizUnitInfo create() throws Exception {
        AbstractMetaDataValue md;
        String editUI;
        BizUnitInfo temp;
        JoinQueryInfo query;
        if (this.templateInfo == null) {
            return null;
        }
        MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).clear(MetaDataTypeList.UIOBJECT);
        XMLAccessEngine.getXMLLoader((Context)this.ctx).clearCacheByType(MetaDataTypeList.UIOBJECT);
        MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).clear(MetaDataTypeList.WEBUIOBJECT);
        XMLAccessEngine.getXMLLoader((Context)this.ctx).clearCacheByType(MetaDataTypeList.WEBUIOBJECT);
        BizUnitInfo template = this.templateInfo.getTemplate();
        BizUnitCtrl bizUnitCtrl = new BizUnitCtrl(this.ctx);
        bizUnitCtrl.loadAll(template, true, false);
        EntityObjectInfo entity = template.getEntity();
        if (entity != null) {
            entity.setTrueClone(true);
        }
        if ((entity = template.getRelatedEntity()) != null) {
            entity.setTrueClone(true);
        }
        if ((query = template.getQuery()) != null) {
            query.setTrueClone(true);
        }
        this.bizUnit = temp = bizUnitCtrl.clone(template, this.suffixs, this.templateInfo.getPackagePath(), this.templateInfo.getName(), this.templateInfo.getUiType());
        temp.setAlias(this.templateInfo.getAlias());
        temp.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        temp.setPackage(this.templateInfo.getPackagePath());
        if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
            temp.getEditUI().setTemplateUIClass(template.getEditUIPK());
        }
        if (temp.getListUI() != null && !StringUtils.isEmpty((String)template.getListUIPK())) {
            temp.getListUI().setTemplateUIClass(template.getListUIPK());
            if (temp.getEditUI() != null && !StringUtils.isEmpty((String)template.getEditUIPK())) {
                temp.getListUI().setTemplateEditUIClass(template.getEditUIPK());
                temp.getListUI().setDynEditUIClass(temp.getEditUI().getRealFullName());
            }
        }
        if (temp.getRelatedTreeUI() != null && !StringUtils.isEmpty((String)template.getRelatedEditUIPK())) {
            temp.getRelatedTreeUI().setTemplateUIClass(template.getRelatedEditUIPK());
        }
        if ((query = temp.getQuery()) != null) {
            query.setExtendedProperty("f7WindowTitle", this.templateInfo.getAlias());
            query.setExtendedProperty("F7WindowTitle", this.templateInfo.getAlias());
        }
        if ((entity = temp.getEntity()) != null) {
            editUI = entity.getExtendedProperty("editUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("editUI", editUI + "$$" + template.getEditUIPK());
            }
            String listUI = entity.getExtendedProperty("listUI");
            if (!StringUtils.isEmpty((String)editUI)) {
                entity.setExtendedProperty("listUI", listUI + "$$" + template.getListUIPK());
            }
        }
        if ((entity = temp.getRelatedEntity()) != null && !StringUtils.isEmpty((String)(editUI = entity.getExtendedProperty("editUI")))) {
            entity.setExtendedProperty("editUI", editUI + "$$" + template.getRelatedTreeUI());
        }
        this.mds = new SHRMetaDataGetter(temp).getMetaData();
        this.fixMds(this.mds);
        for (int i = 0; i < this.mds.length; ++i) {
            md = this.mds[i];
            md.setDynamic(true);
        }
        if (this.existsInDynamicmetas(this.mds, this.depend)) {
            throw new ReCreateException();
        }
        this.isCustomized(this.mds);
        SHRUictUtils.saveMetadata(this.ctx, this.mds, this.customizedSchemedID, this.depend);
        CoreBaseCollection sqlCol = new CoreBaseCollection();
        md = null;
        for (int i = 0; i < this.mds.length; ++i) {
            String pkName;
            md = this.mds[i];
            if (!(md instanceof EntityObjectInfo) || ((EntityObjectInfo)md).getTable() == null) continue;
            entity = (EntityObjectInfo)md;
            DataTableInfo table = entity.getTable();
            pkName = pkName.substring(0, (pkName = BIMNameFactory.createTablePKName((String)table.getRealPackage(), (String)table.getRealName(), (String)"FID", (boolean)true)).length() > 18 ? 18 : pkName.length());
            pkName = pkName.replace('.', '_');
            table.getPrimaryKey().setName(pkName);
            String tableSql = SHRSqlBuilder.buildTableSql(table);
            DBUpdateInfo sqlObj = new DBUpdateInfo(10, table.getRealName(), table.getRealName(), tableSql, 0);
            DBUpdateInfoSet sqlSet = new DBUpdateInfoSet();
            sqlSet.addDBUpdateInfo(sqlObj);
            int total = table.getColumns().size();
            for (int j = 0; j < total; ++j) {
                ColumnInfo columnInfo = table.getColumns().get(j);
                if (!"FHrOrgUnitId".equals(columnInfo.getRealName()) && !"FShrBasicItemId".equals(columnInfo.getRealName()) && !"FState".equals(columnInfo.getRealName()) && !"FIndex".equals(columnInfo.getRealName()) && !"FIsSysPreset".equals(columnInfo.getRealName()) && !"FUsePolicy".equals(columnInfo.getRealName())) continue;
                String cloumnSql = SHRSqlBuilder.buildColumnSql((AbstractTableInfo)table, columnInfo);
                DBUpdateInfo sqlCloumnObj = new DBUpdateInfo(11, table.getRealName(), columnInfo.getRealName(), cloumnSql, 0);
                sqlSet.addDBUpdateInfo(sqlCloumnObj);
            }
            UpdateSqlInfo sqlInfo = new UpdateSqlInfo();
            sqlInfo.setId(BOSUuid.create((BOSObjectType)sqlInfo.getBOSType()));
            sqlInfo.setCustomizedSchemeID(this.customizedSchemedID);
            sqlInfo.setEntityPK(entity.getRealPackage() + "." + entity.getRealName());
            sqlInfo.setTablePK(table.getRealPackage() + "." + table.getRealName());
            sqlInfo.setSql(sqlSet.toJSONObject().toString());
            sqlCol.add((CoreBaseInfo)sqlInfo);
        }
        if (sqlCol.size() > 0) {
            IUpdateSql instance = UpdateSqlFactory.getLocalInstance((Context)this.ctx);
            instance.addnew(sqlCol);
        }
        this.clearCache(template);
        return this.bizUnit;
    }

    private void fixMds(AbstractMetaDataValue[] md) {
        PropertyCollection oldPropertyCollection = (PropertyCollection)this.oldMdsMap.get("properties");
        DataTableInfo oldTable = (DataTableInfo)this.oldMdsMap.get("tableInfo");
        ColumnCollection oldColumnCollection = (ColumnCollection)this.oldMdsMap.get("columnInfos");
        BOSObjectType bosType = (BOSObjectType)this.oldMdsMap.get("bosType");
        DataTableInfo newTable = null;
        if (null == oldTable.getColumns()) {
            oldTable.put("columns", (Object)oldColumnCollection);
        }
        for (AbstractMetaDataValue adm : md) {
            if ("enty".equals(adm.getBOSType().toString())) {
                EntityObjectInfo newEntityObjectInfo = (EntityObjectInfo)adm;
                if (!newEntityObjectInfo.getType().toString().equals(bosType.toString())) {
                    newEntityObjectInfo.setType(bosType);
                }
                if (null != oldPropertyCollection && oldPropertyCollection.size() > 0) {
                    int subTotal = oldPropertyCollection.size();
                    for (int j = 0; j < subTotal; ++j) {
                        PropertyInfo propertyInfo = oldPropertyCollection.get(j);
                        if (propertyInfo instanceof LinkPropertyInfo) {
                            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                            RelationshipInfo _r_ = (RelationshipInfo)this.oldMdsMap.get(propertyInfo.getRealName());
                            linkPropertyInfo.setRelationship(_r_);
                            newEntityObjectInfo.getProperties().add((PropertyInfo)linkPropertyInfo);
                            continue;
                        }
                        newEntityObjectInfo.getProperties().add(propertyInfo);
                    }
                }
                newEntityObjectInfo.setTable(oldTable);
                continue;
            }
            if (!"datb".equals(adm.getBOSType().toString())) continue;
            newTable = (DataTableInfo)adm;
            int subTotal = newTable.getColumns().size();
            for (int j = 0; j < subTotal; ++j) {
                ColumnInfo columnInfo = newTable.getColumns().get(j);
                if (!"FHrOrgUnitId".equals(columnInfo.getRealName()) && !"FShrBasicItemId".equals(columnInfo.getRealName()) && !"FState".equals(columnInfo.getRealName()) && !"FIndex".equals(columnInfo.getRealName()) && !"FIsSysPreset".equals(columnInfo.getRealName()) && !"FUsePolicy".equals(columnInfo.getRealName())) continue;
                oldTable.getColumns().add(columnInfo);
            }
            md[i] = oldTable;
        }
    }

    private boolean existsInDynamicmetas(AbstractMetaDataValue[] md, Project project) {
        if (md == null || md.length < 1) {
            return false;
        }
        String sql = "where ";
        if (project != null) {
            sql = sql + "projectid = '" + project.getId() + "' and ";
        }
        sql = sql + "metadatapk in (";
        int n = md.length;
        for (int i = 0; i < n; ++i) {
            sql = i == 0 ? sql + "'" + md[i].getRealFullName() + "'" : sql + ",'" + md[i].getRealFullName() + "'";
        }
        sql = sql + ")";
        try {
            IDynamicMetadata idynamic = DynamicMetadataFactory.getLocalInstance((Context)this.ctx);
            if (idynamic.exists(sql)) {
                return true;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e, (Throwable)e);
        }
        return false;
    }

    private void clearCache(BizUnitInfo template) {
        AbstractMetaDataValue md2 = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        for (int i = 0; i < this.mds.length; ++i) {
            md2 = this.mds[i];
            if (md2 instanceof UIObjectInfo) continue;
            logger.info((Object)(" clear md cache --- > [" + md2.getBOSType() + "]" + md2.getFullName()));
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)MetaDataPK.create((String)md2.getFullName()));
        }
        List tmds = BizUnitHelper.getRelatedMetadatas((BizUnitInfo)template);
        for (AbstractMetaDataValue md2 : tmds) {
            if (md2 == null || StringUtils.isEmpty((String)md2.getFullName())) continue;
            loader.clear(md2.getBOSType(), (IMetaDataPK)MetaDataPK.create((String)md2.getFullName()));
        }
    }

    public TemplateInfo getTemplateInfo() {
        return this.templateInfo;
    }

    public String getCustomizedSchemedID() {
        return this.customizedSchemedID;
    }

    public Project getDepend() {
        return this.depend;
    }

    public BizUnitInfo getCreatedBizUnit() {
        return this.bizUnit;
    }

    public AbstractMetaDataValue[] getCreatedMetaDatas() {
        return this.mds;
    }

    public static class TemplateInfo {
        private String packagePath = null;
        private String name = null;
        private String alias = null;
        private int uiType = 0;
        private BizUnitInfo template = null;

        public TemplateInfo() {
        }

        public TemplateInfo(String packagePath, String name, String alias, BizUnitInfo template, int uiType) {
            this.packagePath = packagePath;
            this.name = name;
            this.alias = alias;
            this.template = template;
            this.uiType = uiType;
        }

        public String getPackagePath() {
            return this.packagePath;
        }

        public void setPackagePath(String packagePath) {
            this.packagePath = packagePath;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public BizUnitInfo getTemplate() {
            return this.template;
        }

        public void setTemplate(BizUnitInfo template) {
            this.template = template;
        }

        public int getUiType() {
            return this.uiType;
        }

        public void setUiType(int uiType) {
            this.uiType = uiType;
        }
    }
}

