/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.common.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ShrSyssettingDbUtil {
    private static final Logger logger = Logger.getLogger(ShrSyssettingDbUtil.class);
    private static final String SQL_TIP1 = "333 sql is:";

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql);
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    public static IRowSet executeQuery(Context ctx, String sql, ParamData param) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            statement = conn.prepareStatement(sql);
            ParamData.setParamDataToStatement((ParamData)param, (PreparedStatement)statement);
            rs = statement.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)(SQL_TIP1 + sql), (Throwable)exc);
                throw new BOSException("Sql3 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params, ParamData param) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        try {
            ps = conn.prepareStatement(sql);
            ParamData.setParamDataToStatement((ParamData)param, (PreparedStatement)ps);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                StringBuffer sb = new StringBuffer("");
                for (int i = 0; i < params.length; ++i) {
                    sb.append("param ").append(i).append(" is:").append(params[i]);
                }
                logger.error((Object)("sql is:" + sql + " param is:" + sb.toString()));
                logger.error((Object)"sql error!", (Throwable)exc);
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }
}

