/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inte.cq.ex;

import com.kingdee.shr.inte.cq.msg.ResultCode;
import com.kingdee.util.StringUtils;

public class APIException
extends RuntimeException {
    private String errorCode;
    private String message;
    private String tokenData;
    private String tokenRes;
    private String[] args;

    public static APIException of(ResultCode resultCode) {
        return new APIException(resultCode.getCode() + "", resultCode.getMessage(), null);
    }

    public static APIException of(ResultCode resultCode, String message) {
        return new APIException(resultCode.getCode() + "", resultCode.getMessage() + ":" + message, null);
    }

    public static APIException of(ResultCode resultCode, String message, Throwable e) {
        return new APIException(resultCode.getCode() + "", resultCode.getMessage() + ":" + message, e);
    }

    public static APIException of(String errorCode, String message, Throwable cause) {
        return new APIException(errorCode, message, cause);
    }

    public static APIException of(String errorCode, String message) {
        return new APIException(errorCode, message);
    }

    public APIException(String errorCode, String message, String tokenData, String tokenRes) {
        super(message);
        this.errorCode = errorCode;
        this.message = message;
        this.tokenData = tokenData;
        this.tokenRes = tokenRes;
    }

    public APIException(String errorCode, String message, String[] args, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.message = message;
        this.args = args;
    }

    public APIException(String errorCode, String message, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
        this.message = message;
    }

    public APIException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String getMessage() {
        if (StringUtils.isEmpty((String)this.message)) {
            return "";
        }
        return this.args != null && this.args.length != 0 ? String.format(this.message, this.args) : "";
    }

    public String getOrginMessage() {
        return this.message;
    }

    public String getTokenData() {
        return this.tokenData;
    }

    public String getTokenRes() {
        return this.tokenRes;
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

