/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.scheme;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.AppointPositionEnum;
import com.kingdee.shr.base.syssetting.FieldSchemeMaintenanceEntryInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;

public final class FieldSchemeMaintenanceHelper {
    private static final String[] tagList = new String[]{"remark", "description", "mark"};

    FieldSchemeMaintenanceHelper() {
    }

    public static String getContentXml(String content, List<FieldSchemeMaintenanceEntryInfo> entryInfos) {
        try {
            String name;
            XPath xPathEditGrid = XPath.newInstance((String)"//editGrid");
            XPath xPathGroup = XPath.newInstance((String)"//group");
            XPath fieldGroup = XPath.newInstance((String)"//field");
            XMLOutputter outp = new XMLOutputter();
            Document doc = XMLUtil.parseXML(content);
            List editGridList = xPathEditGrid.selectNodes((Object)doc);
            List groupList = xPathGroup.selectNodes((Object)doc);
            List fieldList = fieldGroup.selectNodes((Object)doc);
            boolean editGridBoolean = editGridList != null && editGridList.size() > 0;
            ArrayList<String> editGridStrList = new ArrayList<String>();
            LinkedHashMap<String, Object> editMap = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> commonFieldMap = new LinkedHashMap<String, Object>();
            int size = entryInfos.size();
            if (editGridBoolean) {
                for (Element element : editGridList) {
                    name = element.getAttributeValue("name");
                    editGridStrList.add(name);
                }
                for (String editName : editGridStrList) {
                    LinkedHashMap entryFieldMap = new LinkedHashMap();
                    for (int i = 0; i < size; ++i) {
                        FieldSchemeMaintenanceEntryInfo maintenanceExtInfo = entryInfos.get(i);
                        String name2 = maintenanceExtInfo.getName();
                        String entryName = FieldSchemeMaintenanceHelper.getEntryName(name2, editGridStrList);
                        if (entryName == null) {
                            commonFieldMap.put(name2, maintenanceExtInfo);
                        } else if (editName.equals(entryName)) {
                            entryFieldMap.put(name2, maintenanceExtInfo);
                        }
                        editMap.put(editName, entryFieldMap);
                    }
                }
            } else {
                for (int i = 0; i < entryInfos.size(); ++i) {
                    FieldSchemeMaintenanceEntryInfo info = entryInfos.get(i);
                    commonFieldMap.put(info.getName(), info);
                }
            }
            int number = 0;
            Element group = null;
            for (Element elementGroup : groupList) {
                List content1 = elementGroup.getChildren();
                int num = 0;
                for (Element element : content1) {
                    String qualifiedName = element.getQualifiedName();
                    if (!qualifiedName.contains("field")) continue;
                    num = 1;
                }
                if ((number += num) != 2) continue;
                group = elementGroup;
                break;
            }
            if (group == null) {
                FieldSchemeMaintenanceHelper.addOrUpdateField(fieldList, commonFieldMap, doc, true);
            } else {
                FieldSchemeMaintenanceHelper.updateField(fieldList, commonFieldMap);
                FieldSchemeMaintenanceHelper.appointField(fieldList, commonFieldMap);
                name = group.getAttributeValue("name");
                XPath fieldGroupDo = XPath.newInstance((String)("//group[@name='" + name + "']/field"));
                List groupFieldList = fieldGroupDo.selectNodes((Object)doc);
                FieldSchemeMaintenanceHelper.addOrUpdateField(groupFieldList, commonFieldMap, doc, false);
            }
            if (editMap.size() > 0) {
                for (Map.Entry entry : editMap.entrySet()) {
                    String key = (String)entry.getKey();
                    for (Element editElement : editGridList) {
                        if (!editElement.getAttributeValue("name").equals(key)) continue;
                        List children = editElement.getChildren();
                        Map fieldMap = (Map)editMap.get(key);
                        LinkedHashMap<String, FieldSchemeMaintenanceEntryInfo> newFieldMap = new LinkedHashMap<String, FieldSchemeMaintenanceEntryInfo>();
                        newFieldMap.putAll(fieldMap);
                        FieldSchemeMaintenanceHelper.updateColumnField(key, children, fieldMap);
                        Element elementTag = null;
                        for (Element element : children) {
                            String name3 = element.getAttributeValue("name");
                            if (!FieldSchemeMaintenanceHelper.isTagField(name3)) continue;
                            elementTag = element;
                        }
                        if (elementTag == null) {
                            List editGridChildren = editElement.getChildren();
                            Map<String, FieldSchemeMaintenanceEntryInfo> linkedHashMap = FieldSchemeMaintenanceHelper.getSortMap(fieldMap);
                            for (Map.Entry<String, FieldSchemeMaintenanceEntryInfo> entryAdd : linkedHashMap.entrySet()) {
                                Element element = FieldSchemeMaintenanceHelper.getEditGridElement(entryAdd.getValue());
                                editGridChildren.add(element);
                            }
                        } else {
                            FieldSchemeMaintenanceHelper.addEditGridFiled((Map)entry.getValue(), elementTag);
                        }
                        FieldSchemeMaintenanceHelper.appointEditGridField(key, newFieldMap, doc);
                    }
                }
            }
            content = XMLUtil.getXMLOutputter().outputString(doc);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return content;
    }

    private static String getEntryName(String name, List<String> editGridStrList) {
        for (String entryName : editGridStrList) {
            if (!name.contains(entryName)) continue;
            return entryName;
        }
        return null;
    }

    private static void addOrUpdateField(List<Element> fieldList, Map<String, Object> commonFieldMap, Document doc, boolean flag) throws JDOMException {
        if (flag) {
            FieldSchemeMaintenanceHelper.updateField(fieldList, commonFieldMap);
            FieldSchemeMaintenanceHelper.appointField(fieldList, commonFieldMap);
        }
        Element elementTag = null;
        XPath fieldXPath = XPath.newInstance((String)"//field");
        List fieldXPathList = fieldXPath.selectNodes((Object)doc);
        for (Element element : fieldXPathList) {
            String name = element.getAttributeValue("name");
            if (!FieldSchemeMaintenanceHelper.isTagField(name)) continue;
            elementTag = element;
        }
        if (elementTag == null) {
            elementTag = fieldList.get(fieldList.size() - 1);
            Element parent = elementTag.getParentElement();
            List children = parent.getContent();
            for (Map.Entry<String, Object> entry : commonFieldMap.entrySet()) {
                Element element = FieldSchemeMaintenanceHelper.getElement((FieldSchemeMaintenanceEntryInfo)entry.getValue());
                children.add(element);
            }
        } else if (commonFieldMap.size() > 0) {
            FieldSchemeMaintenanceHelper.addFiled(commonFieldMap, elementTag);
        }
    }

    private static void appointField(List<Element> fieldList, Map<String, Object> commonFieldMap) {
        ArrayList<String> nameLiat = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : commonFieldMap.entrySet()) {
            String name;
            FieldSchemeMaintenanceEntryInfo info = (FieldSchemeMaintenanceEntryInfo)entry.getValue();
            if (null == info.getAppoint()) continue;
            int index = -1;
            String appoint = info.getAppoint();
            Element insertElement = null;
            Element elementMove = null;
            Element elementTag = null;
            for (int i = 0; i < fieldList.size(); ++i) {
                Element element = fieldList.get(i);
                name = element.getAttributeValue("name");
                if (name.equals(appoint)) {
                    elementTag = element;
                }
                if (!name.equals(info.getName())) continue;
                elementMove = element;
            }
            if (elementTag == null) continue;
            Element parent = elementTag.getParentElement();
            AppointPositionEnum appointPosition = info.getAppointPosition();
            name = null;
            if (appointPosition != null) {
                name = appointPosition.getName();
            }
            if (elementMove == null) {
                List content = parent.getContent();
                index = content.indexOf(elementTag);
                insertElement = FieldSchemeMaintenanceHelper.getElement(info);
                if (appointPosition != null && "behind".equals(name)) {
                    content.add(index + 1, insertElement);
                } else {
                    content.add(index, insertElement);
                }
                nameLiat.add(insertElement.getAttributeValue("name"));
                continue;
            }
            if (elementMove.equals((Object)elementTag)) {
                nameLiat.add(elementMove.getAttributeValue("name"));
                continue;
            }
            List content1 = elementMove.getParent().getContent();
            content1.remove(elementMove);
            List content2 = parent.getContent();
            index = content2.indexOf(elementTag);
            if (appointPosition != null && "behind".equals(name)) {
                content2.add(index + 1, elementMove);
            } else {
                content2.add(index, elementMove);
            }
            nameLiat.add(elementMove.getAttributeValue("name"));
        }
        for (String name : nameLiat) {
            commonFieldMap.remove(name);
        }
    }

    private static void appointEditGridField(String key, Map<String, FieldSchemeMaintenanceEntryInfo> fieldMap, Document doc) {
        try {
            Map<String, FieldSchemeMaintenanceEntryInfo> linkedHashMap = FieldSchemeMaintenanceHelper.getSortMap(fieldMap);
            for (Map.Entry<String, FieldSchemeMaintenanceEntryInfo> entry : linkedHashMap.entrySet()) {
                FieldSchemeMaintenanceEntryInfo info = entry.getValue();
                if (null == info.getAppoint()) continue;
                AppointPositionEnum appointPosition = info.getAppointPosition();
                Element elementTag = null;
                Element element = null;
                String appoint = info.getAppoint();
                String appointReplace = appoint.replace(key + ".", "");
                XPath elementColumn = XPath.newInstance((String)("//editGrid[@name='" + key + "']/column[@name='" + appointReplace + "']"));
                List columnTags = elementColumn.selectNodes((Object)doc);
                if (columnTags == null || columnTags.size() <= 0) continue;
                elementTag = (Element)columnTags.get(0);
                String columnName = info.getName();
                String replace = columnName.replace(key + ".", "");
                XPath filedColumn = XPath.newInstance((String)("//editGrid[@name='" + key + "']/column[@name='" + replace + "']"));
                List columns = filedColumn.selectNodes((Object)doc);
                if (columns == null || columns.size() <= 0 || (element = (Element)columns.get(0)).equals((Object)elementTag)) continue;
                Element parentElement = element.getParentElement();
                List ChildrenElements = parentElement.getChildren();
                ChildrenElements.remove(element);
                int number = ChildrenElements.indexOf(elementTag);
                if (appointPosition != null && "behind".equals(appointPosition.getName())) {
                    ChildrenElements.add(number + 1, element);
                    continue;
                }
                ChildrenElements.add(number, element);
            }
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
    }

    private static Map<String, FieldSchemeMaintenanceEntryInfo> getSortMap(Map<String, FieldSchemeMaintenanceEntryInfo> fieldMap) {
        LinkedHashMap<String, FieldSchemeMaintenanceEntryInfo> linkedHashMap = new LinkedHashMap<String, FieldSchemeMaintenanceEntryInfo>();
        List<FieldSchemeMaintenanceEntryInfo> infos = new ArrayList<FieldSchemeMaintenanceEntryInfo>();
        for (Map.Entry<String, FieldSchemeMaintenanceEntryInfo> entry : fieldMap.entrySet()) {
            infos.add(entry.getValue());
        }
        infos = FieldSchemeMaintenanceHelper.extInfoListSort(infos);
        for (FieldSchemeMaintenanceEntryInfo info : infos) {
            linkedHashMap.put(info.getName(), info);
        }
        return linkedHashMap;
    }

    private static void addEditGridFiled(Map<String, FieldSchemeMaintenanceEntryInfo> commonFieldMap, Element elementTag) {
        Element parentLast = elementTag.getParentElement();
        List children = parentLast.getChildren();
        int number = children.indexOf(elementTag);
        List<FieldSchemeMaintenanceEntryInfo> infos = new ArrayList<FieldSchemeMaintenanceEntryInfo>();
        for (Map.Entry<String, FieldSchemeMaintenanceEntryInfo> entry : commonFieldMap.entrySet()) {
            infos.add(entry.getValue());
        }
        infos = FieldSchemeMaintenanceHelper.extInfoListSortReversed(infos);
        for (FieldSchemeMaintenanceEntryInfo info : infos) {
            Element element = FieldSchemeMaintenanceHelper.getEditGridElement(info);
            children.add(number, element);
        }
    }

    private static Element getEditGridElement(FieldSchemeMaintenanceEntryInfo schemeInfo) {
        Element element = new Element("column");
        element.setAttribute("label", schemeInfo.getAlias());
        String fieldName = schemeInfo.getName();
        fieldName = fieldName.substring(fieldName.lastIndexOf(".") + 1);
        element.setAttribute("name", fieldName);
        element.setAttribute("hidden", String.valueOf(!schemeInfo.isVsible()));
        element.setAttribute("editable", String.valueOf(!schemeInfo.isReadonly()));
        element.setAttribute("required", String.valueOf(schemeInfo.isReadonly()));
        return element;
    }

    private static void updateColumnField(String key, List<Element> list, Map<String, FieldSchemeMaintenanceEntryInfo> fieldMap) {
        for (Element element : list) {
            String name = element.getAttributeValue("name");
            name = key + "." + name;
            if (!fieldMap.containsKey(name)) continue;
            FieldSchemeMaintenanceEntryInfo schemeInfo = fieldMap.get(name);
            element.removeAttribute("label");
            element.removeAttribute("hidden");
            element.removeAttribute("editable");
            element.removeAttribute("required");
            String dataType = schemeInfo.getDataType();
            element.setAttribute("label", schemeInfo.getAlias());
            element.setAttribute("hidden", String.valueOf(!schemeInfo.isVsible()));
            element.setAttribute("editable", String.valueOf(!schemeInfo.isReadonly()));
            element.setAttribute("required", String.valueOf(schemeInfo.isRequired()));
            fieldMap.remove(schemeInfo.getName());
        }
    }

    private static void addFiled(Map<String, Object> commonFieldMap, Element elementTag) {
        Element parentLast = elementTag.getParentElement();
        List children = parentLast.getChildren();
        int number = children.indexOf(elementTag);
        List<FieldSchemeMaintenanceEntryInfo> infos = new ArrayList<FieldSchemeMaintenanceEntryInfo>();
        for (Map.Entry<String, Object> entry : commonFieldMap.entrySet()) {
            infos.add((FieldSchemeMaintenanceEntryInfo)entry.getValue());
        }
        infos = FieldSchemeMaintenanceHelper.extInfoListSortReversed(infos);
        for (FieldSchemeMaintenanceEntryInfo info : infos) {
            Element element = FieldSchemeMaintenanceHelper.getElement(info);
            children.add(number, element);
        }
    }

    private static void updateField(List<Element> fieldList, Map<String, Object> commonFieldMap) {
        for (Element element : fieldList) {
            String appoint;
            String name = element.getAttributeValue("name");
            if (!commonFieldMap.containsKey(name)) continue;
            FieldSchemeMaintenanceEntryInfo schemeInfo = (FieldSchemeMaintenanceEntryInfo)commonFieldMap.get(name);
            element.removeAttribute("label");
            element.removeAttribute("visible");
            element.removeAttribute("readonly");
            element.removeAttribute("required");
            String hidden = element.getAttributeValue("type");
            if (null != hidden && "hidden".equals(hidden)) {
                element.removeAttribute("type");
            }
            String dataType = schemeInfo.getDataType();
            element.setAttribute("label", schemeInfo.getAlias());
            element.setAttribute("visible", String.valueOf(schemeInfo.isVsible()));
            element.setAttribute("readonly", String.valueOf(schemeInfo.isReadonly()));
            if (!dataType.equals("Boolean")) {
                element.setAttribute("required", String.valueOf(schemeInfo.isRequired()));
            }
            if (null != (appoint = schemeInfo.getAppoint()) && FieldSchemeMaintenanceHelper.isExistAppoint(appoint, fieldList)) continue;
            commonFieldMap.remove(name);
        }
    }

    private static boolean isExistAppoint(String appoint, List<Element> fieldList) {
        boolean flag = false;
        for (Element element : fieldList) {
            String name = element.getAttributeValue("name");
            if (!appoint.contains(name)) continue;
            flag = true;
        }
        return flag;
    }

    private static Element getElement(FieldSchemeMaintenanceEntryInfo schemeInfo) {
        Element element = new Element("field");
        String dataType = schemeInfo.getDataType();
        element.setAttribute("label", schemeInfo.getAlias());
        element.setAttribute("visible", String.valueOf(schemeInfo.isVsible()));
        element.setAttribute("name", schemeInfo.getName());
        element.setAttribute("readonly", String.valueOf(schemeInfo.isReadonly()));
        if (!dataType.equals("Boolean")) {
            element.setAttribute("required", String.valueOf(schemeInfo.isRequired()));
        }
        return element;
    }

    private static boolean isTagField(String name) {
        boolean result = false;
        for (String tag : tagList) {
            if (!name.contains(tag)) continue;
            result = true;
        }
        return result;
    }

    public static List<FieldSchemeMaintenanceEntryInfo> extInfoListSort(List<FieldSchemeMaintenanceEntryInfo> extInfos) {
        Collections.sort(extInfos, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FieldSchemeMaintenanceEntryInfo a = (FieldSchemeMaintenanceEntryInfo)arg0;
                FieldSchemeMaintenanceEntryInfo b = (FieldSchemeMaintenanceEntryInfo)arg1;
                return a.getIndex() - b.getIndex();
            }
        });
        return extInfos;
    }

    public static List<FieldSchemeMaintenanceEntryInfo> extInfoListSortReversed(List<FieldSchemeMaintenanceEntryInfo> extInfos) {
        Collections.sort(extInfos, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                FieldSchemeMaintenanceEntryInfo a = (FieldSchemeMaintenanceEntryInfo)arg0;
                FieldSchemeMaintenanceEntryInfo b = (FieldSchemeMaintenanceEntryInfo)arg1;
                return b.getIndex() - a.getIndex();
            }
        });
        return extInfos;
    }
}

