/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ueditor.util;

import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.ueditor.util.FileUtil;
import com.kingdee.shr.ueditor.util.StreamReleaseUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileZipUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileZipUtil.class);
    private static final String FORWARD_SLASH = "/";

    private FileZipUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipWithStream(InputStream inputStream, String descDir) {
        if (!descDir.endsWith(FORWARD_SLASH)) {
            descDir = descDir + FORWARD_SLASH;
        }
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String zipEntryNameStr;
                String zipEntryName = zipEntryNameStr = FORWARD_SLASH + zipEntry.getName();
                if (zipEntryNameStr.contains(FORWARD_SLASH)) {
                    String str1 = zipEntryNameStr.substring(0, zipEntryNameStr.indexOf(FORWARD_SLASH));
                    zipEntryName = zipEntryNameStr.substring(str1.length() + 1);
                }
                String outPath = (descDir + zipEntryName).replace(FORWARD_SLASH, "\\");
                String substring = outPath.replace("\\\\", "\\");
                FileZipUtil.writeFile(substring, zipInputStream);
                zipInputStream.closeEntry();
            }
            logger.error("======extracting files success!=======");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamReleaseUtil.safeClose(zipInputStream);
                StreamReleaseUtil.safeClose(inputStream);
                throw throwable;
            }
            StreamReleaseUtil.safeClose(zipInputStream);
            StreamReleaseUtil.safeClose(inputStream);
        }
        StreamReleaseUtil.safeClose(zipInputStream);
        StreamReleaseUtil.safeClose(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String filePath, ZipInputStream zipInputStream) {
        FileOutputStream outputStream = null;
        try {
            int len;
            String imageFormat = FileUtil.getImagesName(filePath);
            String path = SHRCheck.checkFilePath(filePath);
            File file = new File(path);
            if (StringUtils.isEmpty((String)imageFormat)) {
                return;
            }
            boolean mkdirsParentFile = file.getParentFile().mkdirs();
            logger.error("FileZipUtil.mkdirsParentFile:{}", (Object)mkdirsParentFile);
            if (file.exists()) {
                file.delete();
            }
            boolean newFile = file.createNewFile();
            logger.error("FileZipUtil.newFile:{}", (Object)newFile);
            file.setWritable(true);
            outputStream = new FileOutputStream(file);
            byte[] bytes = new byte[4096];
            while ((len = zipInputStream.read(bytes)) != -1) {
                ((OutputStream)outputStream).write(bytes, 0, len);
            }
            StreamReleaseUtil.safeClose(outputStream);
        }
        catch (IOException ex) {
            logger.error("When extracting files  Error writing while decompressing file");
            ex.printStackTrace();
        }
        finally {
            StreamReleaseUtil.safeClose(outputStream);
        }
    }

    public static void unzipFile(String zipPath, String descDir) throws IOException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(zipPath);
            File zipFile = new File(SHRCheck.checkFilePath(zipPath));
            if (!zipFile.exists()) {
                throw new IOException("The target file does not exist");
            }
            File pathFile = new File(descDir);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            FileZipUtil.unzipWithStream(input, descDir);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                StreamReleaseUtil.safeClose(input);
                throw throwable;
            }
        }
        StreamReleaseUtil.safeClose((InputStream)input);
    }
}

