/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.validaterule.formula.base;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.validaterule.ValidateResultBaseFactory;
import com.kingdee.shr.validaterule.ValidateResultBaseInfo;
import com.kingdee.shr.validaterule.ValidateResultInfo;
import com.kingdee.shr.validaterule.ValidateState;
import com.kingdee.shr.validaterule.VerificationRuleInfo;
import com.kingdee.shr.validaterule.VerificationRuleNodeInfo;
import com.kingdee.shr.validaterule.exception.SalaryException;
import com.kingdee.shr.validaterule.formula.base.ISaveCalResult;
import com.kingdee.shr.validaterule.formula.base.vo.Cell;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.formula.base.vo.Row;
import com.kingdee.shr.validaterule.formula.base.vo.Sheet;
import com.kingdee.shr.validaterule.formula.base.vo.VRCell;
import com.kingdee.shr.validaterule.formula.base.vo.VRRow;
import com.kingdee.shr.validaterule.util.EntityUtil;
import com.kingdee.shr.validaterule.util.FunUtils;
import com.kingdee.shr.validaterule.util.Pair;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSaveCalResult
implements ISaveCalResult {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.validaterule.formula.base.AbstractSaveCalResult");
    protected boolean isSaveVRResult = false;

    @Override
    public void saveCalResult(InitCalData initCalData, Sheet result) throws SalaryException {
        String errMsg = result.getErrMsg();
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            throw new RuntimeException(errMsg);
        }
        if (null == result) {
            return;
        }
        this.saveCalResult(initCalData, result.getChangeDataList());
        this.saveVrResult(initCalData, result);
    }

    public void saveCalResult(InitCalData initCalData, List<Row> changeDataList) throws SalaryException {
        if (null == changeDataList) {
            return;
        }
        ArrayList<String> updateSqlList = new ArrayList<String>();
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            String nowDate = FunUtils.toKSqlDate(calendar.getTime());
            Map<String, Object> allCnSnMap = initCalData.getAllCnSnMap();
            String mainTableName = initCalData.getMainTableName();
            Context ctx = initCalData.getCtx();
            Map strItemLenMap = (Map)allCnSnMap.get("strLengthMap");
            Map f7TypeMap = allCnSnMap.containsKey("f7TypeMap") ? (Map)allCnSnMap.get("f7TypeMap") : new HashMap();
            int tempLength = 0;
            String fid = "";
            String column = "";
            String value = "";
            for (Row row : changeDataList) {
                StringBuffer setStr = new StringBuffer();
                StringBuffer updateSql = new StringBuffer();
                fid = row.getFID();
                List<Cell> cells = row.getCells();
                for (Cell cell : cells) {
                    column = cell.getColumn();
                    value = cell.getValue();
                    if (column.equals("FORWARNCONTENT")) {
                        column = "F" + column;
                    }
                    if (value != null && strItemLenMap.containsKey(column.toLowerCase(Locale.ENGLISH))) {
                        tempLength = (Integer)strItemLenMap.get(column.toLowerCase(Locale.ENGLISH));
                        String string = value = value.length() > tempLength ? value.substring(0, tempLength - 1) : value;
                    }
                    if (value != null && f7TypeMap.get(column.toLowerCase()) != null) {
                        boolean inTable = false;
                        for (Map.Entry entry : ((Map)f7TypeMap.get(column.toLowerCase())).entrySet()) {
                            if (!value.equals(entry.getValue())) continue;
                            inTable = true;
                            value = String.valueOf(entry.getKey());
                            break;
                        }
                        if (!inTable) {
                            value = null;
                        }
                    }
                    if (StringUtils.isEmpty((CharSequence)(value = StringEscapeUtils.escapeSql((String)value)))) {
                        setStr.append(", ").append(column).append(" = null ");
                        continue;
                    }
                    setStr.append(", ").append(column).append(" = '").append(value).append("' ");
                }
                updateSql.append("update ").append(mainTableName).append(" set ");
                updateSql.append(setStr.toString().replaceFirst(",", ""));
                updateSql.append(" ,FLastUpdateTime = ").append(nowDate);
                updateSql.append(" where fid = '").append(fid).append("'");
                updateSqlList.add(updateSql.toString());
            }
            this.executeBatch(ctx, updateSqlList.toArray());
        }
        catch (Exception e) {
            throw new SalaryException(SalaryException.SAVEERROR);
        }
    }

    public void saveVrResult(InitCalData initCalData, Sheet result) throws SalaryException {
        if (!this.isSaveVRResult && initCalData.isContainsVerification()) {
            return;
        }
        List<VRRow> vrResultList = result.getVrResultList();
        if (vrResultList.isEmpty()) {
            return;
        }
        Context ctx = initCalData.getCtx();
        String currentUserId = HRFilterUtils.getCurrentUserId((Context)ctx);
        UserInfo currentUser = EntityUtil.getNewObjectInfoWithId(new UserInfo(), currentUserId);
        CtrlUnitInfo cu = HRFilterUtils.getCurrentCU((Context)ctx);
        String nodeId = this.getCurrentVrNodeId(initCalData);
        String typeId = this.getCurrentBusinessTypeId(initCalData);
        this.deleteBeforeData(ctx, initCalData.getCondition(), nodeId, typeId);
        CoreBaseCollection validateResultCollection = new CoreBaseCollection();
        ArrayList rowStateS = Lists.newArrayList();
        for (VRRow vrRow : vrResultList) {
            String businessId = vrRow.getId();
            List<VRCell> vrCells = vrRow.getVrCells();
            ValidateState rowState = ValidateState.PASS;
            boolean isError = false;
            for (VRCell vrCell : vrCells) {
                ValidateResultBaseInfo resultInfo = this.assembleResultInfo(businessId, nodeId, vrCell);
                this.setUserAndCu(currentUser, cu, resultInfo);
                validateResultCollection.add((CoreBaseInfo)resultInfo);
                if (isError) continue;
                if (ValidateState.ERROR.equals((Object)resultInfo.getValidateState())) {
                    isError = true;
                }
                if (resultInfo.getValidateState().getValue() > rowState.getValue()) continue;
                rowState = resultInfo.getValidateState();
            }
            rowStateS.add(new Pair<String, ValidateState>(businessId, rowState));
        }
        this.saveResult(ctx, validateResultCollection);
        this.handleBusinessState(initCalData, rowStateS);
    }

    protected String getCurrentVrNodeId(InitCalData initCalData) {
        return null;
    }

    protected String getCurrentBusinessTypeId(InitCalData initCalData) {
        return null;
    }

    protected void deleteBeforeData(Context ctx, String filterSql, String nodeId, String typeId) throws SalaryException {
        try {
            DbUtil.execute((Context)ctx, (String)("delete from T_HR_SValidateResultBase where FBusinessID in (" + filterSql + ") and FNodeID = ? and FTypeID = ?"), (Object[])new Object[]{nodeId, typeId});
        }
        catch (BOSException e) {
            logger.error((Object)"delete validate result error", (Throwable)e);
        }
    }

    protected void setUserAndCu(UserInfo currentUser, CtrlUnitInfo cu, ValidateResultInfo resultInfo) {
        resultInfo.setCreator(currentUser);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        resultInfo.setCreateTime(timestamp);
        resultInfo.setLastUpdateUser(currentUser);
        resultInfo.setLastUpdateTime(timestamp);
        resultInfo.setCU(cu);
    }

    protected ValidateResultBaseInfo assembleResultInfo(String businessId, String nodeId, VRCell vrCell) {
        String vrId = vrCell.getVrId();
        String cellResult = vrCell.getResult();
        String warnType = vrCell.getWarnType();
        ValidateState cellState = this.assembleState(warnType, cellResult);
        ValidateResultBaseInfo item = new ValidateResultBaseInfo();
        item.setBusinessId(businessId);
        item.setValidateRule(EntityUtil.getNewObjectInfoWithId(new VerificationRuleInfo(), vrId));
        item.setNode(EntityUtil.getNewObjectInfoWithId(new VerificationRuleNodeInfo(), nodeId));
        item.setValidateState(cellState);
        item.setMessage(cellResult);
        return item;
    }

    protected ValidateState assembleState(String warnType, String cellResult) {
        if (StringUtils.isEmpty((CharSequence)cellResult)) {
            return ValidateState.PASS;
        }
        switch (warnType) {
            case "01": {
                return ValidateState.FAILURE_FORCE;
            }
            case "02": {
                return ValidateState.FAILURE_TIPS;
            }
            case "40": {
                return ValidateState.ERROR;
            }
        }
        return ValidateState.NOT_VALIDATE;
    }

    protected void saveResult(Context ctx, CoreBaseCollection collection) {
        try {
            ValidateResultBaseFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)"Save CmpCal ValidateResult error", e);
        }
    }

    protected void handleBusinessState(InitCalData initCalData, List<Pair<String, ValidateState>> rowStateS) {
    }

    protected void executeBatch(Context ctx, Object[] sqlLists) {
        if (sqlLists == null) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        int i = 0;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.createStatement();
            conn.setAutoCommit(false);
            for (i = 0; i < sqlLists.length; ++i) {
                stmt.executeUpdate(sqlLists[i].toString());
            }
            conn.commit();
        }
        catch (Exception e) {
            logger.error((Object)("errorSQL sqlLists[" + i + "]:" + e.getMessage()), (Throwable)e);
            if (null != conn) {
                try {
                    conn.rollback();
                }
                catch (Exception ex) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException(e);
        }
        finally {
            this.closeAllDBSource(conn, stmt, rs);
        }
    }

    public void closeAllDBSource(Connection conn, Statement stmt, ResultSet rs) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

