/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.webservice.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ep.BillEntryCustomCollection;
import com.kingdee.shr.webservice.utils.LocaleUtils;
import com.kingdee.shr.webservice.utils.MetaDataUtil;
import com.kingdee.shr.webservice.utils.MultiLangUtils;
import com.kingdee.shr.webservice.utils.OSFWebServiceJSONUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BosObjectTypeAdapter
implements JsonSerializer<IObjectValue>,
JsonDeserializer<IObjectValue> {
    private static Logger logger = Logger.getLogger(BosObjectTypeAdapter.class);
    public static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String ENTITY_NAME = "_entityName";
    private Context ctx;

    public BosObjectTypeAdapter(Context ctx) {
        this.ctx = ctx;
    }

    public IObjectValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        try {
            IObjectValue objectInfo;
            Class<?> clazz = Class.forName(type.toString().substring(type.toString().indexOf(" ") + 1));
            JsonElement entityNameElement = jsonObject.get(ENTITY_NAME);
            String entityName = null;
            if (entityNameElement != null) {
                entityName = entityNameElement.getAsString();
            }
            if ((objectInfo = MetaDataUtil.newInstance(clazz, entityName)) == null) {
                return null;
            }
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object result;
                Method method;
                int nIndex;
                JsonElement newElement;
                String num;
                JsonElement element = jsonObject.get((String)entry.getKey());
                Type returnType = MetaDataUtil.getMetadataValueType(objectInfo, (String)entry.getKey());
                if (returnType == null) continue;
                Class dataType = this.getDataType(returnType);
                if (element.isJsonNull()) continue;
                if (element.toString().equals("") || element.toString().equals("\"\"") || element.toString().equals("\"null\"") || element.toString().equals("\"undefined\"")) {
                    if (this.asSubClass(dataType, String.class) && MultiLangUtils.isMultiLangEntityProperty(objectInfo.getBOSType(), (String)entry.getKey())) {
                        objectInfo.put((String)entry.getKey(), null, this.ctx.getLocale());
                    }
                    objectInfo.put(((String)entry.getKey()).toString(), null);
                    continue;
                }
                if (this.asSubClass(dataType, String.class)) {
                    if (MultiLangUtils.isMultiLangEntityProperty(objectInfo.getBOSType(), (String)entry.getKey())) {
                        JsonObject jsonValue = null;
                        if (element.isJsonObject()) {
                            jsonValue = element.getAsJsonObject();
                            for (Map.Entry entity : jsonValue.entrySet()) {
                                String key = (String)entity.getKey();
                                Object value = entity.getValue();
                                value = !(value instanceof JsonNull) ? ((JsonPrimitive)value).getAsString() : null;
                                Locale locale = LocaleUtils.getLocale(key);
                                if (this.ctx.getLocale().equals(locale)) {
                                    objectInfo.put((String)entry.getKey(), value);
                                }
                                objectInfo.put((String)entry.getKey(), value, locale);
                            }
                            continue;
                        }
                        String strMultiLangValue = element.getAsString();
                        if (MultiLangUtils.isMultiLangValueFormat(strMultiLangValue)) {
                            Map multiLangPartValue = OSFWebServiceJSONUtils.convertJsonToObject(this.ctx, strMultiLangValue, HashMap.class);
                            for (String key : multiLangPartValue.keySet()) {
                                Object value = multiLangPartValue.get(key);
                                if (value != null) {
                                    objectInfo.put((String)entry.getKey(), value, LocaleUtils.getLocale(key));
                                    continue;
                                }
                                objectInfo.put((String)entry.getKey(), null, LocaleUtils.getLocale(key));
                            }
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)strMultiLangValue);
                        objectInfo.put((String)entry.getKey(), (Object)strMultiLangValue, this.ctx.getLocale());
                        continue;
                    }
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsString());
                    continue;
                }
                if (this.asSubClass(dataType, Boolean.class)) {
                    try {
                        if (element.getAsInt() != 0) {
                            objectInfo.put((String)entry.getKey(), (Object)true);
                            continue;
                        }
                        objectInfo.put((String)entry.getKey(), (Object)false);
                    }
                    catch (NumberFormatException exception) {
                        objectInfo.put((String)entry.getKey(), (Object)element.getAsBoolean());
                    }
                    continue;
                }
                if (this.asSubClass(dataType, Integer.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Long.class)) {
                    num = element.getAsString();
                    if (num.indexOf(".") >= 0) {
                        num = num.substring(0, num.indexOf("."));
                    }
                    objectInfo.put((String)entry.getKey(), (Object)num);
                    continue;
                }
                if (this.asSubClass(dataType, Float.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)Float.valueOf(element.getAsFloat()));
                    continue;
                }
                if (this.asSubClass(dataType, Double.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsDouble());
                    continue;
                }
                if (this.asSubClass(dataType, BigDecimal.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)element.getAsBigDecimal());
                    continue;
                }
                if (this.asSubClass(dataType, Date.class)) {
                    objectInfo.put((String)entry.getKey(), (Object)BosObjectTypeAdapter.parseDate(element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, Timestamp.class)) {
                    Date date = BosObjectTypeAdapter.parseDate(element.getAsString());
                    objectInfo.put((String)entry.getKey(), (Object)date.getTime());
                    continue;
                }
                if (this.asSubClass(dataType, BOSUuid.class)) {
                    if (element.getAsString() == null || element.getAsString().equals("")) continue;
                    objectInfo.put((String)entry.getKey(), (Object)BOSUuid.read((String)element.getAsString()));
                    continue;
                }
                if (this.asSubClass(dataType, BillEntryCustomCollection.class)) {
                    JsonArray jsonArray = element.getAsJsonArray();
                    if (jsonArray == null) continue;
                    BillEntryCustomCollection objectCollection = new BillEntryCustomCollection();
                    EntityObjectInfo entityObjectInfo = MetaDataUtil.getEntityObjectByEntityName(entityName);
                    PropertyInfo simpleProperty = entityObjectInfo.getPropertyByNameRuntime((String)entry.getKey());
                    String fullName = ((LinkPropertyInfo)simpleProperty).getRelationship().getSupplierObject().getFullName();
                    objectInfo.put((String)entry.getKey(), (Object)objectCollection);
                    newElement = null;
                    for (nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                        newElement = jsonArray.get(nIndex);
                        this.setLinkEntityName(newElement, fullName);
                        objectCollection.addObject(this.deserialize(newElement, this.getEntryValueType((IObjectCollection)objectCollection), context));
                    }
                    continue;
                }
                if (this.asSubClass(dataType, AbstractObjectCollection.class)) {
                    String fieldName = (String)entry.getKey();
                    String linkEntityName = MetaDataUtil.getEntityNameByFieldName(entityName, fieldName);
                    IObjectCollection objectCollection = (IObjectCollection)objectInfo.get(fieldName);
                    if (objectCollection == null) continue;
                    Type entryValueType = this.getEntryValueType(objectCollection);
                    if (element.isJsonArray()) {
                        JsonArray jsonArray = element.getAsJsonArray();
                        newElement = null;
                        for (nIndex = 0; nIndex < jsonArray.size(); ++nIndex) {
                            newElement = jsonArray.get(nIndex);
                            this.setLinkEntityName(newElement, linkEntityName);
                            objectCollection.addObject(this.deserialize(jsonArray.get(nIndex), entryValueType, context));
                        }
                        continue;
                    }
                    this.setLinkEntityName(element, linkEntityName);
                    objectCollection.addObject(this.deserialize(element, entryValueType, context));
                    continue;
                }
                if (this.asSubClass(dataType, IObjectValue.class)) {
                    JsonElement newElement2 = null;
                    if (element.isJsonPrimitive()) {
                        JsonObject obj = new JsonObject();
                        obj.add("id", element);
                        newElement2 = obj;
                    } else {
                        newElement2 = element;
                    }
                    String fieldName = (String)entry.getKey();
                    this.setLinkEntityName(newElement2, MetaDataUtil.getEntityNameByFieldName(entityName, fieldName));
                    objectInfo.put(fieldName, (Object)this.deserialize(newElement2, returnType, context));
                    continue;
                }
                if (this.asSubClass(dataType, IntEnum.class)) {
                    method = dataType.getMethod("getEnum", Integer.TYPE);
                    result = null;
                    String num2 = null;
                    if (element.isJsonObject()) {
                        num2 = element.getAsJsonObject().get("value").getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    } else {
                        num2 = element.getAsString();
                        if (num2.indexOf(".") >= 0) {
                            num2 = num2.substring(0, num2.indexOf("."));
                        }
                        result = method.invoke((Object)dataType, Integer.parseInt(num2));
                    }
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (this.asSubClass(dataType, StringEnum.class)) {
                    method = dataType.getMethod("getEnum", String.class);
                    result = null;
                    result = element.isJsonObject() ? method.invoke((Object)dataType, element.getAsJsonObject().get("value").getAsString()) : method.invoke((Object)dataType, element.getAsString());
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (this.asSubClass(dataType, FloatEnum.class)) {
                    method = dataType.getMethod("getEnum", Float.TYPE);
                    result = null;
                    result = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, Float.valueOf(element.getAsFloat()));
                    objectInfo.put((String)entry.getKey(), result);
                    continue;
                }
                if (!this.asSubClass(dataType, DoubleEnum.class)) continue;
                method = dataType.getMethod("getEnum", Double.TYPE);
                result = null;
                result = element.isJsonObject() ? method.invoke((Object)dataType, Float.valueOf(element.getAsJsonObject().get("value").getAsFloat())) : method.invoke((Object)dataType, element.getAsDouble());
                objectInfo.put((String)entry.getKey(), result);
            }
            return objectInfo;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new JsonParseException((Throwable)ex);
        }
    }

    private void setLinkEntityName(JsonElement element, String entityName) {
        element.getAsJsonObject().addProperty(ENTITY_NAME, entityName);
    }

    private Class getDataType(Type returnType) throws ClassNotFoundException {
        String typeStr = returnType.toString().substring(returnType.toString().indexOf(" ") + 1);
        return this.getDataType(typeStr);
    }

    private Class getDataType(String typeStr) throws ClassNotFoundException {
        Class<?> dataType = null;
        if (typeStr.equals("int")) {
            typeStr = "java.lang.Integer";
        } else if (typeStr.equals("float")) {
            typeStr = "java.lang.Float";
        } else if (typeStr.equals("double")) {
            typeStr = "java.lang.Double";
        } else if (typeStr.equals("boolean")) {
            typeStr = "java.lang.Boolean";
        } else if (typeStr.equals("String")) {
            typeStr = "java.lang.String";
        }
        dataType = Class.forName(typeStr);
        return dataType;
    }

    public static Date parseDate(String s) throws ParseException {
        String fmt = "yyyy-MM-dd HH:mm";
        try {
            return DateTimeUtils.parseDate((String)s, (String)"yyyy-MM-dd HH:mm");
        }
        catch (ParseException e) {
            logger.error((Object)MessageFormat.format(" BosObjectTypeAdapter parseDate warning , value is: {0} ,foramt is :{1}", s, "yyyy-MM-dd HH:mm"));
            return DateTimeUtils.parseDate((String)s);
        }
    }

    private boolean asSubClass(Class source, Class desc) {
        try {
            Class result = source.asSubclass(desc);
            if (result == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Type getValueType(Class clazz, String property) {
        if (clazz == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.getGenericReturnType();
            }
            return this.getValueType(clazz.getSuperclass(), property);
        }
        catch (SecurityException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Type getEntryValueType(IObjectCollection collection) {
        Class<?> returnType = null;
        String collectionClassName = collection.getClass().getName();
        String entryInfoClassName = collectionClassName.substring(0, collectionClassName.indexOf("Collection"));
        entryInfoClassName = entryInfoClassName + "Info";
        try {
            returnType = Class.forName(entryInfoClassName);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return returnType;
    }

    private Object getObjectValue(Object object, Class objectClass, String property) {
        if (object == null) {
            return null;
        }
        try {
            String strMethod = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            String strMethodByBoolean = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            for (Method method : objectClass.getMethods()) {
                if (!method.getName().equalsIgnoreCase(strMethod) && !method.getName().equalsIgnoreCase(strMethodByBoolean)) continue;
                return method.invoke(object, null);
            }
            return this.getObjectValue(object, objectClass.getSuperclass(), property);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public JsonElement serialize(IObjectValue objectValue, Type type, JsonSerializationContext context) {
        JsonPrimitive jsonElement = null;
        if (objectValue == null) {
            return null;
        }
        try {
            jsonElement = new JsonPrimitive(this.convertInfoToJson(objectValue));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jsonElement;
    }

    private String convertInfoToJson(IObjectValue objectValue) throws ClassNotFoundException {
        String jsonBuffer = "";
        Class<?> objectClazz = objectValue.getClass();
        jsonBuffer = jsonBuffer + "${leftbracket_2312415321232}";
        Enumeration enumeration = objectValue.keys();
        while (enumeration.hasMoreElements()) {
            SimpleDateFormat format;
            String key = (String)enumeration.nextElement();
            String realKey = this.getRealByMetaData(objectValue.getBOSType(), key);
            if (realKey == null && (realKey = this.getRealByEntity(objectValue.getClass(), key)) == null) {
                realKey = key;
            }
            realKey = "${quote_2312415321232}" + realKey + "${quote_2312415321232}";
            Object value = objectValue.get(key);
            if (value == null) continue;
            Type returnType = this.getValueType(objectValue.getClass(), key);
            String returnTypeString = null;
            returnTypeString = returnType != null ? returnType.toString() : value.getClass().toString();
            String typeStr = returnTypeString.substring(returnTypeString.indexOf(" ") + 1);
            Class dataType = this.getDataType(typeStr);
            if (this.asSubClass(dataType, String.class)) {
                jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
            } else if (this.asSubClass(dataType, Number.class)) {
                jsonBuffer = jsonBuffer + realKey + ":" + value.toString();
            } else if (this.asSubClass(dataType, IObjectValue.class)) {
                jsonBuffer = jsonBuffer + realKey + ":" + this.convertInfoToJson((IObjectValue)value);
            } else if (this.asSubClass(dataType, Boolean.class)) {
                jsonBuffer = jsonBuffer + realKey + ":" + value;
            } else if (this.asSubClass(dataType, IObjectCollection.class)) {
                IObjectCollection objectCollection = (IObjectCollection)value;
                jsonBuffer = jsonBuffer + realKey + ":[";
                for (int nIndex = 0; nIndex < objectCollection.size(); ++nIndex) {
                    IObjectValue entryObject = objectCollection.getObject(nIndex);
                    jsonBuffer = jsonBuffer + this.convertInfoToJson(entryObject);
                    if (nIndex >= objectCollection.size() - 1) continue;
                    jsonBuffer = jsonBuffer + ",";
                }
                jsonBuffer = jsonBuffer + "]";
            } else if (this.asSubClass(dataType, Enum.class)) {
                IntEnum result = null;
                if (value instanceof Integer) {
                    result = EnumUtils.getEnum((Class)dataType, (int)((Integer)value));
                } else if (value instanceof String) {
                    result = EnumUtils.getEnumByValue((Class)dataType, (String)((String)value));
                } else if (value instanceof Float) {
                    result = EnumUtils.getEnum((Class)dataType, (float)((Float)value).floatValue());
                } else if (value instanceof Double) {
                    result = EnumUtils.getEnum((Class)dataType, (double)((Double)value));
                }
                if (result == null) {
                    result = (Enum)this.getObjectValue(objectValue, objectValue.getClass(), key);
                }
                if (result == null) continue;
                jsonBuffer = jsonBuffer + realKey + ":";
                jsonBuffer = jsonBuffer + "{";
                jsonBuffer = jsonBuffer + "${quote_2312415321232}isenum${quote_2312415321232}:true,";
                if (this.asSubClass(dataType, IntEnum.class)) {
                    String strAlias = null;
                    strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? result.getName() : result.getAlias(this.ctx.getLocale());
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + result.getValue();
                } else if (this.asSubClass(dataType, FloatEnum.class)) {
                    String strAlias = null;
                    strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((FloatEnum)result).getName() : ((FloatEnum)result).getAlias(this.ctx.getLocale());
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + ((FloatEnum)result).getValue();
                } else if (this.asSubClass(dataType, DoubleEnum.class)) {
                    String strAlias = null;
                    strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((DoubleEnum)result).getName() : ((DoubleEnum)result).getAlias(this.ctx.getLocale());
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:" + ((DoubleEnum)result).getValue();
                } else if (this.asSubClass(dataType, StringEnum.class)) {
                    String strAlias = null;
                    strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((StringEnum)result).getName() : ((StringEnum)result).getAlias(this.ctx.getLocale());
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:${quote_2312415321232}" + ((StringEnum)result).getValue() + "${quote_2312415321232}";
                } else if (this.asSubClass(dataType, DynamicEnum.class)) {
                    String strAlias = null;
                    strAlias = this.ctx.getLocale().equals(LocaleUtils.locale_l1) ? ((DynamicEnum)result).getName() : ((DynamicEnum)result).getAlias(this.ctx.getLocale());
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}alias${quote_2312415321232}:${quote_2312415321232}" + strAlias + "${quote_2312415321232}" + ",";
                    jsonBuffer = jsonBuffer + "${quote_2312415321232}value${quote_2312415321232}:${quote_2312415321232}" + ((DynamicEnum)result).getValue() + "${quote_2312415321232}";
                }
                jsonBuffer = jsonBuffer + "}";
            } else if (this.asSubClass(dataType, BOSUuid.class)) {
                jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
            } else if (this.asSubClass(dataType, Timestamp.class)) {
                format = new SimpleDateFormat(DATEFORMAT);
                jsonBuffer = value instanceof String ? jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value + "${quote_2312415321232}" : jsonBuffer + realKey + ":" + "${quote_2312415321232}" + format.format((Date)value) + "${quote_2312415321232}";
            } else if (this.asSubClass(dataType, Date.class)) {
                format = new SimpleDateFormat(DATEFORMAT);
                jsonBuffer = value instanceof String ? jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value + "${quote_2312415321232}" : jsonBuffer + realKey + ":" + "${quote_2312415321232}" + format.format((Date)value) + "${quote_2312415321232}";
            } else {
                jsonBuffer = jsonBuffer + realKey + ":" + "${quote_2312415321232}" + value.toString() + "${quote_2312415321232}";
            }
            if (!enumeration.hasMoreElements()) continue;
            jsonBuffer = jsonBuffer + ",";
        }
        if (jsonBuffer.trim().endsWith(",")) {
            jsonBuffer = jsonBuffer.substring(0, jsonBuffer.length() - 1);
        }
        jsonBuffer = jsonBuffer + "${rightbracket_2312415321232}";
        return jsonBuffer.toString();
    }

    private String getRealByMetaData(BOSObjectType bosType, String key) {
        EntityObjectInfo entityObjectInfo;
        if (!StringUtils.isEmpty((String)key) && (entityObjectInfo = MetaDataLoader.getEntity((Context)this.ctx, (BOSObjectType)bosType)) != null) {
            PropertyCollection propertyCollection = entityObjectInfo.getDuplicatedEntityProperties();
            int size = propertyCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!key.equalsIgnoreCase(propertyCollection.get(i).getName())) continue;
                return propertyCollection.get(i).getName();
            }
        }
        return null;
    }

    private String getRealByEntity(Class clazz, String property) {
        if (clazz == null || property == null || property.equals("")) {
            return null;
        }
        Method[] methods = clazz.getDeclaredMethods();
        String strOldKey = "get" + property;
        String strOldKeyByBoolean = "is" + property;
        for (Method method : methods) {
            if (method.getName().equalsIgnoreCase(strOldKey)) {
                String fieldName = method.getName().substring(3);
                return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
            }
            if (!method.getName().equalsIgnoreCase(strOldKeyByBoolean)) continue;
            String fieldName = method.getName().substring(2);
            return fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        }
        return this.getRealByEntity(clazz.getSuperclass(), property);
    }

    private Type getMetadataValueType(SimpleProperty propertyObject) {
        String strDataType = null;
        if (propertyObject == null) {
            return null;
        }
        strDataType = propertyObject.getDataType() == DataType.OBJECTVALUE ? propertyObject.getRefTypeInfo() : (propertyObject.getDataType() == DataType.ENUM ? propertyObject.getRefTypeInfo() : (propertyObject.getDataType() == DataType.STRING ? "java.lang.String" : (propertyObject.getDataType() == DataType.INTEGER ? "java.lang.Integer" : (propertyObject.getDataType() == DataType.FLOAT ? "java.lang.Float" : (propertyObject.getDataType() == DataType.DOUBLE ? "java.lang.Double" : (propertyObject.getDataType() == DataType.BOOLEAN ? "java.lang.Boolean" : propertyObject.getDataType().getJavaTypeName()))))));
        Class<?> dataType = null;
        try {
            dataType = Class.forName(strDataType);
        }
        catch (ClassNotFoundException exception) {
            logger.info((Object)exception.getMessage(), (Throwable)exception);
        }
        return dataType;
    }
}

