/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.webservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.bsf.service.MethodInfo;
import com.kingdee.bos.bsf.service.OSFResponse;
import com.kingdee.bos.bsf.service.ServiceInfo;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.ServiceBizException;
import com.kingdee.shr.base.syssetting.app.util.MsfServiceUtil;
import com.kingdee.shr.base.syssetting.util.SystemContextUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.osf.OSFCacheHelper;
import com.kingdee.shr.webservice.app.AbstractOSFWebserviceFacadeControllerBean;
import com.kingdee.shr.webservice.utils.OSFWebServiceJSONUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OSFWebserviceFacadeControllerBean
extends AbstractOSFWebserviceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.webservice.app.OSFWebserviceFacadeControllerBean");
    public static final String LOCAL_RPC_ADDRESS = "tcp://127.0.0.1:";
    public static final String APP_SERVER_TYPE_APUSIC = "apusic";
    private static final String RPCURL = "RPCUrl";

    @Override
    protected String _proceedOSF(Context ctx, String serviceName, String param) throws BOSException {
        OSFResponse standataResult;
        block8: {
            OSFWebserviceFacadeControllerBean.initRpcInnerParams(ctx);
            Object result = null;
            standataResult = new OSFResponse(0, "", null);
            ServiceInfo serviceInfo = OSFCacheHelper.getServiceInfo((Context)ctx, (String)serviceName);
            boolean isForamt = MsfServiceUtil.isFormat((Context)ctx, (ServiceInfo)serviceInfo);
            Map map = null;
            try {
                if (null == serviceInfo) {
                    throw new ServiceBizException(ServiceBizException.SERVICE_NOT_FOUND, new Object[]{serviceName});
                }
                map = StringUtils.isEmpty((String)param) || "null".equalsIgnoreCase(param) ? new HashMap() : (Map)OSFWebServiceJSONUtils.convertJsonToObject(ctx, param, HashMap.class);
                MethodInfo m = MsfServiceUtil.getMethodInfo((String)"process", (ServiceInfo)serviceInfo);
                MsfServiceUtil.checkOuterAndInnerOsfPermission((Context)ctx, (String)serviceName, (ServiceInfo)serviceInfo, (boolean)OSFWebserviceFacadeControllerBean.isOuterCallOsf(ctx));
                result = MSFServiceFacadeFactory.getLocalInstance((Context)ctx).processService(serviceName, map);
                String jsonStr = OSFWebServiceJSONUtils.convertObjectToJson(ctx, result);
                if (isForamt) {
                    if (null != m && m.getRes().isEncrypt() && !StringUtils.isEmpty((String)serviceInfo.getEncryptKey())) {
                        standataResult.setData((Object)MsfServiceUtil.encode((String)jsonStr, (String)serviceInfo.getEncryptKey()));
                        MsfServiceUtil.setExtData((OSFResponse)standataResult, (String)serviceInfo.getEncryptKey());
                    } else {
                        standataResult.setData(result);
                        MsfServiceUtil.setExtData((OSFResponse)standataResult, null);
                    }
                    if (map.containsKey("_biz_error_code_")) {
                        standataResult.setBizCode((String)map.get("_biz_error_code_"));
                        standataResult.setErrMsg((String)map.get("_biz_error_msg_"));
                        standataResult.setErrCode(1);
                    }
                    break block8;
                }
                return jsonStr;
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder();
                msg.append(SHRServerResource.getString((String)"com.kingdee.shr.webservice.WebServiceResourse", (String)"call_msfservice_fail", (Context)ctx));
                logger.error((Object)msg.toString(), (Throwable)e);
                if (isForamt) {
                    MsfServiceUtil.setErrorCodeAndMessage((OSFResponse)standataResult, (Exception)e, (ServiceInfo)serviceInfo, map);
                }
                return msg.append(e.getMessage()).toString();
            }
        }
        return OSFWebServiceJSONUtils.convertObjectToJson(ctx, standataResult);
    }

    private static boolean isOuterCallOsf(Context ctx) {
        boolean isBaseDB = SystemContextUtil.isBaseDBUserAuthPattern((Context)ctx);
        return isBaseDB && LoginType.WEBSERVICE.toString().equals(SystemContextUtil.getLoginType((Context)ctx));
    }

    private static void initRpcInnerParams(Context ctx) {
        if (ctx == null) {
            return;
        }
        String sessionid = ctx.getContextID();
        HashMap<String, String> envContext = new HashMap<String, String>();
        if (System.getProperty(RPCURL) != null) {
            envContext.put("URL", System.getProperty(RPCURL));
        } else {
            String serverType = System.getProperty("APP_SERVER_TYPE");
            if (serverType != null && serverType.equalsIgnoreCase(APP_SERVER_TYPE_APUSIC)) {
                envContext.put("URL", "[LOCAL]");
            } else {
                envContext.put("URL", LOCAL_RPC_ADDRESS + ORMRPConfig.getTcpConnectionPort());
            }
        }
        if (envContext.get("URL").equals("[LOCAL]")) {
            envContext.put("BOSCTX", (String)ctx);
        } else {
            envContext.put("SESSIONID", sessionid);
        }
        GeniusBOSFactory.setEnvContext(envContext);
    }
}

