/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.webservice.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.PropertySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.shr.webservice.utils.OSFWebServiceJSONUtils;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.jsp.JspContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;

public class MultiLangUtils {
    protected static Logger logger = Logger.getLogger(MultiLangUtils.class);
    private static final String MODEL = "model";
    private static final String PROP_NAME = "propName";
    private static final String VALUE = "value";

    public static String getValue(Context ctx, JspContext jc, boolean displayAsHTML) {
        Object valueObj = jc.getAttribute(VALUE);
        if (valueObj != null) {
            return valueObj.toString();
        }
        String attribute = (String)jc.getAttribute(PROP_NAME);
        Object obj = jc.getAttribute(MODEL);
        if (attribute != null && obj != null && obj instanceof IObjectValue) {
            Locale[] supportedLocales;
            HashMap<String, Object> m = new HashMap<String, Object>();
            IObjectValue model = (IObjectValue)obj;
            for (Locale locale : supportedLocales = BOSLocaleUtil.getSupportedLocales()) {
                String key = BOSLocaleUtil.getShortCode((Locale)locale);
                if (key == null) continue;
                Object localeValue = model.get(attribute, locale);
                if (localeValue instanceof String && displayAsHTML) {
                    localeValue = StringEscapeUtils.escapeHtml((String)((String)localeValue)).replaceAll("(\r\n|\n)", "<br/>").replaceAll(" ", "&nbsp");
                }
                m.put(key, localeValue);
            }
            return OSFWebServiceJSONUtils.convertObjectToJson(ctx, m);
        }
        return null;
    }

    public static void mergeSystemMultiLangOption(Context ctx, JspContext jc) {
        if (ctx != null) {
            Object defaultLang = jc.getAttribute("defaultLang");
            Locale locale = null;
            String language = null;
            if (defaultLang == null && ctx != null && (locale = ctx.getLocale()) != null && (language = locale.getLanguage()) != null) {
                jc.setAttribute("defaultLang", (Object)language);
            }
        }
    }

    public static boolean isMultiLangEntityProperty(BOSObjectType bosObjectType, String property) {
        try {
            EntitySelect select = new EntitySelect(bosObjectType);
            PropertySelect propSelect = select.propertySelect().selectOwnProperty(new String[]{"*"}, new String[]{"isMultilingual"});
            SimpleEntity entity = MetaDataAccessFactory.getRemoteInstance().select(select);
            SimpleProperty propertyObject = entity.property(property);
            return propertyObject != null && propertyObject.getBoolean("isMultilingual");
        }
        catch (BOSException exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static boolean isMultiLangValueFormat(String text) {
        if (text == null) {
            return false;
        }
        return text.startsWith("{") && text.endsWith("}");
    }
}

