/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sscbusiness.contract.BillStateEnum;
import com.kingdee.eas.sscbusiness.contract.ContractFactory;
import com.kingdee.eas.sscbusiness.contract.ContractInfo;
import com.kingdee.eas.sscbusiness.contract.app.AbstractContractDetailReqFacadeControllerBean;
import com.kingdee.eas.sscbusiness.contract.app.ContractDetailFactory;
import com.kingdee.eas.sscbusiness.contract.app.ContractDetailInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;

public class ContractDetailReqFacadeControllerBean
extends AbstractContractDetailReqFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sscbusiness.contract.app.ContractDetailReqFacadeControllerBean");

    @Override
    protected void _setAuditOK(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setState(BillStateEnum.PASS);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        UserInfo uIf = new UserInfo();
        uIf.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        cdInfo.setAuditor(uIf);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
    }

    @Override
    protected void _setAuditNG(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setState(BillStateEnum.UNPASS);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        UserInfo uIf = new UserInfo();
        uIf.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        cdInfo.setAuditor(uIf);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
    }

    @Override
    protected void _reverseAudit(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.inWorkflow(ctx, billId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setState(BillStateEnum.SAVE);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        UserInfo uIf = new UserInfo();
        uIf.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        cdInfo.setAuditor(uIf);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
    }

    @Override
    protected void _discard(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        cdInfo.setState(BillStateEnum.Invalid);
        UserInfo uIf = new UserInfo();
        uIf.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        cdInfo.setAuditor(uIf);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
        SelectorItemCollection csic = new SelectorItemCollection();
        csic.add(new SelectorItemInfo("contract.*"));
        csic.add(new SelectorItemInfo("fixAmount"));
        csic.add(new SelectorItemInfo("computeAmount"));
        ContractDetailInfo info = ContractDetailFactory.getLocalInstance(ctx).getContractDetailInfo((IObjectPK)new ObjectUuidPK(billId), csic);
        ContractInfo cInfo = info.getContract();
        cInfo.setFixAmount(cInfo.getFixAmount().subtract(info.getFixAmount()));
        cInfo.setComputeAmount(cInfo.getComputeAmount().subtract(info.getComputeAmount()));
        ContractFactory.getLocalInstance(ctx).save((CoreBaseInfo)cInfo);
    }

    @Override
    protected void _reverseDiscard(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        cdInfo.setState(BillStateEnum.PASS);
        UserInfo uIf = new UserInfo();
        uIf.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        cdInfo.setAuditor(uIf);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
        SelectorItemCollection csic = new SelectorItemCollection();
        csic.add(new SelectorItemInfo("contract.*"));
        csic.add(new SelectorItemInfo("fixAmount"));
        csic.add(new SelectorItemInfo("computeAmount"));
        ContractDetailInfo info = ContractDetailFactory.getLocalInstance(ctx).getContractDetailInfo((IObjectPK)new ObjectUuidPK(billId), csic);
        ContractInfo cInfo = info.getContract();
        cInfo.setFixAmount(cInfo.getFixAmount().add(info.getFixAmount()));
        cInfo.setComputeAmount(cInfo.getComputeAmount().add(info.getComputeAmount()));
        ContractFactory.getLocalInstance(ctx).save((CoreBaseInfo)cInfo);
    }

    @Override
    protected void _callback(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        ContractDetailInfo cdInfo = new ContractDetailInfo();
        cdInfo.setId(billId);
        cdInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
        cdInfo.setState(BillStateEnum.CALLBACK);
        cdInfo.setAuditor(null);
        ContractDetailFactory.getLocalInstance(ctx).updatePartial(cdInfo, sic);
    }

    private void inWorkflow(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        String sql = "SELECT top 1 FPROCINSTID  FROM t_wfr_procinstref where FREFID = '" + billId.toString() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("00", "\u5df2\u5728\u5de5\u4f5c\u6d41\u4e2d\u5904\u7406\uff01"));
        }
    }
}

