/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sscbusiness.contract.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.sscbusiness.contract.ContractPerformanceFacadeFactory;
import com.kingdee.eas.sscbusiness.contract.MakeInvoiceEntryCollection;
import com.kingdee.eas.sscbusiness.contract.OperateException;
import com.kingdee.eas.sscbusiness.contract.SettlementBillCollection;
import com.kingdee.eas.sscbusiness.contract.SettlementBillEntryCollection;
import com.kingdee.eas.sscbusiness.contract.SettlementBillInfo;
import com.kingdee.eas.sscbusiness.contract.app.AbstractSettlementBillControllerBean;
import com.kingdee.eas.sscbusiness.contract.tool.PermissionOrgUtil;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class SettlementBillControllerBean
extends AbstractSettlementBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.sscbusiness.contract.app.SettlementBillControllerBean");

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        this.handleNumberRule(ctx, info);
        this.checkEntryIsEmpty(ctx, info);
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
        super._update(ctx, pk, model);
    }

    protected void checkEntryIsEmpty(Context ctx, SettlementBillInfo info) throws BOSException, EASBizException {
        if (info != null) {
            SettlementBillEntryCollection entry = info.getSettleEntry();
            if (entry == null || entry.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u5408\u540c\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
            MakeInvoiceEntryCollection invoiceEntry = info.getInvoiceEntry();
            if (invoiceEntry == null || invoiceEntry.size() == 0) {
                throw new EASBizException(new NumericExceptionSubItem("00", "\u5f00\u7968\u4fe1\u606f\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
            }
        }
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        this.handleNumberRule(ctx, info);
        this.checkEntryIsEmpty(ctx, info);
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
        return super._save(ctx, model);
    }

    private void handleNumberRule(Context ctx, SettlementBillInfo info) {
        if (!StringUtils.isEmpty((String)info.getNumber())) {
            return;
        }
        String shareCenterId = ((FullOrgUnitInfo)ctx.get((Object)"CurOU")).getId().toString();
        logger.error((Object)("###com.kingdee.eas.sscbusiness.contract.app.SettlementBillControllerBean.handleNumberRule shareCenterId:" + shareCenterId));
        String sNumber = "";
        try {
            CodingRuleInfo codingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)info, shareCenterId);
            if (null == codingRule) {
                String companyId = PermissionOrgUtil.getCompanyOrgIDByShareCenterID(ctx, shareCenterId);
                logger.error((Object)("###com.kingdee.eas.sscbusiness.contract.app.SettlementBillControllerBean.handleNumberRule companyId:" + companyId));
                codingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getCodingRule((IObjectValue)info, companyId);
            }
            sNumber = null == codingRule ? "" : CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, codingRule);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        info.setNumber(sNumber);
    }

    public Result submit(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        int i;
        if (null != colls && !colls.isEmpty()) {
            SettlementBillInfo info = null;
            for (i = 0; i < colls.size(); ++i) {
                info = (SettlementBillInfo)colls.get(i);
                PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
            }
        }
        Result result = super.submit(ctx, colls);
        if (null != colls && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseSettlementAmt((SettlementBillInfo)colls.get(i));
            }
        }
        return result;
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
        super.submit(ctx, pk, model);
        ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseSettlementAmt((SettlementBillInfo)model);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        SettlementBillInfo info = (SettlementBillInfo)model;
        PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
        IObjectPK pk = super.submit(ctx, model);
        ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseSettlementAmt((SettlementBillInfo)model);
        return pk;
    }

    public IObjectPK[] submitBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        int i;
        if (null != colls && !colls.isEmpty()) {
            SettlementBillInfo info = null;
            for (i = 0; i < colls.size(); ++i) {
                info = (SettlementBillInfo)colls.get(i);
                PermissionOrgUtil.checkIsallotCompanyOrg(ctx, info.getShareCenter().getId().toString());
            }
        }
        IObjectPK[] pks = super.submitBatchData(ctx, colls);
        if (null != colls && !colls.isEmpty()) {
            for (i = 0; i < colls.size(); ++i) {
                ContractPerformanceFacadeFactory.getLocalInstance(ctx).reverseSettlementAmt((SettlementBillInfo)colls.get(i));
            }
        }
        return pks;
    }

    private void checkInfoState(Context ctx, SettlementBillInfo info) throws EASBizException, BOSException {
        if (null != info.getState() && !"save".equals(info.getState().getValue())) {
            throw new OperateException(OperateException.DELETENOSAVESTATEEXCEPTION, new Object[]{"\u5355\u636e\u53f7\uff1a" + info.getNumber()});
        }
        ArrayList destIdList = BOTRelationFactory.getLocalInstance((Context)ctx).getDestObjIdByDestType(info.getId().toString(), null);
        if (destIdList != null && destIdList.size() > 0) {
            throw new OperateException(OperateException.EXISTSDESTOBJECTEXCEPTION, new Object[]{"\u5355\u636e\u53f7\uff1a" + info.getNumber()});
        }
    }

    public void deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        for (IObjectPK pk : pkArray) {
            this.checkInfoState(ctx, this.getSettlementBillInfo(ctx, pk));
        }
        super.deleteBatchData(ctx, pkArray);
    }

    @Override
    public IObjectPK[] delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SettlementBillCollection colls = this.getSettlementBillCollection(ctx, view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                SettlementBillInfo info = colls.get(i);
                this.checkInfoState(ctx, info);
            }
        }
        return super.delete(ctx, filter);
    }

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkInfoState(ctx, this.getSettlementBillInfo(ctx, pk));
        super.delete(ctx, pk);
    }

    @Override
    public void delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        for (IObjectPK pk : arrayPK) {
            this.checkInfoState(ctx, this.getSettlementBillInfo(ctx, pk));
        }
        super.delete(ctx, arrayPK);
    }

    @Override
    public IObjectPK[] delete(Context ctx, String oql) throws BOSException, EASBizException {
        SettlementBillCollection colls = this.getSettlementBillCollection(ctx, oql);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                SettlementBillInfo info = colls.get(i);
                this.checkInfoState(ctx, info);
            }
        }
        return super.delete(ctx, oql);
    }
}

