/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceBizStatus;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.TaxSepInvoiceRelationInfo;
import com.kingdee.eas.tm.im.TaxSeparationEntryInfo;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Action {
    private BigDecimal maxAmount = new BigDecimal(100000);
    private int maxLine = 7;
    private int pricePrecision = 10;
    private boolean isList = false;
    private boolean isInTax = true;
    private List<TaxSepInvoiceRelationInfo> actionList;
    private Map<String, List<TaxSepInvoiceRelationInfo>> actionMap;
    private Map<String, TaxSeparationEntryInfo> taxSepEntryMap;
    private List<TaxSeparationEntryInfo> taxSepEntryList = new ArrayList<TaxSeparationEntryInfo>();
    private List<TaxSepInvoiceRelationInfo> invoiceRelationList = new ArrayList<TaxSepInvoiceRelationInfo>();
    private List<MakeInvoiceEntryInfo> invoiceEntryList = new ArrayList<MakeInvoiceEntryInfo>();
    private List<MakeInvoiceInfo> invoiceList = new ArrayList<MakeInvoiceInfo>();
    private MakeInvoiceEntryInfo invoiceEntry;
    private MakeInvoiceInfo invoice;
    private BigDecimal hasAmount = null;
    private BigDecimal hasQuantity = null;

    public Action(TaxSepInvoiceRelationInfo action) {
        this.actionList = new ArrayList<TaxSepInvoiceRelationInfo>();
        this.actionList.add(action);
        this.init();
    }

    public Action(List<TaxSepInvoiceRelationInfo> actionList) {
        this.actionList = actionList;
        this.init();
    }

    public void init() {
        this.actionMap = new LinkedHashMap<String, List<TaxSepInvoiceRelationInfo>>();
        this.taxSepEntryMap = new LinkedHashMap<String, TaxSeparationEntryInfo>();
        this.taxSepEntryList = new ArrayList<TaxSeparationEntryInfo>();
        this.invoiceRelationList = new ArrayList<TaxSepInvoiceRelationInfo>();
        this.invoiceEntryList = new ArrayList<MakeInvoiceEntryInfo>();
        this.invoiceList = new ArrayList<MakeInvoiceInfo>();
        this.invoice = this.initMakeInvoice();
        this.invoiceEntry = this.initMakeInvoiceEntry(BigDecimal.ZERO, this.invoice);
        this.actionList2Map();
        this.storeTaxSepEntryMap();
    }

    protected MakeInvoiceEntryInfo initMakeInvoiceEntry(BigDecimal noTaxAmt, MakeInvoiceInfo makeInvoice) {
        return MakeInvoiceEntryInfo.createMakeInvoiceEntryInfo(makeInvoice);
    }

    protected MakeInvoiceInfo initMakeInvoice() {
        return MakeInvoiceInfo.createMakeInvoiceInfo();
    }

    private void actionList2Map() {
        for (TaxSepInvoiceRelationInfo action : this.getActionList()) {
            ArrayList<TaxSepInvoiceRelationInfo> actionNewList = new ArrayList<TaxSepInvoiceRelationInfo>();
            actionNewList.add(action);
            this.actionMap.put(action.toString(), actionNewList);
        }
    }

    private void storeTaxSepEntryMap() {
        for (TaxSepInvoiceRelationInfo action : this.getActionList()) {
            this.taxSepEntryList.add(action.getTaxSepEntry());
            this.taxSepEntryMap.put(action.getTaxSepEntry().getId().toString(), action.getTaxSepEntry());
        }
    }

    protected void beforeAction() {
    }

    public void action() {
        this.beforeAction();
        if (this.actionMap == null || this.actionMap.size() == 0) {
            return;
        }
        for (String key : this.actionMap.keySet()) {
            for (TaxSepInvoiceRelationInfo action : this.actionMap.get(key)) {
                TaxSeparationEntryInfo taxSepEntry = action.getTaxSepEntry();
                BigDecimal taxRate = taxSepEntry.getTaxRate();
                if (this.isInTax) {
                    BigDecimal _noTaxAmount = action.getAmount().divide(taxRate.add(BigDecimal.ONE), this.pricePrecision, 6);
                    action.setLeftAmount(_noTaxAmount);
                } else {
                    action.setLeftAmount(action.getAmount());
                }
                BigDecimal quantity = taxSepEntry.getQuantity();
                TaxSeparationInfo sourceBillInfo = taxSepEntry.getBill();
                while (this.invoice.getNoTaxAmtTotal().add(action.getLeftAmount()).compareTo(this.maxAmount) > 0) {
                    BigDecimal amount = this.subtractBigDecimal(this.maxAmount, this.invoice.getNoTaxAmtTotal());
                    this.putInvoiceRelation(taxSepEntry, amount, quantity, this.invoiceEntry);
                    this.putTaxSepEntryInfoToInvoiceEntryInfo(this.invoiceEntry, taxSepEntry, action, amount);
                    this.putInvoiceEntry(this.invoiceEntry);
                    this.putTaxSepInfoToInvoiceInfo(this.invoice, sourceBillInfo, taxSepEntry, amount);
                    this.putInvoice(this.invoice);
                    action.setLeftAmount(this.subtractBigDecimal(action.getLeftAmount(), amount));
                }
                if (this.invoice.getNoTaxAmtTotal().add(action.getLeftAmount()).compareTo(this.maxAmount) > 0) continue;
                this.putInvoiceRelation(taxSepEntry, action.getLeftAmount(), quantity, this.invoiceEntry);
                this.putTaxSepEntryInfoToInvoiceEntryInfo(this.invoiceEntry, taxSepEntry, action, action.getLeftAmount());
                this.putTaxSepInfoToInvoiceInfo(this.invoice, sourceBillInfo, taxSepEntry, action.getLeftAmount());
                if (this.invoice.getNoTaxAmtTotal().compareTo(this.maxAmount) != 0) continue;
                this.putInvoiceEntry(this.invoiceEntry);
                this.putInvoice(this.invoice);
            }
            if (this.invoiceEntry.getNoTaxAmt().compareTo(new BigDecimal(0)) <= 0) continue;
            this.putInvoiceEntry(this.invoiceEntry);
            if (this.invoice.getEntries().size() != this.maxLine) continue;
            if (!this.isList) {
                this.putInvoice(this.invoice);
                continue;
            }
            this.invoice.setIsList(true);
        }
        if (this.invoice.getNoTaxAmtTotal().compareTo(new BigDecimal(0)) > 0) {
            this.putInvoice(this.invoice);
        }
        this.afterAction();
    }

    protected void afterAction() {
    }

    private void putInvoice(MakeInvoiceInfo invoiceSave) {
        MakeInvoiceInfo makeInvoice = (MakeInvoiceInfo)invoiceSave.clone();
        this.invoiceList.add(makeInvoice);
        this.invoice = this.initMakeInvoice();
        if (this.isInTax) {
            this.invoice.setIsContainTax(true);
        } else {
            this.invoice.setIsContainTax(false);
        }
        this.invoiceEntry.setMakeInvoice(this.invoice);
    }

    private void putTaxSepInfoToInvoiceInfo(MakeInvoiceInfo makeInvoice, TaxSeparationInfo taxSepInfo, TaxSeparationEntryInfo taxSepEntry, BigDecimal amount) {
        if (taxSepInfo != null) {
            this.invoice.setNoTaxAmtTotal(this.addBigDecimal(this.invoice.getNoTaxAmtTotal(), amount));
            this.invoice.setTaxAmtTotal(this.multipyBigDecimal(this.invoice.getNoTaxAmtTotal(), taxSepEntry.getTaxRate()));
            this.invoice.setPriceTaxTotal(this.addBigDecimal(this.invoice.getNoTaxAmtTotal(), this.invoice.getTaxAmtTotal()));
            makeInvoice.setApplicateDate(new Date());
            makeInvoice.setCurrAcctCustomer(taxSepInfo.getCustomer());
            makeInvoice.setCurrentAccountType(CurrentAccountType.CUSTOMER);
            makeInvoice.setIsContainTax(true);
            makeInvoice.setBizStatus(InvoiceBizStatus.NULL);
            makeInvoice.setCurrency(taxSepInfo.getCurrency());
            makeInvoice.setStatus(InvoiceBillStatus.TEMPSTROE);
            makeInvoice.setFiVouchered(false);
            makeInvoice.setSrcSystem(InvoiceSrcSystem.SYSTEM);
            makeInvoice.setIsRedVoice(false);
            makeInvoice.setBizDate(taxSepInfo.getBizDate());
            makeInvoice.setCompany(taxSepInfo.getCompany());
        }
    }

    private void putTaxSepEntryInfoToInvoiceEntryInfo(MakeInvoiceEntryInfo invoiceEntryNew, TaxSeparationEntryInfo taxSepEntry, TaxSepInvoiceRelationInfo action, BigDecimal amount) {
        if (taxSepEntry != null) {
            invoiceEntryNew.setEntryName(taxSepEntry.getProductCode());
            if (action.isTakeModel()) {
                invoiceEntryNew.setSpecs(taxSepEntry.getSpecification());
            }
            invoiceEntryNew.setMeasureUnit(taxSepEntry.getMeasureUnit());
            this.invoiceEntry.setNoTaxAmt(this.addBigDecimal(this.invoiceEntry.getNoTaxAmt(), amount));
            BigDecimal quantity = null;
            if (this.isFinalProcess(amount, action, taxSepEntry.getTaxRate())) {
                BigDecimal leftQuantity = this.getLeftQuantity(action);
                quantity = this.addBigDecimal(invoiceEntryNew.getQuantity(), leftQuantity);
            } else {
                BigDecimal addQuantity = this.getAddQuantity(taxSepEntry, amount, action);
                quantity = this.addBigDecimal(invoiceEntryNew.getQuantity(), addQuantity);
            }
            invoiceEntryNew.setQuantity(quantity);
            invoiceEntryNew.setNoTaxPrice(this.divideBigDecimal(invoiceEntryNew.getNoTaxAmt(), invoiceEntryNew.getQuantity()));
            invoiceEntryNew.setTaxRate(taxSepEntry.getTaxRate());
            invoiceEntryNew.setTaxAmt(this.multipyBigDecimal(invoiceEntryNew.getNoTaxAmt(), invoiceEntryNew.getTaxRate()));
            invoiceEntryNew.setPriceTax(this.addBigDecimal(invoiceEntryNew.getNoTaxAmt(), invoiceEntryNew.getTaxAmt()));
            invoiceEntryNew.setPrice(this.divideBigDecimal(invoiceEntryNew.getPriceTax(), invoiceEntryNew.getQuantity()));
            invoiceEntryNew.setDiscountRate(taxSepEntry.getDiscountRate());
            invoiceEntryNew.setDiscountAmt(taxSepEntry.getDiscountAmount());
        }
    }

    private BigDecimal getAddQuantity(TaxSeparationEntryInfo taxSepEntry, BigDecimal amount, TaxSepInvoiceRelationInfo action) {
        BigDecimal addQuantity = this.divideBigDecimal(this.multipyBigDecimal(action.getQuantityTotal(), amount), action.getAmountTotal());
        if (this.hasQuantity == null) {
            this.hasQuantity = BigDecimal.ZERO;
        }
        this.hasQuantity = this.hasQuantity.add(addQuantity);
        return addQuantity;
    }

    private BigDecimal getLeftQuantity(TaxSepInvoiceRelationInfo action) {
        BigDecimal minuend = this.hasQuantity == null ? BigDecimal.ZERO : this.hasQuantity;
        BigDecimal leftQuantity = this.subtractBigDecimal(action.getQuantityTotal(), minuend);
        this.hasQuantity = null;
        return leftQuantity;
    }

    private boolean isFinalProcess(BigDecimal amount, TaxSepInvoiceRelationInfo action, BigDecimal taxRate) {
        BigDecimal total = BigDecimal.ZERO;
        total = this.isInTax ? action.getAmountTotal().divide(new BigDecimal("1").add(taxRate), this.pricePrecision, 6) : action.getAmountTotal();
        boolean b = false;
        if (this.hasAmount == null) {
            this.hasAmount = BigDecimal.ZERO;
        }
        this.hasAmount = this.hasAmount.add(amount);
        BigDecimal _hasAmount = this.hasAmount.setScale(this.pricePrecision, 6);
        if (_hasAmount.compareTo(total) == 0) {
            b = true;
            this.hasAmount = null;
        }
        return b;
    }

    private BigDecimal addBigDecimal(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (b2 == null) {
            b2 = BigDecimal.ZERO;
        }
        return b1.add(b2).setScale(this.pricePrecision, 6);
    }

    private BigDecimal subtractBigDecimal(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (b2 == null) {
            b2 = BigDecimal.ZERO;
        }
        return b1.subtract(b2).setScale(this.pricePrecision, 6);
    }

    private BigDecimal multipyBigDecimal(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (b2 == null) {
            b2 = BigDecimal.ZERO;
        }
        return b1.multiply(b2).setScale(this.pricePrecision, 6);
    }

    private BigDecimal divideBigDecimal(BigDecimal b1, BigDecimal b2) {
        if (b1 == null) {
            b1 = BigDecimal.ZERO;
        }
        if (b2 == null || BigDecimal.ZERO.compareTo(b2) == 0) {
            return null;
        }
        return b1.divide(b2, this.pricePrecision, 6);
    }

    private void putInvoiceEntry(MakeInvoiceEntryInfo invoiceEntrySave) {
        MakeInvoiceEntryInfo makeInvoiceEntry;
        MakeInvoiceEntryInfo invoiceEntryNew = (MakeInvoiceEntryInfo)invoiceEntrySave.clone();
        this.invoiceEntryList.add(invoiceEntryNew);
        this.invoice.getEntries().add(invoiceEntryNew);
        this.invoiceEntry = makeInvoiceEntry = this.initMakeInvoiceEntry(BigDecimal.ZERO, this.invoice);
    }

    private void putInvoiceRelation(TaxSeparationEntryInfo taxSepEntry, BigDecimal amount, BigDecimal quantity, MakeInvoiceEntryInfo invoiceEntry) {
        TaxSepInvoiceRelationInfo relationInfo = new TaxSepInvoiceRelationInfo();
        TaxSeparationEntryInfo taxSepEntryClone = (TaxSeparationEntryInfo)taxSepEntry.clone();
        relationInfo.setTaxSepEntry(taxSepEntryClone);
        MakeInvoiceEntryInfo makeInvoiceEntryInfo = (MakeInvoiceEntryInfo)invoiceEntry.clone();
        relationInfo.setInvoiceEntry(makeInvoiceEntryInfo);
        relationInfo.setAmount(amount);
        relationInfo.setQuantity(quantity);
        this.invoiceRelationList.add(relationInfo);
        this.updateTaxSepEntryAmt(taxSepEntryClone.getId(), amount);
    }

    private void updateTaxSepEntryAmt(BOSUuid taxSepEntryId, BigDecimal amount) {
        TaxSeparationEntryInfo taxSepEntry = this.taxSepEntryMap.get(taxSepEntryId.toString());
        taxSepEntry.setInvoiceAmout(this.addBigDecimal(taxSepEntry.getInvoiceAmout(), amount));
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal maxAmount) {
        this.maxAmount = maxAmount;
    }

    public int getMaxLine() {
        return this.maxLine;
    }

    public void setMaxLine(int maxLine) {
        this.maxLine = maxLine;
    }

    public List<TaxSepInvoiceRelationInfo> getActionList() {
        return this.actionList;
    }

    public void setActionList(List<TaxSepInvoiceRelationInfo> actionList) {
        this.actionList = actionList;
    }

    public Map<String, List<TaxSepInvoiceRelationInfo>> getActionMap() {
        return this.actionMap;
    }

    public void setActionMap(Map<String, List<TaxSepInvoiceRelationInfo>> actionMap) {
        this.actionMap = actionMap;
    }

    public Map<String, TaxSeparationEntryInfo> getTaxSepEntryMap() {
        return this.taxSepEntryMap;
    }

    public void setTaxSepEntryMap(Map<String, TaxSeparationEntryInfo> taxSepEntryMap) {
        this.taxSepEntryMap = taxSepEntryMap;
    }

    public List<TaxSeparationEntryInfo> getTaxSepEntryList() {
        return this.taxSepEntryList;
    }

    public void setTaxSepEntryList(List<TaxSeparationEntryInfo> taxSepEntryList) {
        this.taxSepEntryList = taxSepEntryList;
    }

    public List<TaxSepInvoiceRelationInfo> getInvoiceRelationList() {
        return this.invoiceRelationList;
    }

    public void setInvoiceRelationList(List<TaxSepInvoiceRelationInfo> invoiceRelationList) {
        this.invoiceRelationList = invoiceRelationList;
    }

    public List<MakeInvoiceEntryInfo> getInvoiceEntryList() {
        return this.invoiceEntryList;
    }

    public void setInvoiceEntryList(List<MakeInvoiceEntryInfo> invoiceEntryList) {
        this.invoiceEntryList = invoiceEntryList;
    }

    public List<MakeInvoiceInfo> getInvoiceList() {
        return this.invoiceList;
    }

    public void setInvoiceList(List<MakeInvoiceInfo> invoiceList) {
        this.invoiceList = invoiceList;
    }

    public MakeInvoiceEntryInfo getInvoiceEntry() {
        return this.invoiceEntry;
    }

    public void setInvoiceEntry(MakeInvoiceEntryInfo invoiceEntry) {
        this.invoiceEntry = invoiceEntry;
    }

    public MakeInvoiceInfo getInvoice() {
        return this.invoice;
    }

    public void setMakeInvoice(MakeInvoiceInfo invoice) {
        this.invoice = invoice;
    }

    public boolean isList() {
        return this.isList;
    }

    public void setisList(boolean isList) {
        this.isList = isList;
    }

    public int getPricePrecision() {
        return this.pricePrecision;
    }

    public void setPricePrecision(int pricePrecision) {
        this.pricePrecision = pricePrecision;
    }

    public boolean isInTax() {
        return this.isInTax;
    }

    public void setisInTax(boolean isInTax) {
        this.isInTax = isInTax;
    }
}

