/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CertificateInvoiceImport
extends AbstractDataTransmission {
    private List<IncomeInvoiceInfo> invoiceList = new ArrayList<IncomeInvoiceInfo>();
    private List<String> msgList = new ArrayList<String>();

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"invoiceList", this.invoiceList);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.im.client.AuthenticateWizard", (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String invoiceCode = ((DataToken)hsData.get((Object)"FInvoiceCode")).data.toString();
        String invoiceNumber = ((DataToken)hsData.get((Object)"FInvoiceNumber")).data.toString();
        this.checkInvoice(ctx, invoiceCode, invoiceNumber);
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FInvoiceCode", (Object)rs.getString("invoiceCode"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceNumber", (Object)rs.getString("invoiceNumber"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void checkInvoice(Context ctx, String invoiceCode, String invoiceNumber) {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
            view.setFilter(filter);
            IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
            if (coll != null && coll.size() > 0) {
                IncomeInvoiceInfo incomeInvoiceInfo = coll.get(0);
                if (IncomeStatusEnum.NORMAL.equals((Object)incomeInvoiceInfo.getStatus())) {
                    this.buildErrorMsg(ctx, invoiceCode, invoiceNumber, "InvoiceNotNormal");
                } else if (IncomeAuthenticateStatusEnum.UNAUTHORIZED.equals((Object)incomeInvoiceInfo.getAuthenticateStatus())) {
                    this.buildErrorMsg(ctx, invoiceCode, invoiceNumber, "InvoicePassed");
                }
                this.invoiceList.add(incomeInvoiceInfo);
            } else {
                this.buildErrorMsg(ctx, invoiceCode, invoiceNumber, "InvoiceNotExists");
            }
        }
        catch (BOSException e) {
            this.buildErrorMsg(ctx, invoiceCode, invoiceNumber, "InvoiceNotExists");
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    private void buildErrorMsg(Context ctx, String invoiceCode, String invoiceNumber, String key) {
        StringBuffer msg = new StringBuffer();
        msg.append(invoiceCode).append("_").append(invoiceNumber).append(": ");
        msg.append(IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, ctx.getLocale()));
        this.msgList.add(msg.toString());
    }
}

