/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExchInvSqlHelper {
    private Context ctx;
    private List<BOTRelationInfo> botpUpdateList = new ArrayList<BOTRelationInfo>();
    private List<String> delSqlList = new ArrayList<String>();
    private List<String> updateSqlList = new ArrayList<String>();

    public ExchInvSqlHelper(Context context) {
        this.ctx = context;
    }

    public String getIncomeTypeID(String obId) throws BOSException {
        String incomeTypeID = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select parent.fid as id from T_TM_IncomeType parent ").append("\n");
            sql.append(" left join T_TM_IncomeTypeEntry entry on parent.FID = entry.FParentID ").append("\n");
            sql.append(" where parent.FStatus = '").append("0").append("' ");
            sql.append(" and entry.FTypeId = (");
            sql.append(" Select top 1 FRowTypeId from T_AP_OtherBillentry where FParentID='").append(obId).append("')");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                incomeTypeID = rs.getString("id");
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return incomeTypeID;
    }

    public boolean getReBusiness(String obId) throws BOSException {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" select FFiVouchered from T_AP_OtherBill ").append("\n");
            sql.append(" where FID = '").append(obId).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                return rs.getBoolean("FFiVouchered");
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return false;
    }

    public List getAPOBIDs(List ids) throws BOSException {
        ArrayList<String> obIdList = new ArrayList<String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FDestObjectID as FOtherBillId,count(FDestObjectID) from T_BOT_Relation where FDESTEntityID = '48DA3A71' ").append("\n");
            sql.append(" and FSRCEntityID = '1343913D' ").append("\n");
            sql.append(" and FSrcObjectID in ").append(IMUtils.getInStringFromList(ids)).append(" group by FDestObjectID ;");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                obIdList.add(rs.getString("FOtherBillId"));
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return obIdList;
    }

    public IRowSet getAPOBInfos(List ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select FID as id,FInvoiceNumber as invNumber,FInvoiceCode as invCode from T_AP_OtherBill ");
        sql.append(" where FID in ");
        sql.append(IMUtils.getInStringFromList(ids));
        return DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
    }

    public Map getTSMRecordInfo(List ids) throws BOSException {
        HashMap<String, Object> tsmRecordInfo = new HashMap<String, Object>();
        String idStr = IMUtils.getInStringFromList(ids);
        try {
            ArrayList<String[]> stepAmounts = new ArrayList<String[]>();
            ArrayList<Integer> seqs = new ArrayList<Integer>();
            String parentId = "";
            int maxSeq = 0;
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FStepSeq as step,sum(FMatchedAmt) as amount from T_TM_ThreeSideMatchRecordEntry ");
            sql.append(" where FBillID in ").append(idStr);
            sql.append(" group by FStepSeq ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                String[] stepAmount = new String[]{rs.getString("step"), rs.getString("amount")};
                stepAmounts.add(stepAmount);
            }
            sql.setLength(0);
            sql.append(" Select FSeq as seq,FParentID as id from T_TM_ThreeSideMatchRecordEntry ");
            sql.append(" where FBillID in ").append(idStr).append(" order by FSeq asc");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                seqs.add(rs.getInt("seq"));
                parentId = rs.getString("id");
            }
            sql.setLength(0);
            sql.append(" Select Max(FSeq) as maxSeq from T_TM_ThreeSideMatchRecordEntry ");
            sql.append(" where FParentID = '").append(parentId).append("' ");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            if (rs.next()) {
                maxSeq = rs.getInt("maxSeq");
            }
            tsmRecordInfo.put("stepAmounts", stepAmounts);
            tsmRecordInfo.put("seqs", seqs);
            tsmRecordInfo.put("parentId", parentId);
            tsmRecordInfo.put("maxSeq", maxSeq);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return tsmRecordInfo;
    }

    public Map getIncomeInvoiceInfo(List ids) throws BOSException {
        HashMap invInfo = new HashMap();
        try {
            ArrayList<String> invIdList = new ArrayList<String>();
            ArrayList<String> invNumList = new ArrayList<String>();
            ArrayList<String> entriesIdList = new ArrayList<String>();
            ArrayList<BigDecimal> entriesAmtList = new ArrayList<BigDecimal>();
            StringBuffer sql = new StringBuffer();
            sql.append(" Select parent.FID invId, parent.FInvoiceNumber invNum, parent.FReBusiness reBusiness, entry.FID entryId, entry.FTaxTotal entryAmt");
            sql.append(" from T_IM_IncomeInvoice parent ");
            sql.append(" Left Join T_IM_IncomeInvoiceEntry entry on parent.FID = entry.FIncomeInvoiceID ");
            sql.append(" where parent.FID in ").append(IMUtils.getInStringFromList(ids)).append(" ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                invIdList.add(rs.getString("invId"));
                invNumList.add(rs.getString("invNum"));
                entriesIdList.add(rs.getString("entryId"));
                entriesAmtList.add(rs.getBigDecimal("entryAmt"));
            }
            invInfo.put("invIdList", invIdList);
            invInfo.put("invNumList", invNumList);
            invInfo.put("entriesIdList", entriesIdList);
            invInfo.put("entriesAmtList", entriesAmtList);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        return invInfo;
    }

    public void delTSMRecord(List ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_TM_ThreeSideMatchRecordEntry ").append("\n");
        sql.append(" where FBillID in ").append(IMUtils.getInStringFromList(ids));
        this.delSqlList.add(sql.toString());
    }

    public void delInvApRelation(List ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_BOT_Relation where FDESTEntityID = '48DA3A71' ").append("\n");
        sql.append(" and FSRCEntityID = '1343913D' ").append("\n");
        sql.append(" and FSrcObjectID in ").append(IMUtils.getInStringFromList(ids));
        this.delSqlList.add(sql.toString());
    }

    public void delInvRelation(List ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_BOT_Relation where FDESTEntityID = '1343913D' ").append("\n");
        sql.append(" and FSRCEntityID = '1343913D' ").append("\n");
        sql.append(" and FOperatorID = 'exchangeInvoice' ").append("\n");
        sql.append(" and FSrcObjectID in ").append(IMUtils.getInStringFromList(ids));
        this.delSqlList.add(sql.toString());
    }

    public void updateInvoice(List ids, String isDeduct, String bizRelation, String incomeTypeID, Boolean reBusiness) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_IM_IncomeInvoice set FID = FID ");
        if (isDeduct != null) {
            sql.append(" ,FIsDeduct = '").append(isDeduct).append("' ");
        } else {
            sql.append(" ,FIsDeduct = null ");
        }
        if (incomeTypeID != null) {
            sql.append(" ,FIncomeTypeID = '").append(incomeTypeID).append("' ");
        }
        if (reBusiness != null) {
            sql.append(" ,FReBusiness = ").append(reBusiness != false ? 1 : 0).append(" ");
        }
        sql.append(" where FID in ").append(IMUtils.getInStringFromList(ids));
        this.updateSqlList.add(sql.toString());
    }

    public void updateAPOB(String invNumbers, String invCodes, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_AP_OtherBill set FInvoiceCode = '");
        sql.append(invCodes).append("' ,FInvoiceNumber='").append(invNumbers).append("'");
        sql.append(" where FID = '");
        sql.append(id).append("' ");
        this.updateSqlList.add(sql.toString());
    }

    public void addBOTPUpdateList(String srcEntityID, String destEntityID, String srcObjectID, String destObjectID, String operatorID) {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcEntityID(srcEntityID);
        info.setDestEntityID(destEntityID);
        info.setSrcObjectID(srcObjectID);
        info.setDestObjectID(destObjectID);
        info.setOperatorID(operatorID);
        this.botpUpdateList.add(info);
    }

    public void executeSqls() throws BOSException {
        String[] delSql = this.delSqlList.toArray(new String[this.delSqlList.size()]);
        DBUtil.executeBatch((Context)this.ctx, (String[])delSql);
        String[] updateSql = this.updateSqlList.toArray(new String[this.updateSqlList.size()]);
        DBUtil.executeBatch((Context)this.ctx, (String[])updateSql);
        if (!this.botpUpdateList.isEmpty()) {
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = EJBFactory.getConnection((Context)this.ctx);
                StringBuffer sql = new StringBuffer();
                sql.append("INSERT INTO t_bot_relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType)");
                sql.append(" values(?,?,?,?,?,?,1,0)");
                pstmt = conn.prepareStatement(sql.toString());
                int size = this.botpUpdateList.size();
                for (int i = 0; i < size; ++i) {
                    BOTRelationInfo info = this.botpUpdateList.get(i);
                    pstmt.setString(1, BOSUuid.create((String)"59302EC6").toString());
                    pstmt.setString(2, info.getSrcEntityID());
                    pstmt.setString(3, info.getDestEntityID());
                    pstmt.setString(4, info.getSrcObjectID());
                    pstmt.setString(5, info.getDestObjectID());
                    pstmt.setString(6, info.getOperatorID());
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        }
    }
}

