/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.im.ExchInvSqlHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExchInvStrategy {
    private static String INV_ENTITYID = "1343913D";
    private static String APOB_ENTITYID = "48DA3A71";
    private static String EXCH_OPERATORID = "exchangeInvoice";
    private Context ctx;
    private ExchInvSqlHelper sqlHelper;
    private Map result = new HashMap();
    private List<String> srcIdList = new ArrayList<String>();
    private List<String> destIdList = new ArrayList<String>();
    private List<String> obIdList = new ArrayList<String>();
    private String srcCode;
    private String srcNum;
    private String[] destCodes;
    private String[] destNums;
    private Boolean isExchange;

    public ExchInvStrategy(Map params) throws BOSException {
        this.ctx = (Context)params.get("ctx");
        this.isExchange = (Boolean)params.get("isExchange");
        this.srcIdList.add((String)params.get("srcId"));
        this.destIdList = (List)params.get("destIdList");
        this.srcCode = (String)params.get("srcCode");
        this.srcNum = (String)params.get("srcNum");
        this.destCodes = (String[])params.get("destCodes");
        this.destNums = (String[])params.get("destNums");
        this.sqlHelper = new ExchInvSqlHelper(this.ctx);
        this.obIdList = this.isExchange != false ? this.sqlHelper.getAPOBIDs(this.srcIdList) : this.sqlHelper.getAPOBIDs(this.destIdList);
        this.result.put("result", "exchangeInvoiceSuccess");
    }

    public Map doExchange() throws BOSException {
        List<String> newList;
        List<String> oldList;
        if (this.isExchange.booleanValue()) {
            for (int i = 0; i < this.destIdList.size(); ++i) {
                this.sqlHelper.addBOTPUpdateList(INV_ENTITYID, INV_ENTITYID, this.srcIdList.get(0), this.destIdList.get(i), EXCH_OPERATORID);
            }
            oldList = this.srcIdList;
            newList = this.destIdList;
        } else {
            this.sqlHelper.delInvRelation(this.srcIdList);
            oldList = this.destIdList;
            newList = this.srcIdList;
        }
        if (this.obIdList.isEmpty()) {
            this.sqlHelper.executeSqls();
            return this.result;
        }
        this.updateInvApRelation(oldList, newList);
        this.updateInvoice(oldList, newList);
        this.updateAPOB();
        this.updateThreeSideMatchRecord(oldList, newList);
        this.sqlHelper.executeSqls();
        return this.result;
    }

    private void updateInvApRelation(List<String> oldList, List<String> newList) throws BOSException {
        this.sqlHelper.delInvApRelation(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            for (int j = 0; j < this.obIdList.size(); ++j) {
                this.sqlHelper.addBOTPUpdateList(INV_ENTITYID, APOB_ENTITYID, newList.get(i), this.obIdList.get(j), EXCH_OPERATORID);
            }
        }
    }

    private void updateInvoice(List oldList, List newList) throws BOSException {
        this.sqlHelper.updateInvoice(oldList, null, "", "", false);
        String incomeTypeID = this.sqlHelper.getIncomeTypeID(this.obIdList.get(0));
        boolean reBusiness = this.sqlHelper.getReBusiness(this.obIdList.get(0));
        this.sqlHelper.updateInvoice(newList, "1", "", incomeTypeID, reBusiness);
    }

    private void updateThreeSideMatchRecord(List oldList, List newList) throws BOSException {
        Map tsmRecordInfo = this.sqlHelper.getTSMRecordInfo(oldList);
        List stepAmounts = (List)tsmRecordInfo.get("stepAmounts");
        List seqs = (List)tsmRecordInfo.get("seqs");
        String parentId = (String)tsmRecordInfo.get("parentId");
        int maxSeq = (Integer)tsmRecordInfo.get("maxSeq");
        Map invInfo = this.sqlHelper.getIncomeInvoiceInfo(newList);
        List invIdList = (List)invInfo.get("invIdList");
        List invNumList = (List)invInfo.get("invNumList");
        List entriesIdList = (List)invInfo.get("entriesIdList");
        List entriesAmountList = (List)invInfo.get("entriesAmtList");
        BigDecimal[] entriesAmounts = new BigDecimal[entriesAmountList.size()];
        for (int i = 0; i < entriesAmountList.size(); ++i) {
            entriesAmounts[i] = (BigDecimal)entriesAmountList.get(i);
        }
        if (stepAmounts.isEmpty()) {
            return;
        }
        this.sqlHelper.delTSMRecord(oldList);
        Connection con = null;
        PreparedStatement pst = null;
        try {
            int seqIndex = 0;
            con = EJBFactory.getConnection((Context)this.ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO T_TM_ThreeSideMatchRecordEntry(FParentID,FBillID,FBillEntryID,FBillType,FBillTypeAlias,FBillNumber,FMatchedQty,FMatchedAmt,FStepSeq,FSeq,FID)");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
            pst = con.prepareStatement(sql.toString());
            int index = 0;
            block5: for (int i = 0; i < stepAmounts.size(); ++i) {
                String[] stepAmount = (String[])stepAmounts.get(i);
                BigDecimal stepAmt = new BigDecimal(stepAmount[1]);
                while (index < entriesAmountList.size()) {
                    pst.setString(1, parentId);
                    pst.setString(2, (String)invIdList.get(index));
                    pst.setString(3, (String)entriesIdList.get(index));
                    pst.setString(4, INV_ENTITYID);
                    pst.setString(5, IMUtils.getString("com.kingdee.eas.tm.im.match.ThreeSideMatchResource", "Title_IncomeInvoice", this.ctx.getLocale()));
                    pst.setString(6, (String)invNumList.get(index));
                    pst.setInt(7, 0);
                    pst.setInt(9, Integer.parseInt(stepAmount[0].toString()));
                    if (seqIndex < seqs.size()) {
                        pst.setInt(10, (Integer)seqs.get(seqIndex++));
                    } else {
                        pst.setInt(10, ++maxSeq);
                    }
                    pst.setString(11, BOSUuid.create((String)"E0A81961").toString());
                    if (entriesAmounts[index].compareTo(stepAmt) < 0) {
                        pst.setString(8, entriesAmounts[index].toString());
                        pst.addBatch();
                        stepAmt = stepAmt.subtract(entriesAmounts[index]);
                        ++index;
                        continue;
                    }
                    if (entriesAmounts[index].compareTo(stepAmt) == 0) {
                        pst.setString(8, entriesAmounts[index].toString());
                        pst.addBatch();
                        ++index;
                        continue block5;
                    }
                    pst.setString(8, stepAmount[1].toString());
                    pst.addBatch();
                    entriesAmounts[index] = entriesAmounts[index].subtract(stepAmt);
                    continue block5;
                }
            }
            pst.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pst, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pst, (Connection)con);
    }

    private void updateAPOB() throws BOSException {
        IRowSet rs = this.sqlHelper.getAPOBInfos(this.obIdList);
        String invCodes = IMUtils.join(this.destCodes, ';');
        String invNumbers = IMUtils.join(this.destNums, ';');
        try {
            while (rs.next()) {
                Object[] invNum = null;
                Object[] invCode = null;
                if (rs.getString("invNumber") == null) continue;
                invNum = rs.getString("invNumber").split(";");
                invCode = rs.getString("invCode").split(";");
                if (this.isExchange.booleanValue()) {
                    for (int i = 0; i < invNum.length; ++i) {
                        if (!this.srcNum.equals(invNum[i]) || !this.srcCode.equals(invCode[i])) continue;
                        invCode[i] = invCodes;
                        invNum[i] = invNumbers;
                    }
                } else {
                    boolean hasNum = false;
                    block4: for (int i = 0; i < invNum.length; ++i) {
                        for (int j = 0; j < this.destNums.length; ++j) {
                            if (!this.destNums[j].equals(invNum[i]) || !this.destCodes[j].equals(invCode[i])) continue;
                            if (hasNum) {
                                invCode[i] = null;
                                invNum[i] = null;
                                continue block4;
                            }
                            invCode[i] = this.srcCode;
                            invNum[i] = this.srcNum;
                            hasNum = true;
                            continue block4;
                        }
                    }
                }
                this.sqlHelper.updateAPOB(IMUtils.join(invNum, ';'), IMUtils.join(invCode, ';'), rs.getString("id"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

