/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.CheckPurposeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckWayEnum;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.NotDeductibleTypeEnum;
import com.kingdee.eas.tm.im.AuthenticateTypeEnum;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IIncomeInvoiceEntry;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IncomeInvoiceImport
extends IMBillImportBase {
    private static Logger logger = Logger.getLogger((String)IncomeInvoiceImport.class.getName());
    private Map infoMap = new HashMap();
    String curKey = null;
    IncomeInvoiceInfo head = null;
    IncomeInvoiceEntryInfo entry = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IncomeInvoiceFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            logger.error((Object)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        IncomeInvoiceInfo head;
        block10: {
            head = new IncomeInvoiceInfo();
            try {
                String invoiceCode = ((DataToken)hsData.get((Object)"FInvoiceCode")).data.toString();
                if (null == invoiceCode || invoiceCode.length() <= 0) {
                    throw new TaskExternalException(this.getResource(ctx, "InvoiceCodeNotNull"));
                }
                String invoiceNumber = ((DataToken)hsData.get((Object)"FInvoiceNumber")).data.toString();
                if (null == invoiceNumber || invoiceNumber.length() <= 0) {
                    throw new TaskExternalException(this.getResource(ctx, "InvoiceNumberNotNull"));
                }
                this.curKey = invoiceCode.concat(invoiceNumber);
                Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
                int mode = datataskMode;
                if (this.infoMap.containsKey(this.curKey)) {
                    head = (IncomeInvoiceInfo)this.infoMap.get(this.curKey);
                } else {
                    head = this.getHeadInfo(ctx, mode, invoiceCode, invoiceNumber);
                    head = this.parseHead(hsData, ctx, head);
                    head.setResourceType(InvResourceType.INV_IMPORT);
                    this.infoMap.put(this.curKey, head);
                }
                String FEntrySeq = ((DataToken)hsData.get((Object)"FEntries_seq")).data.toString();
                this.entry = this.getEntryInfo(ctx, mode, head, FEntrySeq);
                this.entry = this.parseEntry(hsData, ctx, this.entry);
                IncomeInvoiceEntryCollection coll = head.getEntries();
                int collSize = coll.size();
                if (coll.size() > 0) {
                    for (int i = 0; i < collSize; ++i) {
                        IncomeInvoiceEntryInfo entryInfo = coll.get(i);
                        if (entryInfo.getSeq() == this.entry.getSeq()) {
                            coll.set(i, this.entry);
                        } else {
                            if (this.entry.getSeq() <= collSize) continue;
                            coll.add(this.entry);
                        }
                        break block10;
                    }
                    break block10;
                }
                coll.add(this.entry);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return head;
    }

    private IncomeInvoiceInfo getHeadInfo(Context ctx, int mode, String invoiceCode, String invoiceNumber) throws TaskExternalException {
        IncomeInvoiceInfo invoiceInfo = new IncomeInvoiceInfo();
        invoiceInfo.setIsInTax(true);
        try {
            if (mode == 16 || mode == 128) {
                if (invoiceNumber == null) {
                    return invoiceInfo;
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("checkAbs.*"));
                sic.add(new SelectorItemInfo("nonCompliantInvoice.*"));
                sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.*"));
                sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.nonCompliantType.*"));
                sic.add(new SelectorItemInfo("entries.*"));
                view.setSelector(sic);
                IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
                if (coll != null && coll.size() > 0) {
                    invoiceInfo = coll.get(0);
                    if (IncomeStatusEnum.RETURN.equals((Object)invoiceInfo.getStatus())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasReturnORExchange"));
                    }
                    if (!InvResourceType.INV_IMPORT.equals((Object)invoiceInfo.getResourceType())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceSrcOnlyExcel"));
                    }
                    if (AuthenticateTypeEnum.ONLINE.equals((Object)invoiceInfo.getAuthenticateType())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasAuthenticate"));
                    }
                    if (invoiceInfo.getCheckAbs() != null && CheckTypeEnum.ONLINE.equals((Object)invoiceInfo.getCheckAbs().getCheckType())) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasAuthenticate"));
                    }
                    if (invoiceInfo.isIsAccept()) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasAccept"));
                    }
                    if (invoiceInfo.isIsReceive()) {
                        throw new TaskExternalException(this.getResource(ctx, "InvoiceHasReceive"));
                    }
                    return invoiceInfo;
                }
                return invoiceInfo;
            }
            if (mode == 8) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
                view.setFilter(filter);
                IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
                if (coll.size() > 0) {
                    throw new TaskExternalException(this.getResource(ctx, "InvoiceHasExists"));
                }
                return invoiceInfo;
            }
            return invoiceInfo;
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IncomeInvoiceInfo parseHead(Hashtable hsData, Context ctx, IncomeInvoiceInfo head) throws TaskExternalException {
        String checkTime;
        String isIssue;
        String FSupplierNumber;
        SupplierInfo supplierInfo;
        String invoiceCode = ((DataToken)hsData.get((Object)"FInvoiceCode")).data.toString();
        if (null == invoiceCode || invoiceCode.length() <= 0) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceCodeNotNull"));
        }
        head.setInvoiceCode(invoiceCode);
        String invoiceNumber = ((DataToken)hsData.get((Object)"FInvoiceNumber")).data.toString();
        if (null == invoiceNumber || invoiceNumber.length() <= 0) {
            throw new TaskExternalException(this.getResource(ctx, "InvoiceNumberNotNull"));
        }
        head.setInvoiceNumber(invoiceNumber);
        head.setNumber(head.getInvoiceCode() + "_" + head.getInvoiceNumber());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)"FBizDate")).data;
        if (o == null || o.toString().length() <= 0) throw new TaskExternalException(this.getResource(ctx, "BizDateNotNull"));
        try {
            o = df.parse(o.toString());
            Date value = (Date)o;
            if (value != null) {
                head.setBizDate(value);
            }
        }
        catch (ParseException pex) {
            logger.error((Object)pex);
            throw new TaskExternalException(this.getResource(ctx, "DateFormatError"));
        }
        boolean isValueAddedTaxinv = false;
        String invoiceType = ((DataToken)hsData.get((Object)"FInvoiceType")).data.toString();
        String electInv = IMUtils.getResource("com.kingdee.eas.tm.im.app.IMImportResource", "ELECTRONICINVOICE", ctx);
        PayInvoiceTypeEnum payInvoiceTypeEnum = null;
        if (invoiceType.equals(PayInvoiceTypeEnum.COMMONINVOICE.getAlias())) {
            payInvoiceTypeEnum = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if (invoiceType.equals(PayInvoiceTypeEnum.VALUEADDEDTAXINV.getAlias())) {
            payInvoiceTypeEnum = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
            isValueAddedTaxinv = true;
        } else if (invoiceType.equals(PayInvoiceTypeEnum.ELECTRONICINVOICE.getAlias()) || invoiceType.equals(electInv)) {
            payInvoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if (invoiceType.equals(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.getAlias())) {
            payInvoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
            isValueAddedTaxinv = true;
        } else {
            try {
                List enumList = PayInvoiceTypeEnum.getEnumList();
                for (int i = 0; i < enumList.size(); ++i) {
                    PayInvoiceTypeEnum enumValue = (PayInvoiceTypeEnum)enumList.get(i);
                    if (!enumValue.getValue().equals(invoiceType) || enumValue.equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE) || enumValue.equals((Object)PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE)) continue;
                    payInvoiceTypeEnum = enumValue;
                    break;
                }
                if (payInvoiceTypeEnum == null || payInvoiceTypeEnum == PayInvoiceTypeEnum.DEFAULTTYPE) {
                    throw new IMException(IMException.INVOICETYPEERROR);
                }
                if (payInvoiceTypeEnum == PayInvoiceTypeEnum.VALUEADDEDTAXINV || payInvoiceTypeEnum == PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE) {
                    isValueAddedTaxinv = true;
                }
            }
            catch (IMException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        head.setInvoiceType(payInvoiceTypeEnum);
        String billingCompany = ((DataToken)hsData.get((Object)"FBillingCompany")).data.toString();
        if (billingCompany == null || billingCompany.length() <= 0) {
            throw new TaskExternalException(this.getResource(ctx, "BillingCompanyNotNull"));
        }
        head.setBillingCompany(billingCompany);
        String taxNumber = ((DataToken)hsData.get((Object)"FTaxNumber")).data.toString();
        if (null != taxNumber && taxNumber.length() > 0) {
            head.setTaxNumber(taxNumber);
        } else {
            head.setTaxNumber(null);
            if (isValueAddedTaxinv) {
                throw new TaskExternalException(this.getResource(ctx, "TaxNumberNotNull"));
            }
        }
        String buyerTaxNo = ((DataToken)hsData.get((Object)"FBuyerTaxNo")).data.toString();
        if (null != buyerTaxNo && buyerTaxNo.length() > 0) {
            head.setBuyerTaxNo(buyerTaxNo);
        } else {
            head.setBuyerTaxNo(null);
            if (isValueAddedTaxinv) {
                throw new TaskExternalException(this.getResource(ctx, "BuyerTaxNoNotNull"));
            }
        }
        String currentAccountType = ((DataToken)hsData.get((Object)"FCurrentAccountType")).data.toString();
        if (null != currentAccountType && currentAccountType.length() > 0) {
            if (!currentAccountType.equals(CurrentAccountType.SUPPLIER.getAlias()) && !currentAccountType.equals("2")) throw new TaskExternalException(new IMException(IMException.ACCOUNTTYPEERROR).getMessage());
            head.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        } else {
            head.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        String currentAccountNumber = ((DataToken)hsData.get((Object)"FCurrAcctSupplier_number")).data.toString();
        if (currentAccountNumber != null && !currentAccountNumber.equals("") && (supplierInfo = this.getSupplier(ctx, FSupplierNumber = ((DataToken)hsData.get((Object)"FCurrAcctSupplier_number")).data.toString())) != null) {
            head.setCurrAcctSupplier(supplierInfo);
        }
        String FProjectNumber = ((DataToken)hsData.get((Object)"FProject_number")).data.toString();
        ProjectInfo project = this.getProject(ctx, FProjectNumber);
        head.setProject(project);
        String useing = ((DataToken)hsData.get((Object)"FUseing")).data.toString();
        head.setUseing(useing);
        String amount = ((DataToken)hsData.get((Object)"FAmount")).data.toString();
        head.setAmount(this.getBigDecimalValue(ctx, "FAmount", amount));
        String tax = ((DataToken)hsData.get((Object)"FTax")).data.toString();
        head.setTax(this.getBigDecimalValue(ctx, "FTax", tax));
        String amountTax = ((DataToken)hsData.get((Object)"FAmountTax")).data.toString();
        head.setAmountTax(this.getBigDecimalValue(ctx, "FAmountTax", amountTax));
        String status = ((DataToken)hsData.get((Object)"FStatus")).data.toString();
        if (null != status && status.length() > 0) {
            IncomeStatusEnum incomeStatus = null;
            if (status.equals(IncomeStatusEnum.NORMAL.getAlias())) {
                incomeStatus = IncomeStatusEnum.NORMAL;
            } else if (status.equals(IncomeStatusEnum.CANCEL.getAlias())) {
                incomeStatus = IncomeStatusEnum.CANCEL;
            } else if (status.equals(IncomeStatusEnum.UNUSUAL.getAlias())) {
                incomeStatus = IncomeStatusEnum.UNUSUAL;
            } else if (status.equals(IncomeStatusEnum.LOSECONTROL.getAlias())) {
                incomeStatus = IncomeStatusEnum.LOSECONTROL;
            } else if (status.equals(IncomeStatusEnum.CREDIT.getAlias())) {
                incomeStatus = IncomeStatusEnum.CREDIT;
            } else if (status.equals(IncomeStatusEnum.RETURN.getAlias())) {
                incomeStatus = IncomeStatusEnum.RETURN;
            } else if (status.equals(IncomeStatusEnum.UNNORMAL.getAlias())) {
                incomeStatus = IncomeStatusEnum.UNNORMAL;
            } else if (status.equals(IncomeStatusEnum.UNCONFIRMRED.getAlias())) {
                incomeStatus = IncomeStatusEnum.UNCONFIRMRED;
            } else if (status.equals(IncomeStatusEnum.PARTLYRED.getAlias())) {
                incomeStatus = IncomeStatusEnum.PARTLYRED;
            } else if (status.equals(IncomeStatusEnum.FULLRED.getAlias())) {
                incomeStatus = IncomeStatusEnum.FULLRED;
            } else {
                incomeStatus = IncomeStatusEnum.getEnum(status);
                if (incomeStatus == null) {
                    throw new TaskExternalException(this.getResource(ctx, "StatusTip"));
                }
            }
            head.setStatus(incomeStatus);
        }
        if (null != (isIssue = ((DataToken)hsData.get((Object)"FIsIssue")).data.toString())) {
            if (isIssue.equals(this.getResource(ctx, "TRUE")) || isIssue.equals("1")) {
                head.setIsIssue(true);
            } else if (isIssue.equals(this.getResource(ctx, "FALSE")) || isIssue.equals("0")) {
                head.setIsIssue(false);
            }
        }
        String FCompanyNumber = ((DataToken)hsData.get((Object)"FCompany_number")).data.toString();
        CompanyOrgUnitInfo company = this.getCompany(ctx, FCompanyNumber);
        head.setCompany(company);
        CheckAbsInfo checkAbs = head.getCheckAbs();
        if (checkAbs == null) {
            checkAbs = CheckAbsUtil.createCheckAbs(head);
            head.setCheckAbs(checkAbs);
        }
        checkAbs.setEffectiveTaxAmt(head.getTax());
        String checkState = ((DataToken)hsData.get((Object)"FCheckAbs_checkState")).data.toString();
        CheckStateEnum checkStateEnum = (CheckStateEnum)IMUtils.getEnumByValueOrAlias(CheckStateEnum.getEnumList(), checkState);
        checkAbs.setCheckState(checkStateEnum == null ? CheckStateEnum.Unchecked : checkStateEnum);
        if (CheckStateEnum.Checked.equals((Object)checkAbs.getCheckState()) && checkAbs.getCheckType() == null) {
            checkAbs.setCheckType(CheckTypeEnum.OFFLINE);
        }
        if (!(checkTime = ((DataToken)hsData.get((Object)"FCheckAbs_checkTime")).data.toString()).isEmpty()) {
            Date checkDate = this.getDate(checkTime);
            if (checkDate == null) {
                throw new TaskExternalException(this.getResource(ctx, "checkTimeFormat"));
            }
            checkAbs.setCheckTime(checkDate);
        }
        checkAbs.setCheckUser(this.getUserFromNumber(ctx, ((DataToken)hsData.get((Object)"FCheckAbs$checkUser_number")).data.toString()));
        String checkPurpose = ((DataToken)hsData.get((Object)"FCheckAbs_checkPurpose")).data.toString();
        checkAbs.setCheckPurpose((CheckPurposeEnum)IMUtils.getEnumByValueOrAlias(CheckPurposeEnum.getEnumList(), checkPurpose));
        String notDeductibleType = this.getString(hsData, "FCheckAbs_notDeductibleType");
        checkAbs.setNotDeductibleType((NotDeductibleTypeEnum)IMUtils.getEnumByValueOrAlias(NotDeductibleTypeEnum.getEnumList(), notDeductibleType));
        if (CheckPurposeEnum.NonDeduct.equals((Object)checkAbs.getCheckPurpose()) && checkAbs.getNotDeductibleType() == null) {
            throw new TaskExternalException(this.getResource(ctx, "SetNotDeductibleTypeError"));
        }
        String checkWay = ((DataToken)hsData.get((Object)"FCheckAbs_checkWay")).data.toString();
        checkAbs.setCheckWay((CheckWayEnum)IMUtils.getEnumByValueOrAlias(CheckWayEnum.getEnumList(), checkWay));
        String confirmState = ((DataToken)hsData.get((Object)"FCheckAbs_confirmState")).data.toString();
        ConfirmStateEnum confirmStateEnum = (ConfirmStateEnum)IMUtils.getEnumByValueOrAlias(ConfirmStateEnum.getEnumList(), confirmState);
        checkAbs.setConfirmState(confirmStateEnum == null ? ConfirmStateEnum.UnConfirm : confirmStateEnum);
        String confirmTime = ((DataToken)hsData.get((Object)"FCheckAbs_confirmTime")).data.toString();
        if (!confirmTime.isEmpty()) {
            Date confirmDate = this.getDate(confirmTime);
            if (confirmDate == null) {
                throw new TaskExternalException(this.getResource(ctx, "confirmTimeFormat"));
            }
            checkAbs.setConfirmTime(confirmDate);
        }
        String confirmUserNumber = ((DataToken)hsData.get((Object)"FCheckAbs$confirmUser_number")).data.toString();
        checkAbs.setConfirmUser(this.getUserFromNumber(ctx, confirmUserNumber));
        String taxPeriodNumber = ((DataToken)hsData.get((Object)"FCheckAbs$taxPeriod_number")).data.toString();
        if (null != taxPeriodNumber && taxPeriodNumber.length() > 0) {
            if (taxPeriodNumber.length() != 6) {
                throw new TaskExternalException(this.getResource(ctx, "SetPeriodFormatError"));
            }
            try {
                int year = Integer.parseInt(taxPeriodNumber.substring(0, 4));
                int number = Integer.parseInt(taxPeriodNumber.substring(4, 6));
                PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)year, (int)number, (CompanyOrgUnitInfo)company);
                if (periodInfo == null || periodInfo.getId() == null) {
                    throw new TaskExternalException(this.getResource(ctx, "PeriodNotExists"));
                }
                checkAbs.setTaxPeriod(periodInfo);
            }
            catch (Exception e) {
                throw new TaskExternalException(this.getResource(ctx, "SetPeriodFormatError"));
            }
        }
        head.setDescription(((DataToken)hsData.get((Object)"FDescription")).data.toString());
        head.setContact(((DataToken)hsData.get((Object)"FContact")).data.toString());
        head.setBankInformation(((DataToken)hsData.get((Object)"FBankInformation")).data.toString());
        return head;
    }

    private IncomeInvoiceEntryInfo getEntryInfo(Context ctx, int mode, IncomeInvoiceInfo head, String FSeq) throws TaskExternalException {
        IncomeInvoiceEntryInfo info = new IncomeInvoiceEntryInfo();
        if (mode == 16 || mode == 128) {
            String headId;
            String string = headId = head.getId() == null ? null : head.getId().toString();
            if (headId == null || StringUtils.isEmpty((String)FSeq)) {
                return info;
            }
            try {
                IIncomeInvoiceEntry iIncomeInvoiceEntry = IncomeInvoiceEntryFactory.getLocalInstance(ctx);
                IncomeInvoiceEntryCollection coll = iIncomeInvoiceEntry.getIncomeInvoiceEntryCollection("where incomeInvoice.id = '" + headId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                info.setSeq(Integer.valueOf(FSeq));
                return info;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            info.setSeq(head.getEntries().size() + 1);
            return info;
        }
        return new IncomeInvoiceEntryInfo();
    }

    private IncomeInvoiceEntryInfo parseEntry(Hashtable hsData, Context ctx, IncomeInvoiceEntryInfo entry) throws TaskExternalException, BOSException {
        String taxClassNumber;
        BigDecimal decimalRate;
        String productName = ((DataToken)hsData.get((Object)"FEntries_productName")).data.toString();
        if (productName != null && productName.length() > 0) {
            entry.setProductName(productName);
        }
        entry.setSpecs(((DataToken)hsData.get((Object)"FEntries_specs")).data.toString());
        entry.setUnitName(((DataToken)hsData.get((Object)"FEntries_unitName")).data.toString());
        String quantity = ((DataToken)hsData.get((Object)"FEntries_quantity")).data.toString();
        entry.setQuantity(this.getBigDecimalValue(ctx, "FEntries_quantity", quantity));
        String price = ((DataToken)hsData.get((Object)"FEntries_price")).data.toString();
        entry.setTaxExcluded(this.getBigDecimalValue(ctx, "FEntries_price", price));
        String taxRate = ((DataToken)hsData.get((Object)"FEntries_taxRate")).data.toString();
        if (taxRate != null && taxRate.length() > 0 && (decimalRate = this.getBigDecimalValue(ctx, "FEntries_taxRate", taxRate)) != null) {
            int compareTo = decimalRate.compareTo(BigDecimal.ONE);
            if (compareTo > 0) {
                entry.setTaxRate(this.getBigDecimalValue(ctx, "FEntries_taxRate", decimalRate.divide(new BigDecimal(100)) + ""));
            } else {
                entry.setTaxRate(decimalRate);
            }
        }
        entry.setTaxAmt(this.getBigDecimalValue(ctx, "FEntries_taxAmt", ((DataToken)hsData.get((Object)"FEntries_taxAmt")).data.toString()));
        entry.setMoney(this.getBigDecimalValue(ctx, "FEntries_money", ((DataToken)hsData.get((Object)"FEntries_money")).data.toString()));
        entry.setTaxTotal(this.getBigDecimalValue(ctx, "FEntries_taxPrice", ((DataToken)hsData.get((Object)"FEntries_taxPrice")).data.toString()));
        if (hsData.get("FEntries_taxClassificationNumber") != null && null != (taxClassNumber = ((DataToken)hsData.get((Object)"FEntries_taxClassificationNumber")).data.toString()) && taxClassNumber.length() > 0) {
            entry.setTaxClassificationNumber(taxClassNumber);
            EntityViewInfo taxClassView = new EntityViewInfo();
            FilterInfo taxClassFilter = new FilterInfo();
            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entry.getTaxClassificationNumber(), CompareType.EQUALS));
            taxClassView.setFilter(taxClassFilter);
            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
            if (taxClassColl != null && taxClassColl.size() > 0) {
                TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                entry.setTaxClassificationCode(taxClassInfo);
            }
        }
        return entry;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FBizDate", (Object)rs.getString("bizDate"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceCode", (Object)rs.getString("invoiceCode"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceNumber", (Object)rs.getString("invoiceNumber"));
            DataImportTools.putToHashtable(result, (Object)"FInvoiceType", (Object)PayInvoiceTypeEnum.getEnum((String)rs.getString("invoiceType")));
            DataImportTools.putToHashtable(result, (Object)"FBillingCompany", (Object)rs.getString("billingCompany"));
            DataImportTools.putToHashtable(result, (Object)"FTaxNumber", (Object)rs.getString("taxNumber"));
            DataImportTools.putToHashtable(result, (Object)"FUseing", (Object)rs.getString("useing"));
            CurrentAccountType currentAccountType = CurrentAccountType.getEnum(rs.getString("currentAccountType"));
            DataImportTools.putToHashtable(result, (Object)"FCurrentAccountType", (Object)((Object)currentAccountType));
            if (CurrentAccountType.CUSTOMER.equals((Object)currentAccountType)) {
                DataImportTools.putToHashtable(result, (Object)"FCurrAcctSupplier_number", (Object)rs.getString("currAcctSupplier.number"));
            } else if (CurrentAccountType.SUPPLIER.equals((Object)currentAccountType)) {
                DataImportTools.putToHashtable(result, (Object)"FCurrAcctSupplier_number", (Object)rs.getString("currAcctSupplier.number"));
            } else if (CurrentAccountType.COMPANY.equals((Object)currentAccountType)) {
                DataImportTools.putToHashtable(result, (Object)"FCurrAcctSupplier_number", (Object)rs.getString("currAcctSupplier.number"));
            }
            DataImportTools.putToHashtable(result, (Object)"FProject_number", (Object)rs.getString("project.number"));
            DataImportTools.putToHashtable(result, (Object)"FAmount", (Object)rs.getString("amount"));
            DataImportTools.putToHashtable(result, (Object)"FTax", (Object)rs.getString("tax"));
            DataImportTools.putToHashtable(result, (Object)"FAmountTax", (Object)rs.getString("amountTax"));
            DataImportTools.putToHashtable(result, (Object)"FStatus", (Object)((Object)IncomeStatusEnum.getEnum(rs.getString("status"))));
            DataImportTools.putToHashtable(result, (Object)"FIsIssue", (Object)(rs.getBoolean("isIssue") ? this.getResource(ctx, "TRUE") : this.getResource(ctx, "FALSE")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkState", (Object)CheckStateEnum.getEnum((String)rs.getString("checkAbs.checkState")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkTime", (Object)rs.getString("checkAbs.checkTime"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$checkUser_number", (Object)rs.getString("checkUser.number"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkPurpose", (Object)CheckPurposeEnum.getEnum((String)rs.getString("checkAbs.checkPurpose")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_notDeductibleType", (Object)NotDeductibleTypeEnum.getEnum((String)rs.getString("checkAbs.notDeductibleType")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_checkWay", (Object)CheckWayEnum.getEnum((String)rs.getString("checkAbs.checkWay")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$taxPeriod_number", (Object)rs.getString("taxPeriod.number"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_confirmState", (Object)ConfirmStateEnum.getEnum((String)rs.getString("checkAbs.confirmState")));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs_confirmTime", (Object)rs.getString("checkAbs.confirmTime"));
            DataImportTools.putToHashtable(result, (Object)"FCheckAbs$confirmUser_number", (Object)rs.getString("confirmUser.number"));
            DataImportTools.putToHashtable(result, (Object)"FCompany_number", (Object)rs.getString("company.number"));
            DataImportTools.putToHashtable(result, (Object)"FDescription", (Object)rs.getString("description"));
            DataImportTools.putToHashtable(result, (Object)"FBuyerTaxNo", (Object)rs.getString("buyerTaxNo"));
            DataImportTools.putToHashtable(result, (Object)"FContact", (Object)rs.getString("contact"));
            DataImportTools.putToHashtable(result, (Object)"FBankInformation", (Object)rs.getString("bankInformation"));
            DataImportTools.putToHashtable(result, (Object)"FPassword", (Object)rs.getString("password"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_productName", (Object)rs.getString("entries.productName"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_specs", (Object)rs.getString("entries.specs"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_unitName", (Object)rs.getString("entries.unitName"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_quantity", (Object)rs.getString("entries.quantity"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_price", (Object)rs.getString("entries.taxExcluded"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_taxRate", (Object)rs.getString("entries.taxRate"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_taxPrice", (Object)rs.getString("entries.taxTotal"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_seq", (Object)rs.getString("entries.seq"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_taxAmt", (Object)rs.getString("entries.taxAmt"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_money", (Object)rs.getString("entries.money"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_taxClassificationNumber", (Object)rs.getString("entries.taxClassificationNumber"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.IncomeInvoiceImportQuery";
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iIncomeInvoice = this.getController(ctx);
        IncomeInvoiceInfo invoice = (IncomeInvoiceInfo)coreBaseInfo;
        if (coreBaseInfo == null) {
            return;
        }
        this.recalculate(ctx, invoice);
        try {
            if (coreBaseInfo.getId() == null || !iIncomeInvoice.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iIncomeInvoice.addnew(coreBaseInfo);
            } else {
                iIncomeInvoice.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    private void recalculate(Context ctx, IncomeInvoiceInfo incomeInvoice) throws TaskExternalException {
        int pricePrecision;
        IncomeInvoiceEntryCollection entries = incomeInvoice.getEntries();
        int size = entries.size();
        if (size == 0) {
            return;
        }
        CompanyOrgUnitInfo company = incomeInvoice.getCompany();
        if (company == null) {
            return;
        }
        try {
            pricePrecision = IMUtils.getDecimalParam(ctx, company.getId().toString(), new String[]{"VATM001"}).intValue();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        for (int idx = 0; idx < size; ++idx) {
            IncomeInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal quantity = entry.getQuantity();
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal noTaxPrice = entry.getTaxExcluded();
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal noTaxAmt = entry.getMoney();
            BigDecimal taxAmt = entry.getTaxAmt();
            BigDecimal priceTax = entry.getTaxTotal();
            if (noTaxAmt == null && taxAmt == null && priceTax == null) {
                throw new TaskExternalException(IMUtils.getIMResource(ctx, "IMPORT_CHECK", new String[0]));
            }
            if (taxRate == null || taxRate.compareTo(BigDecimal.ZERO) == 0) continue;
            if (quantity != null && quantity.compareTo(BigDecimal.ZERO) != 0) {
                if (taxPrice == null && noTaxPrice != null) {
                    taxPrice = noTaxPrice.multiply(new BigDecimal(1).add(taxRate)).setScale(pricePrecision, 6);
                    entry.setTaxPrice(taxPrice);
                }
                if (taxPrice != null && noTaxPrice == null) {
                    noTaxPrice = taxPrice.divide(new BigDecimal(1).add(taxRate), pricePrecision, 6);
                    entry.setTaxExcluded(noTaxPrice);
                }
                if (noTaxPrice != null && noTaxAmt == null) {
                    noTaxAmt = noTaxPrice.multiply(quantity).setScale(2, 6);
                    entry.setMoney(noTaxAmt);
                }
            }
            if (noTaxAmt == null && priceTax != null) {
                noTaxAmt = priceTax.divide(new BigDecimal(1).add(taxRate), 2, 6);
                entry.setMoney(noTaxAmt);
            }
            if (taxAmt == null && noTaxAmt != null) {
                taxAmt = noTaxAmt.multiply(taxRate).setScale(2, 6);
                entry.setTaxAmt(taxAmt);
            }
            if (noTaxAmt == null || priceTax != null) continue;
            priceTax = noTaxAmt.multiply(new BigDecimal(1).add(taxRate)).setScale(2, 6);
            entry.setTaxTotal(priceTax);
        }
        BigDecimal noTaxAmtTotal = BigDecimal.ZERO;
        BigDecimal taxAmtTotal = BigDecimal.ZERO;
        BigDecimal priceTaxAmtTotal = BigDecimal.ZERO;
        for (int idx = 0; idx < entries.size(); ++idx) {
            IncomeInvoiceEntryInfo entry = entries.get(idx);
            BigDecimal noTaxAmt = entry.getMoney();
            BigDecimal taxAmt = entry.getTaxAmt();
            BigDecimal priceTax = entry.getTaxTotal();
            noTaxAmtTotal = noTaxAmtTotal.add(noTaxAmt != null ? noTaxAmt : BigDecimal.ZERO);
            taxAmtTotal = taxAmtTotal.add(taxAmt != null ? taxAmt : BigDecimal.ZERO);
            priceTaxAmtTotal = priceTaxAmtTotal.add(priceTax != null ? priceTax : BigDecimal.ZERO);
        }
        incomeInvoice.setAmount(noTaxAmtTotal);
        incomeInvoice.setTax(taxAmtTotal);
        incomeInvoice.setAmountTax(priceTaxAmtTotal);
    }

    private ProjectInfo getProject(Context ctx, String projectNumber) throws TaskExternalException {
        ProjectInfo project = null;
        String sql = "select top 1 fid,FNAME_l2  from T_BD_PROJECT  where FNUMBER = ?";
        if (projectNumber != null && projectNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{projectNumber});
                if (rs != null && rs.next()) {
                    project = new ProjectInfo();
                    project.setId(BOSUuid.read((String)rs.getString("fid")));
                    project.setNumber(projectNumber);
                    project.setName(rs.getString("fname_l2"));
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return project;
    }

    private SupplierInfo getSupplier(Context ctx, String supplierNumber) throws TaskExternalException {
        SupplierInfo supplierInfo = null;
        String sql = "select top 1 fid,fnumber,fname_l2 from t_bd_supplier where fnumber = ?";
        if (supplierNumber != null && supplierNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{supplierNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(this.getResource(ctx, "CustomerNotSuitable"));
                }
                supplierInfo = new SupplierInfo();
                supplierInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                supplierInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (UuidException e) {
                logger.error((Object)e);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        return supplierInfo;
    }

    private BigDecimal getBigDecimalValue(Context ctx, String colName, String strNum) throws TaskExternalException {
        try {
            if (strNum != null && strNum.length() > 0) {
                return new BigDecimal(strNum);
            }
            return null;
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getResource(ctx, "ColumnFormatError", new Object[]{colName}));
        }
    }

    private CompanyOrgUnitInfo getCompany(Context ctx, String companyNumber) throws TaskExternalException {
        CompanyOrgUnitInfo company = null;
        if (companyNumber != null && companyNumber.length() > 0) {
            String sql = "select top 1 fid,FAccountPeriodID,fnumber,fname_l2,fisbizunit from T_ORG_COMPANY where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyNumber});
                if (rs.next() && rs.getString("fisbizunit").equals("1")) {
                    company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("fid")));
                    company.setNumber(rs.getString("fnumber"));
                    company.setName(rs.getString("fname_l2"));
                    PeriodTypeInfo pt = new PeriodTypeInfo();
                    pt.setId(BOSUuid.read((String)rs.getString("FAccountPeriodID")));
                    company.setAccountPeriodType(pt);
                }
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if (company == null) {
            throw new TaskExternalException(this.getResource(ctx, "CompanyNotExists"));
        }
        return company;
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws TaskExternalException {
        UserInfo personInfo = null;
        if (number != null && number.trim().length() > 0) {
            try {
                UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where number='" + number + "'");
                if (users != null && users.size() > 0) {
                    personInfo = users.get(0);
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return personInfo;
    }

    private Date getDate(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return format.parse(time);
        }
        catch (ParseException pex) {
            return null;
        }
    }

    private String getResource(Context ctx, String resName, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)resName, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)resName, (Locale)ctx.getLocale());
    }

    private String getLogResource(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }

    private String getLogResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.LogResource", (String)key, (Locale)ctx.getLocale());
    }

    private String getBillBosType() {
        return "1343913D";
    }
}

