/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.basedata.IIncomeType;
import com.kingdee.eas.tm.im.basedata.IIncomeTypeEntry;
import com.kingdee.eas.tm.im.basedata.IncomeTypeCollection;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryCollection;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryFactory;
import com.kingdee.eas.tm.im.basedata.IncomeTypeEntryInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeFactory;
import com.kingdee.eas.tm.im.basedata.IncomeTypeInfo;
import com.kingdee.eas.tm.im.basedata.IncomeTypeStatusEnum;
import com.kingdee.eas.tm.im.basedata.TypeEnum;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class IncomeTypeImport
extends IMBillImportBase {
    Map<String, IncomeTypeInfo> map = new HashMap<String, IncomeTypeInfo>();
    String curKey = null;
    IncomeTypeInfo head = null;
    IncomeTypeEntryInfo entry = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return IncomeTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            Logger.error((Throwable)bex);
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase iIncomeType = this.getController(ctx);
        if (coreBaseInfo == null) {
            return;
        }
        try {
            if (coreBaseInfo.getId() == null || !iIncomeType.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iIncomeType.addnew(coreBaseInfo);
            } else {
                iIncomeType.submit(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        block11: {
            try {
                String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
                if (null == number || number.length() <= 0) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.app.IMImportResource", "NUMBER_IS_ISNULL", ctx.getLocale()));
                }
                String name = ((DataToken)hsData.get((Object)"FName")).data.toString();
                if (null == name || name.length() <= 0) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "NAME_NOT_NULL", ctx.getLocale()));
                }
                this.curKey = number;
                Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
                int mode = datataskMode;
                if (this.map.containsKey(this.curKey)) {
                    this.head = this.map.get(this.curKey);
                } else {
                    this.head = this.getHeadInfo(ctx, mode, number);
                    this.map.put(this.curKey, this.head);
                }
                this.head = this.parseHead(mode, hsData, ctx, this.head);
                String FEntrySeq = ((DataToken)hsData.get((Object)"FEntries_seq")).data.toString();
                this.entry = this.getEntryInfoAndparseEntry(hsData, mode, ctx, this.head, FEntrySeq);
                if (this.entry.getTypeId() == null) {
                    this.head.getEntries().remove(this.entry);
                }
                IncomeTypeEntryCollection coll = this.head.getEntries();
                int collSize = coll.size();
                if (coll != null && coll.size() > 0) {
                    for (int i = 0; i < collSize; ++i) {
                        IncomeTypeEntryInfo entryInfo = coll.get(i);
                        if (entryInfo.getSeq() == this.entry.getSeq()) {
                            coll.set(i, this.entry);
                        } else {
                            if (this.entry.getSeq() <= collSize) continue;
                            coll.add(this.entry);
                        }
                        break block11;
                    }
                    break block11;
                }
                coll.add(this.entry);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return this.head;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FName", (Object)rs.getString("name"));
            DataImportTools.putToHashtable(result, (Object)"FStatus", (Object)((Object)IncomeTypeStatusEnum.getEnum(rs.getString("status"))));
            DataImportTools.putToHashtable(result, (Object)"FType", (Object)((Object)TypeEnum.getEnum(rs.getString("type"))));
            DataImportTools.putToHashtable(result, (Object)"FCU_number", (Object)rs.getString("CU.number"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_seq", (Object)rs.getString("entries.seq"));
            DataImportTools.putToHashtable(result, (Object)"FRowType.number", (Object)rs.getString("rowType.number"));
            DataImportTools.putToHashtable(result, (Object)"FRowType.name", (Object)rs.getString("rowType.name"));
            DataImportTools.putToHashtable(result, (Object)"FExpenseType.number", (Object)rs.getString("expenseType.number"));
            DataImportTools.putToHashtable(result, (Object)"FExpenseType.name", (Object)rs.getString("expenseType.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.basedata.IncomeTypeQuery";
    }

    private IncomeTypeInfo getHeadInfo(Context ctx, int mode, String number) throws BOSException, EASBizException, TaskExternalException {
        IncomeTypeInfo incomeTypeInfo = new IncomeTypeInfo();
        incomeTypeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        incomeTypeInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        Date date = new Date();
        incomeTypeInfo.setCreateTime(new Timestamp(date.getTime()));
        if (mode == 16 || mode == 128) {
            if (number == null) {
                return incomeTypeInfo;
            }
            try {
                IncomeTypeCollection coll = IncomeTypeFactory.getLocalInstance(ctx).getIncomeTypeCollection("where number ='" + number + "'");
                if (coll != null && coll.size() > 0) {
                    incomeTypeInfo = coll.get(0);
                    if (incomeTypeInfo.getStatus().equals((Object)IncomeTypeStatusEnum.Active)) {
                        throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "ActiveNotAllowImport", ctx.getLocale(), new Object[]{incomeTypeInfo.getNumber()}));
                    }
                    return incomeTypeInfo;
                }
                return incomeTypeInfo;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            view.setFilter(filter);
            IncomeTypeCollection coll = IncomeTypeFactory.getLocalInstance(ctx).getIncomeTypeCollection(view);
            if (coll.size() > 0) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "IncomeTypeHasExists", ctx.getLocale(), new String[]{number}));
            }
            return incomeTypeInfo;
        }
        return incomeTypeInfo;
    }

    private IncomeTypeInfo parseHead(int mode, Hashtable hsData, Context ctx, IncomeTypeInfo head) throws TaskExternalException, IMException, BOSException, SQLException {
        String number = ((DataToken)hsData.get((Object)"FNumber")).data.toString();
        if (null == number || number.length() <= 0) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.app.IMImportResource", "NUMBER_IS_ISNULL", ctx.getLocale()));
        }
        head.setNumber(number);
        String name = ((DataToken)hsData.get((Object)"FName")).data.toString();
        if (null == name || name.length() <= 0) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "NAME_NOT_NULL", ctx.getLocale()));
        }
        head.setName(name);
        IncomeTypeCollection coll = IncomeTypeFactory.getLocalInstance(ctx).getIncomeTypeCollection("where number ='" + number + "'");
        IncomeTypeInfo info = null;
        String type = ((DataToken)hsData.get((Object)"FType")).data.toString();
        TypeEnum typeEnum = this.getTypeEnum(type);
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
            if (!typeEnum.equals((Object)info.getType()) && info.getEntries().size() > 1) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "TypeNotEqual", ctx.getLocale(), new Object[]{info.getNumber()}));
            }
            head.setType(typeEnum);
        } else {
            head.setType(typeEnum);
        }
        String status = ((DataToken)hsData.get((Object)"FStatus")).data.toString();
        IncomeTypeStatusEnum incomeStatus = null;
        incomeStatus = null != status && status.length() > 0 ? (status.equals(IncomeTypeStatusEnum.UnActive.toString()) || status.equals("1") ? IncomeTypeStatusEnum.UnActive : IncomeTypeStatusEnum.Active) : IncomeTypeStatusEnum.Active;
        head.setStatus(incomeStatus);
        return head;
    }

    private TypeEnum getTypeEnum(String type) {
        TypeEnum typeEnum = null;
        typeEnum = null != type && type.length() > 0 ? (type.equals(TypeEnum.RowType.getValue()) || type.equals(TypeEnum.RowType.getAlias()) ? TypeEnum.RowType : (type.equals(TypeEnum.ExpenseType.getValue()) || type.equals(TypeEnum.ExpenseType.getAlias()) ? TypeEnum.ExpenseType : TypeEnum.NULL)) : TypeEnum.NULL;
        return typeEnum;
    }

    private IncomeTypeEntryInfo getEntryInfo(Context ctx, int mode, IncomeTypeInfo head, String FSeq) throws TaskExternalException {
        IncomeTypeEntryInfo info = new IncomeTypeEntryInfo();
        if (mode == 16 || mode == 128) {
            String headId;
            String string = headId = head.getId() == null ? null : head.getId().toString();
            if (headId == null || FSeq == null) {
                return info;
            }
            try {
                IIncomeTypeEntry iIncomeTypeEntry = IncomeTypeEntryFactory.getLocalInstance(ctx);
                IncomeTypeEntryCollection coll = iIncomeTypeEntry.getIncomeTypeEntryCollection("where parent.id = '" + headId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                if (!"".equals(FSeq)) {
                    info.setSeq(Integer.valueOf(FSeq));
                }
                return info;
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            info.setSeq(head.getEntries().size() + 1);
            return info;
        }
        return new IncomeTypeEntryInfo();
    }

    private IncomeTypeEntryInfo getEntryInfoAndparseEntry(Hashtable hsData, int mode, Context ctx, IncomeTypeInfo headInfo, String fEntrySeq) throws TaskExternalException {
        IncomeTypeEntryInfo entry = new IncomeTypeEntryInfo();
        String type = ((DataToken)hsData.get((Object)"FType")).data.toString();
        TypeEnum typeEnum = this.getTypeEnum(type);
        if (!typeEnum.equals((Object)headInfo.getType())) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "TypeNotEqual", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
        }
        String rownumber = ((DataToken)hsData.get((Object)"FRowType.number")).data.toString();
        String expensenumber = ((DataToken)hsData.get((Object)"FExpenseType.number")).data.toString();
        if (typeEnum.equals((Object)TypeEnum.RowType) && !StringUtils.isEmpty((String)expensenumber)) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "RowTypeDataImportError", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
        }
        if (typeEnum.equals((Object)TypeEnum.ExpenseType) && !StringUtils.isEmpty((String)rownumber)) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "ExpenseTypeDataImportError", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
        }
        if (!(!typeEnum.equals((Object)TypeEnum.NULL) || StringUtils.isEmpty((String)expensenumber) && StringUtils.isEmpty((String)rownumber))) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "TypeEntryNotEqual", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
        }
        entry = this.getEntryInfo(ctx, mode, this.head, fEntrySeq);
        String typeId = null;
        if (null != typeEnum) {
            if (typeEnum.getAlias().equals(TypeEnum.RowType.getAlias())) {
                if (null != rownumber && rownumber.length() > 0) {
                    try {
                        typeId = ((IIncomeType)this.getController(ctx)).getTypeIdbyNumber(rownumber, Integer.parseInt(typeEnum.getValue()));
                    }
                    catch (Exception e) {
                        MsgBox.showWarning((String)e.getMessage());
                    }
                    if (StringUtils.isEmpty(typeId)) {
                        throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "RowTypeNotFound", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
                    }
                }
            } else if (typeEnum.getAlias().equals(TypeEnum.ExpenseType.getAlias()) && null != expensenumber && expensenumber.length() > 0) {
                try {
                    typeId = ((IIncomeType)this.getController(ctx)).getTypeIdbyNumber(expensenumber, Integer.parseInt(typeEnum.getValue()));
                }
                catch (Exception e) {
                    MsgBox.showWarning((String)e.getMessage());
                }
                if (StringUtils.isEmpty((String)typeId)) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.basedata.IncomeTypeResource", "ExpenseTypeNotFound", ctx.getLocale(), new Object[]{headInfo.getNumber()}));
                }
            }
        }
        entry.setTypeId(typeId);
        return entry;
    }
}

