/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.app.DataImportUtils;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.ITaxSeparation;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.TaxSeparationEntryInfo;
import com.kingdee.eas.tm.im.TaxSeparationFactory;
import com.kingdee.eas.tm.im.TaxSeparationInfo;
import com.kingdee.eas.tm.im.TaxSeparationStatusEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MakeInvoiceReqDataImport
extends IMBillImportBase {
    private TaxSeparationInfo info = null;
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";
    private Hashtable firstData = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return TaxSeparationFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        int k = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(i);
            if (k == 0) {
                try {
                    this.info = this.transmitHead(lineData, ctx);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (this.info == null) {
                    return null;
                }
            }
            TaxSeparationEntryInfo entryInfo = null;
            try {
                entryInfo = this.transmitEntry(lineData, ctx);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            entryInfo.setSeq(k + 1);
            this.info.getEntries().add(entryInfo);
            ++k;
        }
        return this.info;
    }

    private TaxSeparationInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String bankAccount;
        String address;
        String taxNumber;
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission((String)ctx.get((Object)"CurCompanyId"), "im_taxSeperation_new");
        this.info = new TaxSeparationInfo();
        this.info.setStatus(TaxSeparationStatusEnum.untreated);
        this.setCompany(ctx, lineData, this.info);
        this.info.setBizDate(this.getDate(ctx, lineData, "FBizDate"));
        this.setCurrency(ctx, lineData, this.info);
        boolean setCustTax = this.setCustomer(ctx, lineData, this.info);
        String recOrgName = this.getString(lineData, "FRecOrgName");
        if (recOrgName != null && !recOrgName.isEmpty()) {
            if (recOrgName.length() > 300) {
                throw new TaskExternalException(DataImportUtils.getResource((String)"com.kingdee.eas.basedata.master.cssp.CSSPResource", (String)"BillToCompantNameLen100", (Context)ctx));
            }
            this.info.setRecOrgName(recOrgName.trim());
            setCustTax = false;
        }
        if ((taxNumber = this.getString(lineData, "FTaxNumber")) != null && !taxNumber.isEmpty()) {
            if (taxNumber.trim().length() > 100) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "TaxNumber_tooLong", ctx.getLocale()));
            }
            this.info.setTaxNumber(taxNumber.trim());
            setCustTax = false;
        }
        if ((address = this.getString(lineData, "FAddress")) != null && !address.isEmpty()) {
            if (address.trim().length() > 300) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AddressTel_tooLong", ctx.getLocale()));
            }
            this.info.setAddress(address.trim());
            setCustTax = false;
        }
        if ((bankAccount = this.getString(lineData, "FBankAccount")) != null && !bankAccount.isEmpty()) {
            if (bankAccount.trim().length() > 300) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BankAccount_tooLong", ctx.getLocale()));
            }
            this.info.setBankAccount(bankAccount);
            setCustTax = false;
        }
        if (setCustTax) {
            Map ret;
            IObjectValue customerTaxInfo;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("customerId", this.info.getCustomer().getId().toString());
            params.put("invoiceType", "1");
            if (this.info.getCompany() != null) {
                params.put("companyId", this.info.getCompany().getId().toString());
            }
            if ((customerTaxInfo = (IObjectValue)(ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params)).get("value")) != null) {
                this.info.setRecOrgName((String)customerTaxInfo.get("recCompanyName"));
                this.info.setTaxNumber((String)customerTaxInfo.get("taxNumber"));
                this.info.setAddress((String)customerTaxInfo.get("addressTel"));
                this.info.setBankAccount((String)customerTaxInfo.get("bankAccount"));
            }
        } else if (this.info.getCustomer() == null && (this.info.getRecOrgName() == null || "".equals(this.info.getRecOrgName()))) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "CustomerOrBillCompanyNotALLNULL", ctx.getLocale()));
        }
        this.info.setDescription(this.getString(lineData, "FDescription"));
        this.info.setSourceBillNumber(this.getString(lineData, "FSourceBillNumber"));
        this.info.setSourceSys(InvoiceSrcSystem.EXCEL.getAlias());
        this.doNumber(ctx, lineData);
        return this.info;
    }

    private void doEntryMaterial(TaxSeparationEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        String productName = ((DataToken)hsData.get((Object)"FEntries_productName")).data.toString();
        String productNum = ((DataToken)hsData.get((Object)"FEntries$productCode_number")).data.toString();
        try {
            if (IMUtils.isEmpty(productName) && IMUtils.isEmpty(productNum)) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ProductCodeNotExists", ctx.getLocale()));
            }
            entryInfo.setProductName(productName);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (!IMUtils.isEmpty(productNum)) {
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)productNum, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("taxClassificationCode.*"));
                view.setSelector(sic);
                ProductCodeCollection collection = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
                ProductCodeInfo productInfo = collection.get(0);
                if (productInfo == null && IMUtils.isEmpty(productName)) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ProductCodeNotExists", ctx.getLocale()));
                }
                entryInfo.setProductCode(productInfo);
                if (productInfo != null) {
                    entryInfo.setTaxClassificationCode(productInfo.getTaxClassificationCode().getMergeCode());
                }
                if (IMUtils.isEmpty(productName) && productInfo != null) {
                    entryInfo.setProductName(productInfo.getName());
                }
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private TaxSeparationEntryInfo transmitEntry(Hashtable lineData, Context ctx) throws TaskExternalException, EASBizException, BOSException {
        TaxSeparationEntryInfo entryInfo = new TaxSeparationEntryInfo();
        this.doEntryMaterial(entryInfo, lineData, ctx);
        String specification = this.getString(lineData, "FEntries_specification");
        if (specification != null && !specification.equals("")) {
            entryInfo.setSpecification(specification);
        }
        this.setUnit(ctx, lineData, entryInfo);
        BigDecimal quantity = this.getBigDecimal(lineData, "FEntries_quantity", ctx);
        if (quantity != null) {
            entryInfo.setQuantity(quantity);
        } else {
            entryInfo.setQuantity(new BigDecimal(0));
        }
        BigDecimal price = this.getBigDecimal(lineData, "FEntries_price", ctx);
        if (price != null) {
            entryInfo.setPrice(price);
        } else {
            entryInfo.setPrice(new BigDecimal("0.00"));
        }
        BigDecimal taxRate = this.getBigDecimal(lineData, "FEntries_taxRate", ctx);
        if (taxRate == null) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "RateNotNull", ctx.getLocale()));
        }
        entryInfo.setTaxRate(taxRate);
        BigDecimal tax = this.getBigDecimal(lineData, "FEntries_tax", ctx);
        if (tax == null) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TaxAmountNotNull", ctx.getLocale()));
        }
        entryInfo.setTax(tax);
        BigDecimal amout = this.getBigDecimal(lineData, "FEntries_priceExcludingTax", ctx);
        if (amout == null) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "AmountNotNull", ctx.getLocale()));
        }
        entryInfo.setPriceExcludingTax(amout);
        BigDecimal totalAmout = this.getBigDecimal(lineData, "FEntries_priceIncludingTax", ctx);
        if (totalAmout == null) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "TotalAmountNotNull", ctx.getLocale()));
        }
        entryInfo.setPriceIncludingTax(totalAmout);
        if (tax.add(amout).compareTo(totalAmout) != 0) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "AmountAndTaxNotEqualTotalAmount", ctx.getLocale()));
        }
        String taxTypeNum = this.getString(lineData, "FEntries_taxClassificationCode");
        if (taxTypeNum != null && !taxTypeNum.equals("")) {
            TaxClassificationCodeCollection taxClassCode;
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)taxTypeNum, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("sumItem", (Object)"N", CompareType.EQUALS));
            ev.setFilter(filter);
            try {
                taxClassCode = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(ev);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (taxClassCode == null || taxClassCode.size() == 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)taxTypeNum, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("sumItem", (Object)"N", CompareType.EQUALS));
                ev.setFilter(filter);
                try {
                    taxClassCode = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(ev);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage());
                }
                if (taxClassCode == null || taxClassCode.size() == 0) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_ERROR", ctx));
                }
                TaxClassificationCodeInfo taxclassInfo = taxClassCode.get(0);
                taxTypeNum = taxclassInfo.getMergeCode();
            }
            entryInfo.setTaxClassificationCode(taxTypeNum);
        } else if (entryInfo.getTaxClassificationCode() == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_ERROR", ctx));
        }
        return entryInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.TaxSeparationQuery";
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof TaxSeparationInfo)) {
            return;
        }
        try {
            ITaxSeparation iTaxSeparation = (ITaxSeparation)this.getController(ctx);
            TaxSeparationInfo info = (TaxSeparationInfo)coreBaseInfo;
            Map<String, String> map = this.getNumber(ctx, info.getNumber());
            if (map.size() > 0) {
                iTaxSeparation.delete((IObjectPK)new ObjectUuidPK(map.get("id")));
                iTaxSeparation.save((CoreBaseInfo)info);
            } else {
                iTaxSeparation.save((CoreBaseInfo)info);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FCustomer_number", rs.getString("customer.number"));
            this.putTable(result, "FStatus", rs.getString("status"));
            this.putTable(result, "FSourceBillNumber", rs.getString("sourceBillNumber"));
            this.putTable(result, "FEntries$productCode_number", rs.getString("productCode.number"));
            this.putTable(result, "FEntries_productName", rs.getString("entries.productName"));
            this.putTable(result, "FEntries$measureUnit_number", rs.getString("measureUnit.number"));
            this.putTable(result, "FEntries_specification", rs.getString("entries.specification"));
            this.putTable(result, "FEntries_price", rs.getBigDecimal("entries.price").setScale(8, RoundingMode.HALF_UP));
            this.putTable(result, "FEntries_quantity", rs.getBigDecimal("entries.quantity"));
            this.putTable(result, "FEntries_taxRate", rs.getBigDecimal("entries.taxRate"));
            this.putTable(result, "FEntries_tax", rs.getBigDecimal("entries.tax").setScale(2, RoundingMode.HALF_UP));
            this.putTable(result, "FEntries_priceExcludingTax", rs.getBigDecimal("entries.priceExcludingTax").setScale(2, RoundingMode.HALF_UP));
            this.putTable(result, "FEntries_priceIncludingTax", rs.getBigDecimal("entries.priceIncludingTax").setScale(2, RoundingMode.HALF_UP));
            this.putTable(result, "FEntries_taxClassificationCode", rs.getString("entries.taxClassificationCode"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FRecOrgName", rs.getString("recOrgName"));
            this.putTable(result, "FTaxNumber", rs.getString("taxNumber"));
            this.putTable(result, "FAddress", rs.getString("address"));
            this.putTable(result, "FBankAccount", rs.getString("bankAccount"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public int getSubmitType() {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNumber(Context ctx, Hashtable lineData) throws TaskExternalException, EASBizException, BOSException {
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        boolean isNumberByRule = true;
        boolean isSupporNumberRule = IMUtils.getImportParam(ctx);
        if (isSupporNumberRule) {
            Map<String, String> billMap;
            if (!StringUtils.isEmpty((String)((String)number)) && this.isSltImportUpdate() && (billMap = this.getNumber(ctx, number.toString().trim())).size() > 0 && billMap.containsKey("status")) {
                String status = billMap.get("status").toString();
                if ("1".equals(status)) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotImportUpdateForDone", ctx.getLocale()));
                }
                isNumberByRule = false;
            }
            if (isNumberByRule) {
                String mainOrgId = null;
                CompanyOrgUnitInfo mainOrg = this.info.getCompany();
                if (mainOrg == null) {
                    return;
                }
                mainOrgId = mainOrg.getString("id");
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                if (!iCodingRuleManager.isExist((IObjectValue)this.info, mainOrgId)) throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotNubmerRule", ctx.getLocale()));
                number = iCodingRuleManager.getNumber((IObjectValue)this.info, mainOrgId, "");
            }
        } else if (number != null && number.toString().trim().length() > 0) {
            Map<String, String> billMap = this.getNumber(ctx, number.toString().trim());
            if (this.isSltImportUpdate()) {
                String status;
                if (billMap.containsKey("status") && "1".equals(status = billMap.get("status").toString())) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotImportUpdateForDone", ctx.getLocale()));
                }
            } else if (billMap.size() > 0) {
                String str = IMUtils.getResource(resClassName, "EXIST_SAME_NUMBER", ctx);
                throw new TaskExternalException(number.toString().trim() + "  " + str);
            }
        } else {
            String str = IMUtils.getResource(resClassName, "NUMBER_IS_ISNULL", ctx);
            throw new TaskExternalException(str);
        }
        this.info.setNumber(number.toString().trim());
    }

    private Map<String, String> getNumber(Context ctx, String number) throws EASBizException, BOSException {
        HashMap<String, String> billMap = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" select fid, fnumber, fstatus from T_IM_TaxSeparation where fnumber = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{number});
        try {
            while (rs.next()) {
                billMap.put("status", rs.getString("fstatus"));
                billMap.put("id", rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return billMap;
    }

    private boolean setCustomer(Context ctx, Hashtable hsData, TaxSeparationInfo mkInvoiceReq) throws TaskExternalException {
        String customerNum = this.getString(hsData, "FCustomer_number");
        if (customerNum != null && customerNum.length() > 0) {
            CustomerInfo customerInfo = null;
            String sql = "select top 1 fid, fnumber, fname_l2 from T_BD_Customer where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{customerNum});
                if (rs != null && rs.next()) {
                    customerInfo = new CustomerInfo();
                    customerInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                    customerInfo.setName(rs.getString("fname_l2"));
                    mkInvoiceReq.setCustomer(customerInfo);
                    return true;
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        return false;
    }

    private void setCompany(Context ctx, Hashtable hsData, TaxSeparationInfo mkInvoiceReq) throws TaskExternalException {
        CompanyOrgUnitInfo comOrgUnitInfo = null;
        String companyNum = ((DataToken)hsData.get((Object)"FCompany_number")).data.toString();
        String sql = "select top 1 fid, fnumber, fname_l2, fisbizunit from T_ORG_COMPANY where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyNum});
            if (rs != null && rs.next()) {
                if (!rs.getString("fisbizunit").equals("1")) {
                    throw new IMException(IMException.NOTBIZCOMPANY);
                }
            } else {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "CompanyNotExists", ctx.getLocale()));
            }
            comOrgUnitInfo = new CompanyOrgUnitInfo();
            comOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            comOrgUnitInfo.setName(rs.getString("fname_l2"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        mkInvoiceReq.setCompany(comOrgUnitInfo);
    }

    private void setCurrency(Context ctx, Hashtable hsData, TaxSeparationInfo mkInvoiceReq) throws TaskExternalException {
        CurrencyInfo info = null;
        String number = ((DataToken)hsData.get((Object)"FCurrency_number")).data.toString();
        String sql = "select top 1 fid, fnumber, fname_l2 from T_BD_CURRENCY where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
            if (rs != null && rs.next()) {
                info = new CurrencyInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setName(rs.getString("fname_l2"));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        mkInvoiceReq.setCurrency(info);
    }

    private Date getDate(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
            }
        }
        if (o != null && o instanceof Date) {
            date = (Date)o;
        }
        return date;
    }

    private void setUnit(Context ctx, Hashtable hsData, TaxSeparationEntryInfo entryInfo) throws TaskExternalException {
        MeasureUnitInfo unitInfo = null;
        String unit = this.getString(hsData, "FEntries$measureUnit_number");
        String sql = "select top 1 fid, fname_l2, fnumber from T_BD_MEASUREUNIT where fnumber = ?";
        if (unit != null && unit.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{unit});
                if (!rs.next()) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "UNIT_ERROR", ctx));
                }
                unitInfo = new MeasureUnitInfo();
                unitInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                unitInfo.setName(rs.getString("fname_l2"));
                unitInfo.setNumber(unit);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        entryInfo.setMeasureUnit(unitInfo);
    }

    protected BigDecimal getBigDecimal(Hashtable hsData, String key, Context ctx) throws TaskExternalException {
        String data = this.getString(hsData, key);
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        data = data.replaceAll("[\uff0c,]", "");
        String reg = "(^-?\\d+(\\.\\d+)?$)";
        if (data != null && data.length() > 0) {
            if (data.matches(reg)) {
                return new BigDecimal(data);
            }
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BigDecimalDataError", ctx.getLocale()));
        }
        return null;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }
}

