/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IProductCode;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.ProductRelationEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ProductCodeDataImport
extends IMBillImportBase {
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";
    private int modelLength = 40;
    private String TRUE = "true";
    private String FALSE = "false";

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ProductCodeFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    protected BigDecimal getValue(Object data) {
        if (data == null) {
            return null;
        }
        return new BigDecimal(((DataToken)data).data.toString().trim());
    }

    private BigDecimal string2Decimale(String str) {
        if (str == null || "".equals(str)) {
            return null;
        }
        return new BigDecimal(str);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        IProductCode iproductCode = (IProductCode)this.getController(ctx);
        try {
            int dataSmode = (Integer)this.getContextMap().get("DATATASKMODE");
            if (16 == dataSmode) {
                String id = null;
                String sourceType = null;
                String sql = " select fid,fsourcetype from t_im_productcode where fnumber = ? ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{coreBaseInfo.get("number")});
                if (rs.next()) {
                    id = rs.getString("fid");
                    sourceType = rs.getString("fsourcetype");
                    coreBaseInfo.setId(BOSUuid.read((String)id));
                    iproductCode.impUpdate((IObjectPK)new ObjectUuidPK(id), (IObjectValue)coreBaseInfo);
                } else {
                    coreBaseInfo.put("sourceType", (Object)"2");
                    iproductCode.save(coreBaseInfo);
                }
            } else if (8 == dataSmode) {
                coreBaseInfo.put("sourceType", (Object)"2");
                iproductCode.save(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String number;
        this.checkStatus(ctx, this.getString(hsData, "FNumber"));
        ProductCodeInfo productCodeInfo = new ProductCodeInfo();
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, hsData);
        productCodeInfo.setCompany(companyInfo);
        BigDecimal taxRate = BigDecimal.ZERO;
        if (hsData.get("FTaxRate") != null && !hsData.get("FTaxRate").toString().equals("")) {
            taxRate = this.getValue(hsData.get("FTaxRate"));
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            if (taxRate.compareTo(new BigDecimal(1)) >= 0 || taxRate.compareTo(new BigDecimal(0)) < 0) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "TaxRateRangeError1", ctx.getLocale()));
            }
            productCodeInfo.setTaxRate(taxRate);
        }
        MeasureUnitInfo unitInfo = this.getUnit(ctx, hsData);
        productCodeInfo.setUnit(unitInfo);
        String model = ((DataToken)hsData.get((Object)"FModel")).data.toString();
        if (IMUtils.getStringlength(model) > this.modelLength) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "model_overlength", ctx));
        }
        productCodeInfo.setModel(model);
        TaxClassificationCodeInfo taxClassInfo = this.getTaxClassificationCode(ctx, hsData);
        productCodeInfo.setTaxClassificationCode(taxClassInfo);
        if (productCodeInfo.getTaxRate() == null && taxClassInfo != null) {
            productCodeInfo.setTaxRate(taxClassInfo.getTaxRate());
        }
        if (productCodeInfo.getTaxRate() == null) {
            productCodeInfo.setTaxRate(taxRate);
        }
        if (taxClassInfo != null) {
            TaxClassificationCodeInfo taxClass = this.getTaxClass(ctx, taxClassInfo.getParentNum());
            productCodeInfo.setTaxClass(taxClass);
        }
        String hasPreferential = null;
        String preferentialPolicies = null;
        if (hsData.get("FHasPreferential") != null) {
            hasPreferential = hsData.get("FHasPreferential").toString();
        }
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        boolean hasPrefer = false;
        if (!StringUtils.isEmpty((String)hasPreferential) && (yes.equals(hasPreferential) || this.TRUE.equalsIgnoreCase(hasPreferential))) {
            hasPrefer = true;
        } else {
            if (!StringUtils.isEmpty((String)hasPreferential) && !no.equals(hasPreferential) && !this.FALSE.equalsIgnoreCase(hasPreferential)) throw new TaskExternalException(IMUtils.getResource(resClassName, "hasPreferential_error", ctx));
            hasPrefer = false;
        }
        if (hsData.get("FPreferentialPolicies") != null) {
            preferentialPolicies = hsData.get("FPreferentialPolicies").toString();
        }
        PreferentialPoliciesEnum preferPolicies = null;
        Iterator iterator = PreferentialPoliciesEnum.iterator();
        while (iterator.hasNext()) {
            PreferentialPoliciesEnum temp = (PreferentialPoliciesEnum)((Object)iterator.next());
            if (StringUtils.isEmpty((String)temp.getAlias()) || !temp.getAlias().equals(preferentialPolicies)) continue;
            preferPolicies = temp;
            break;
        }
        productCodeInfo.setHasPreferential(hasPrefer);
        if (preferPolicies == null) {
            productCodeInfo.setPreferentialPolicies(PreferentialPoliciesEnum.Null);
        } else {
            productCodeInfo.setPreferentialPolicies(preferPolicies);
        }
        if (!StringUtils.isEmpty((String)preferentialPolicies) && preferPolicies == null) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "PREFER_NOT_RIGHT", ctx));
        }
        String mergeCode = taxClassInfo.getMergeCode();
        if (mergeCode.startsWith("6", 0) && !mergeCode.startsWith("614", 0)) {
            if (!hasPrefer) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_HASPREFER", ctx));
            }
            if (hasPrefer) {
                if (preferPolicies == null) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "PREFER_CANNOT_NULL", ctx));
                }
                if (!PreferentialPoliciesEnum.NoTaxation.equals((Object)preferPolicies)) throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_HASPREFER", ctx));
                if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXTATE_NOTRIGHT", ctx));
                }
            }
        } else {
            HashSet<PreferentialPoliciesEnum> containPreferPolicySet = new HashSet<PreferentialPoliciesEnum>();
            containPreferPolicySet.add(PreferentialPoliciesEnum.Simple);
            containPreferPolicySet.add(PreferentialPoliciesEnum.CollectRefund100Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.CollectRefund50Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.CollectRefund);
            containPreferPolicySet.add(PreferentialPoliciesEnum.RefundOver3Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.RefundOver8Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.RefundOver12Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.Refund100Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.Refund30Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.Refund50Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.Refund70Per);
            containPreferPolicySet.add(PreferentialPoliciesEnum.RareEarth);
            if (!hasPrefer) {
                if (preferPolicies != null) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "PREFER_CANNOT_HAS_NULL", ctx));
                }
            } else if (hasPrefer) {
                if (preferPolicies == null) {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "PREFER_CANNOT_NULL", ctx));
                }
                if (PreferentialPoliciesEnum.NoTaxation.equals((Object)preferPolicies) || PreferentialPoliciesEnum.DutyFree.equals((Object)preferPolicies)) {
                    if (taxRate.compareTo(BigDecimal.ZERO) != 0) {
                        throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXTATE_NOTRIGHT", ctx));
                    }
                } else if (PreferentialPoliciesEnum.Simple3Per.equals((Object)preferPolicies)) {
                    this.isContainPreferPolicies(PreferentialPoliciesEnum.Simple3Per.getAlias(), taxClassInfo.getVATSpecialManagement(), ctx);
                    if (new BigDecimal("0.03").compareTo(taxRate) != 0) {
                        throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXTATE_NOTRIGHT", ctx));
                    }
                } else if (PreferentialPoliciesEnum.Simple5Per.equals((Object)preferPolicies)) {
                    this.isContainPreferPolicies(PreferentialPoliciesEnum.Simple5Per.getAlias(), taxClassInfo.getVATSpecialManagement(), ctx);
                    if (new BigDecimal("0.05").compareTo(taxRate) != 0) {
                        throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXTATE_NOTRIGHT", ctx));
                    }
                } else if (PreferentialPoliciesEnum.Simple5Per15.equals((Object)preferPolicies)) {
                    this.isContainPreferPolicies(PreferentialPoliciesEnum.Simple5Per15.getAlias(), taxClassInfo.getVATSpecialManagement(), ctx);
                    if (new BigDecimal("0.015").compareTo(taxRate) != 0) {
                        throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXTATE_NOTRIGHT", ctx));
                    }
                } else if (containPreferPolicySet.contains((Object)preferPolicies)) {
                    this.isContainPreferPolicies(preferPolicies.getAlias(), taxClassInfo.getVATSpecialManagement(), ctx);
                }
            }
        }
        if (null == (number = this.getString(hsData, "FNumber")) || number.length() <= 0) throw new TaskExternalException(IMUtils.getResource(resClassName, "PRODUCT_NUMBER_NOT_NULL", ctx));
        if (!this.isSltImportUpdate()) {
            String sql = " select top 1 fid from t_im_productcode where fnumber = ? ";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
                if (null != rs && rs.next()) {
                    throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{number});
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        productCodeInfo.setNumber(number);
        String name = this.getString(hsData, "FName_l2");
        if (null == name || name.length() <= 0) {
            try {
                throw new IMException(IMException.CODE_NAME_NULL);
            }
            catch (IMException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        productCodeInfo.setName(name.trim());
        String simpleCode = this.getString(hsData, "FSimpleCode");
        productCodeInfo.setSimpleCode(simpleCode);
        BigDecimal price = BigDecimal.ZERO;
        if (!hsData.get("FPrice").toString().equals("") && hsData.get("FPrice") != null) {
            price = this.getValue(hsData.get("FPrice"));
        }
        productCodeInfo.setPrice(price);
        Boolean isTax = false;
        String isTaxString = this.getString(hsData, "FIsTax");
        if ("true".equalsIgnoreCase(isTaxString) || IMUtils.getResource(resClassName, "YES", ctx).equals(isTaxString)) {
            isTax = true;
        }
        productCodeInfo.setIsTax(isTax);
        Boolean isDiffTax = false;
        String isDiffTaxString = this.getString(hsData, "FIsDiffTax");
        if (isDiffTaxString.equals("true") || isDiffTaxString.equals(IMUtils.getResource(resClassName, "YES", ctx))) {
            isDiffTax = true;
        }
        productCodeInfo.setIsDiffTax(isDiffTax);
        ProductCodeStatusEnum statusEnum = ProductCodeStatusEnum.USING;
        String status = this.getString(hsData, "FStatus");
        if (IMUtils.getResource(resClassName, "FORBIDDEN", ctx).equals(status.trim()) || "1".equals(status.trim())) {
            statusEnum = ProductCodeStatusEnum.FORBIDDEN;
        } else {
            if (!IMUtils.getResource(resClassName, "USING", ctx).equals(status.trim()) && !"0".equals(status.trim())) throw new TaskExternalException(IMUtils.getResource(resClassName, "STATUS_ERROR", ctx));
            statusEnum = ProductCodeStatusEnum.USING;
        }
        productCodeInfo.setStatus(statusEnum);
        String FRemark = this.getString(hsData, "FRemark");
        productCodeInfo.setDescription(FRemark);
        productCodeInfo.setRemark(FRemark);
        String customerNumber = this.getString(hsData, "FCustomer_number");
        if ("".equals(customerNumber)) {
            productCodeInfo.setCustomer(null);
        } else {
            CustomerInfo customer = this.getCustomerByNumber(ctx, customerNumber);
            productCodeInfo.setCustomer(customer);
        }
        String srcNumber = this.getString(hsData, "FSrcNumber");
        String srcType = this.getString(hsData, "FSrcType");
        productCodeInfo.setSrcType(srcType);
        productCodeInfo.setSrcNumber(srcNumber);
        String vehicleChinese = IMUtils.getResource("com.kingdee.eas.tm.im.IMResource", "Vehicle", ctx);
        Boolean isVehicle = false;
        String isVehicleString = this.getString(hsData, "FIsVehicle");
        if ("1".equals(isVehicleString) || "true".equalsIgnoreCase(isVehicleString) || IMUtils.getResource(resClassName, "YES", ctx).equals(isVehicleString)) {
            isVehicle = true;
        }
        productCodeInfo.setIsVehicle(isVehicle);
        String vehicleType = this.getString(hsData, "FVehicleType");
        String facPlateModel = this.getString(hsData, "FFacPlateModel");
        String origin = this.getString(hsData, "FOrigin");
        String tonnage = this.getString(hsData, "FTonnage");
        String limitPopulation = this.getString(hsData, "FLimitPopulation");
        String productionEnterprise = this.getString(hsData, "FProductionEnterprise");
        productCodeInfo.setVehicleType(vehicleType);
        productCodeInfo.setFacPlateModel(facPlateModel);
        productCodeInfo.setOrigin(origin);
        productCodeInfo.setTonnage(tonnage);
        productCodeInfo.setLimitPopulation(limitPopulation);
        productCodeInfo.setProductionEnterprise(productionEnterprise);
        if (isVehicle.booleanValue()) {
            if (!vehicleChinese.equals(taxClassInfo.getSimpleName())) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "TaxClass_notVehicle", ctx));
            }
        } else if (!(StringUtils.isEmpty((String)vehicleType) && StringUtils.isEmpty((String)facPlateModel) && StringUtils.isEmpty((String)origin) && StringUtils.isEmpty((String)tonnage) && StringUtils.isEmpty((String)limitPopulation) && StringUtils.isEmpty((String)productionEnterprise))) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "VehicleFieldsNeedEmpty", ctx));
        }
        if (srcNumber != null && srcNumber.length() > 0) {
            if (srcType == null || srcType.length() == 0) {
                try {
                    throw new TaskExternalException(IMUtils.getResource(resClassName, "SOURCETYPE_NOT_NULL", ctx));
                }
                catch (TaskExternalException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            boolean isProductRelationEnum = false;
            ProductRelationEnum relationEnum = null;
            List proRelationList = ProductRelationEnum.getEnumList();
            int size = proRelationList.size();
            for (int i = 0; i < size; ++i) {
                relationEnum = (ProductRelationEnum)((Object)proRelationList.get(i));
                if (!relationEnum.getValue().equals(srcType) && !relationEnum.getAlias().equals(srcType)) continue;
                isProductRelationEnum = true;
                break;
            }
            if (!isProductRelationEnum) {
                try {
                    throw new IMException(IMException.SRCTYPEERROR);
                }
                catch (IMException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            if ("EXPENSEITEM".equals(srcType)) {
                ExpenseTypeInfo expense = this.checkChargeItem(ctx, srcNumber);
                productCodeInfo.setExpenseItem(expense);
            } else if ("MATERIAL".equals(srcType)) {
                MaterialInfo material = this.checkMaterial(ctx, srcNumber);
                productCodeInfo.setMaterial(material);
                if (material == null) {
                    throw new TaskExternalException(ResourceBase.getString((String)resClassName, (String)"Material_NOT_Exists", (Locale)ctx.getLocale()));
                }
                if (IMUtils.isEmpty(productCodeInfo.getModel())) {
                    if (IMUtils.getStringlength(material.getModel()) > this.modelLength) {
                        throw new TaskExternalException(ResourceBase.getString((String)resClassName, (String)"materModel_overLength", (Locale)ctx.getLocale(), (Object[])new Object[]{material.getNumber()}));
                    }
                    productCodeInfo.setModel(material.getModel());
                }
                if (productCodeInfo.getUnit() == null) {
                    productCodeInfo.setUnit(material.getBaseUnit());
                }
            }
        }
        if (srcType.length() > 0 && srcNumber != null && srcNumber.length() == 0) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "SOURCE_NUMBER_NOT_NULL", ctx));
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        productCodeInfo.setCU(cu);
        return productCodeInfo;
    }

    public boolean isContainPreferPolicies(String PreferentialPolicies, String taxVATSpecialManage, Context ctx) throws TaskExternalException {
        HashSet<String> preferPoliciesSet = new HashSet<String>();
        preferPoliciesSet.add(PreferentialPoliciesEnum.NoTaxation.getAlias());
        preferPoliciesSet.add(PreferentialPoliciesEnum.DutyFree.getAlias());
        String[] taxVATSpecManage = taxVATSpecialManage.split("\u3001");
        for (int i = 0; i < taxVATSpecManage.length; ++i) {
            preferPoliciesSet.add(taxVATSpecManage[i]);
        }
        if (preferPoliciesSet.contains(PreferentialPolicies)) {
            return true;
        }
        throw new TaskExternalException(IMUtils.getResource(resClassName, "TAXCLASS_NOT_SUPPORT_POLICY", ctx));
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        CompanyOrgUnitInfo companyInfo = null;
        String FCompanyNumber = this.getString(hsData, "FCompany_number");
        String sql = "select top 1 fid,fnumber,fname_l2 from T_ORG_COMPANY where fnumber = ?";
        if (FCompanyNumber != null && FCompanyNumber.length() > 0) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCompanyNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(this.getResource(ctx, "Company_NOT_Exists"));
                }
                companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                companyInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return companyInfo;
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)key, (Locale)ctx.getLocale());
    }

    private TaxClassificationCodeInfo getTaxClass(Context ctx, String number) throws TaskExternalException {
        try {
            TaxClassificationCodeInfo taxClass = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            TaxClassificationCodeCollection taxClassCollection = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(view);
            if (taxClassCollection != null && taxClassCollection.size() > 0) {
                taxClass = taxClassCollection.get(0);
            }
            return taxClass;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String expenseItemNumbe;
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FName_l2", rs.getString("name"));
            this.putTable(result, "FSimpleCode", rs.getString("simpleCode"));
            this.putTable(result, "FModel", rs.getString("model"));
            this.putTable(result, "FTaxClassificationCode_number", rs.getString("taxClassificationCode.number"));
            this.putTable(result, "FHasPreferential", Boolean.parseBoolean(rs.getString("hasPreferential")) ? IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale()));
            this.putTable(result, "FPreferentialPolicies", (Object)PreferentialPoliciesEnum.getEnum(rs.getString("preferentialPolicies")));
            this.putTable(result, "FUnit_number", rs.getString("unit.number"));
            this.putTable(result, "FPrice", rs.getString("price"));
            this.putTable(result, "FIsTax", Boolean.parseBoolean(rs.getString("isTax")) ? IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale()));
            this.putTable(result, "FIsDiffTax", Boolean.parseBoolean(rs.getString("isDiffTax")) ? IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale()));
            this.putTable(result, "FStatus", (Object)ProductCodeStatusEnum.getEnum(rs.getInt("status")));
            this.putTable(result, "FRemark", rs.getString("remark"));
            String materialNumber = rs.getString("material.number");
            if (materialNumber != null && !materialNumber.equals("")) {
                this.putTable(result, "FSrcNumber", materialNumber);
                this.putTable(result, "FSrcType", "MATERIAL");
            }
            if ((expenseItemNumbe = rs.getString("expenseItem.number")) != null && !expenseItemNumbe.equals("")) {
                this.putTable(result, "FSrcNumber", expenseItemNumbe);
                this.putTable(result, "FSrcType", "EXPENSEITEM");
            }
            this.putTable(result, "FCustomer_number", rs.getString("customer.number"));
            ProductCodeSourceTypeEnum sourceType = ProductCodeSourceTypeEnum.getEnum(rs.getString("sourceType"));
            if (sourceType != null) {
                this.putTable(result, "FSourceType", sourceType.getAlias());
            }
            this.putTable(result, "FIsVehicle", Boolean.parseBoolean(rs.getString("isVehicle")) ? IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_true", ctx.getLocale()) : IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Data_false", ctx.getLocale()));
            this.putTable(result, "FVehicleType", rs.getString("vehicleType"));
            this.putTable(result, "FFacPlateModel", rs.getString("facPlateModel"));
            this.putTable(result, "FOrigin", rs.getString("origin"));
            this.putTable(result, "FTonnage", rs.getString("tonnage"));
            this.putTable(result, "FLimitPopulation", rs.getString("limitPopulation"));
            this.putTable(result, "FProductionEnterprise", rs.getString("productionEnterprise"));
            this.putTable(result, "FFieldStr1", rs.getString("fieldStr1"));
            this.putTable(result, "FFieldStr2", rs.getString("fieldStr2"));
            this.putTable(result, "FFieldStr3", rs.getString("fieldStr3"));
            this.putTable(result, "FFieldStr4", rs.getString("fieldStr4"));
            this.putTable(result, "FFieldDecimal5", rs.getString("fieldDecimal5"));
            this.putTable(result, "FFieldDecimal6", rs.getString("fieldDecimal6"));
            this.putTable(result, "FFieldDecimal7", rs.getString("fieldDecimal7"));
            this.putTable(result, "FFieldDecimal8", rs.getString("fieldDecimal8"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FTaxRate", rs.getString("taxRate"));
        }
        catch (SQLException e) {
            Logger.error((Throwable)e, (String)"export error");
            throw new TaskExternalException("SQLException:", (Throwable)e);
        }
        return result;
    }

    private CustomerInfo getCustomerByNumber(Context ctx, String number) throws TaskExternalException {
        CustomerInfo customer = null;
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            CustomerCollection collection = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(viewInfo);
            if (collection == null || collection.size() <= 0) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "CustomerNotExists", ctx.getLocale()));
            }
            customer = collection.get(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return customer;
    }

    private MeasureUnitInfo getUnit(Context ctx, Hashtable hsData) throws TaskExternalException {
        MeasureUnitInfo unitInfo;
        block8: {
            unitInfo = null;
            String FUnitNumber = this.getString(hsData, "FUnit_number");
            String sqlToGetUnit = " select top 1 fid, fname_l2, fnumber from T_BD_MEASUREUNIT where fnumber = ? ";
            if (null != FUnitNumber && FUnitNumber.length() > 0) {
                try {
                    IRowSet rsToGetUnit = DbUtil.executeQuery((Context)ctx, (String)sqlToGetUnit, (Object[])new Object[]{FUnitNumber});
                    if (rsToGetUnit != null && rsToGetUnit.next()) {
                        unitInfo = new MeasureUnitInfo();
                        unitInfo.setId(BOSUuid.read((String)rsToGetUnit.getString("fid")));
                        unitInfo.setName(rsToGetUnit.getString("fname_l2"));
                        unitInfo.setNumber(FUnitNumber);
                        break block8;
                    }
                    try {
                        throw new IMException(IMException.MEASUREUNIT_ERROR);
                    }
                    catch (IMException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                }
                catch (UuidException e) {
                    Logger.error((Throwable)e);
                }
                catch (SQLException e) {
                    Logger.error((Throwable)e);
                }
            }
        }
        return unitInfo;
    }

    private TaxClassificationCodeInfo getTaxClassificationCode(Context ctx, Hashtable hsData) throws TaskExternalException {
        TaxClassificationCodeInfo taxClassficationInfo;
        block7: {
            taxClassficationInfo = null;
            String fTaxClassification = this.getString(hsData, "FTaxClassificationCode_number");
            String sql = " select top 1 fnumber, fid, fname_l2, ftaxrate,FParentNum,FSIMPLENAME,FVATSpecialManagement,fmergeCode  from T_IM_TaxClassificationCode where fnumber = ? and FSumItem = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{fTaxClassification, "N"});
                if (rs != null && rs.next()) {
                    taxClassficationInfo = new TaxClassificationCodeInfo();
                    taxClassficationInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                    taxClassficationInfo.setName(rs.getString("fname_l2"));
                    taxClassficationInfo.setTaxRate(rs.getBigDecimal("ftaxRate"));
                    taxClassficationInfo.setParentNum(rs.getString("FParentNum"));
                    taxClassficationInfo.setSimpleName(rs.getString("FSIMPLENAME"));
                    taxClassficationInfo.setVATSpecialManagement(rs.getString("FVATSpecialManagement"));
                    taxClassficationInfo.setMergeCode(rs.getString("fmergeCode"));
                    taxClassficationInfo.setNumber(fTaxClassification);
                    break block7;
                }
                try {
                    throw new IMException(IMException.TAXCLASSIFICATION_ERROR);
                }
                catch (IMException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return taxClassficationInfo;
    }

    private MaterialInfo checkMaterial(Context ctx, String srcNumber) throws TaskExternalException {
        MaterialInfo materialInfo = null;
        String materialNumber = srcNumber;
        if (materialNumber != null && materialNumber.length() > 0) {
            String sql = " select top 1 fid, fname_l2, fnumber,FModel,FBaseUnit from t_bd_material where fnumber = ? ";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{materialNumber});
                if (null != rs && rs.next()) {
                    materialInfo = new MaterialInfo();
                    materialInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                    materialInfo.setNumber(rs.getString("fnumber"));
                    materialInfo.setName(rs.getString("fname_l2"));
                    materialInfo.setModel(rs.getString("FModel"));
                    if (!IMUtils.isEmpty(rs.getString("FBaseUnit"))) {
                        MeasureUnitInfo measureUnit = new MeasureUnitInfo();
                        measureUnit.setId(BOSUuid.read((String)rs.getString("FBaseUnit")));
                        materialInfo.setBaseUnit(measureUnit);
                    }
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return materialInfo;
    }

    private ExpenseTypeInfo checkChargeItem(Context ctx, String srcNumber) throws TaskExternalException {
        String chargeItemNumber = srcNumber;
        ExpenseTypeInfo expense = new ExpenseTypeInfo();
        if (chargeItemNumber != null && chargeItemNumber.length() > 0) {
            String sql = " select top 1 fid, fname_l2, fnumber from T_BC_ExpenseType where fnumber = ? ";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{chargeItemNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "ExpenseItemNotExists", ctx.getLocale()));
                }
                expense.setId(BOSUuid.read((String)rs.getString("fid")));
                expense.setNumber(rs.getString("fnumber"));
                expense.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return expense;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkExpenseType(Context ctx, String srcNumber) throws TaskExternalException {
        String expenseTypeNumber = srcNumber;
        if (expenseTypeNumber == null || expenseTypeNumber.length() <= 0) return;
        String sql = " select top 1 fid, fname_l2, fnumber from T_BC_ExpenseType where fnumber = ? ";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{expenseTypeNumber});
            if (null != rs && !rs.next()) return;
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
            return;
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
        }
    }

    protected void checkStatus(Context ctx, String number) throws TaskExternalException {
        if (this.isSltImportUpdate() && !StringUtils.isEmpty((String)number)) {
            String sql = " select top 1 fid, FStatus  from t_im_productcode where fnumber = ? ";
            IRowSet rs = null;
            try {
                int status;
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{number});
                if (null != rs && rs.next() && (status = rs.getInt("FStatus")) == 0) {
                    throw new TaskExternalException(ResourceBase.getString((String)resClassName, (String)"ImportPorduct_StatusError", (Locale)ctx.getLocale(), (Object[])new Object[]{number}));
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.ProductCodeQuery";
    }
}

