/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im;

import com.alibaba.fastjson.JSON;
import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.Kson;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.SpecificInformationEntryCollection;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.app.util.SpecificServiceServerUtils;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetFactory;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.ICommunicationSet;
import com.kingdee.eas.tm.im.common.uihelper.SpecificServiceFieldProperties;
import com.kingdee.eas.tm.im.imExtend.PwyHelperExtend;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PwyHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.PwyHelper");

    public Map getCASjd(String ca) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("ca", ca);
        return sjdMap;
    }

    public Map getTaxCardSjd() {
        return new HashMap();
    }

    public Map getOpenDiskSjd() {
        return new HashMap();
    }

    public Map getCloseDiskSjd() {
        return new HashMap();
    }

    public Map getSjd4ServerEleInvoice(Context ctx, MakeInvoiceInfo info) throws BOSException {
        CompanyOrgUnitInfo companyOrgInfo = info.getCompany();
        HashMap<String, Object> sjdMap = new HashMap<String, Object>();
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", PwyHelper.md5(info.getId().toString()));
        }
        sjdMap.put("mdid", "");
        sjdMap.put("hsbz", "0");
        sjdMap.put("qdbz", "0");
        if (info.isIsList()) {
            sjdMap.put("qdbz", "1");
        } else {
            sjdMap.put("qdbz", "0");
        }
        sjdMap.put("ddh", info.getNumber());
        sjdMap.put("kplx", info.isIsRedVoice() ? "1" : "0");
        sjdMap.put("yfpdm", "");
        sjdMap.put("yfphm", "");
        String taxNo = companyOrgInfo.getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        sjdMap.put("xhf_nsrsbh", this.dealNullString(taxNo));
        sjdMap.put("xhf_mc", this.dealNullString(companyOrgInfo.getRegisteredCode()));
        sjdMap.put("xhf_dzdh", this.dealNullString(companyOrgInfo.getTaxAddress()) + this.dealNullString(companyOrgInfo.getContactPhone()));
        sjdMap.put("xhf_dz", "");
        sjdMap.put("xhf_dh", "");
        String bankNo = "";
        if (companyOrgInfo.getBank() != null) {
            bankNo = companyOrgInfo.getBank().getName();
        }
        sjdMap.put("xhf_yhzh", this.dealNullString(bankNo) + this.dealNullString(companyOrgInfo.getBankAccount()));
        sjdMap.put("ghf_nsrsbh", this.dealNullString(info.getTaxNumber()));
        sjdMap.put("ghf_mc", this.dealNullString(info.getReceiveCompany()));
        sjdMap.put("ghf_sj", this.dealNullString(info.getCellphone()));
        sjdMap.put("ghf_dzdh", info.getAddress() == null ? "" : (info.getAddress() + " " + info.getTel() == null ? "" : info.getTel()));
        sjdMap.put("ghf_yhzh", this.dealNullString(info.getBankAccount()));
        sjdMap.put("ghf_dh", "");
        sjdMap.put("czdm", "10");
        sjdMap.put("tschbz", "0");
        sjdMap.put("bz", this.mkRemarkformatterConver(info.getRemark()));
        if (this.isaddSpecInfo(info)) {
            sjdMap.put("tdyslxDm", info.getSpecificService() != null ? info.getSpecificService().getValue() : "");
            this.addSpecInformationParams(info, sjdMap, ctx);
        }
        sjdMap.put("hjbhsje", this.bigDecimalToZeroString(info.getNoTaxAmtTotal()));
        sjdMap.put("jshjje", this.bigDecimalToZeroString(info.getPriceTaxTotal()));
        sjdMap.put("kphjse", this.bigDecimalToZeroString(info.getTaxAmtTotal()));
        UserInfo user = null;
        user = ctx != null ? (UserInfo)ctx.get((Object)"UserInfo") : SysContext.getSysContext().getCurrentUserInfo();
        sjdMap.put("kpy", info.getDrawertxt() != null ? info.getDrawertxt() : user.getName());
        sjdMap.put("sky", info.getPayeetxt() != null ? info.getPayeetxt() : "");
        sjdMap.put("fhr", info.getChecktxt() != null ? info.getChecktxt() : "");
        ArrayList items = new ArrayList();
        sjdMap.put("items", items);
        for (int j = 0; j < info.getEntries().size(); ++j) {
            MakeInvoiceEntryInfo entryInfo = info.getEntries().get(j);
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("byzd1", "");
            if (this.isGGXHEmpty(info)) {
                entryMap.put("ggxh", "");
            } else {
                entryMap.put("ggxh", entryInfo.getSpecs() == null ? "" : entryInfo.getSpecs());
            }
            entryMap.put("ggxh", entryInfo.getSpecs() == null ? "" : entryInfo.getSpecs());
            entryMap.put("se", this.bigDecimalToZeroString(entryInfo.getTaxAmt()));
            entryMap.put("sl", this.bigDecimalToZeroString(entryInfo.getTaxRate()));
            entryMap.put("lslbs", "");
            entryMap.put("spbm", entryInfo.getEntryName().getTaxClassificationCode().getMergeCode());
            if (entryInfo.getNoTaxPrice() != null) {
                if (this.isXMDJEmpty(info)) {
                    entryMap.put("xmdj", "");
                } else {
                    entryMap.put("xmdj", this.bigDecimalToString(entryInfo.getNoTaxPrice()));
                }
            }
            if (entryInfo.getNoTaxAmt() != null) {
                entryMap.put("xmje", this.bigDecimalToString(entryInfo.getNoTaxAmt()));
            }
            if (this.isXMDWEmpty(info)) {
                entryMap.put("xmdw", "");
            } else {
                entryMap.put("xmdw", PwyHelper.getProductUnit(entryInfo));
            }
            boolean isDiscountRow = false;
            RowType rowType = entryInfo.getBillRowType();
            String xmlx = "0";
            if (rowType != null && 1 == rowType.getValue()) {
                xmlx = "2";
            }
            if (rowType != null && 2 == rowType.getValue()) {
                isDiscountRow = true;
                xmlx = "1";
            }
            entryMap.put("xmlx", xmlx);
            if (entryInfo.getEntryName() != null) {
                entryMap.put("xmmc", entryInfo.getEntryName().getName());
            } else {
                entryMap.put("xmmc", "");
            }
            if (this.isXMSLEmpty(info)) {
                entryMap.put("xmsl", "");
            } else {
                entryMap.put("xmsl", this.bigDecimalToString(entryInfo.getQuantity()));
            }
            if (isDiscountRow) {
                entryMap.put("xmsl", "-1");
                if (this.isXMDJEmpty(info)) {
                    entryMap.put("xmdj", "");
                } else {
                    entryMap.put("xmdj", this.bigDecimalToString(entryInfo.getNoTaxAmt().abs()));
                }
            }
            entryMap.put("yhzcbs", "0");
            entryMap.put("zxbm", "");
            entryMap.put("zzstsgl", "");
            Map<Object, Object> taxcodeMap = new HashMap();
            taxcodeMap = this.buildTaxCodeMap(entryInfo, ctx);
            entryMap.put("lslbs", taxcodeMap.get("lslbs"));
            entryMap.put("yhzcbs", taxcodeMap.get("ssyhzc"));
            entryMap.put("zzstsgl", taxcodeMap.get("ssyhzcnr"));
            items.add(entryMap);
        }
        return sjdMap;
    }

    private boolean isConstructionService(MakeInvoiceInfo info) {
        return (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType())) && SpecificServiceEnum.ConstructionService.equals((Object)info.getSpecificService());
    }

    private boolean isEstateOperate(MakeInvoiceInfo info) {
        return (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType())) && SpecificServiceEnum.EstateOperate.equals((Object)info.getSpecificService());
    }

    private boolean isEstateSaleService(MakeInvoiceInfo info) {
        return (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType())) && SpecificServiceEnum.EstateSaleService.equals((Object)info.getSpecificService());
    }

    protected boolean isXMSLEmpty(MakeInvoiceInfo info) {
        return this.isConstructionService(info);
    }

    protected boolean isGGXHEmpty(MakeInvoiceInfo info) {
        return this.isConstructionService(info) || this.isEstateOperate(info) || this.isEstateSaleService(info);
    }

    protected boolean isXMDWEmpty(MakeInvoiceInfo info) {
        return this.isConstructionService(info) || this.isEstateOperate(info) || this.isEstateSaleService(info);
    }

    protected boolean isXMDJEmpty(MakeInvoiceInfo info) {
        return this.isConstructionService(info);
    }

    private boolean isaddSpecInfo(MakeInvoiceInfo info) {
        return (PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)info.getInvoiceType())) && !SpecificServiceEnum.Normal.equals((Object)info.getSpecificService());
    }

    public Map getSjd4ServerRedEleInvoice(Context ctx, MakeInvoiceInfo info) throws BOSException {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("byzd1", "");
        sjdMap.put("byzd2", "");
        sjdMap.put("byzd3", "");
        sjdMap.put("byzd4", "");
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", info.getInvoiceSn());
        }
        sjdMap.put("new_fpqqlsh", "");
        return sjdMap;
    }

    private String mkRemarkformatterConver(String remark) {
        if (!StringUtils.isEmpty((String)remark)) {
            remark = remark.replaceAll("\r\n", "\n");
            remark = remark.replaceAll("\n", "\r\n");
        }
        return remark == null ? "" : remark;
    }

    public Map getSjd4ClientEleInvoice(MakeInvoiceInfo info, Context ctx) throws BOSException {
        String taxNo;
        HashMap<String, Object> sjdMap = new HashMap<String, Object>();
        sjdMap.put("byzd1", "");
        sjdMap.put("byzd2", "");
        sjdMap.put("byzd3", "");
        sjdMap.put("byzd4", "");
        if (info.isIsRedVoice()) {
            if (info.getRushRedReason() != null) {
                sjdMap.put("hcyy", info.getRushRedReason().getValue());
            }
            if (info.getBlueInvoiceType() != null) {
                if ("0".equals(info.getBlueInvoiceType().getValue())) {
                    sjdMap.put("dylppz", "2");
                } else if ("2".equals(info.getBlueInvoiceType().getValue())) {
                    sjdMap.put("dylppz", "51");
                }
            }
            if (info.getBlueInvoiceDate() != null) {
                sjdMap.put("dylpkprq", PwyHelper.getDateFormatter(info.getBlueInvoiceDate()));
            }
        }
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", PwyHelper.md5(info.getId().toString()));
        }
        sjdMap.put("ddh", info.getNumber());
        sjdMap.put("hsbz", "0");
        if ("2".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "51");
        } else if ("3".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "61");
        } else if ("4".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "26");
        } else if ("5".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "27");
        }
        if (info.isIsRedVoice()) {
            sjdMap.put("kplx", "1");
            sjdMap.put("yfpdm", info.getBlueVoiceCode());
            sjdMap.put("yfphm", info.getBlueVoiceNum());
        } else {
            sjdMap.put("kplx", "0");
            sjdMap.put("yfpdm", "");
            sjdMap.put("yfphm", "");
        }
        sjdMap.put("ylbz", "0");
        sjdMap.put("dkbz", "0");
        sjdMap.put("kpxm", "");
        sjdMap.put("tschbz", "0");
        sjdMap.put("czdm", "10");
        if (info.isIsList()) {
            Locale locale = ctx == null ? IMUtils.getLocale() : ctx.getLocale();
            String saleList = IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "SALES_LIST_FOR_DETAIL", locale);
            sjdMap.put("qdbz", "1");
            sjdMap.put("qdxmmc", saleList);
        } else {
            sjdMap.put("qdbz", "0");
            sjdMap.put("qdxmmc", "");
        }
        CompanyOrgUnitInfo companyInfo = TaxManageCustomerImpl.getMakeInvoiceInfo(ctx, StringUtils.isEmpty((String)info.getMakeInvoiceOrgID()) ? info.getCompany().getId().toString() : info.getMakeInvoiceOrgID());
        if (companyInfo == null) {
            companyInfo = info.getCompany();
        }
        if (!StringUtils.isEmpty((String)(taxNo = companyInfo.getTaxNumber()))) {
            taxNo = taxNo.trim();
        }
        sjdMap.put("xhf_nsrsbh", this.dealNullString(taxNo));
        sjdMap.put("xhf_mc", this.dealNullString(companyInfo.getRegisteredCode()));
        sjdMap.put("xhf_dzdh", this.dealNullString(companyInfo.getTaxAddress()) + this.dealNullString(companyInfo.getContactPhone()));
        String bankNo = "";
        if (companyInfo.getBank() != null) {
            bankNo = companyInfo.getBank().getName();
        }
        sjdMap.put("xhf_yhzh", this.dealNullString(bankNo) + this.dealNullString(companyInfo.getBankAccount()));
        if (info.getRecBillEmail() != null) {
            sjdMap.put("ghf_email", info.getRecBillEmail());
        } else {
            sjdMap.put("ghf_email", "");
        }
        sjdMap.put("ghf_nsrsbh", this.dealNullString(info.getTaxNumber()));
        sjdMap.put("ghf_mc", this.dealNullString(info.getReceiveCompany()));
        sjdMap.put("ghf_sj", this.dealNullString(info.getCellphone()));
        sjdMap.put("ghf_openid", "");
        sjdMap.put("ghf_dzdh", this.dealNullString(info.getAddress()));
        sjdMap.put("ghf_yhzh", this.dealNullString(this.dealNullString(info.getBankAccount())));
        UserInfo user = null;
        user = ctx != null ? (UserInfo)ctx.get((Object)"UserInfo") : SysContext.getSysContext().getCurrentUserInfo();
        sjdMap.put("kpy", info.getDrawertxt() != null ? info.getDrawertxt() : user.getName());
        sjdMap.put("sky", info.getPayeetxt() != null ? info.getPayeetxt() : "");
        sjdMap.put("fhr", info.getChecktxt() != null ? info.getChecktxt() : "");
        sjdMap.put("hjbhsje", this.bigDecimalToZeroString(info.getNoTaxAmtTotal()));
        sjdMap.put("kphjse", this.bigDecimalToZeroString(info.getTaxAmtTotal()));
        sjdMap.put("jshjje", this.bigDecimalToZeroString(info.getPriceTaxTotal()));
        sjdMap.put("bz", this.dealNullString(this.mkRemarkformatterConver(info.getRemark())));
        if (this.isaddSpecInfo(info)) {
            sjdMap.put("tdyslxDm", info.getSpecificService() != null ? info.getSpecificService().getValue() : "");
            this.addSpecInformationParams(info, sjdMap, ctx);
        }
        ArrayList items = new ArrayList();
        sjdMap.put("items", items);
        for (int j = 0; j < info.getEntries().size(); ++j) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            MakeInvoiceEntryInfo entryInfo = info.getEntries().get(j);
            if (entryInfo.getEntryName() != null && entryInfo.getEntryName().getTaxData() != null) {
                entryMap.put("sm", "20105");
            } else {
                entryMap.put("sm", "");
            }
            if (entryInfo.getProduceName() != null) {
                entryMap.put("xmmc", entryInfo.getProduceName());
            } else if (entryInfo.getEntryName() != null) {
                entryMap.put("xmmc", entryInfo.getEntryName().getName());
            } else {
                entryMap.put("xmmc", "");
            }
            boolean isDiscountRow = false;
            RowType rowType = entryInfo.getBillRowType();
            String xmlx = "0";
            if (rowType != null && 1 == rowType.getValue()) {
                xmlx = "2";
            }
            if (rowType != null && 2 == rowType.getValue()) {
                isDiscountRow = true;
                xmlx = "1";
            }
            entryMap.put("xmlx", xmlx);
            if (this.isXMDWEmpty(info)) {
                entryMap.put("xmdw", "");
            } else {
                entryMap.put("xmdw", PwyHelper.getProductUnit(entryInfo));
            }
            if (this.isGGXHEmpty(info)) {
                entryMap.put("ggxh", "");
            } else {
                entryMap.put("ggxh", entryInfo.getSpecs() == null ? "" : entryInfo.getSpecs());
            }
            if (this.isXMSLEmpty(info)) {
                entryMap.put("xmsl", "");
            } else {
                entryMap.put("xmsl", this.bigDecimalToString(entryInfo.getQuantity()));
            }
            entryMap.put("xmdj", "");
            entryMap.put("xmje", "");
            if (entryInfo.getNoTaxPrice() != null && !this.isXMDJEmpty(info)) {
                entryMap.put("xmdj", this.bigDecimalToString(entryInfo.getNoTaxPrice().abs()));
            }
            if (entryInfo.getNoTaxAmt() != null) {
                entryMap.put("xmje", this.bigDecimalToString(entryInfo.getNoTaxAmt()));
            }
            if (isDiscountRow) {
                entryMap.put("xmsl", "-1");
                if (!this.isXMDJEmpty(info)) {
                    entryMap.put("xmdj", this.bigDecimalToString(entryInfo.getNoTaxAmt().abs()));
                }
            }
            entryMap.put("se", this.bigDecimalToZeroString(entryInfo.getTaxAmt()));
            entryMap.put("sl", this.bigDecimalToZeroString(entryInfo.getTaxRate()));
            entryMap.put("byzd1", "");
            entryMap.put("byzd2", "");
            entryMap.put("byzd3", "");
            Map<String, String> taxCodeMap = this.buildTaxCodeMap(entryInfo, ctx);
            if (taxCodeMap.size() == 0 && !StringUtils.isEmpty((String)entryInfo.getProduceName()) && entryInfo.getProduceName().contains("\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355")) {
                taxCodeMap.put("ssflbm", "");
                taxCodeMap.put("lslbs", "");
                taxCodeMap.put("ssyhzc", "");
                taxCodeMap.put("bmbb", "");
                taxCodeMap.put("kce", "");
                taxCodeMap.put("ssyhzcnr", "");
                taxCodeMap.put("qyzbm", "");
            }
            entryMap.put("taxcode", taxCodeMap);
            items.add(entryMap);
        }
        return sjdMap;
    }

    public static String getProductUnit(MakeInvoiceEntryInfo entryInfo) {
        String productUnit = PwyHelperExtend.getProductUnit(entryInfo);
        if (StringUtils.isEmpty((String)productUnit)) {
            productUnit = entryInfo.getMakeInvoiceUnit();
        }
        if (StringUtils.isEmpty((String)productUnit)) {
            productUnit = "";
        }
        return productUnit;
    }

    private Map<String, String> buildTaxCodeMap(MakeInvoiceEntryInfo entryInfo, Context ctx) {
        HashMap<String, String> taxCodeMap = new HashMap<String, String>();
        TaxClassificationCodeInfo taxCode = null;
        try {
            if (entryInfo.getTaxClassificationCode() != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)entryInfo.getTaxClassificationCode()));
                view.setFilter(filter);
                CoreBaseCollection collection = null;
                collection = ctx != null ? TaxClassificationCodeFactory.getLocalInstance(ctx).getCollection(view) : TaxClassificationCodeFactory.getRemoteInstance().getCollection(view);
                if (collection.size() > 0) {
                    taxCode = (TaxClassificationCodeInfo)collection.get(0);
                }
            }
            if (taxCode == null && entryInfo.getEntryName() != null) {
                taxCode = entryInfo.getEntryName().getTaxClassificationCode();
            }
        }
        catch (BOSException e) {
            logger.error((Object)("Get TCC : " + e.getMessage()));
        }
        if (taxCode != null) {
            taxCodeMap.put("bmbb", taxCode.getCodeTableVersion());
            taxCodeMap.put("kce", entryInfo.getDeductAmt() == null ? "" : this.bigDecimalToZeroString(entryInfo.getDeductAmt()));
            if (entryInfo.getTaxRate() == null || entryInfo.getTaxRate().compareTo(BigDecimal.ZERO) == 0) {
                if (entryInfo.isHasPreferential()) {
                    if (PreferentialPoliciesEnum.DutyFree.equals((Object)entryInfo.getPreferentialPolicies())) {
                        taxCodeMap.put("lslbs", "1");
                    } else if (PreferentialPoliciesEnum.NoTaxation.equals((Object)entryInfo.getPreferentialPolicies())) {
                        taxCodeMap.put("lslbs", "2");
                    }
                } else {
                    taxCodeMap.put("lslbs", "3");
                }
            } else {
                taxCodeMap.put("lslbs", "");
            }
            taxCodeMap.put("ssyhzc", entryInfo.isHasPreferential() ? "1" : "0");
            taxCodeMap.put("ssyhzcnr", entryInfo.getPreferentialPolicies() == null ? "" : entryInfo.getPreferentialPolicies().getAlias());
            taxCodeMap.put("qyzbm", taxCode.getNumber().toString());
            taxCodeMap.put("ssflbm", taxCode.getMergeCode().toString());
        } else {
            logger.error((Object)"TCC Null ");
        }
        return taxCodeMap;
    }

    public Map getSjd4ClientRedEleInvoice(MakeInvoiceInfo info, Context ctx) throws BOSException {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("byzd1", "");
        sjdMap.put("byzd2", "");
        sjdMap.put("byzd3", "");
        sjdMap.put("byzd4", "");
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", info.getInvoiceSn());
        }
        sjdMap.put("new_fpqqlsh", "");
        return sjdMap;
    }

    public Map getMakeInvoiceSjd(MakeInvoiceInfo info, Context ctx) throws BOSException {
        String taxNo;
        HashMap<String, Object> sjdMap = new HashMap<String, Object>();
        sjdMap.put("byzd1", "");
        sjdMap.put("byzd2", "");
        sjdMap.put("byzd3", "");
        sjdMap.put("byzd4", "");
        if (info.isIsRedVoice()) {
            if (info.getRushRedReason() != null) {
                sjdMap.put("hcyy", info.getRushRedReason().getValue());
            }
            if (info.getBlueInvoiceType() != null) {
                if ("0".equals(info.getBlueInvoiceType().getValue())) {
                    sjdMap.put("dylppz", "2");
                } else if ("2".equals(info.getBlueInvoiceType().getValue())) {
                    sjdMap.put("dylppz", "51");
                }
            }
            if (info.getBlueInvoiceDate() != null) {
                sjdMap.put("dylpkprq", PwyHelper.getDateFormatter(info.getBlueInvoiceDate()));
            }
        }
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", PwyHelper.md5(info.getId().toString()));
        }
        sjdMap.put("ddh", info.getNumber());
        sjdMap.put("hsbz", "0");
        if ("0".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "2");
        } else if ("1".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "0");
        } else if ("2".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "51");
        } else if ("3".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "61");
        } else if ("4".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "26");
        } else if ("5".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("kpzl", "27");
        }
        if (info.isIsRedVoice()) {
            sjdMap.put("kplx", "1");
            sjdMap.put("yfpdm", info.getBlueVoiceCode());
            sjdMap.put("yfphm", info.getBlueVoiceNum());
        } else {
            sjdMap.put("kplx", "0");
            sjdMap.put("yfpdm", "");
            sjdMap.put("yfphm", "");
        }
        sjdMap.put("ylbz", "0");
        if (info.isIsList()) {
            sjdMap.put("qdbz", "1");
        } else {
            sjdMap.put("qdbz", "0");
        }
        CompanyOrgUnitInfo companyInfo = TaxManageCustomerImpl.getMakeInvoiceInfo(ctx, StringUtils.isEmpty((String)info.getMakeInvoiceOrgID()) ? info.getCompany().getId().toString() : info.getMakeInvoiceOrgID());
        if (companyInfo == null) {
            companyInfo = info.getCompany();
        }
        if (!StringUtils.isEmpty((String)(taxNo = companyInfo.getTaxNumber()))) {
            taxNo = taxNo.trim();
        }
        sjdMap.put("xhf_nsrsbh", this.dealNullString(taxNo));
        sjdMap.put("xhf_mc", this.dealNullString(companyInfo.getRegisteredCode()));
        sjdMap.put("xhf_dzdh", this.dealNullString(companyInfo.getTaxAddress()) + this.dealNullString(companyInfo.getContactPhone()));
        String bankNo = "";
        if (companyInfo.getBank() != null) {
            bankNo = companyInfo.getBank().getName();
        }
        sjdMap.put("xhf_yhzh", this.dealNullString(bankNo) + this.dealNullString(companyInfo.getBankAccount()));
        sjdMap.put("ghf_nsrsbh", this.dealNullString(info.getTaxNumber()));
        sjdMap.put("ghf_mc", this.dealNullString(info.getReceiveCompany()));
        sjdMap.put("ghf_sj", this.dealNullString(info.getCellphone()));
        if ("2".equals(info.getInvoiceType().getValue()) || "3".equals(info.getInvoiceType().getValue()) || "4".equals(info.getInvoiceType().getValue()) || "5".equals(info.getInvoiceType().getValue())) {
            sjdMap.put("ghf_email", this.dealNullString(info.getRecBillEmail()));
        }
        sjdMap.put("ghf_openid", "");
        sjdMap.put("ghf_dzdh", this.dealNullString(info.getAddress()));
        sjdMap.put("ghf_yhzh", this.dealNullString(info.getBankAccount()));
        UserInfo user = null;
        user = ctx != null ? (UserInfo)ctx.get((Object)"UserInfo") : SysContext.getSysContext().getCurrentUserInfo();
        sjdMap.put("kpy", info.getDrawertxt() != null ? info.getDrawertxt() : user.getName());
        sjdMap.put("sky", info.getPayeetxt() != null ? info.getPayeetxt() : "");
        sjdMap.put("fhr", info.getChecktxt() != null ? info.getChecktxt() : "");
        sjdMap.put("hjbhsje", this.bigDecimalToZeroString(info.getNoTaxAmtTotal()));
        sjdMap.put("kphjse", this.bigDecimalToZeroString(info.getTaxAmtTotal()));
        sjdMap.put("jshjje", this.bigDecimalToZeroString(info.getPriceTaxTotal()));
        sjdMap.put("bz", this.dealNullString(this.mkRemarkformatterConver(info.getRemark())));
        if (this.isaddSpecInfo(info)) {
            sjdMap.put("tdyslxDm", info.getSpecificService() != null ? info.getSpecificService().getValue() : "");
            this.addSpecInformationParams(info, sjdMap, ctx);
        }
        ArrayList items = new ArrayList();
        sjdMap.put("items", items);
        for (int j = 0; j < info.getEntries().size(); ++j) {
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            MakeInvoiceEntryInfo entryInfo = info.getEntries().get(j);
            if (entryInfo.getEntryName() != null && entryInfo.getEntryName().getTaxData() != null) {
                entryMap.put("sm", "20105");
            } else {
                entryMap.put("sm", "");
            }
            if (entryInfo.getProduceName() != null) {
                entryMap.put("xmmc", entryInfo.getProduceName());
            } else if (entryInfo.getEntryName() != null) {
                entryMap.put("xmmc", entryInfo.getEntryName().getName());
            } else {
                entryMap.put("xmmc", "");
            }
            boolean isDiscountRow = false;
            RowType rowType = entryInfo.getBillRowType();
            String xmlx = "0";
            if (rowType != null && 1 == rowType.getValue()) {
                xmlx = "2";
            }
            if (rowType != null && 2 == rowType.getValue()) {
                isDiscountRow = true;
                xmlx = "1";
            }
            entryMap.put("xmlx", xmlx);
            if (this.isXMDWEmpty(info)) {
                entryMap.put("xmdw", "");
            } else {
                entryMap.put("xmdw", PwyHelper.getProductUnit(entryInfo));
            }
            if (this.isGGXHEmpty(info)) {
                entryMap.put("ggxh", "");
            } else {
                entryMap.put("ggxh", entryInfo.getSpecs() == null ? "" : entryInfo.getSpecs());
            }
            if (entryInfo.getQuantity() != null) {
                if (this.isXMSLEmpty(info)) {
                    entryMap.put("xmsl", "");
                } else {
                    entryMap.put("xmsl", entryInfo.getQuantity().toString());
                }
            } else {
                entryMap.put("xmsl", "0");
            }
            entryMap.put("xmdj", "");
            entryMap.put("xmje", "");
            if (entryInfo.getNoTaxPrice() != null && !this.isXMDJEmpty(info)) {
                entryMap.put("xmdj", entryInfo.getNoTaxPrice().abs().toString());
            }
            if (entryInfo.getNoTaxAmt() != null) {
                entryMap.put("xmje", entryInfo.getNoTaxAmt().toString());
            }
            if (isDiscountRow) {
                entryMap.put("xmsl", "-1");
                if (!this.isXMDJEmpty(info)) {
                    entryMap.put("xmdj", this.bigDecimalToString(entryInfo.getNoTaxAmt().abs()));
                }
            }
            entryMap.put("se", this.bigDecimalToZeroString(entryInfo.getTaxAmt()));
            entryMap.put("sl", this.bigDecimalToZeroString(entryInfo.getTaxRate()));
            entryMap.put("byzd1", "");
            entryMap.put("byzd2", "");
            entryMap.put("byzd3", "");
            Map<Object, Object> taxCodeMap = new HashMap();
            taxCodeMap = this.buildTaxCodeMap(entryInfo, ctx);
            if (taxCodeMap.size() == 0 && !StringUtils.isEmpty((String)entryInfo.getProduceName()) && entryInfo.getProduceName().contains("\u8be6\u89c1\u5bf9\u5e94\u6b63\u6570\u53d1\u7968\u53ca\u6e05\u5355")) {
                taxCodeMap.put("ssflbm", "");
                taxCodeMap.put("lslbs", "");
                taxCodeMap.put("ssyhzc", "");
                taxCodeMap.put("bmbb", "");
                taxCodeMap.put("kce", "");
                taxCodeMap.put("ssyhzcnr", "");
                taxCodeMap.put("qyzbm", "");
            }
            entryMap.put("taxcode", taxCodeMap);
            items.add(entryMap);
        }
        return sjdMap;
    }

    public Map getSaleRedInvoiceReqSjd(Map params) {
        String invoiceNumber = (String)params.get("invoiceNumber");
        String invoiceNo = (String)params.get("invoiceNo");
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", invoiceNumber);
        sjdMap.put("fphm", invoiceNo);
        sjdMap.putAll(params);
        sjdMap.put("reqmemo", "2");
        return sjdMap;
    }

    public Map getRedInvoiceQuery(Context ctx, MakeInvoiceInfo info, Map params) {
        String kjfTaxCode = info.getCompany().getTaxNumber();
        if (!StringUtils.isEmpty((String)kjfTaxCode)) {
            kjfTaxCode = kjfTaxCode.trim();
        }
        String deviceNumber = (String)params.get("deviceNumber");
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("kjf_jh", "0");
        sjdMap.put("kjf_nsrsbh", kjfTaxCode);
        sjdMap.put("kjf_sbbh", deviceNumber);
        sjdMap.put("qstkrq", "");
        sjdMap.put("jstkrq", "");
        sjdMap.put("xxbbh", "");
        sjdMap.put("xzfw", "0");
        sjdMap.put("yqzt", "N");
        sjdMap.put("pageno", "1");
        sjdMap.put("pagesize", "10");
        return sjdMap;
    }

    public Map getGoldTaxDiskInfoSid() {
        return new HashMap();
    }

    public Map getPrintInvoiceSjd(MakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getInvoiceNumber());
        sjdMap.put("fphm", info.getInvoiceNo());
        sjdMap.put("kpzl", info.getInvoiceType().getValue() == "1" ? "0" : "2");
        sjdMap.put("ylbz", "0");
        return sjdMap;
    }

    public Map getPrintInvoiceListSjd(MakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getInvoiceNumber());
        sjdMap.put("fphm", info.getInvoiceNo());
        sjdMap.put("kpzl", info.getInvoiceType().getValue() == "1" ? "0" : "2");
        sjdMap.put("ylbz", "0");
        return sjdMap;
    }

    public Map getCancelInvoiceSjd(MakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        sjdMap.put("fpdm", info.getInvoiceNumber());
        sjdMap.put("fphm", info.getInvoiceNo());
        sjdMap.put("kpzl", info.getInvoiceType().getValue() == "1" ? "0" : "2");
        return sjdMap;
    }

    public Map getQueryElecInvoiceSjd(MakeInvoiceInfo info) {
        HashMap<String, String> sjdMap = new HashMap<String, String>();
        if (PwyHelperExtend.getFpqqlsh(info) != null) {
            sjdMap.put("fpqqlsh", PwyHelperExtend.getFpqqlsh(info));
        } else {
            sjdMap.put("fpqqlsh", info.getInvoiceSn());
        }
        return sjdMap;
    }

    public Map getHead(String czlx, String authCode, String tid) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("czlx", czlx);
        jsonMap.put("authcode", authCode);
        if (czlx == "110" || czlx == "3" || czlx == "100") {
            jsonMap.put("tidtype", "1");
        }
        jsonMap.put("tid", tid);
        jsonMap.put("byzd1", "");
        jsonMap.put("byzd2", "");
        jsonMap.put("byzd3", "");
        jsonMap.put("byzd4", "");
        return jsonMap;
    }

    public static Map getSfrz(PwySettingInfo setting) {
        HashMap<String, String> sfrzMap = new HashMap<String, String>();
        String client_id = setting.getClientId();
        String client_secret = setting.getClientSecret();
        String timestamp = String.valueOf(new Date().getTime());
        timestamp = timestamp.substring(0, 10);
        String sign = PwyHelper.StringToMD5(client_id + client_secret + timestamp);
        sfrzMap.put("client_id", client_id);
        sfrzMap.put("sign", sign);
        sfrzMap.put("timestamp", timestamp);
        return sfrzMap;
    }

    public Map getSfrzForMakeInvoice(PwySettingInfo setting) {
        HashMap<String, String> sfrzMap = new HashMap<String, String>();
        String client_id = setting.getClientId();
        String client_secret = setting.getClientSecret();
        String timestamp = String.valueOf(new Date().getTime());
        timestamp = timestamp.substring(0, 10);
        String signature = PwyHelper.StringToMD5(client_id + timestamp + client_secret);
        sfrzMap.put("client_id", client_id);
        sfrzMap.put("timestamp", timestamp);
        sfrzMap.put("signature", signature);
        return sfrzMap;
    }

    public Map getAuthcodeSjd(PwySettingInfo setting, String userID, String taxNo) throws BOSException {
        long timestamp = System.currentTimeMillis();
        String clientid = setting.getClientId();
        String clientSecret = setting.getClientSecret();
        String sign = PwyHelper.StringToMD5(clientid + clientSecret + timestamp);
        String eid = "";
        try {
            eid = URLEncoder.encode(userID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("client_id", clientid);
        map.put("timestamp", timestamp);
        map.put("sign", sign);
        map.put("eid", eid);
        map.put("isAdmin", "0");
        ArrayList<String> taxNos = new ArrayList<String>();
        taxNos.add(taxNo);
        map.put("taxNo", taxNos);
        return map;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    private static String StringToMD5(String input) {
        String md5str = null;
        if (input == null) {
            return "";
        }
        byte[] bytes = input.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = md.digest(bytes);
            md5str = PwyHelper.bytesToHex(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5str;
    }

    private String dealNullString(String str) {
        return str == null ? "" : str.trim();
    }

    public static Map getSfrz(String client_id, String client_secret) {
        HashMap<String, String> sfrzMap = new HashMap<String, String>();
        String timestamp = String.valueOf(new Date().getTime());
        timestamp = timestamp.substring(0, 10);
        String sign = PwyHelper.StringToMD5(client_id + client_secret + timestamp);
        sfrzMap.put("client_id", client_id);
        sfrzMap.put("sign", sign);
        sfrzMap.put("timestamp", timestamp);
        return sfrzMap;
    }

    public String getAccessToken(Context ctx, String clientId, String clientSecret) throws IMException {
        String baseUrl = "https://api.piaozone.com";
        try {
            ICommunicationSet comm = ctx == null ? CommunicationSetFactory.getRemoteInstance() : CommunicationSetFactory.getLocalInstance(ctx);
            CommunicationSetInfo info = comm.getCommunicationSetCollection().get(0);
            baseUrl = info.isIsPwyDev() ? info.getPwyURL() : info.getPwyDevURL();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        String tokenURL = baseUrl + "/base/oauth/token";
        Map tokenParamMap = PwyHelper.getSfrz(clientId, clientSecret);
        String accessToken = this.getAccessToken(tokenURL, tokenParamMap);
        return accessToken;
    }

    private String getAccessToken(String url, Map params) throws IMException {
        String accessToken = null;
        String result = null;
        String tokenParam = Kson.getGson().toJson((Object)params);
        try {
            logger.error((Object)("\u8bf7\u6c42accessToken\uff01 url : " + url + " tokenParam : " + tokenParam));
            result = HttpClientUtil.doPost((String)url, (String)tokenParam);
            logger.error((Object)("accessToken\u7ed3\u679c\uff01 result : " + result));
        }
        catch (Exception e) {
            logger.error((Object)("\u8bf7\u6c42accessToken\u5931\u8d25\uff01 url : " + url + " tokenParam : " + tokenParam));
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        JSONObject resultJson = null;
        try {
            resultJson = new JSONObject(result);
            String errcode = resultJson.getString("errcode");
            if (!"0000".equals(errcode)) {
                throw new IMException(IMException.ERRORMSG, new Object[]{resultJson.getString("description")});
            }
            accessToken = resultJson.getString("access_token");
        }
        catch (JSONException e) {
            if (resultJson != null) {
                logger.info((Object)("\u89e3\u6790accessToken\u5931\u8d25\uff01 resultJson : " + resultJson.toString()));
            }
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return accessToken;
    }

    public Map buildSalerRedParams(MakeInvoiceInfo info) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if ("1".equals(info.getInvoiceType().getValue())) {
            param.put("invoiceType", "0");
            param.put("kpzl", "0");
        } else if ("3".equals(info.getInvoiceType().getValue())) {
            param.put("invoiceType", "61");
            param.put("kpzl", "61");
        } else if ("4".equals(info.getInvoiceType().getValue())) {
            param.put("invoiceType", "26");
            param.put("kpzl", "26");
        } else if ("5".equals(info.getInvoiceType().getValue())) {
            param.put("invoiceType", "27");
            param.put("kpzl", "27");
        }
        param.put("invoiceNumber", info.getBlueVoiceCode());
        param.put("invoiceNo", info.getBlueVoiceNum());
        param.put("ghf_mc", info.getReceiveCompany());
        param.put("ghf_nsrsbh", this.dealNullString(info.getTaxNumber()));
        param.put("hjbhsje", this.bigDecimalToZeroString(info.getNoTaxAmtTotal()));
        param.put("hjse", this.bigDecimalToZeroString(info.getTaxAmtTotal()));
        param.put("hsbz", "0");
        param.put("sqsm", "2");
        param.put("szlb", "1");
        param.put("tkrq", "");
        if (info.getBlueInvoiceDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String blueInvoiceDate = sdf.format(info.getBlueInvoiceDate());
            param.put("kprq", blueInvoiceDate);
        }
        if (info.getRushRedReason() != null) {
            param.put("hcyy", info.getRushRedReason().getValue());
        }
        param.put("xhf_mc", info.getCompany().getRegisteredCode());
        String taxNo = info.getCompany().getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        param.put("xhf_nsrsbh", taxNo);
        if (info.isIsVehicle() && info.getRedMsgType() != null) {
            param.put("xxblx", info.getRedMsgType().getValue());
        } else {
            param.put("xxblx", "0");
        }
        ArrayList items = new ArrayList();
        for (int j = 0; j < info.getEntries().size(); ++j) {
            MakeInvoiceEntryInfo mkEntry = info.getEntries().get(j);
            HashMap<String, Object> entryMap = new HashMap<String, Object>();
            entryMap.put("ggxh", this.dealNullString(mkEntry.getSpecs()));
            entryMap.put("se", this.bigDecimalToZeroString(mkEntry.getTaxAmt()));
            entryMap.put("sl", this.bigDecimalToZeroString(mkEntry.getTaxRate()));
            entryMap.put("xmdj", this.bigDecimalToString(mkEntry.getNoTaxPrice()));
            if (mkEntry.getMeasureUnit() != null && mkEntry.getMeasureUnit().getName() != null) {
                entryMap.put("xmdw", mkEntry.getMeasureUnit().getName());
            } else {
                entryMap.put("xmdw", "");
            }
            entryMap.put("xmje", this.bigDecimalToString(mkEntry.getNoTaxAmt()));
            entryMap.put("xmmc", mkEntry.getProduceName());
            entryMap.put("xmsl", this.bigDecimalToString(mkEntry.getQuantity()));
            Map<String, String> taxCodeMap = this.buildTaxCodeMap(mkEntry, null);
            entryMap.put("taxcode", taxCodeMap);
            items.add(entryMap);
        }
        param.put("items", items);
        return param;
    }

    private void addSpecInformationParams(MakeInvoiceInfo info, Map params, Context ctx) {
        String specServiceType = info.getSpecificService().getValue();
        SpecificServiceServerUtils.refreshSpecServiceFieldMap(ctx);
        HashSet<String> panelSet = SpecificServiceServerUtils.specServicePanelMap.get(specServiceType);
        ArrayList<SpecificServiceFieldProperties> fields = SpecificServiceServerUtils.specServiceFieldMap.get(specServiceType);
        if (panelSet != null) {
            for (String s : panelSet) {
                if ("kDPSpeInfo".equals(s)) {
                    if (fields.size() <= 0 || info.getSpecificInformation() == null || IMUtils.isEmpty(info.getSpecificInformation().getSpecInfoData())) continue;
                    Map specMap = (Map)JSON.parseObject((String)info.getSpecificInformation().getSpecInfoData(), Map.class);
                    params.put(fields.get(0).getTransSpecType(), specMap);
                    continue;
                }
                if (!"kDPSpeInfoEntries".equals(s) || fields.size() <= 0 || info.getSpecificInformation() == null) continue;
                ArrayList<Map> specInfoItems = new ArrayList<Map>();
                SpecificInformationEntryCollection coll = info.getSpecificInformation().getEntries();
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (IMUtils.isEmpty(coll.get(i).getSpecInfoData())) continue;
                    Map specMap = (Map)JSON.parseObject((String)coll.get(i).getSpecInfoData(), Map.class);
                    specInfoItems.add(specMap);
                }
                params.put(fields.get(0).getTransSpecType(), specInfoItems);
            }
        }
    }

    private String bigDecimalToString(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return "";
        }
        return value.toString();
    }

    private String bigDecimalToZeroString(BigDecimal value) {
        if (value == null || value.compareTo(BigDecimal.ZERO) == 0) {
            return "0";
        }
        return value.toString();
    }

    public static void setInvoiceType(IncomeInvoiceInfo invoiceInfo, String type) {
        if (type != null && !type.isEmpty()) {
            int invoiceType = Integer.parseInt(type);
            switch (invoiceType) {
                case 1: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICINVOICE);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_COMMON_ELECTRONIC);
                    break;
                }
                case 2: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL);
                    break;
                }
                case 3: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.COMMONINVOICE);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_COMMON_PAPER);
                    break;
                }
                case 4: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_SPECIAL_PAPER);
                    break;
                }
                case 5: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.COMMONINVOICE);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_COMMON_PAPER_ROLL);
                    break;
                }
                case 15: {
                    invoiceInfo.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICINVOICE);
                    invoiceInfo.setTmInvoiceType(TMInvoiceType.INVOICETYPE_TOLL);
                    break;
                }
            }
        }
    }

    public Map getMailOrderSjd(Context ctx, MakeInvoiceInfo invoice, Map params) {
        CustomerMailingEntryInfo mailingEntryInfo = null;
        if (params.get("mailingEntryInfo") instanceof LinkedTreeMap) {
            LinkedTreeMap map = (LinkedTreeMap)params.get("mailingEntryInfo");
            mailingEntryInfo = new CustomerMailingEntryInfo();
            mailingEntryInfo.setTelephone((String)map.get((Object)"telephone"));
            mailingEntryInfo.setCompanyName((String)map.get((Object)"companyName"));
            mailingEntryInfo.setAddress((String)map.get((Object)"address"));
        } else {
            mailingEntryInfo = (CustomerMailingEntryInfo)params.get("mailingEntryInfo");
        }
        ArrayList expdataList = new ArrayList();
        HashMap<String, Object> expdata = new HashMap<String, Object>();
        expdata.put("ddh", PwyHelper.md5(invoice.getId().toString()));
        ArrayList fpDataList = new ArrayList();
        HashMap<String, String> fpData = new HashMap<String, String>();
        fpData.put("fpdm", invoice.getInvoiceNumber());
        fpData.put("fphm", invoice.getInvoiceNo());
        fpDataList.add(fpData);
        expdata.put("fpdata", fpDataList);
        expdata.put("area", "");
        expdata.put("city", "");
        expdata.put("province", "");
        expdata.put("reccountry", "");
        expdata.put("recname", invoice.getDisInvoicer());
        expdata.put("reccompany", invoice.getRecBillComName());
        expdata.put("recmobile", invoice.getCellphone());
        expdata.put("rectel", invoice.getCellphone());
        expdata.put("recaddr", invoice.getRecBillAdress());
        expdata.put("recpectaddr", invoice.getRecBillAdress());
        expdata.put("sendname", invoice.getDrawertxt());
        expdata.put("sendaddr", mailingEntryInfo.getAddress());
        expdata.put("sendmobile", mailingEntryInfo.getTelephone());
        expdata.put("sendtel", mailingEntryInfo.getTelephone());
        expdata.put("sendcompany", mailingEntryInfo.getCompanyName());
        expdataList.add(expdata);
        HashMap mailOrderSjd = new HashMap();
        mailOrderSjd.put("expdata", expdataList);
        return mailOrderSjd;
    }

    public static String md5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u6ca1\u6709md5\u8fd9\u4e2a\u7b97\u6cd5\uff01");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); ++i) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    public static String getDateFormatter(Date date) {
        SimpleDateFormat df1 = new SimpleDateFormat("yyyyMMdd");
        if (date == null) {
            return "";
        }
        return df1.format(date);
    }
}

