/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.AbstractMakeInvoiceInfo;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.app.AbstractInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.MakeInvoiceControllerBean;
import com.kingdee.eas.tm.im.app.MakeInvoiceDifferGroupStrategy;
import com.kingdee.eas.tm.im.app.MakeInvoiceGroupStrategy;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginContext;
import com.kingdee.eas.tm.im.app.service.SplitLimitAmt4NoTaxAmtService;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.basedata.IsPrintListEnum;
import com.kingdee.eas.tm.im.basedata.OverLimitAmtSplitTypeEnum;
import com.kingdee.eas.tm.im.basedata.SpecsCarryTypeEnum;
import com.kingdee.eas.tm.im.common.cache.IMThreadLocalCache;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.model.SplitLimitAmtParams;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMParamUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractGenerateInvoiceReqHandler
extends AbstractInvoiceReqHandler {
    private static Logger logger = Logger.getLogger(AbstractGenerateInvoiceReqHandler.class);
    private LowTimer timer = new LowTimer();
    private boolean isPrint;
    private boolean isReq;
    private int splitLimitAmtMaxCount = 10000;
    Map<String, String> srcMap = new HashMap<String, String>();
    Map<String, String> destMap = new HashMap<String, String>();
    Map<String, BigDecimal> discountAmtMap = new HashMap<String, BigDecimal>();
    private Map<String, ProductCodeCollection> productMaterialCache = null;
    private Map<String, ProductCodeCollection> productExpenseItemCache = null;
    private Map<String, ProductCodeInfo> productCache = null;

    public AbstractGenerateInvoiceReqHandler(Context ctx, InvoiceReqInfo invoiceReq) {
        super(ctx, invoiceReq);
        this.isPrint = invoiceReq.isPrint();
        this.isReq = invoiceReq.isReq();
    }

    @Override
    protected void initData() {
        this.splitLimitAmtMaxCount = IMParamUtils.getSplitLimitAmtMaxCount(this.ctx);
        InvoicePluginContext pluginContext = this.invoiceReq.getPluginService().getPluginContext();
        pluginContext.setSrcMap(this.srcMap);
        pluginContext.setDestMap(this.destMap);
        pluginContext.setDiscountAmtMap(this.discountAmtMap);
        pluginContext.setSplitLimitAmtMaxCount(this.splitLimitAmtMaxCount);
    }

    @Override
    protected ArrayList handleBills(List exList) throws Exception {
        String combinRuleID = this.invoiceReq.getDestCombinRuleID();
        CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, combinRuleID);
        this.timer.reset();
        List<MakeInvoiceInfo> invoiceInfos = this.invoiceReq2MakeInvoiceBills(this.invoiceReq.getBills(), combinRule, exList);
        if (invoiceInfos.isEmpty()) {
            return null;
        }
        this.calInvoiceFields(invoiceInfos);
        logger.error((Object)("\u5f00\u7968\u5355\u6309\u5206\u5f55\u9650\u989d\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        ArrayList<MakeInvoiceInfo> afterGroupList = new ArrayList<MakeInvoiceInfo>();
        ArrayList<MakeInvoiceInfo> diffAfterGroupList = new ArrayList<MakeInvoiceInfo>();
        MakeInvoiceInfo mkInfo = null;
        BigDecimal limitAmt = BigDecimal.ZERO;
        List<MakeInvoiceInfo> afterGroupInvoice = null;
        List<MakeInvoiceInfo> diffAfterGroupInvoice = null;
        for (int i = 0; i < invoiceInfos.size(); ++i) {
            mkInfo = invoiceInfos.get(i);
            limitAmt = mkInfo.getLimitAmt();
            if (mkInfo.isIsDiffTax()) {
                diffAfterGroupInvoice = MakeInvoiceGroupStrategy.groupDiffEntry(this.ctx, this.destBillRelation, mkInfo, limitAmt, this.discountAmtMap, this.srcMap);
            } else {
                afterGroupInvoice = MakeInvoiceGroupStrategy.groupEntry(this.ctx, this.destBillRelation, mkInfo, limitAmt, this.discountAmtMap, this.destMap);
            }
            if (mkInfo.isIsDiffTax()) {
                diffAfterGroupList.addAll(diffAfterGroupInvoice);
                continue;
            }
            afterGroupList.addAll(afterGroupInvoice);
        }
        logger.error((Object)("\u5f00\u7968\u5355\u6309\u5355\u9650\u989d\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        String combineDiscountRow = IMFacadeFactory.getLocalInstance(this.ctx).getParamByKey("combineDiscountRow");
        if ("1".equals(combineDiscountRow)) {
            this.combinBizBillByRuleNew(afterGroupList, combinRule);
        } else {
            this.combinBizBillByRule(afterGroupList, combinRule);
        }
        logger.error((Object)("\u5f00\u7968\u5355\u4e8c\u6b21\u5408\u5e76\u5206\u5f55\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        afterGroupList.addAll(diffAfterGroupList);
        this.checkInvoceLimitNum(afterGroupList, this.invoiceReq);
        this.calInvoiceFields(afterGroupList);
        logger.error((Object)("\u5f00\u7968\u5355\u8d85\u9650\u884c\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.removeZeroEntres(afterGroupList, exList);
        this.setConstantQty_calPrice(afterGroupList);
        this.reverseCalPrice(afterGroupList);
        this.setBizYearAndMonth(afterGroupList);
        this.timer.reset();
        ArrayList ids = IMInvoiceFacadeFactory.getLocalInstance(this.ctx).makeInvoiceSaveRelation(this.invoiceReq, this.destBillRelation, afterGroupList);
        logger.error((Object)("\u6784\u9020\u4e1a\u52a1\u5355\u636e\u8ddf\u5f00\u7968\u5355\u62c6\u5206\u5408\u5e76\u5173\u7cfb\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        if (IMConstant.SRCTYPE_FI_AR.equals(this.invoiceReq.getSrcSystem())) {
            this.carryBd2Invoice(ids, afterGroupList);
        } else {
            this.carryReqBd2Invoice(ids, afterGroupList);
        }
        logger.error((Object)("\u643a\u5e26\u5f00\u7968\u3001\u6536\u7968\u4fe1\u606f \u5230\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        List errorID = this.submitMakeInvoice(afterGroupList, exList);
        logger.error((Object)("\u63d0\u4ea4\u3001\u5ba1\u6838\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.doOtherErrorInvoice(errorID, exList);
        this.getResp().setMkFailBills((ArrayList)errorID);
        this.remvoeErrorID(ids, errorID);
        return ids;
    }

    private void setBizYearAndMonth(List<MakeInvoiceInfo> afterGroupList) throws BOSException {
        String bosType = this.invoiceReq.getBosType();
        for (int i = 0; i < afterGroupList.size(); ++i) {
            int j;
            HashMap<Integer, Integer> yearMap = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> monthMap = new HashMap<Integer, Integer>();
            MakeInvoiceInfo info = afterGroupList.get(i);
            String makeBillID = info.getId().toString();
            ArrayList bizIds = (ArrayList)this.destBillRelation.get(makeBillID);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(bizIds), CompareType.INCLUDE));
            view.setFilter(filter);
            if ("FC910EF3".equals(bosType)) {
                OtherBillCollection arColl = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillCollection(view);
                for (j = 0; j < arColl.size(); ++j) {
                    OtherBillInfo arInfo = arColl.get(j);
                    yearMap.put(arInfo.getYear(), arInfo.getYear());
                    monthMap.put(arInfo.getPeriod(), arInfo.getPeriod());
                }
            } else if ("AC368D2D".equals(bosType)) {
                MakeInvoiceReqCollection reqColl = MakeInvoiceReqFactory.getLocalInstance(this.ctx).getMakeInvoiceReqCollection(view);
                for (j = 0; j < reqColl.size(); ++j) {
                    MakeInvoiceReqInfo reqInfo = reqColl.get(j);
                    yearMap.put(reqInfo.getBizYear(), reqInfo.getBizYear());
                    monthMap.put(reqInfo.getBizMonth(), reqInfo.getBizMonth());
                }
            }
            if (yearMap.size() == 1 && monthMap.size() == 1 && (Integer)yearMap.values().toArray()[0] != 0 && (Integer)monthMap.values().toArray()[0] != 0) {
                info.setBizYear((Integer)yearMap.values().toArray()[0]);
                info.setBizMonth((Integer)monthMap.values().toArray()[0]);
                continue;
            }
            info.put("bizYear", null);
            info.put("bizMonth", null);
        }
    }

    protected void removeZeroEntres(List<MakeInvoiceInfo> afterGroupList, List exList) {
        MakeInvoiceInfo invoice = null;
        for (int i = 0; i < afterGroupList.size(); ++i) {
            invoice = afterGroupList.get(i);
            MakeInvoiceEntryInfo entryInfo = null;
            for (int j = 0; j < invoice.getEntries().size(); ++j) {
                entryInfo = invoice.getEntries().get(j);
                if (entryInfo.getPriceTax().compareTo(BigDecimal.ZERO) != 0) continue;
                invoice.getEntries().removeObject(j);
                --j;
            }
            if (invoice.getEntries().size() != 0) continue;
            afterGroupList.remove(i);
            --i;
        }
    }

    @Override
    protected void batchFecthData() throws EASBizException, BOSException {
        this.ctx.put((Object)"CTX_ENABLE_THREADLOCAL_CACHE", (Object)true);
        this.batchFetchProductCode();
    }

    @Override
    protected void clearCache() throws EASBizException, BOSException {
        IMThreadLocalCache.clearPwySettingCache();
        this.ctx.remove((Object)"CTX_ENABLE_THREADLOCAL_CACHE");
    }

    protected void carryReqBd2Invoice(ArrayList ids, List<MakeInvoiceInfo> invoiceCol) throws BOSException, EASBizException {
        if (ids.size() == 0) {
            return;
        }
        String sql = "select FInvoiceBillID, FBizBillID from T_IM_MakeInvoiceRelation where fsrcbostype = 'AC368D2D' and FInvoiceBillID in (" + CollectionUtil.convertList2String(ids) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        HashMap<String, String> invoiceRelation = new HashMap<String, String>();
        HashMap<String, MakeInvoiceReqInfo> makeInvoiceReqMap = new HashMap<String, MakeInvoiceReqInfo>();
        HashSet<String> makeInvoiceReqIds = new HashSet<String>();
        try {
            while (rs.next()) {
                makeInvoiceReqIds.add(rs.getString("FBizBillID"));
                invoiceRelation.put(rs.getString("FInvoiceBillID"), rs.getString("FBizBillID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (makeInvoiceReqIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", makeInvoiceReqIds, CompareType.INCLUDE));
            view.setFilter(filter);
            MakeInvoiceReqCollection coll = MakeInvoiceReqFactory.getLocalInstance(this.ctx).getMakeInvoiceReqCollection(view);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    MakeInvoiceReqInfo info = coll.get(i);
                    makeInvoiceReqMap.put(info.getId().toString(), info);
                }
            }
        }
        MakeInvoiceInfo mkInvoice = null;
        boolean carryMail2Invoice = false;
        for (int j = 0; j < invoiceCol.size(); ++j) {
            mkInvoice = invoiceCol.get(j);
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)makeInvoiceReqMap.get(invoiceRelation.get(mkInvoice.getId().toString()));
            carryMail2Invoice = false;
            if (info != null) {
                if (info.getDisInvoicer() == null && info.getRecBillPhone() == null && info.getRecBillComName() == null && info.getRecBillAdress() == null && info.getMailNumber() == null && info.getRecBillEmail() == null) {
                    carryMail2Invoice = true;
                } else {
                    mkInvoice.setDisInvoicer(info.getDisInvoicer());
                    mkInvoice.setRecBillPhone(info.getRecBillPhone());
                    mkInvoice.setCellphone(info.getRecBillPhone());
                    mkInvoice.setRecBillComName(info.getRecBillComName());
                    mkInvoice.setRecBillAdress(info.getRecBillAdress());
                    mkInvoice.setMailNumber(info.getMailNumber());
                    mkInvoice.setRecBillEmail(info.getRecBillEmail());
                }
                if (info.getBankAccount() != null) {
                    mkInvoice.setBankAccount(info.getBankAccount());
                }
                if (info.getTaxNumber() != null) {
                    mkInvoice.setTaxNumber(info.getTaxNumber());
                }
                if (info.getInvoiceType() != null && !info.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    mkInvoice.setInvoiceType(info.getInvoiceType());
                }
                if (info.getAddress() != null) {
                    mkInvoice.setAddress(info.getAddress());
                }
                if (info.getRecOrgName() != null) {
                    mkInvoice.setReceiveCompany(info.getRecOrgName());
                }
            } else {
                carryMail2Invoice = true;
            }
            if (!carryMail2Invoice) continue;
            this.carryCustomerMaillingInfo(mkInvoice);
        }
    }

    protected void remvoeErrorID(List allId, List errorID) {
        allId.removeAll(errorID);
    }

    protected void carryBd2Invoice(List ids, List<MakeInvoiceInfo> invoiceCol) throws BOSException, EASBizException {
        if (ids.size() == 0) {
            return;
        }
        String sql = "select FInvoiceBillID, FBizBillID from T_IM_MakeInvoiceRelation where fsrcbostype = 'FC910EF3' and FInvoiceBillID in (" + CollectionUtil.convertList2String(ids) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        HashMap<String, String> invoiceRelation = new HashMap<String, String>();
        HashMap<String, OtherBillInfo> otherBillMap = new HashMap<String, OtherBillInfo>();
        HashSet<String> otherBillIds = new HashSet<String>();
        try {
            while (rs.next()) {
                otherBillIds.add(rs.getString("FBizBillID"));
                invoiceRelation.put(rs.getString("FInvoiceBillID"), rs.getString("FBizBillID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        OtherBillCollection coll = null;
        OtherBillInfo otherBillInfo = null;
        if (otherBillIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("invoiceType"));
            sic.add(new SelectorItemInfo("comInvoiceName"));
            sic.add(new SelectorItemInfo("taxNo"));
            sic.add(new SelectorItemInfo("addressAndTel"));
            sic.add(new SelectorItemInfo("oBankAndAcountNum"));
            sic.add(new SelectorItemInfo("disInvoicer"));
            sic.add(new SelectorItemInfo("recBillPhone"));
            sic.add(new SelectorItemInfo("recBillComName"));
            sic.add(new SelectorItemInfo("recBillAdress"));
            sic.add(new SelectorItemInfo("mailNumber"));
            sic.add(new SelectorItemInfo("recBillEmail"));
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", otherBillIds, CompareType.INCLUDE));
            view.setFilter(filter);
            coll = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillCollection(view);
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    otherBillInfo = coll.get(i);
                    otherBillMap.put(otherBillInfo.getId().toString(), otherBillInfo);
                }
            }
        }
        MakeInvoiceInfo mkInvoice = null;
        boolean carryMail2Invoice = false;
        for (int j = 0; j < invoiceCol.size(); ++j) {
            mkInvoice = invoiceCol.get(j);
            OtherBillInfo oInfo = (OtherBillInfo)otherBillMap.get(invoiceRelation.get(mkInvoice.getId().toString()));
            carryMail2Invoice = false;
            if (oInfo != null) {
                if (StringUtils.isEmpty((String)oInfo.getDisInvoicer()) && StringUtils.isEmpty((String)oInfo.getRecBillPhone()) && StringUtils.isEmpty((String)oInfo.getRecBillComName()) && StringUtils.isEmpty((String)oInfo.getRecBillAdress()) && StringUtils.isEmpty((String)oInfo.getMailNumber()) && StringUtils.isEmpty((String)oInfo.getRecBillEmail())) {
                    carryMail2Invoice = true;
                } else {
                    mkInvoice.setDisInvoicer(oInfo.getDisInvoicer());
                    mkInvoice.setRecBillPhone(oInfo.getRecBillPhone());
                    mkInvoice.setCellphone(oInfo.getRecBillPhone());
                    mkInvoice.setRecBillComName(oInfo.getRecBillComName());
                    mkInvoice.setRecBillAdress(oInfo.getRecBillAdress());
                    mkInvoice.setMailNumber(oInfo.getMailNumber());
                    mkInvoice.setRecBillEmail(oInfo.getRecBillEmail());
                }
                if (!StringUtils.isEmpty((String)oInfo.getOBankAndAcountNum())) {
                    mkInvoice.setBankAccount(oInfo.getOBankAndAcountNum());
                }
                if (!StringUtils.isEmpty((String)oInfo.getTaxNo())) {
                    mkInvoice.setTaxNumber(oInfo.getTaxNo());
                }
                if (oInfo.getInvoiceType() != null && oInfo.getComInvoiceName() != null && !oInfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    mkInvoice.setInvoiceType(oInfo.getInvoiceType());
                }
                if (!StringUtils.isEmpty((String)oInfo.getAddressAndTel())) {
                    mkInvoice.setAddress(oInfo.getAddressAndTel());
                }
                if (!StringUtils.isEmpty((String)oInfo.getComInvoiceName())) {
                    mkInvoice.setReceiveCompany(oInfo.getComInvoiceName());
                }
            } else {
                carryMail2Invoice = true;
            }
            if (!carryMail2Invoice) continue;
            this.carryCustomerMaillingInfo(mkInvoice);
        }
    }

    public void carryCustomerMaillingInfo(MakeInvoiceInfo mkInvoice) throws EASBizException, BOSException {
        if (mkInvoice.getCompany() == null || mkInvoice.getCurrAcctCustomer() == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comOrgUnitId", mkInvoice.getCompany().getId().toString());
        param.put("customerId", mkInvoice.getCurrAcctCustomer().getId().toString());
        Map entryMap = CustomerMailingFactory.getLocalInstance(this.ctx).getDefaultCustomerMailInfo(param);
        CustomerMailingEntryInfo defaultEntry = null;
        if (entryMap.get("defaultEntry") != null) {
            defaultEntry = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
            mkInvoice.setDisInvoicer(defaultEntry.getContacts());
            mkInvoice.setRecBillComName(defaultEntry.getCompanyName());
            mkInvoice.setRecBillAdress(defaultEntry.getAddress());
            mkInvoice.setRecBillPhone(defaultEntry.getTelephone());
            mkInvoice.setCellphone(defaultEntry.getTelephone());
            mkInvoice.setRecBillEmail(defaultEntry.getMailbox());
            mkInvoice.setMailNumber(defaultEntry.getPostalcode());
        }
    }

    protected void calInvoiceFields(List<MakeInvoiceInfo> mkInvoices) {
        MakeInvoiceInfo info = null;
        MakeInvoiceEntryCollection entrys = null;
        MakeInvoiceEntryInfo entry = null;
        for (int i = 0; i < mkInvoices.size(); ++i) {
            BigDecimal totalNoTaxAmt = BigDecimal.ZERO;
            BigDecimal totalTax = BigDecimal.ZERO;
            BigDecimal totalTaxAmt = BigDecimal.ZERO;
            info = mkInvoices.get(i);
            entrys = info.getEntries();
            for (int j = 0; j < entrys.size(); ++j) {
                entry = entrys.get(j);
                totalNoTaxAmt = totalNoTaxAmt.add(entry.getNoTaxAmt());
                totalTax = totalTax.add(entry.getTaxAmt());
                totalTaxAmt = totalTaxAmt.add(entry.getPriceTax());
            }
            info.setNoTaxAmtTotal(totalNoTaxAmt);
            info.setTaxAmtTotal(totalTax);
            info.setPriceTaxTotal(totalTaxAmt);
        }
    }

    protected void calInvoiceEntryFields(MakeInvoiceEntryInfo entry) {
        BigDecimal notTaxPrice = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal noTaxAmt = entry.getNoTaxAmt();
        BigDecimal priceTax = entry.getPriceTax();
        BigDecimal tax = entry.getPriceTax().subtract(noTaxAmt);
        if (entry.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
            notTaxPrice = noTaxAmt.divide(entry.getQuantity(), 10, 4);
            price = priceTax.divide(entry.getQuantity(), 10, 4);
        }
        entry.setNoTaxAmt(noTaxAmt.setScale(2, 4));
        entry.setPriceTax(entry.getPriceTax().setScale(2, 4));
        entry.setTaxAmt(tax.setScale(2, 4));
        entry.setNoTaxPrice(notTaxPrice);
        entry.setPrice(price);
    }

    protected void checkInvoceLimitNum(List<MakeInvoiceInfo> invoiceColl, InvoiceReqInfo invoiceReq) throws BOSException, EASBizException {
        ArrayList<MakeInvoiceInfo> newList = new ArrayList<MakeInvoiceInfo>();
        for (int i = 0; i < invoiceColl.size(); ++i) {
            MakeInvoiceInfo invoiceInfo = invoiceColl.get(i);
            newList.add(invoiceInfo);
            int limitNum = this.getInvoiceLimitLineNum(invoiceInfo.getInvoiceType().getValue(), invoiceInfo.getCompany().getId().toString());
            boolean isPrintList = IMUtils.getBooleanParam(this.ctx, invoiceInfo.getCompany().getId().toString(), "VATM007");
            CustomerTaxInfo customerTax = invoiceInfo.getCustomerTax();
            if (customerTax != null) {
                CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
                CustomerTaxEntryCollection coll = customerTax.getEntries();
                int size = coll.size();
                for (int j = 0; j < size && !(entryInfo = coll.get(j)).getInvoiceType().getValue().equals(invoiceInfo.getInvoiceType().getValue()); ++j) {
                }
                IsPrintListEnum printEnum = entryInfo.getIsPrintList();
                if ("0" != printEnum.getValue()) {
                    isPrintList = printEnum.getValue() == "1";
                }
            }
            if (PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoiceInfo.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoiceInfo.getInvoiceType())) {
                isPrintList = false;
                invoiceInfo.setIsList(false);
            }
            if (invoiceReq.getBills().get(0).getIsList()) {
                isPrintList = true;
                invoiceInfo.setIsList(true);
            } else if (!isPrintList) {
                boolean isHasDiscount = this.hasDiscountRow(invoiceInfo);
                if (isHasDiscount && limitNum > 2 && limitNum % 2 > 0) {
                    --limitNum;
                }
                ArrayList<MakeInvoiceInfo> newLimitList = new ArrayList<MakeInvoiceInfo>();
                this.doInvoiceLimitNumEntry(invoiceInfo, limitNum, newLimitList);
                newList.remove(invoiceInfo);
                newList.addAll(newLimitList);
            } else if (isPrintList && invoiceInfo.getEntries().size() > limitNum) {
                invoiceInfo.setIsList(true);
            } else {
                invoiceInfo.setIsList(false);
            }
            if (!invoiceInfo.isIsList()) continue;
            int invoiceListLimitNum = this.getInvoiceListLimitLineNumByType(invoiceReq.getInvoiceType(), invoiceInfo.getCompany().getId().toString());
            boolean isHasDiscount = this.hasDiscountRow(invoiceInfo);
            if (isHasDiscount && invoiceListLimitNum > 2 && invoiceListLimitNum % 2 > 0) {
                --invoiceListLimitNum;
            }
            ArrayList<MakeInvoiceInfo> limitNewList = new ArrayList<MakeInvoiceInfo>();
            this.doInvoiceLimitNumEntry(invoiceInfo, invoiceListLimitNum, limitNewList);
            this.doHeadDiffer(invoiceInfo, invoiceListLimitNum, limitNewList);
            for (MakeInvoiceInfo invoice : limitNewList) {
                if (invoice.getEntries().size() >= limitNum) continue;
                invoice.setIsList(false);
            }
            newList.remove(invoiceInfo);
            newList.addAll(limitNewList);
        }
        for (int k = 0; k < newList.size(); ++k) {
            MakeInvoiceInfo newMkInvoice = (MakeInvoiceInfo)newList.get(k);
            ArrayList bizBillIds = (ArrayList)this.destBillRelation.get(newMkInvoice.getString("tempID"));
            if (bizBillIds == null) continue;
            this.destBillRelation.put(newMkInvoice.getId().toString(), bizBillIds);
        }
        invoiceColl.clear();
        invoiceColl.addAll(newList);
    }

    protected void doHeadDiffer(MakeInvoiceInfo beforeGroup, int invoiceListLimitNum, List<MakeInvoiceInfo> newList) throws EASBizException, BOSException {
        if (beforeGroup.isIsDiffTax()) {
            return;
        }
        boolean isDifferOver = false;
        MakeInvoiceInfo invoice = null;
        int size = newList.size();
        for (int i = 0; i < size; ++i) {
            invoice = newList.get(i);
            if (beforeGroup.getAllowTotalDiffMax().abs().compareTo(invoice.getTotalDiffer().abs()) >= 0) continue;
            isDifferOver = true;
            break;
        }
        if (!isDifferOver) {
            return;
        }
        newList.clear();
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("srcMap", this.srcMap);
        params.put("destMap", this.destMap);
        MakeInvoiceDifferGroupStrategy.groupEntry(this.ctx, beforeGroup, invoiceListLimitNum, newList, params);
    }

    protected void doInvoiceLimitNumEntry(MakeInvoiceInfo invoiceInfo, int limitNum, List<MakeInvoiceInfo> newList) {
        MakeInvoiceEntryCollection entrys = invoiceInfo.getEntries();
        int entrySize = entrys.size();
        if (entrySize <= limitNum) {
            newList.add(invoiceInfo);
            return;
        }
        LinkedHashMap<String, MakeInvoiceEntryInfo> values = new LinkedHashMap<String, MakeInvoiceEntryInfo>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < entrys.size(); ++i) {
            MakeInvoiceEntryInfo entry = entrys.get(i);
            values.put(entry.getId().toString(), entry);
            idList.add(entry.getId().toString());
        }
        MakeInvoiceInfo tempValue = (MakeInvoiceInfo)invoiceInfo.cloneHead();
        HashSet<String> exists = new HashSet<String>();
        ArrayList<String> blueIDList = new ArrayList<String>();
        int count = 0;
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            ++count;
            String id = (String)idList.get(i);
            MakeInvoiceEntryInfo entry = (MakeInvoiceEntryInfo)values.get(id);
            if (tempValue.getEntries().size() == limitNum) {
                newList.add(tempValue);
                tempValue = (MakeInvoiceInfo)invoiceInfo.cloneHead();
                tempValue.setId(BOSUuid.create((String)"412A6F98"));
                tempValue.setString("tempID", invoiceInfo.getId().toString());
            }
            if (this.srcMap.get(id) != null) {
                String redid = this.srcMap.get(id);
                if (!exists.contains(redid)) {
                    MakeInvoiceEntryInfo redInfo = (MakeInvoiceEntryInfo)values.get(redid);
                    tempValue.getEntries().add(entry);
                    tempValue.getEntries().add(redInfo);
                    exists.add(id);
                    exists.add(redid);
                }
            } else {
                blueIDList.add(id);
            }
            if (count != entrySize) continue;
            newList.add(tempValue);
        }
        AbstractMakeInvoiceInfo info = null;
        int size2 = blueIDList.size();
        for (int i = 0; i < size2; ++i) {
            String billID = String.valueOf(blueIDList.get(i));
            if (exists.contains(billID)) continue;
            MakeInvoiceEntryInfo entry = (MakeInvoiceEntryInfo)values.get(billID);
            if (tempValue.getEntries().size() < limitNum) {
                tempValue.getEntries().add(entry);
                continue;
            }
            if (info == null || info.getEntries().size() == 0 || info.getEntries().size() == limitNum) {
                info = (MakeInvoiceInfo)invoiceInfo.cloneHead();
                info.setId(BOSUuid.create((String)"412A6F98"));
                info.setString("tempID", invoiceInfo.getId().toString());
                newList.add((MakeInvoiceInfo)info);
            }
            info.getEntries().add(entry);
        }
    }

    protected boolean hasDiscountRow(MakeInvoiceInfo invoiceInfo) {
        boolean retValue = false;
        MakeInvoiceEntryCollection entrys = invoiceInfo.getEntries();
        MakeInvoiceEntryInfo entry = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            if (!RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType())) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    protected void combinBizBillByRule(List<MakeInvoiceInfo> invoiceColl, CombinRuleSettingInfo combinRule) throws BOSException {
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(combinRule, entryProp);
        MakeInvoiceInfo invoice = null;
        MakeInvoiceEntryCollection entrys = null;
        HashMap<String, MakeInvoiceEntryInfo> combinBillEntry = null;
        for (int i = 0; i < invoiceColl.size(); ++i) {
            invoice = invoiceColl.get(i);
            combinBillEntry = new HashMap<String, MakeInvoiceEntryInfo>();
            invoice.setIsContainTax(combinRule.isIsInTax());
            boolean isHasDiscount = this.hasDiscountRow(invoice);
            if (isHasDiscount) continue;
            entrys = invoice.getEntries();
            MakeInvoiceEntryCollection newEntrys = new MakeInvoiceEntryCollection();
            for (int j = 0; j < entrys.size(); ++j) {
                MakeInvoiceEntryInfo entry = entrys.get(j);
                String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
                MakeInvoiceEntryInfo obj = (MakeInvoiceEntryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    continue;
                }
                obj.setQuantity(obj.getQuantity().add(entry.getQuantity()));
                obj.setPriceTax(obj.getPriceTax().add(entry.getPriceTax()));
                obj.setNoTaxAmt(obj.getNoTaxAmt().add(entry.getNoTaxAmt()));
                obj.setBoolean("KEY_IS_CONSTANTQTY", true);
                this.calInvoiceEntryFields(obj);
            }
            invoice.getEntries().clear();
            invoice.getEntries().addCollection(newEntrys);
        }
        this.calInvoiceFields(invoiceColl);
    }

    protected void combinBizBillByRuleNew(List<MakeInvoiceInfo> invoiceColl, CombinRuleSettingInfo combinRule) throws BOSException {
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(combinRule, entryProp);
        MakeInvoiceInfo invoice = null;
        MakeInvoiceEntryCollection entrys = null;
        MakeInvoiceEntryInfo entry = null;
        for (int i = 0; i < invoiceColl.size(); ++i) {
            invoice = invoiceColl.get(i);
            invoice.setIsContainTax(combinRule.isIsInTax());
            MakeInvoiceEntryCollection blueEntrys = new MakeInvoiceEntryCollection();
            MakeInvoiceEntryCollection redEntrys = new MakeInvoiceEntryCollection();
            entrys = invoice.getEntries();
            for (int j = 0; j < entrys.size(); ++j) {
                entry = entrys.get(j);
                if (RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType())) {
                    redEntrys.add(entry);
                    continue;
                }
                blueEntrys.add(entry);
            }
            MakeInvoiceEntryCollection newblueEntrys = this.conbineInvoiceEntry(blueEntrys, entryProp, false);
            MakeInvoiceEntryCollection newRedEntrys = this.conbineInvoiceEntry(redEntrys, entryProp, true);
            MakeInvoiceEntryInfo redEntry = null;
            Set redConbineEntryIds = null;
            HashSet entryIds = null;
            MakeInvoiceEntryInfo blueEntry = null;
            Set blueConbineEntryIds = null;
            invoice.getEntries().clear();
            if (newblueEntrys.size() <= 0) continue;
            block2: for (int k = 0; k < newblueEntrys.size(); ++k) {
                blueEntry = newblueEntrys.get(k);
                blueConbineEntryIds = (Set)blueEntry.get("conbineEntryIds");
                invoice.getEntries().add(blueEntry);
                for (int j = 0; j < newRedEntrys.size(); ++j) {
                    redEntry = newRedEntrys.get(j);
                    redConbineEntryIds = (Set)redEntry.get("conbineEntryIds");
                    entryIds = new HashSet();
                    entryIds.addAll(blueConbineEntryIds);
                    entryIds.retainAll(redConbineEntryIds);
                    if (entryIds.size() != redConbineEntryIds.size()) continue;
                    redEntry.setSourceBillEntryId(blueEntry.getId().toString());
                    blueEntry.setBillRowType(RowType.DISCOUNTED_ROW);
                    invoice.getEntries().add(redEntry);
                    continue block2;
                }
            }
        }
        this.calInvoiceFields(invoiceColl);
    }

    private MakeInvoiceEntryCollection conbineInvoiceEntry(MakeInvoiceEntryCollection entrys, ArrayList<String> entryProp, boolean isRed) {
        HashMap<String, MakeInvoiceEntryInfo> combinBillEntry = new HashMap<String, MakeInvoiceEntryInfo>();
        MakeInvoiceEntryCollection newEntrys = new MakeInvoiceEntryCollection();
        for (int i = 0; i < entrys.size(); ++i) {
            MakeInvoiceEntryInfo entry = entrys.get(i);
            String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
            MakeInvoiceEntryInfo obj = (MakeInvoiceEntryInfo)combinBillEntry.get(key);
            if (obj == null) {
                combinBillEntry.put(key, entry);
                entry.put("conbineEntryIds", new HashSet());
                ((Set)entry.get("conbineEntryIds")).add(isRed ? entry.getSourceBillEntryId() : entry.getId().toString());
                newEntrys.add(entry);
                continue;
            }
            obj.setQuantity(obj.getQuantity().add(entry.getQuantity()));
            obj.setPriceTax(obj.getPriceTax().add(entry.getPriceTax()));
            obj.setNoTaxAmt(obj.getNoTaxAmt().add(entry.getNoTaxAmt()));
            obj.setBoolean("KEY_IS_CONSTANTQTY", !isRed);
            this.calInvoiceEntryFields(obj);
            ((Set)obj.get("conbineEntryIds")).add(isRed ? entry.getSourceBillEntryId() : entry.getId().toString());
        }
        return newEntrys;
    }

    private List<MakeInvoiceInfo> invoiceReq2MakeInvoiceBills(List<BillReqInfo> bills, CombinRuleSettingInfo combinRule, List exList) throws BOSException, IMException {
        ArrayList<MakeInvoiceInfo> retValue = new ArrayList<MakeInvoiceInfo>();
        HashMap<String, ArrayList<MakeInvoiceInfo>> successInfo = new HashMap<String, ArrayList<MakeInvoiceInfo>>();
        ArrayList bizFailBills = this.getResp().getBizFailBills();
        boolean hasFailBill = false;
        int size = bills.size();
        for (int idx = 0; idx < size; ++idx) {
            hasFailBill = false;
            HashSet<String> genInvoiceSuccessBillNumber = new HashSet<String>();
            String[] bizBillNumbers = bills.get(idx).getBillNumber().split(";");
            String bizBillNumber = "";
            for (int i = 0; i < bizBillNumbers.length; ++i) {
                bizBillNumber = bizBillNumbers[i];
                if (!bizFailBills.contains(bizBillNumber)) continue;
                hasFailBill = true;
                break;
            }
            if (hasFailBill) continue;
            MakeInvoiceInfo info = null;
            try {
                info = this.invoiceReq2MakeInvoiceInfo(bills.get(idx), combinRule.isIsInTax());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ArrayList tempList = null;
                for (int i = 0; i < bizBillNumbers.length; ++i) {
                    bizBillNumber = bizBillNumbers[i];
                    if (!this.getResp().getBizFailBills().contains(bizBillNumber)) {
                        this.getResp().getBizFailBills().add(bizBillNumber);
                    }
                    if ((tempList = (ArrayList)successInfo.get(bizBillNumber)) == null) continue;
                    for (int j = 0; j < tempList.size(); ++j) {
                        Object obj = tempList.get(j);
                        retValue.remove(obj);
                    }
                }
                exList.add(e);
            }
            if (info != null) {
                for (int i = 0; i < bizBillNumbers.length; ++i) {
                    bizBillNumber = bizBillNumbers[i];
                    ArrayList<MakeInvoiceInfo> reqInfoList = (ArrayList<MakeInvoiceInfo>)successInfo.get(bizBillNumber);
                    if (reqInfoList == null) {
                        reqInfoList = new ArrayList<MakeInvoiceInfo>();
                    }
                    reqInfoList.add(info);
                    successInfo.put(bizBillNumber, reqInfoList);
                    genInvoiceSuccessBillNumber.add(bizBillNumber);
                }
                retValue.add(info);
            }
            if (genInvoiceSuccessBillNumber.isEmpty()) continue;
            Iterator it = genInvoiceSuccessBillNumber.iterator();
            while (it.hasNext()) {
                this.getResp().getBizFailBills().remove(it.next());
            }
        }
        return retValue;
    }

    protected void setConstantQty_calPrice(List<MakeInvoiceInfo> invoiceColl) {
        if (this.invoiceReq.getOtherParams() != null && this.invoiceReq.getOtherParams().get("isConstantQty") != null) {
            boolean isConstantQty = (Boolean)this.invoiceReq.getOtherParams().get("isConstantQty");
            if (!isConstantQty) {
                return;
            }
            if (this.invoiceReq.getOtherParams().get("constantQty") == null) {
                return;
            }
            Number tempConstantQty = (Number)this.invoiceReq.getOtherParams().get("constantQty");
            BigDecimal constantQty = null;
            constantQty = tempConstantQty instanceof Double ? BigDecimal.valueOf((Double)tempConstantQty) : (BigDecimal)tempConstantQty;
            MakeInvoiceInfo info = null;
            MakeInvoiceEntryCollection entryColl = null;
            MakeInvoiceEntryInfo entryInfo = null;
            int j = invoiceColl.size();
            for (int i = 0; i < j; ++i) {
                info = invoiceColl.get(i);
                entryColl = info.getEntries();
                int m = entryColl.size();
                for (int k = 0; k < m; ++k) {
                    entryInfo = entryColl.get(k);
                    BigDecimal quantity = IMUtils.getDecimalValue(entryInfo.getQuantity());
                    if (RowType.DISCOUNT_ROW.equals((Object)entryInfo.getBillRowType()) || BigDecimal.ZERO.compareTo(quantity) == 0 && entryInfo.getBoolean("KEY_IS_QTYZERO")) continue;
                    if (entryInfo.getDeductAmt() != null && entryInfo.getDeductAmt().compareTo(BigDecimal.ZERO) > 0) {
                        entryInfo.setBoolean("KEY_IS_CONSTANTQTY", true);
                    }
                    if (!entryInfo.getBoolean("KEY_IS_CONSTANTQTY") || quantity.compareTo(constantQty) == 0) continue;
                    if (BigDecimal.ZERO.compareTo(constantQty) == 0) {
                        entryInfo.setQuantity(BigDecimal.ZERO);
                        entryInfo.setNoTaxPrice(BigDecimal.ZERO);
                        entryInfo.setPrice(BigDecimal.ZERO);
                        continue;
                    }
                    entryInfo.setQuantity(constantQty);
                    this.calInvoiceEntryPrice(entryInfo);
                }
            }
        }
    }

    protected void reverseCalPrice(List<MakeInvoiceInfo> invoiceColl) throws BOSException {
        if (!this.invoiceReq.getPluginService().isSupportPlugin()) {
            return;
        }
        boolean isNeedCal = true;
        MakeInvoiceInfo info = null;
        MakeInvoiceEntryCollection entryColl = null;
        Object entryInfo = null;
        InvoiceParamConfigInfo paramConfigInfo = null;
        int j = invoiceColl.size();
        for (int i = 0; i < j; ++i) {
            info = invoiceColl.get(i);
            paramConfigInfo = this.invoiceReq.getPluginService().getInvoiceParamConfig(info.getCompany().getId().toString());
            isNeedCal = paramConfigInfo.isIsReverseCal();
            if (!isNeedCal) continue;
            entryColl = info.getEntries();
            int m = entryColl.size();
            for (int k = 0; k < m; ++k) {
                this.calInvoiceEntryPrice(entryColl.get(k));
            }
        }
    }

    protected void calInvoiceEntryPrice(MakeInvoiceEntryInfo entryInfo) {
        BigDecimal noTaxPrice = entryInfo.getNoTaxPrice();
        BigDecimal noTaxAmt = entryInfo.getNoTaxAmt();
        BigDecimal quantity = IMUtils.getDecimalValue(entryInfo.getQuantity());
        if (BigDecimal.ZERO.compareTo(quantity) == 0) {
            return;
        }
        int precision = 2;
        if (noTaxPrice.multiply(quantity).setScale(precision, 4).compareTo(noTaxAmt) != 0) {
            BigDecimal priceTax = entryInfo.getPriceTax();
            BigDecimal price = entryInfo.getPrice();
            noTaxPrice = noTaxAmt.divide(quantity, 10, 4);
            price = priceTax.divide(quantity, 10, 4);
            entryInfo.setNoTaxPrice(noTaxPrice);
            entryInfo.setPrice(price);
        }
    }

    protected List submitMakeInvoice(List<MakeInvoiceInfo> invoiceColl, List exList) throws BOSException, EASBizException {
        IMakeInvoice facade = MakeInvoiceFactory.getLocalInstance(this.ctx);
        ArrayList<String> errorIDs = new ArrayList<String>();
        if (this.isReq) {
            for (int i = 0; i < invoiceColl.size(); ++i) {
                MakeInvoiceInfo info = invoiceColl.get(i);
                facade.save((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
            return errorIDs;
        }
        for (int i = 0; i < invoiceColl.size(); ++i) {
            MakeInvoiceInfo info = invoiceColl.get(i);
            String billID = info.getId().toString();
            try {
                facade.save((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
                this.submitMakeInvoiceWithNewTx(this.ctx, info);
                this.auditMakeInvoiceWithNewTx(this.ctx, info);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)e.getMessage(), e);
                exList.add(new IMException(IMException.SUBMITINVOICE_ERROR, new Object[]{info.getNumber(), e.getMessage()}));
                errorIDs.add(billID);
            }
        }
        return errorIDs;
    }

    private boolean submitMakeInvoiceWithNewTx(Context ctx, MakeInvoiceInfo info) throws BOSException, EASBizException {
        try {
            Method method = MakeInvoiceControllerBean.class.getDeclaredMethod("_submit", Context.class, IObjectValue.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new MakeInvoiceControllerBean());
            txInvoker.invoke(method, new Object[]{ctx, info}, 0);
            return true;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    private boolean auditMakeInvoiceWithNewTx(Context ctx, MakeInvoiceInfo info) throws BOSException, EASBizException {
        try {
            Method method = MakeInvoiceControllerBean.class.getDeclaredMethod("_audit", Context.class, IObjectValue.class);
            method.setAccessible(true);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new MakeInvoiceControllerBean());
            txInvoker.invoke(method, new Object[]{ctx, info}, 0);
            return true;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
    }

    protected void doOtherErrorInvoice(List errorIds, List exList) throws BOSException, EASBizException {
        if (errorIds.isEmpty()) {
            return;
        }
        String sqlID = IMUtils.getInStringFromList(errorIds);
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT t2.fid ,t2.FNUMBER  FROM  T_IM_MakeInvoiceRelation t1 inner join t_im_makeinvoice t2 on t2.fid = t1.FINVOICEBILLID  ");
        sb.append(" where fgroupid in ( SELECT fgroupid FROM  T_IM_MakeInvoiceRelation where FINVOICEBILLID in " + sqlID + ")");
        IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                String id = rs.getString("fid");
                String number = rs.getString("fnumber");
                if (errorIds.contains(id)) continue;
                exList.add(new IMException(IMException.GROUP_HAS_ERRORID, new Object[]{number}));
                errorIds.add(id);
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
    }

    private MakeInvoiceInfo invoiceReq2MakeInvoiceInfo(BillReqInfo billReq, boolean isInTax) throws BOSException, EASBizException {
        BigDecimal limitAmt = this.getInvoiceLimitAmtByType(this.getInvoiceType(this.invoiceReq.getInvoiceType()) != null ? this.getInvoiceType(this.invoiceReq.getInvoiceType()).getValue() : billReq.getInvoiceType().getValue(), billReq.getCompanyID());
        MakeInvoiceInfo invoice = MakeInvoiceInfo.createMakeInvoiceInfo();
        invoice.setInvoiceType(this.getInvoiceType(billReq, this.invoiceReq.getInvoiceType()));
        if (invoice.getInvoiceType() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "InvoiceTypeIsNull", this.ctx.getLocale(), new Object[]{billReq.getBillNumber()})});
        }
        invoice.setTaxNumber(billReq.getTaxNumber());
        invoice.setReceiveCompany(billReq.getRecOrgName());
        invoice.setAddress(billReq.getAddress());
        invoice.setBankAccount(billReq.getBankAccount());
        invoice.setIsContainTax(isInTax);
        invoice.setSplit(billReq.isSplit());
        Map paramMap = IMUtils.getParam(this.ctx, billReq.getCompanyID(), new String[]{"VATM010", "VATM015"});
        int limitSplitMethod = IMUtils.getIntegerValue((String)paramMap.get("VATM010"));
        invoice.setLimitSplitMethod(limitSplitMethod);
        int goldenTaxControl = -1;
        goldenTaxControl = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoice.getInvoiceType()) ? 2 : IMUtils.getIntegerValue((String)paramMap.get("VATM015"));
        invoice.setGoldenTaxControl(goldenTaxControl);
        Map<String, String> taxControlMap = IMUtils.getTaxControlParam(this.ctx, goldenTaxControl, new String[]{"diffFactor", "allowDiffMax", "allowTotalDiffMax", "allowDiffAmtMax", "allowDiffMaxAvg"});
        BigDecimal allowDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMax"));
        invoice.setAllowDiffMax(allowDiffMax);
        BigDecimal diffFactor = IMUtils.getDecimalValue(taxControlMap.get("diffFactor"));
        invoice.setDiffFactor(diffFactor);
        BigDecimal allowTotalDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowTotalDiffMax"));
        invoice.setAllowTotalDiffMax(allowTotalDiffMax);
        BigDecimal allowDiffAmtMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffAmtMax"));
        invoice.setAllowDiffAmtMax(allowDiffAmtMax);
        BigDecimal allowDiffMaxAvg = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMaxAvg"));
        invoice.setAllowDiffMaxAvg(allowDiffMaxAvg);
        if (this.invoiceReq.getPluginService().isSupportPlugin()) {
            InvoiceParamConfigInfo config = this.invoiceReq.getPluginService().getInvoiceParamConfig(billReq.getCompanyID());
            invoice.setSplitType(config.getOverLimitAmtSplitType());
        } else {
            invoice.setSplitType(OverLimitAmtSplitTypeEnum.PriceExcludingTax);
        }
        String[] ids = billReq.getSrcBillID();
        ArrayList<String> srcBillID = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            srcBillID.add(ids[i]);
        }
        this.destBillRelation.put(invoice.getId().toString(), srcBillID);
        invoice.setLimitAmt(limitAmt);
        invoice.setApplicateDate(new Date());
        invoice.setApplicant(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        invoice.setRemark(billReq.getDescription());
        invoice.setIsList(billReq.getIsList());
        invoice.setIsPurchaseInvoice(billReq.isIsPurchaseInvoice());
        invoice.setIsVehicle(billReq.isVehicle());
        invoice.setIsDiffTax(billReq.isDiffTax());
        invoice.setBizDate(new Date());
        String companyId = billReq.getCompanyID();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        invoice.setCompany(companyInfo);
        this.beforSetCustomerInfo(invoice, billReq);
        this.overrideSetCustomerInfo(invoice, billReq);
        this.afterSetCustomerInfo(invoice, billReq);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)billReq.getCurrencyID()));
        invoice.setCurrency(currencyInfo);
        invoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        invoice.setSrcSystem(InvoiceSrcSystem.SYSTEM);
        invoice.setIsRedVoice(false);
        invoice.setIsDelete(false);
        invoice.setIsPrint(false);
        invoice.setAgentName(billReq.getAgentName());
        invoice.setAgentIDType(billReq.getAgentIDType());
        invoice.setAgentIDNumber(billReq.getAgentIDNumber());
        invoice.setAgentCountry(billReq.getAgentCountry());
        invoice.setTaxIDNumber(billReq.getTaxIDNumber());
        invoice.setSpecificService(billReq.getSpecService());
        if (invoice.getSpecificService() == null) {
            invoice.setSpecificService(SpecificServiceEnum.Normal);
        }
        invoice.setSpecificInformation(billReq.getSpecificInformation());
        this.beforSetInvoiceOrgId(invoice, billReq);
        this.overrideSetInvoiceOrgId(invoice, billReq);
        this.afterSetInvoiceOrgId(invoice, billReq);
        List<BillEntryReqInfo> billEntries = billReq.getEntrys();
        HashMap<String, String> idRelation = new HashMap<String, String>();
        int size = billEntries.size();
        for (int i = 0; i < size; ++i) {
            BillEntryReqInfo entry = billEntries.get(i);
            idRelation.put(entry.getBillEntryID(), entry.getSrcEntryID());
        }
        ArrayList<EASBizException> exceptions = new ArrayList<EASBizException>();
        int size2 = billEntries.size();
        for (int i = 0; i < size2; ++i) {
            try {
                this.invoiceReqEntry2MakeInvoiceEntry(invoice, billReq, billEntries.get(i), idRelation);
                continue;
            }
            catch (EASBizException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < exceptions.size(); ++i) {
                Exception e = (Exception)exceptions.get(i);
                sb.append(e.getMessage()).append("\r\n");
            }
            throw new IMException(IMException.ERRORMSG, new Object[]{sb.toString()});
        }
        MakeInvoiceEntryCollection entrys = invoice.getEntries();
        size2 = entrys.size();
        if (size2 == 0) {
            return null;
        }
        MakeInvoiceEntryInfo entry = null;
        MakeInvoiceEntryCollection newEntrs = new MakeInvoiceEntryCollection();
        MakeInvoiceInfo oldInvoice = (MakeInvoiceInfo)invoice.clone();
        MakeInvoiceEntryCollection oldEntrys = oldInvoice.getEntries();
        for (int i = 0; i < size2; ++i) {
            entry = entrys.get(i);
            if (this.destMap.containsKey(entry.getId().toString()) || this.srcMap.containsKey(entry.getId().toString())) {
                if (this.srcMap.containsKey(entry.getId().toString())) {
                    entry.setBillRowType(RowType.DISCOUNTED_ROW);
                } else if (this.destMap.containsKey(entry.getId().toString())) {
                    entry.setBillRowType(RowType.DISCOUNT_ROW);
                    entry.setSpecs(null);
                    entry.setMeasureUnit(null);
                    entry.setMakeInvoiceUnit(null);
                } else {
                    entry.setBillRowType(RowType.NORMAL_ROW);
                }
            }
            MakeInvoiceEntryInfo entryInfo = (MakeInvoiceEntryInfo)entry.clone();
            this.splitLimitAmtEntry(invoice, oldEntrys, newEntrs, entry, entryInfo);
        }
        newEntrs.addCollection(invoice.getEntries());
        invoice.getEntries().clear();
        invoice.getEntries().addCollection(newEntrs);
        return invoice;
    }

    public BigDecimal getInvoiceLimitAmtByType(String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM002";
        if ("0".equals(invoiceType)) {
            paramNumber = "VATM003";
        } else if ("2".equals(invoiceType)) {
            paramNumber = "VATM004";
        } else if ("3".equals(invoiceType)) {
            paramNumber = "VATM016";
        } else if ("4".equals(invoiceType)) {
            paramNumber = "VATM023";
        } else if ("5".equals(invoiceType)) {
            paramNumber = "VATM022";
        }
        BigDecimal amt = IMUtils.getDecimalParam(this.ctx, companyId, new String[]{paramNumber});
        if (("4".equals(invoiceType) || "5".equals(invoiceType)) && amt.compareTo(BigDecimal.ZERO) == 0) {
            amt = IMConstant.DIGELECAMT;
        }
        return amt;
    }

    public int getInvoiceLimitLineNum(String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM005";
        if ("4".equals(invoiceType) || "5".equals(invoiceType)) {
            paramNumber = "VATM024";
        }
        int limit = IMUtils.getDecimalParam(this.ctx, companyId, new String[]{paramNumber}).intValue();
        if (("4".equals(invoiceType) || "5".equals(invoiceType)) && limit == 0) {
            limit = IMConstant.DIGELECLIMIT;
        }
        return limit;
    }

    public int getInvoiceListLimitLineNumByType(String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM012";
        if ("2".equals(invoiceType)) {
            paramNumber = "VATM013";
        } else if ("3".equals(invoiceType)) {
            paramNumber = "VATM014";
        } else if ("4".equals(invoiceType)) {
            paramNumber = "VATM017";
        }
        return IMUtils.getDecimalParam(this.ctx, companyId, new String[]{paramNumber}).intValue();
    }

    public boolean getIsList(String companyId) throws EASBizException, BOSException {
        return IMUtils.getBooleanParam(this.ctx, companyId, "VATM007");
    }

    private void setCustomerInfo(MakeInvoiceInfo makeInvoice, BillReqInfo billReq) throws BOSException, EASBizException {
        Map ret;
        CustomerTaxInfo customerTax;
        SupplierInfo info;
        String asstActID = billReq.getCustomerID();
        String custID = "";
        if (billReq.getAsstActType() != null && "T_BD_Supplier".equalsIgnoreCase(billReq.getAsstActType().getRealtionDataObject())) {
            info = new SupplierInfo();
            if (!StringUtils.isEmpty((String)asstActID)) {
                info.setId(BOSUuid.read((String)asstActID));
                makeInvoice.setCurrAcctSupplier(info);
                custID = asstActID;
            } else {
                custID = "CUSTOMER_EMPTY";
            }
            makeInvoice.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        } else if (billReq.getAsstActType() != null && "T_BD_Customer".equalsIgnoreCase(billReq.getAsstActType().getRealtionDataObject())) {
            if (!StringUtils.isEmpty((String)asstActID)) {
                info = new CustomerInfo();
                info.setId(BOSUuid.read((String)asstActID));
                makeInvoice.setCurrAcctCustomer((CustomerInfo)info);
                custID = asstActID;
            } else {
                custID = "CUSTOMER_EMPTY";
            }
            makeInvoice.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        } else {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)custID)) {
            params.put("customerId", custID);
        }
        params.put("invoiceType", makeInvoice.getInvoiceType().getValue());
        params.put("receiveCompany", makeInvoice.getReceiveCompany());
        if (makeInvoice.getCompany() != null) {
            params.put("companyId", makeInvoice.getCompany().getId().toString());
        }
        if ((customerTax = (CustomerTaxInfo)(ret = CustomerTaxFactory.getLocalInstance(this.ctx).getCustomerTaxInfo(params)).get("value")) != null) {
            if (makeInvoice.getReceiveCompany() == null || "".equals(makeInvoice.getReceiveCompany())) {
                makeInvoice.setReceiveCompany(customerTax.getRecCompanyName());
                makeInvoice.setTaxNumber(customerTax.getTaxNumber());
                makeInvoice.setAddress(customerTax.getAddressTel());
                makeInvoice.setBankAccount(customerTax.getBankAccount());
            }
            makeInvoice.setCustomerTax(customerTax);
            CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
            CustomerTaxEntryCollection coll = customerTax.getEntries();
            int size = coll.size();
            for (int j = 0; j < size && !(entryInfo = coll.get(j)).getInvoiceType().getValue().equals(makeInvoice.getInvoiceType().getValue()); ++j) {
            }
            logger.error((Object)("method setCustomerInfo: entryInfo.getLimitAmt()" + entryInfo.getLimitAmt() + ",makeInvoice.getLimitAmt()" + makeInvoice.getLimitAmt()));
            if (entryInfo.getLimitAmt() != null && entryInfo.getLimitAmt().compareTo(BigDecimal.ZERO) > 0 && entryInfo.getLimitAmt().compareTo(makeInvoice.getLimitAmt()) < 0) {
                makeInvoice.setLimitAmt(entryInfo.getLimitAmt());
            }
            if ("1" == entryInfo.getDiscountType().getValue()) {
                makeInvoice.setSplit(true);
            } else if ("2" == entryInfo.getDiscountType().getValue()) {
                makeInvoice.setSplit(false);
            }
        } else if (billReq.getAsstActType() != null && "T_BD_Supplier".equalsIgnoreCase(billReq.getAsstActType().getRealtionDataObject()) && makeInvoice.isIsPurchaseInvoice() && !StringUtils.isEmpty((String)asstActID) && StringUtils.isEmpty((String)makeInvoice.getReceiveCompany()) && StringUtils.isEmpty((String)makeInvoice.getTaxNumber())) {
            SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)this.getCtx()).getSupplierInfo((IObjectPK)new ObjectUuidPK(asstActID));
            makeInvoice.setReceiveCompany(supplierInfo.getName());
            makeInvoice.setTaxNumber(supplierInfo.getTaxRegisterNo());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("2".equals(makeInvoice.getInvoiceType().getValue()) || "3".equals(makeInvoice.getInvoiceType().getValue())) {
            String companyOrgId = billReq.getCompanyID();
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)companyOrgId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("customer", (Object)asstActID, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            view.setSelector(selector);
            CustomerCompanyInfoCollection custCompany = CustomerCompanyInfoFactory.getLocalInstance((Context)this.ctx).getCustomerCompanyInfoCollection(view);
            if (custCompany.size() > 0) {
                CustomerCompanyInfoInfo info2 = custCompany.get(0);
                makeInvoice.setCellphone(info2.getMobile());
            }
        }
    }

    private MakeInvoiceEntryInfo invoiceReqEntry2MakeInvoiceEntry(MakeInvoiceInfo makeInvoice, BillReqInfo billReq, BillEntryReqInfo entryReq, Map idRelation) throws EASBizException, BOSException {
        MakeInvoiceEntryInfo entry = MakeInvoiceEntryInfo.createMakeInvoiceEntryInfo(makeInvoice);
        entry.setTaxClassificationCode(entryReq.getTaxClassificationCode());
        entry.setProduceName(entryReq.getProductName());
        entry.setSpecs(entryReq.getModel());
        boolean isSplit = makeInvoice.isSplit();
        this.beforeSetProduct(makeInvoice, billReq, entryReq, entry);
        this.overrideSetProduct(makeInvoice, billReq, entryReq, entry);
        this.afterSetProduct(makeInvoice, billReq, entryReq, entry);
        String billEntryID = entryReq.getBillEntryID();
        String unitID = entryReq.getMeasureUnitID();
        if (unitID != null) {
            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
            unitInfo.setId(BOSUuid.read((String)unitID));
            entry.setMeasureUnit(unitInfo);
        }
        entry.setMakeInvoiceUnit(entryReq.getMakeInvoiceUnit());
        entry.setNoTaxPrice(entryReq.getNoTaxPrice());
        entry.setPrice(entryReq.getTaxPrice());
        if (!isSplit) {
            entry.setNoTaxPrice(entryReq.getRealPrice());
            entry.setPrice(entryReq.getActualPrice());
        }
        entry.setQuantity(entryReq.getQty());
        entry.setNoTaxAmt(entryReq.getNoTaxAmount());
        entry.setTaxRate(entryReq.getTaxRate());
        entry.setTaxAmt(entryReq.getTax());
        entry.setPriceTax(entryReq.getTaxAmount());
        entry.setDiscountRate(entryReq.getDiscountRate());
        entry.setDiscountAmt(entryReq.getDiscountAmount());
        entry.setDeductAmt(entryReq.getDeductAmt());
        entry.setSeq(entryReq.getSeq());
        entry.setBoolean("KEY_IS_CONSTANTQTY", entryReq.getBoolean("KEY_IS_CONSTANTQTY"));
        entry.setBoolean("KEY_IS_QTYZERO", entryReq.isQtyZero());
        this.checkPolicies(entry);
        makeInvoice.getEntries().add(entry);
        Object srcId = idRelation.get(billEntryID);
        if (srcId == null) {
            idRelation.put(billEntryID, entry.getId().toString());
        } else {
            Object newParentMkEntryID = idRelation.get(srcId.toString());
            entry.setSourceBillEntryId(newParentMkEntryID.toString());
            this.destMap.put(entry.getId().toString(), entry.getSourceBillEntryId());
            this.srcMap.put(entry.getSourceBillEntryId(), entry.getId().toString());
            this.discountAmtMap.put(entry.getSourceBillEntryId(), entry.getAmtBySplitType(makeInvoice));
            entry.setBillRowType(RowType.DISCOUNT_ROW);
        }
        this.invoiceReq.getPluginService().unitConvert(makeInvoice, entry, billReq, entryReq);
        return entry;
    }

    protected void checkPolicies(MakeInvoiceEntryInfo entry) {
        List<BigDecimal> taxRateByPolicies;
        if (entry.isHasPreferential() && entry.getPreferentialPolicies() != null && (taxRateByPolicies = TCCUtil.getTaxRateByPolicies(entry.getPreferentialPolicies())) != null && !taxRateByPolicies.contains(entry.getTaxRate())) {
            entry.setHasPreferential(false);
            entry.setPreferentialPolicies(PreferentialPoliciesEnum.Null);
        }
    }

    protected void splitLimitAmtEntry(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryCollection oldEntrys, MakeInvoiceEntryCollection newEntrs, MakeInvoiceEntryInfo oldEntry, MakeInvoiceEntryInfo entry) throws EASBizException, BOSException {
        if (this.invoiceReq.getPluginService().isSupportPlugin()) {
            this.invoiceReq.getPluginService().splitLimitAmtEntry(makeInvoice, oldEntrys, newEntrs, oldEntry, entry);
        } else {
            logger.error((Object)"splitLimitAmtEntry default!");
            SplitLimitAmtParams params = SplitLimitAmtParams.custom().setCtx(this.ctx).setSrcMap(this.srcMap).setDestMap(this.destMap).setDiscountAmtMap(this.discountAmtMap).setSplitLimitAmtMaxCount(this.splitLimitAmtMaxCount).build();
            new SplitLimitAmt4NoTaxAmtService(params).splitLimitAmtEntry(makeInvoice, oldEntrys, newEntrs, oldEntry, entry);
        }
    }

    protected void batchFetchProductCode() throws BOSException {
        String key;
        int i;
        int size;
        this.productMaterialCache = new HashMap<String, ProductCodeCollection>();
        this.productExpenseItemCache = new HashMap<String, ProductCodeCollection>();
        this.productCache = new HashMap<String, ProductCodeInfo>();
        List<BillReqInfo> bills = this.invoiceReq.getBills();
        HashSet<String> materialIDs = new HashSet<String>();
        HashSet<String> expenseItemIDS = new HashSet<String>();
        HashSet<String> productIDS = new HashSet<String>();
        ArrayList bizFailBills = this.getResp().getBizFailBills();
        ProductCodeInfo productCodeInfo = null;
        for (BillReqInfo billReq : bills) {
            String bizBillNumber = billReq.getBillNumber();
            if (bizFailBills.contains(bizBillNumber)) continue;
            size = billReq.getEntrys().size();
            for (i = 0; i < size; ++i) {
                String expenseItemID;
                BillEntryReqInfo entryReq = billReq.getEntrys().get(i);
                String materialID = entryReq.getMaterialID();
                if (!StringUtils.isEmpty((String)materialID)) {
                    materialIDs.add(materialID);
                }
                if (!StringUtils.isEmpty((String)(expenseItemID = entryReq.getExpenseItemID()))) {
                    expenseItemIDS.add(expenseItemID);
                }
                if ((productCodeInfo = entryReq.getProductCode()) == null) continue;
                productIDS.add(productCodeInfo.getId().toString());
            }
        }
        if (materialIDs.size() > 0) {
            ProductCodeCollection productMaterialColl = this.getProductCodeCollection("material", materialIDs, null);
            size = productMaterialColl.size();
            for (i = 0; i < size; ++i) {
                productCodeInfo = productMaterialColl.get(i);
                key = productCodeInfo.getMaterial().getId().toString() + "_" + this.formatTaxRate(productCodeInfo.getTaxRate());
                if (!this.productMaterialCache.containsKey(key)) {
                    this.productMaterialCache.put(key, new ProductCodeCollection());
                }
                this.productMaterialCache.get(key).add(productCodeInfo);
            }
        }
        if (expenseItemIDS.size() > 0) {
            ProductCodeCollection productExpenseItemColl = this.getProductCodeCollection("expenseItem", null, expenseItemIDS);
            size = productExpenseItemColl.size();
            for (i = 0; i < size; ++i) {
                productCodeInfo = productExpenseItemColl.get(i);
                key = productCodeInfo.getExpenseItem().getId().toString() + "_" + this.formatTaxRate(productCodeInfo.getTaxRate());
                if (!this.productExpenseItemCache.containsKey(key)) {
                    this.productExpenseItemCache.put(key, new ProductCodeCollection());
                }
                this.productExpenseItemCache.get(key).add(productCodeInfo);
            }
        }
        if (productIDS.size() > 0) {
            ProductCodeCollection productColl = this.getProductCodeCollection(productIDS);
            int size2 = productColl.size();
            for (int i2 = 0; i2 < size2; ++i2) {
                productCodeInfo = productColl.get(i2);
                this.productCache.put(productCodeInfo.getId().toString(), productCodeInfo);
            }
        }
    }

    protected ProductCodeCollection getProductCodeCollection(String productRelation, Set materialIDs, Set expenseIDS) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("material".equals(productRelation)) {
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIDs, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("expenseItem", (Object)expenseIDS, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("customer.id"));
        view.setSorter(sort);
        view.setFilter(filter);
        view.setSelector(this.getProductCodeSelector());
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(this.ctx).getProductCodeCollection(view);
        return coll;
    }

    protected SelectorItemCollection getProductCodeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("expenseItem.id"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("hasPreferential"));
        sic.add(new SelectorItemInfo("preferentialPolicies"));
        sic.add(new SelectorItemInfo("taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("taxClassificationCode.simpleName"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        return sic;
    }

    protected ProductCodeCollection getProductCodeCollection(Set productIDS) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)productIDS, CompareType.INCLUDE));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("customer.id"));
        view.setSorter(sort);
        view.setFilter(filter);
        view.setSelector(this.getProductCodeSelector());
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(this.ctx).getProductCodeCollection(view);
        return coll;
    }

    private String formatTaxRate(BigDecimal taxRate) {
        if (taxRate == null) {
            return "";
        }
        return taxRate.setScale(4, 4).toPlainString();
    }

    private ProductCodeInfo getProductName(String productRelation, String materialExpenseID, BillReqInfo billReq, BigDecimal taxRate) throws BOSException, IMException {
        String customerID = billReq.getCustomerID();
        String companyID = billReq.getCompanyID();
        ProductCodeInfo product = null;
        ProductCodeCollection coll = "material".equals(productRelation) ? this.productMaterialCache.get(materialExpenseID + "_" + this.formatTaxRate(taxRate)) : this.productExpenseItemCache.get(materialExpenseID + "_" + this.formatTaxRate(taxRate));
        if (coll != null && coll.size() > 0) {
            ProductCodeCollection sameCustomer = new ProductCodeCollection();
            ProductCodeCollection sameCompany = new ProductCodeCollection();
            ProductCodeCollection allNull = new ProductCodeCollection();
            for (int i = 0; i < coll.size(); ++i) {
                ProductCodeInfo info = coll.get(i);
                if (billReq.isVehicle() && !"\u673a\u52a8\u8f66".equals(info.getTaxClassificationCode().getSimpleName())) continue;
                if (info.getCustomer() != null && info.getCompany() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID) || !info.getCompany().getId().toString().equals(companyID)) continue;
                    return info;
                }
                if (info.getCompany() != null) {
                    if (!info.getCompany().getId().toString().equals(companyID)) continue;
                    sameCompany.add(info);
                    continue;
                }
                if (info.getCustomer() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID)) continue;
                    sameCustomer.add(info);
                    continue;
                }
                allNull.add(info);
            }
            if (sameCompany.size() > 0) {
                product = sameCompany.get(0);
            } else if (sameCustomer.size() > 0) {
                product = sameCustomer.get(0);
            } else if (allNull.size() > 0) {
                product = allNull.get(0);
            }
        }
        return product;
    }

    private PayInvoiceTypeEnum getInvoiceType(BillReqInfo billReq, String reqInvoiceType) throws EASBizException {
        String billName = (String)this.ctx.get((Object)"billName");
        if (!StringUtils.isEmpty((String)billName) && ("0".equals(reqInvoiceType) || reqInvoiceType == null && billReq.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE && billReq.getInvoiceType() != null)) {
            return billReq.getInvoiceType();
        }
        return this.getInvoiceType(reqInvoiceType);
    }

    private PayInvoiceTypeEnum getInvoiceType(String reqInvoiceType) {
        PayInvoiceTypeEnum retValue = null;
        if ("1".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if ("2".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if ("3".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if ("4".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if ("5".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if ("6".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        }
        return retValue;
    }

    private void buildCombinRule(CombinRuleSettingInfo combinRule, ArrayList<String> entryProp) throws BOSException {
        if (combinRule == null || combinRule.getCombinFields() == null) {
            entryProp.add("id");
        } else {
            String[] properties = combinRule.getCombinFields().split("_");
            for (int i = 0; i < properties.length; ++i) {
                String value = properties[i];
                String[] tempValue = value.split("\\.");
                if (tempValue.length <= 1 || entryProp.contains(tempValue[1])) continue;
                entryProp.add(tempValue[1]);
            }
        }
    }

    public boolean isNotPrint() {
        return this.isPrint;
    }

    public void setNotPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    private void beforSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforSetCustomerInfo(this.ctx, invoice, billReq);
    }

    private void overrideSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetCustomerInfo(this.ctx, invoice, billReq)) {
            this.setCustomerInfo(invoice, billReq);
        }
    }

    private void afterSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterCustomerInfo(this.ctx, invoice, billReq);
    }

    private void beforSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforeSetInvoiceOrgId(this.ctx, invoice, billReq);
    }

    private void overrideSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetInvoiceOrgId(this.ctx, invoice, billReq)) {
            invoice.setMakeInvoiceOrgID(billReq.getCompanyID());
        }
    }

    private void afterSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterSetInvoiceOrgId(this.ctx, invoice, billReq);
    }

    private void beforeSetProduct(MakeInvoiceInfo invoice, BillReqInfo billReq, BillEntryReqInfo entryReq, MakeInvoiceEntryInfo entry) throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforeSetProduct(this.ctx, invoice, billReq, entryReq, entry);
    }

    private void overrideSetProduct(MakeInvoiceInfo invoice, BillReqInfo billReq, BillEntryReqInfo entryReq, MakeInvoiceEntryInfo entry) throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetProduct(this.ctx, invoice, billReq, entryReq, entry)) {
            if (IMConstant.SRCTYPE_IM_INVOICEREQ.equals(this.invoiceReq.getSrcSystem())) {
                this.setMKReqProduct(invoice, billReq, entryReq, entry);
            } else {
                this.setProduct(invoice, billReq, entryReq, entry);
            }
        }
    }

    private void setProduct(MakeInvoiceInfo makeInvoice, BillReqInfo billReq, BillEntryReqInfo entryReq, MakeInvoiceEntryInfo entry) throws BOSException, IMException {
        SpecsCarryTypeEnum specsSource = IMConstant.SRCTYPE_IM_VEHICLEREQ.equals(this.invoiceReq.getSrcSystem()) || IMConstant.SRCTYPE_IM_USEDCARREQ.equals(this.invoiceReq.getSrcSystem()) ? SpecsCarryTypeEnum.SourceBill : SpecsCarryTypeEnum.ProductCode;
        String companyID = makeInvoice.getCompany().getId().toString();
        if (this.invoiceReq.getPluginService().isSupportPlugin()) {
            InvoiceParamConfigInfo paramConfigInfo = this.invoiceReq.getPluginService().getInvoiceParamConfig(companyID);
            specsSource = paramConfigInfo.getSpecsCarryType();
        }
        ProductCodeInfo prodcut = entryReq.getProductCode();
        String materialID = entryReq.getMaterialID();
        String expenseItemID = entryReq.getExpenseItemID();
        if (prodcut == null && entryReq.getProductName() == null) {
            BigDecimal taxRate = entryReq.getTaxRate();
            String resName = "PRODUCTERROR";
            if (materialID != null) {
                prodcut = this.getProductName("material", materialID, billReq, taxRate);
            } else {
                resName = "Product_error_expenseItem";
                prodcut = this.getProductName("expenseItem", expenseItemID, billReq, taxRate);
            }
            if (prodcut == null) {
                String errorMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", resName, this.ctx.getLocale(), new Object[]{entryReq.get("parentNumber"), entryReq.getMaterialNumber(), entryReq.getMaterialName()});
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg});
            }
            entry.setProduceName(prodcut.getName());
            entry.setEntryName(prodcut);
            if (prodcut.getTaxClassificationCode() != null) {
                entry.setTaxClassificationCode(prodcut.getTaxClassificationCode().getMergeCode());
            }
            entry.setHasPreferential(prodcut.isHasPreferential());
            entry.setPreferentialPolicies(prodcut.getPreferentialPolicies());
            if (SpecsCarryTypeEnum.ProductCode == specsSource) {
                entry.setSpecs(prodcut.getModel());
            }
        } else if (prodcut != null) {
            entry.setEntryName(prodcut);
            entry.setHasPreferential(prodcut.isHasPreferential());
            entry.setPreferentialPolicies(prodcut.getPreferentialPolicies());
            if (SpecsCarryTypeEnum.ProductCode == specsSource) {
                entry.setSpecs(prodcut.getModel());
            }
        }
    }

    private void setMKReqProduct(MakeInvoiceInfo makeInvoice, BillReqInfo billReq, BillEntryReqInfo entryReq, MakeInvoiceEntryInfo entry) throws BOSException, IMException {
        ProductCodeInfo prodcut = entryReq.getProductCode();
        String materialID = entryReq.getMaterialID();
        String expenseItemID = entryReq.getExpenseItemID();
        BigDecimal taxRate = entryReq.getTaxRate();
        ProductCodeInfo matchProdcut = null;
        if (materialID != null) {
            matchProdcut = this.getProductName("material", materialID, billReq, taxRate);
        } else if (expenseItemID != null) {
            matchProdcut = this.getProductName("expenseItem", expenseItemID, billReq, taxRate);
        }
        if (prodcut != null) {
            ProductCodeInfo reloadProduct = this.productCache.get(prodcut.getId().toString());
            if (reloadProduct != null) {
                prodcut = reloadProduct;
            }
            this.fillProductCode(makeInvoice, entry, prodcut);
        }
        if (matchProdcut != null) {
            this.fillProductCode(makeInvoice, entry, matchProdcut);
        }
        if (makeInvoice.isIsVehicle()) {
            entry.setSpecs(entryReq.getModel());
        }
    }

    protected void fillProductCode(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryInfo entry, ProductCodeInfo prodcut) throws BOSException {
        SpecsCarryTypeEnum specsSource = IMConstant.SRCTYPE_IM_VEHICLEREQ.equals(this.invoiceReq.getSrcSystem()) || IMConstant.SRCTYPE_IM_USEDCARREQ.equals(this.invoiceReq.getSrcSystem()) ? SpecsCarryTypeEnum.SourceBill : SpecsCarryTypeEnum.ProductCode;
        String companyID = makeInvoice.getCompany().getId().toString();
        if (this.invoiceReq.getPluginService().isSupportPlugin()) {
            InvoiceParamConfigInfo paramConfigInfo = this.invoiceReq.getPluginService().getInvoiceParamConfig(companyID);
            specsSource = paramConfigInfo.getSpecsCarryType();
        }
        if (prodcut != null) {
            entry.setEntryName(prodcut);
            if (SpecsCarryTypeEnum.ProductCode == specsSource) {
                entry.setSpecs(prodcut.getModel());
            }
            if (prodcut.getTaxClassificationCode() != null) {
                entry.setTaxClassificationCode(prodcut.getTaxClassificationCode().getMergeCode());
            }
            entry.setHasPreferential(prodcut.isHasPreferential());
            entry.setPreferentialPolicies(prodcut.getPreferentialPolicies());
        }
    }

    private void afterSetProduct(MakeInvoiceInfo invoice, BillReqInfo billReq, BillEntryReqInfo entryReq, MakeInvoiceEntryInfo entry) throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterSetProduct(this.ctx, invoice, billReq, entryReq, entry);
    }

    public boolean isPrint() {
        return this.isPrint;
    }

    public void setPrint(boolean isPrint) {
        this.isPrint = isPrint;
    }

    public boolean isReq() {
        return this.isReq;
    }

    public void setReq(boolean isReq) {
        this.isReq = isReq;
    }
}

