/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryRespInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.BillRespInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.app.IInvoiceReqHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractInvoiceReqHandler
implements IInvoiceReqHandler {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.AbstractInvoiceReqHandler");
    protected InvoiceReqInfo invoiceReq;
    protected Context ctx;
    private InvoiceRespInfo resp = new InvoiceRespInfo();
    protected Map<String, ArrayList> destBillRelation = new HashMap<String, ArrayList>();

    public AbstractInvoiceReqHandler(Context ctx, InvoiceReqInfo invoiceReq) {
        this.ctx = ctx;
        this.invoiceReq = invoiceReq;
    }

    protected abstract ArrayList handleBills(List var1) throws Exception;

    protected abstract void checkInvoiceReq() throws IMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvoiceRespInfo handle() {
        ArrayList<Throwable> exList = new ArrayList<Throwable>();
        try {
            this.checkInvoiceReq();
            this.beforeHandle();
            ArrayList ids = this.handleBills(exList);
            this.resp.setMkSucessBillIds(ids);
            this.resp.setDestBillRelation(this.destBillRelation);
        }
        catch (Throwable e) {
            List<BillReqInfo> bills = this.invoiceReq.getBills();
            int size = bills.size();
            for (int idx = 0; idx < size; ++idx) {
                String[] bizBillNumbers;
                if (bills.get(idx).getBillNumber() == null) continue;
                for (String number : bizBillNumbers = bills.get(idx).getBillNumber().split(";")) {
                    if (this.getResp().getBizFailBills().contains(number)) continue;
                    this.getResp().getBizFailBills().add(number);
                }
            }
            this.logger.error((Object)("handle:" + e.getMessage()), e);
            exList.add(e);
        }
        finally {
            try {
                this.afterHandle();
            }
            catch (Exception e) {
                this.logger.error((Object)("handle:" + e.getMessage()), (Throwable)e);
                exList.add(e);
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < exList.size(); ++i) {
            Throwable e = (Throwable)exList.get(i);
            sb.append(e.getMessage()).append("\r\n");
        }
        this.resp.setErrorMsg(sb.toString());
        return this.resp;
    }

    protected void beforeHandle() throws EASBizException, BOSException {
        this.batchFecthData();
        this.initData();
    }

    protected void afterHandle() throws EASBizException, BOSException {
        this.clearCache();
    }

    protected void batchFecthData() throws EASBizException, BOSException {
    }

    protected void initData() {
    }

    protected void clearCache() throws EASBizException, BOSException {
    }

    public void setRespError(BillRespInfo resp, Exception e) {
        resp.setStatusCode("500");
        resp.setDescription(e.getMessage());
        this.logger.error((Object)e.getMessage(), (Throwable)e);
    }

    public void setRespError(BillEntryRespInfo resp, Exception e) {
        resp.setStatusCode("500");
        resp.setDescription(e.getMessage());
        this.logger.error((Object)e.getMessage(), (Throwable)e);
    }

    public void setRespError(BillEntryRespInfo resp, Map retMap) {
        resp.setStatusCode((String)retMap.get("errcode"));
        resp.setDescription((String)retMap.get("description"));
    }

    public InvoiceReqInfo getInvoiceReq() {
        return this.invoiceReq;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public InvoiceRespInfo getResp() {
        return this.resp;
    }

    public void setResp(InvoiceRespInfo resp) {
        this.resp = resp;
    }
}

