/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryRespInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.app.AbstractInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.IInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractPrintInvoiceReqHandler
extends AbstractInvoiceReqHandler
implements IInvoiceReqHandler {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.AbstractPrintInvoiceReqHandler");

    public AbstractPrintInvoiceReqHandler(Context ctx, InvoiceReqInfo invoiceReq) {
        super(ctx, invoiceReq);
    }

    protected abstract void handleInvoice(MakeInvoiceInfo var1, BillEntryRespInfo var2);

    @Override
    protected ArrayList handleBills(List exceptionList) throws Exception {
        Set<String> billIdSet = this.collectBill(this.invoiceReq.getBills());
        ArrayList<String> makeBillIDs = new ArrayList<String>();
        MakeInvoiceCollection invoiceColl = this.queryInvoices(billIdSet);
        if (invoiceColl != null) {
            for (int i = 0; i < invoiceColl.size(); ++i) {
                MakeInvoiceInfo invoiceInfo = invoiceColl.get(i);
                if (makeBillIDs.contains(invoiceInfo.getId().toString())) continue;
                makeBillIDs.add(invoiceInfo.getId().toString());
            }
        }
        return makeBillIDs;
    }

    private Set<String> collectBill(List<BillReqInfo> bills) {
        HashSet<String> billIdSet = new HashSet<String>();
        int size = bills.size();
        for (int idx = 0; idx < size; ++idx) {
            BillReqInfo billReq = bills.get(idx);
            if (billReq.getBillId() == null) continue;
            billIdSet.add(billReq.getBillId());
        }
        return billIdSet;
    }

    private MakeInvoiceCollection queryInvoices(Set<String> billIdSet) throws EASBizException, BOSException {
        MakeInvoiceCollection invoiceColl = this.getInvoiceByBills(billIdSet);
        if (invoiceColl.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(this.ctx, "INVOICE_NOTFOUND", new String[0])});
        }
        return invoiceColl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MakeInvoiceCollection getInvoiceByBills(Set<String> billIdSet) throws BOSException, EASBizException {
        Set<String> invoiceNoSet = this.getInvoiceNoListByAROtherBillIDSet(billIdSet);
        MakeInvoiceCollection invoiceColl = new MakeInvoiceCollection();
        if (billIdSet.size() == 0) {
            return invoiceColl;
        }
        String selectSQL = "SELECT relation.FInvoiceBillID as invoiceID FROM T_IM_MakeInvoiceRelation as relation  INNER JOIN T_IM_MakeInvoice as mkBill on mkBill.fid = relation.FInvoiceBillID  WHERE relation.FBizBillID IN (" + InvoiceReqUtils.concat(billIdSet) + ") and mkBill.FStatus = '4' and mkBill.FInvoiceNo in (" + InvoiceReqUtils.concat(invoiceNoSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSQL);
        try {
            while (rs.next()) {
                try {
                    String invoiceID = rs.getString("invoiceID");
                    MakeInvoiceInfo invoice = MakeInvoiceFactory.getLocalInstance(this.ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceID), MakeInvoiceInfo.getPrintSelector());
                    invoiceColl.add(invoice);
                }
                catch (ObjectNotFoundException e) {
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(this.ctx, "QUERYINVOICE_FAILURE", new String[0])});
                    return invoiceColl;
                }
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private Set<String> getInvoiceNoListByAROtherBillIDSet(Set<String> billIdSet) throws BOSException {
        String billID = billIdSet.iterator().next();
        String bosType = BOSUuid.read((String)billID).getType().toString();
        String tableName = bosType.equals("FC910EF3") ? "t_ar_otherbill" : "t_im_makeInvoiceReq";
        try {
            String selectSQL = "select FInvoiceNo from " + tableName + " where fid in (" + InvoiceReqUtils.concat(billIdSet) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSQL);
            HashSet<String> invoiceNoSet = new HashSet<String>();
            while (rs.next()) {
                String invoiceNo = rs.getString("FInvoiceNo");
                if (invoiceNo == null || "".equals(invoiceNo)) continue;
                String[] invoiceNoArr = invoiceNo.split(";");
                for (int i = 0; i < invoiceNoArr.length; ++i) {
                    invoiceNoSet.add(invoiceNoArr[i]);
                }
            }
            return invoiceNoSet;
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }
}

