/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.InvoiceBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoicePoolService;
import com.kingdee.eas.tm.common.invoicePool.utils.converter.AbstractConverter;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.app.AbstractAddSyncDownloadInvFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.ITaxTransLog;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.AddSyncMsg;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class AddSyncDownloadInvFacadeControllerBean
extends AbstractAddSyncDownloadInvFacadeControllerBean {
    private static Logger logger = Logger.getLogger(AddSyncDownloadInvFacadeControllerBean.class);
    private int TIME_OUT = 10;

    @Override
    protected Map _addSync(Context ctx, IObjectCollection companyRange) throws BOSException, EASBizException {
        logger.error((Object)"enter method _addSync.");
        Context newCtx = null;
        StringBuffer errorBuffer = new StringBuffer();
        HashMap ret = new HashMap();
        try {
            newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
            if ("00000000-0000-0000-0000-00000000000013B7DE7F".equals(newCtx.getCaller().toString())) {
                newCtx.setCaller((IObjectPK)new ObjectUuidPK("256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            }
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            newCtx.put((Object)"UserInfo", (Object)userInfo);
            newCtx.setUserName("user");
        }
        catch (CloneNotSupportedException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (companyRange == null) {
            this.sendBMCMsg(newCtx, IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "companyNotNull", newCtx.getLocale()));
            return ret;
        }
        Set<String> companyIDs = AddSyncDownloadInvFacadeControllerBean.getCompanyIds(newCtx, companyRange, errorBuffer);
        List paramList = this.buildIncomePwyParam(newCtx, companyIDs);
        if (paramList.isEmpty()) {
            this.sendBMCMsg(newCtx, errorBuffer.toString());
            return ret;
        }
        errorBuffer.append("\r\n").append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "downloadMsgTitle", newCtx.getLocale())).append("\r\n");
        List list = PwyServiceFacadeFactory.getLocalInstance(newCtx).buildPwyParam(paramList);
        this.handleDownloadAddSync(ctx, newCtx, errorBuffer, list);
        this.sendBMCMsg(newCtx, errorBuffer.toString());
        logger.error((Object)"exit method _addSync.");
        return ret;
    }

    private void handleDownloadAddSync(Context ctx, Context newCtx, StringBuffer errorBuffer, List list) throws BOSException, EASBizException {
        int i;
        ArrayList<String> errorMsg = new ArrayList<String>();
        PwyInvokeParam invokeParam = null;
        Map invokeActionMap = null;
        ArrayList<AddSyncMsg> addSyncList = new ArrayList<AddSyncMsg>();
        for (i = 0; i < list.size(); ++i) {
            invokeParam = (PwyInvokeParam)list.get(i);
            if (invokeParam.isError()) {
                errorMsg.add(invokeParam.getExceptionMsg());
                continue;
            }
            IPwyService pwyService = PwyServiceHelper.getPwyService(newCtx, invokeParam);
            pwyService.invoke();
            Map pwyData = (Map)invokeParam.getParams().get("pwyData");
            if (!pwyService.isSuccess()) {
                errorBuffer.append((String)pwyData.get("taxNo")).append("\uff1a");
                errorBuffer.append(pwyService.getInvokeParam().getDescription());
                errorBuffer.append("\r\n");
                continue;
            }
            invokeActionMap = pwyService.getInvokeParam().getInvokeActionMap();
            if (invokeActionMap == null) continue;
            List singleAddSyncList = (List)invokeActionMap.get("addSyncList");
            if (singleAddSyncList.size() == 0) {
                errorBuffer.append((String)pwyData.get("taxNo")).append("\uff1a");
                errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "BatchNoIsNULL", newCtx.getLocale()));
                errorBuffer.append("\r\n");
                continue;
            }
            addSyncList.addAll(singleAddSyncList);
        }
        if (addSyncList.size() != 0) {
            this.downloadWithMultithread(addSyncList, newCtx);
        }
        for (i = 0; i < addSyncList.size(); ++i) {
            this.handleAddSyncSingle(newCtx, errorBuffer, addSyncList, i);
        }
        errorBuffer.append(IMUtils.buildErrorMsg(errorMsg));
    }

    private void handleAddSyncSingle(Context newCtx, StringBuffer errorBuffer, List<AddSyncMsg> addSyncList, int i) throws BOSException, EASBizException {
        AddSyncMsg msg = addSyncList.get(i);
        String batchNo = msg.getBatchNo();
        String logId = msg.getLogID();
        String taxNo = msg.getTaxNo();
        if (StringUtils.isEmpty((String)logId)) {
            errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "downloadMsg", newCtx.getLocale(), new Object[]{msg.getTaxNo(), batchNo + ":" + msg.getMsg()}));
            errorBuffer.append("\r\n");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            ITaxTransLog iTaxTransLog = TaxTransLogFactory.getLocalInstance(newCtx);
            TaxTransLogInfo log = iTaxTransLog.getTaxTransLogInfo((IObjectPK)new ObjectUuidPK(logId));
            while (StringUtils.isEmpty((String)log.getRevMsg())) {
                if (System.currentTimeMillis() - start > (long)(this.TIME_OUT * 60 * 1000)) {
                    logger.error((Object)"handleAddSyncSingle time out");
                    break;
                }
                Thread.sleep(2000L);
                log = iTaxTransLog.getTaxTransLogInfo((IObjectPK)new ObjectUuidPK(logId));
            }
            JSONObject queryResultJson = new JSONObject(log.getRevMsg());
            String errorCode = queryResultJson.getString("errcode");
            String description = queryResultJson.getString("description");
            if ("0000".equals(errorCode)) {
                JSONArray invoiceArray = queryResultJson.getJSONArray("data");
                TaxNoSumResult sumRet = null;
                Map params = msg.getParams();
                if (params.get("sumRet") instanceof TaxNoSumResult) {
                    sumRet = (TaxNoSumResult)params.get("sumRet");
                }
                Map<String, CompanyOrgUnitInfo> companyMap = IncomeInvoicePwyHelper.matchPwySettingCompany(sumRet);
                DownloadInvoiceParams downloadParams = new DownloadInvoiceParams(DownloadInvoiceType.ADD);
                downloadParams.putAll(params);
                downloadParams.put((Object)"batchNo", (Object)batchNo);
                downloadParams.setCompanyMap(companyMap);
                String invoiceType = null;
                int syncTotalNum = 0;
                int downloadSum = invoiceArray.length();
                IObjectValue obj = null;
                ArrayList<IObjectValue> invoiceList = new ArrayList<IObjectValue>();
                int size = invoiceArray.length();
                for (int j = 0; j < size; ++j) {
                    JSONObject jsonObject = invoiceArray.getJSONObject(j);
                    invoiceType = jsonObject.getString("invoiceType");
                    AbstractConverter converter = InvoicePoolService.getConverter((Context)newCtx, (CreateInvoiceParams)downloadParams, (JSONObject)jsonObject, (String)invoiceType);
                    String id = converter.parseInvoice();
                    if (converter.getModel() != null) {
                        obj = converter.getModel();
                        invoiceList.add(obj);
                    }
                    if (StringUtils.isEmpty((String)id)) continue;
                    ++syncTotalNum;
                }
                Map imTempParams = IMFacadeFactory.getLocalInstance(newCtx).getIMTempParamByKey(new String[]{"isSendBMCMessage"});
                BillBaseInfo invoiceInfo = null;
                Object statusChaged = null;
                if (imTempParams != null && "1".equals((String)imTempParams.get("isSendBMCMessage"))) {
                    String title = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "INVOICESTATUS_CHANGE_WARNING", newCtx.getLocale());
                    StringBuffer bmcMsg = new StringBuffer();
                    int size2 = invoiceList.size();
                    for (int j = 0; j < size2; ++j) {
                        invoiceInfo = (BillBaseInfo)invoiceList.get(j);
                        statusChaged = invoiceInfo.get("statusChaged");
                        if (statusChaged == null || !Boolean.parseBoolean(statusChaged.toString())) continue;
                        if (invoiceInfo instanceof InvoiceBaseInfo) {
                            bmcMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "STATUS_WARNING_CONTENT", newCtx.getLocale(), new Object[]{invoiceInfo.getCompany().getName(), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNo"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                            continue;
                        }
                        bmcMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "STATUS_WARNING_CONTENT", newCtx.getLocale(), new Object[]{invoiceInfo.getCompany().getName(), invoiceInfo.get("invoiceCode") + "_" + invoiceInfo.get("invoiceNumber"), invoiceInfo.get("oldStatus"), invoiceInfo.get("CurStatus")}));
                    }
                    if (bmcMsg.length() > 0) {
                        IMUtils.sendBMCMsg(newCtx, bmcMsg.toString(), title, MsgBizType.FORWARN, newCtx.getCaller().toString());
                        if (!"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(newCtx.getCaller().toString())) {
                            IMUtils.sendBMCMsg(newCtx, bmcMsg.toString(), title, MsgBizType.FORWARN, "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F");
                        }
                    }
                }
                msg.setMsg(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "downloadMsgDetail", newCtx.getLocale(), new Object[]{batchNo, TMInvoiceType.getEnum((String)invoiceType), syncTotalNum, downloadSum - syncTotalNum}));
                if (!StringUtils.isEmpty((String)batchNo)) {
                    String status = "2";
                    if (syncTotalNum == 0 && downloadSum != 0) {
                        status = "3";
                    } else if (syncTotalNum < downloadSum) {
                        status = "4";
                    } else if (syncTotalNum == downloadSum) {
                        status = "1";
                    } else {
                        logger.error((Object)("sync fail\uff0ctaxNo=" + taxNo + ",batchNo=" + batchNo + ",downloadSum=" + downloadSum + ",syncTotalNum=" + syncTotalNum));
                        return;
                    }
                    HashMap<String, Object> tempParam = new HashMap<String, Object>();
                    tempParam.put("taxNo", taxNo);
                    tempParam.put("batchNo", batchNo);
                    tempParam.put("status", status);
                    tempParam.put("syncTotalNum", syncTotalNum);
                    tempParam.put("consumerType", "EAS");
                    this.callReceipt(newCtx, tempParam, msg.getOrgId());
                }
            } else {
                msg.setMsg(description);
            }
        }
        catch (Exception e) {
            msg.setMsg(e.getMessage());
            logger.error((Object)("AddSyncDownloadInvFacadeControllerBean: parse error " + e.getMessage()), (Throwable)e);
        }
        errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "downloadMsg", newCtx.getLocale(), new Object[]{msg.getTaxNo(), msg.getMsg()}));
        errorBuffer.append("\r\n");
    }

    private void callReceipt(Context ctx, Map tempParam, String orgId) throws BOSException, EASBizException {
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_ADD_SYNC_RECEIPT, TransSrcSystemEnum.easgui, orgId, tempParam);
        paramList.add(actionParam);
        List list = PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
        PwyInvokeParam invokeParam = (PwyInvokeParam)list.get(0);
        if (invokeParam.isError()) {
            logger.error((Object)("AddSyncDownloadInvFacadeControllerBean callReceipt: " + invokeParam.getExceptionMsg()));
            return;
        }
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.invoke();
    }

    protected void downloadWithMultithread(List<AddSyncMsg> addSyncList, Context ctx) throws BOSException {
        ExecutorService service = null;
        try {
            int defaultThreadPoolSize = 8;
            int size = addSyncList.size();
            int threadPoolsize = size > defaultThreadPoolSize ? defaultThreadPoolSize : size;
            service = Executors.newFixedThreadPool(threadPoolsize);
            CountDownLatch latch = new CountDownLatch(size);
            AddSyncMsg addSyncMsg = null;
            for (int i = 0; i < size; ++i) {
                addSyncMsg = addSyncList.get(i);
                DownloadTask task = new DownloadTask(ctx, addSyncMsg, latch);
                service.execute(task);
            }
            latch.await();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
    }

    public static Set<String> getCompanyIds(Context newCtx, IObjectCollection companyRange, StringBuffer errorBuffer) throws EASBizException, BOSException {
        HashSet<String> companySet = new HashSet<String>();
        for (IObjectValue companyInfo : companyRange) {
            if (null == companyInfo.get("id")) continue;
            String id = companyInfo.get("id").toString();
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)newCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
            if (company == null) {
                FullOrgUnitInfo orgUnit = FullOrgUnitFactory.getLocalInstance((Context)newCtx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "isNoCompany", newCtx.getLocale(), new Object[]{orgUnit.getName()}));
                errorBuffer.append("\r\n");
                logger.error((Object)("company is null,id=" + id));
                continue;
            }
            if (!StringUtils.isEmpty((String)company.getTaxNumber())) {
                PwySettingInfo pwyInfo = (PwySettingInfo)PwySettingFactory.getLocalInstance(newCtx).getPwySetting(id, OPTypeEnum.RecInvoice, null, null);
                if (pwyInfo == null) {
                    errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "pwySettingIsNull", newCtx.getLocale(), new Object[]{company.getName()}));
                    errorBuffer.append("\r\n");
                    continue;
                }
                companySet.add(id);
                continue;
            }
            errorBuffer.append(IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "taxNumberIsNull", newCtx.getLocale(), new Object[]{company.getName()}));
            errorBuffer.append("\r\n");
        }
        return companySet;
    }

    private List buildIncomePwyParam(Context ctx, Set companyIDs) throws EASBizException, BOSException {
        PwyServiceType msgType = PwyServiceType.OPR_INV_ADD_SYNC_BATCHNO;
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = null;
        Map resultMap = PwySettingFactory.getLocalInstance(ctx).getTaxNoSumResult(companyIDs);
        HashMap tempParam = null;
        HashMap<String, Object> newPwyData = null;
        for (String taxNo : resultMap.keySet()) {
            tempParam = new HashMap();
            newPwyData = new HashMap<String, Object>();
            newPwyData.put("taxNo", taxNo);
            newPwyData.put("dataType", "1");
            newPwyData.put("syncStatusList", "2,3,4");
            newPwyData.put("currentPage", 1);
            newPwyData.put("pageSize", 200);
            newPwyData.put("consumerType", "EAS");
            tempParam.put("sumRet", resultMap.get(taxNo));
            tempParam.put("pwyData", newPwyData);
            actionParam = new PwyActionParam(msgType, TransSrcSystemEnum.easgui, ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany().getId().toString(), tempParam);
            paramList.add(actionParam);
        }
        return paramList;
    }

    private void sendBMCMsg(Context newCtx, String msg) throws EASBizException, BOSException {
        String title = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "TITLE", newCtx.getLocale());
        if (StringUtils.isEmpty((String)msg)) {
            msg = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "SUCCESS", newCtx.getLocale());
        }
        IMUtils.sendBMCMsg(newCtx, msg, title, newCtx.getCaller().toString());
    }

    public void DownloadSingle(Context ctx, AddSyncMsg addSyncMsg) throws EASBizException, BOSException {
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        HashMap tempParam = new HashMap();
        HashMap<String, String> newPwyData = new HashMap<String, String>();
        newPwyData.put("taxNo", addSyncMsg.getTaxNo());
        newPwyData.put("dataType", "1");
        String batchNo = addSyncMsg.getBatchNo();
        newPwyData.put("batchNo", batchNo);
        newPwyData.put("consumerType", "EAS");
        tempParam.put("pwyData", newPwyData);
        tempParam.put("sumRet", addSyncMsg.getParams().get("sumRet"));
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_ADD_SYNC_DOWNLOAD, TransSrcSystemEnum.easgui, addSyncMsg.getOrgId(), tempParam);
        paramList.add(actionParam);
        List list = PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
        PwyInvokeParam invokeParam = (PwyInvokeParam)list.get(0);
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.invoke();
        if (pwyService.isSuccess() && invokeParam.getPwyLog().getId() != null) {
            addSyncMsg.setLogID(invokeParam.getPwyLog().getId().toString());
        } else {
            addSyncMsg.setMsg(invokeParam.getDescription());
        }
    }

    class DownloadTask
    implements Runnable {
        private Context ctx = null;
        private CountDownLatch latch = null;
        private AddSyncMsg addSyncMsg = null;

        public DownloadTask(Context ctx, AddSyncMsg addSyncMsg, CountDownLatch latch) {
            this.ctx = ctx;
            this.latch = latch;
            this.addSyncMsg = addSyncMsg;
        }

        @Override
        public void run() {
            try {
                AddSyncDownloadInvFacadeControllerBean.this.DownloadSingle(this.ctx, this.addSyncMsg);
            }
            catch (Exception e) {
                logger.error((Object)("AddSyncDownloadInvFacadeControllerBean,e=" + e.getMessage()), (Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

