/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.AbstractMakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.DeductRowEnum;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginUtil;
import com.kingdee.eas.tm.im.basedata.AbstractCustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BuildInvoiceReq4NewMKRequest
extends AbstractBuildInvoiceReq {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.BuildInvoiceReq4NewMKRequest");

    public BuildInvoiceReq4NewMKRequest(Context ctx, MakeInvoiceParam params) {
        this.setParams(params);
        this.setCtx(ctx);
    }

    @Override
    protected void removeDiffTaxErrorGroupBill() {
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        ArrayList<String> removeKey = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        boolean isClear = false;
        String errorMsg = IMUtils.getIMResource(this.ctx, "DIFFTAX_BILL_ENTRYSUM_ERROR", new String[0]);
        while (iterator.hasNext()) {
            int i;
            String key = iterator.next();
            IObjectValue info = this.getCombinBill().get(key);
            boolean isSuccess = this.handlerDiffTax(info);
            boolean isSplitSuceess = true;
            if (isSuccess) {
                IObjectCollection splitBillColl = (IObjectCollection)info.get("splitBillColl");
                IObjectValue splitInfo = null;
                if (splitBillColl != null && splitBillColl.size() > 0) {
                    for (int k = 0; k < splitBillColl.size() && (isSplitSuceess = this.handlerDiffTax(splitInfo = splitBillColl.getObject(k))); ++k) {
                    }
                }
            }
            if (!isSuccess || !isSplitSuceess) {
                isClear = true;
            }
            StringBuffer tempVal = new StringBuffer(info.getString("description"));
            IObjectCollection splitBillColl = (IObjectCollection)info.get("splitBillColl");
            IObjectValue splitInfo = null;
            if (splitBillColl != null && splitBillColl.size() > 0) {
                for (int k = 0; k < splitBillColl.size(); ++k) {
                    splitInfo = splitBillColl.getObject(k);
                    tempVal.append("_" + splitInfo.getString("description"));
                }
            }
            String[] ids = tempVal.toString().split("_");
            for (i = 0; i < ids.length; ++i) {
                String id = ids[i];
                if (!idList.contains(id)) {
                    idList.add(id);
                }
                if (!this.errorMsgMap.containsKey(id)) continue;
                isClear = true;
            }
            if (!isClear) continue;
            for (i = 0; i < idList.size(); ++i) {
                if (this.errorMsgMap.containsKey(idList.get(i))) continue;
                this.errorMsgMap.put(idList.get(i), errorMsg);
            }
            removeKey.add(key);
        }
        for (int i = 0; i < removeKey.size(); ++i) {
            this.getCombinBill().remove(removeKey.get(i));
        }
    }

    private boolean handlerDiffTax(IObjectValue info) {
        boolean isSuccess = false;
        if (info.getBoolean("isDiffTax")) {
            BigDecimal totalDecuctAmt = BigDecimal.ZERO;
            BigDecimal totalPriceTax = BigDecimal.ZERO;
            BigDecimal totalNoTaxAmout = BigDecimal.ZERO;
            BigDecimal totalQty = BigDecimal.ZERO;
            BigDecimal totalBaseQty = BigDecimal.ZERO;
            int productEntrySum = 0;
            AbstractMakeInvoiceReqEntryInfo productEntry = null;
            MakeInvoiceReqEntryCollection colls = null;
            boolean isExistDeductRow = false;
            if (info instanceof MakeInvoiceReqInfo) {
                colls = (MakeInvoiceReqEntryCollection)((Object)info.get("entries"));
                for (int i = 0; i < colls.size(); ++i) {
                    MakeInvoiceReqEntryInfo entry = colls.get(i);
                    totalPriceTax = totalPriceTax.add(entry.getPriceIncludingTax());
                    totalNoTaxAmout = totalNoTaxAmout.add(entry.getPriceExcludingTax());
                    totalQty = totalQty.add(entry.getQty());
                    totalBaseQty = totalBaseQty.add(entry.getBaseQty());
                    if (DeductRowEnum.DeductRow.equals((Object)entry.getDeductRow())) {
                        totalDecuctAmt = totalDecuctAmt.add(entry.getPriceExcludingTax());
                        isExistDeductRow = true;
                        continue;
                    }
                    if (!DeductRowEnum.NotDeductRow.equals((Object)entry.getDeductRow())) continue;
                    ++productEntrySum;
                    productEntry = entry;
                }
            }
            if (productEntrySum == 1) {
                productEntry.put("deductAmt", totalDecuctAmt);
                productEntry.setPriceIncludingTax(totalPriceTax);
                productEntry.setPriceExcludingTax(totalNoTaxAmout);
                productEntry.setTax(productEntry.getPriceIncludingTax().subtract(productEntry.getPriceExcludingTax()));
                productEntry.setQty(totalQty);
                productEntry.setBaseQty(totalBaseQty);
                if (BigDecimal.ZERO.compareTo(productEntry.getQty()) != 0) {
                    String key = (String)productEntry.get("combinKey");
                    if (isExistDeductRow || productEntry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                        BigDecimal taxPrice = productEntry.getPriceIncludingTax().divide(productEntry.getQty(), this.combinePricePrecision, 4);
                        BigDecimal price = productEntry.getPriceExcludingTax().divide(productEntry.getQty(), this.combinePricePrecision, 4);
                        productEntry.setPrice(taxPrice);
                        productEntry.setNoTaxPrice(price);
                    }
                } else {
                    productEntry.setPrice(BigDecimal.ZERO);
                    productEntry.setNoTaxPrice(BigDecimal.ZERO);
                }
                colls = (MakeInvoiceReqEntryCollection)((Object)info.get("entries"));
                colls.clear();
                colls.addObject((IObjectValue)productEntry);
                isSuccess = true;
            }
        } else {
            isSuccess = true;
        }
        return isSuccess;
    }

    protected void checkBillStatus(Context ctx, Set idSet) throws BOSException {
        super.checkBillStatus(ctx, idSet);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        MakeInvoiceReqCollection collection = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            MakeInvoiceReqInfo reqInfo = collection.get(i);
            if (reqInfo.getStatus() == MakeInvoiceReqStatusEnum.AUDITED) continue;
            String errMsg = IMUtils.getIMResource(ctx, "MakeInvoiceReq_makeInvoice_statusError", new String[0]);
            String id = reqInfo.get("id").toString();
            this.getErrorMsgMap().put(id, errMsg);
            idSet.remove(id);
        }
        this.checkAutoMakeInvoiceType(ctx, idSet);
    }

    private void checkAutoMakeInvoiceType(Context ctx, Set idSet) throws BOSException {
        String billName = (String)this.ctx.get((Object)"billName");
        if (StringUtils.isEmpty((String)billName)) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceType"));
        viewInfo.setSelector(sic);
        MakeInvoiceReqCollection infos = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(viewInfo);
        String reqInvoiceType = this.getParams().getInvoiceType();
        if (infos.size() > 0) {
            for (int i = 0; i < infos.size(); ++i) {
                MakeInvoiceReqInfo info = infos.get(i);
                if (!(!"0".equals(reqInvoiceType) && reqInvoiceType != null || info.getInvoiceType() != null && info.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    this.getErrorMsgMap().put(info.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"MAKEINVOICE_ERROR", (Locale)IMUtils.getLocale()));
                    idSet.remove(info.getId().toString());
                    continue;
                }
                if ("0".equals(reqInvoiceType) || reqInvoiceType == null || info.getInvoiceType() == null || info.getInvoiceType() == PayInvoiceTypeEnum.DEFAULTTYPE || info.getInvoiceType().getValue().equals(this.getInvoiceType(reqInvoiceType))) continue;
                this.getErrorMsgMap().put(info.getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"INVOICETYPE_INVALID", (Locale)IMUtils.getLocale()));
                idSet.remove(info.getId().toString());
            }
        }
    }

    @Override
    protected void combinBizBillByRule(String ruleID) throws BOSException, EASBizException {
        String[] id = this.getIds();
        ArrayList<String> headProp = new ArrayList<String>();
        ArrayList<String> entryProp = new ArrayList<String>();
        this.buildCombinRule(ruleID, headProp, entryProp);
        HashSet<String> idset = new HashSet<String>();
        for (int i = 0; i < id.length; ++i) {
            idset.add(id[i]);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        MakeInvoiceReqCollection makeInvoiceReqBillColl = MakeInvoiceReqFactory.getLocalInstance(this.getCtx()).getMakeInvoiceReqCollection(ev);
        MakeInvoiceReqInfo billInfo = null;
        String key = "";
        int abstractNameMode = 0;
        if (makeInvoiceReqBillColl.size() > 0) {
            Map paramMap = IMUtils.getParam(this.ctx, makeInvoiceReqBillColl.get(0).getCompany().getId().toString(), new String[]{"VATM018"});
            abstractNameMode = IMUtils.getIntegerValue((String)paramMap.get("VATM018"));
        }
        HashSet<String> abstractNameSet = new HashSet<String>();
        for (int i = 0; i < makeInvoiceReqBillColl.size(); ++i) {
            billInfo = makeInvoiceReqBillColl.get(i);
            billInfo.put("remark", billInfo.getAbstractName());
            key = IMUtils.buildKey(headProp, (IObjectValue)billInfo);
            MakeInvoiceReqInfo value = (MakeInvoiceReqInfo)this.getCombinBill().get(key);
            if (value == null) {
                billInfo.setDescription(billInfo.getId().toString());
                if (abstractNameMode == 2) {
                    billInfo.setAbstractName(null);
                }
                this.getCombinBill().put(key, (IObjectValue)billInfo);
                billInfo.put("billNumber", billInfo.getNumber());
                abstractNameSet.add(billInfo.getAbstractName());
                continue;
            }
            value.getEntries().addObjectCollection((IObjectCollection)billInfo.getEntries());
            if (value.getSpecificInformation() != null && value.getSpecificInformation().getEntries() != null && billInfo.getSpecificInformation() != null && billInfo.getSpecificInformation().getEntries() != null) {
                value.getSpecificInformation().getEntries().addObjectCollection((IObjectCollection)billInfo.getSpecificInformation().getEntries());
            }
            value.setDescription(value.getDescription() + "_" + billInfo.getId().toString());
            value.put("billNumber", value.get("billNumber") + "_" + billInfo.getNumber());
            if (abstractNameMode != 2) {
                if (billInfo.getAbstractName() == null || billInfo.getAbstractName().isEmpty()) continue;
                if (value.getAbstractName() == null || value.getAbstractName().isEmpty()) {
                    value.setAbstractName(billInfo.getAbstractName());
                    continue;
                }
                if (abstractNameMode == 0) {
                    value.setAbstractName(value.getAbstractName() + ";" + billInfo.getAbstractName());
                    continue;
                }
                if (!abstractNameSet.add(billInfo.getAbstractName())) continue;
                value.setAbstractName(value.getAbstractName() + ";" + billInfo.getAbstractName());
                continue;
            }
            value.setAbstractName(null);
        }
        if (entryProp.size() == 0) {
            this.clearEntrySrcId((IObjectCollection)makeInvoiceReqBillColl);
        }
        HashMap<String, MakeInvoiceReqEntryInfo> combinBillEntry = new HashMap<String, MakeInvoiceReqEntryInfo>();
        MakeInvoiceReqEntryCollection entrys = null;
        MakeInvoiceReqEntryInfo entry = null;
        int groupFalg = 1;
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        InvoiceParamConfigInfo paramConfigInfo = null;
        this.getIsNeedCalMap().clear();
        boolean isNeedCalPrice = true;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)this.getCombinBill().get(key);
            entrys = info.getEntries();
            paramConfigInfo = this.getReq().getPluginService().getInvoiceParamConfig(info.getCompany().getId().toString());
            isNeedCalPrice = paramConfigInfo.isIsReverseCal();
            HashMap<String, MakeInvoiceReqEntryInfo> checkPriceSameEntry = new HashMap<String, MakeInvoiceReqEntryInfo>();
            if (!isNeedCalPrice) {
                for (int i = 0; i < entrys.size(); ++i) {
                    entry = entrys.get(i);
                    key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                    MakeInvoiceReqEntryInfo obj = (MakeInvoiceReqEntryInfo)checkPriceSameEntry.get(key);
                    if (obj == null) {
                        checkPriceSameEntry.put(key, entry);
                        this.getIsNeedCalMap().put(key, false);
                        continue;
                    }
                    if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) != 0) {
                        boolean isSplit = this.getIsSplitPram(info);
                        if (!isSplit) {
                            if (IMUtils.getDecimalValue(entry.getActualPrice()).compareTo(IMUtils.getDecimalValue(obj.getActualPrice())) == 0) continue;
                            this.getIsNeedCalMap().put(key, true);
                            continue;
                        }
                        if (IMUtils.getDecimalValue(entry.getNoTaxPrice()).compareTo(IMUtils.getDecimalValue(obj.getNoTaxPrice())) == 0) continue;
                        this.getIsNeedCalMap().put(key, true);
                        continue;
                    }
                    if (IMUtils.getDecimalValue(entry.getNoTaxPrice()).compareTo(IMUtils.getDecimalValue(obj.getNoTaxPrice())) == 0) continue;
                    this.getIsNeedCalMap().put(key, true);
                }
            }
            MakeInvoiceReqEntryCollection newEntrys = new MakeInvoiceReqEntryCollection();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                key = IMUtils.buildKey(entryProp, (IObjectValue)entry) + groupFalg;
                MakeInvoiceReqEntryInfo obj = (MakeInvoiceReqEntryInfo)combinBillEntry.get(key);
                if (obj == null) {
                    combinBillEntry.put(key, entry);
                    newEntrys.add(entry);
                    entry.put("parentNumber", entry.getParent().getNumber());
                    entry.put("parentIds", entry.getParent().getId().toString());
                    entry.put("combinKey", key);
                    continue;
                }
                obj.setQty(obj.getQty().add(entry.getQty()));
                obj.setBaseQty(obj.getBaseQty().add(entry.getBaseQty()));
                obj.setPriceExcludingTax(obj.getPriceExcludingTax().add(entry.getPriceExcludingTax()));
                obj.setPriceIncludingTax(obj.getPriceIncludingTax().add(entry.getPriceIncludingTax()));
                if (obj.getQty().compareTo(BigDecimal.ZERO) <= 0) {
                    obj.setPrice(BigDecimal.ZERO);
                    obj.setNoTaxPrice(BigDecimal.ZERO);
                } else if (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue()) {
                    obj.setPrice(obj.getPriceIncludingTax().divide(obj.getQty(), this.combinePricePrecision, RoundingMode.HALF_UP));
                    obj.setNoTaxPrice(obj.getPriceExcludingTax().divide(obj.getQty(), this.combinePricePrecision, RoundingMode.HALF_UP));
                }
                obj.setDiscountAmount(obj.getDiscountAmount().add(entry.getDiscountAmount()));
                obj.setBoolean("KEY_IS_COMBIN", true);
                obj.put("parentNumber", obj.get("parentNumber") + "_" + entry.getParent().getNumber());
                obj.put("parentIds", obj.get("parentIds") + "_" + entry.getParent().getId().toString());
            }
            info.getEntries().clear();
            info.getEntries().addCollection(newEntrys);
            ++groupFalg;
        }
    }

    @Override
    protected void splitBizBillByRule(String ruleID) throws BOSException, EASBizException {
        ArrayList<String> entryProp = this.buildSplitRule(ruleID);
        if (entryProp == null || entryProp.size() == 0) {
            return;
        }
        MakeInvoiceReqEntryCollection entrys = null;
        MakeInvoiceReqEntryCollection newEntrys = null;
        MakeInvoiceReqEntryInfo entry = null;
        for (IObjectValue o : this.getCombinBill().values()) {
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)o;
            entrys = info.getEntries();
            HashMap<String, MakeInvoiceReqEntryCollection> splitBillEntryMap = new HashMap<String, MakeInvoiceReqEntryCollection>();
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                String key = IMUtils.buildKey(entryProp, (IObjectValue)entry);
                MakeInvoiceReqEntryCollection entryColl = (MakeInvoiceReqEntryCollection)((Object)splitBillEntryMap.get(key));
                if (entryColl == null) {
                    newEntrys = new MakeInvoiceReqEntryCollection();
                    newEntrys.add(entry);
                    splitBillEntryMap.put(key, newEntrys);
                    continue;
                }
                entryColl.add(entry);
            }
            if (splitBillEntryMap.size() <= 1) continue;
            boolean isFirstValue = true;
            MakeInvoiceReqCollection splitBillColl = new MakeInvoiceReqCollection();
            for (MakeInvoiceReqEntryCollection value : splitBillEntryMap.values()) {
                if (isFirstValue) {
                    info.getEntries().clear();
                    info.getEntries().addCollection(value);
                    isFirstValue = false;
                    this.updateInfoDescription(info);
                    continue;
                }
                MakeInvoiceReqInfo tempBill = (MakeInvoiceReqInfo)info.clone();
                tempBill.setId(BOSUuid.create((String)"FC910EF3"));
                tempBill.setString("tempID", info.getId().toString());
                tempBill.getEntries().clear();
                tempBill.getEntries().addCollection(value);
                this.updateInfoDescription(tempBill);
                splitBillColl.add(tempBill);
            }
            info.put("splitBillColl", (Object)splitBillColl);
        }
    }

    protected void updateInfoDescription(MakeInvoiceReqInfo info) {
        MakeInvoiceReqEntryCollection entrys = info.getEntries();
        MakeInvoiceReqEntryInfo entry = null;
        HashSet<String> parentIdSet = new HashSet<String>();
        HashSet<String> parentNumberSet = new HashSet<String>();
        String parentIds = null;
        String parentNumber = null;
        for (int i = 0; i < entrys.size(); ++i) {
            entry = entrys.get(i);
            parentIds = (String)entry.get("parentIds");
            parentNumber = (String)entry.get("parentNumber");
            if (parentIds != null) {
                parentIdSet.addAll(Arrays.asList(parentIds.split("_")));
            }
            if (parentNumber == null) continue;
            parentNumberSet.addAll(Arrays.asList(parentNumber.split("_")));
        }
        Iterator iter = parentIdSet.iterator();
        info.setDescription("");
        while (iter.hasNext()) {
            if (info.getDescription().equals("")) {
                info.setDescription((String)iter.next());
                continue;
            }
            info.setDescription(info.getDescription() + "_" + iter.next());
        }
        Iterator numberIter = parentNumberSet.iterator();
        info.put("billNumber", "");
        while (numberIter.hasNext()) {
            if (info.get("billNumber").equals("")) {
                info.put("billNumber", (String)numberIter.next());
                continue;
            }
            info.put("billNumber", info.get("billNumber") + "_" + numberIter.next());
        }
    }

    @Override
    protected void clearEntrySrcId(IObjectCollection coll) {
        MakeInvoiceReqEntryInfo entry = null;
        MakeInvoiceReqInfo info = null;
        MakeInvoiceReqCollection MakeInvoiceReqBillColl = (MakeInvoiceReqCollection)coll;
        for (int k = 0; k < MakeInvoiceReqBillColl.size(); ++k) {
            info = MakeInvoiceReqBillColl.get(k);
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entry = info.getEntries().get(i);
                entry.setSourceBillEntryId(null);
            }
        }
    }

    protected void setBills(InvoiceReqInfo req, Map combinBill) throws EASBizException, BOSException {
        ArrayList billList = this.getOrderBiz();
        for (int i = 0; i < billList.size(); ++i) {
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)billList.get(i);
            req.getBills().add(this.getBillReqInfo((IObjectValue)info));
        }
    }

    @Override
    protected BillReqInfo getBillReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)objectValue;
        BillReqInfo billReq = new BillReqInfo();
        String descript = info.getDescription();
        String[] srcBillID = descript.split("_");
        billReq.setSrcBillID(srcBillID);
        billReq.setBillId(info.getId().toString());
        String[] billNumbers = ((String)info.get("billNumber")).split("_");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < billNumbers.length; ++i) {
            sb.append(billNumbers[i]).append(";");
        }
        billReq.setBillNumber(sb.substring(0, sb.length() - 1));
        billReq.setInvoiceType(info.getInvoiceType());
        billReq.setTotalAmount(info.getPriceExcludingTax());
        billReq.setInvoiceAmount(info.getPriceExcludingTax());
        billReq.setUsedAmount(BigDecimal.ZERO);
        if (info.getAsstActID() != null) {
            billReq.setCustomerID(info.getAsstActID());
        }
        billReq.setAsstActType(info.getAsstActType());
        if (info.getCurrency() != null && info.getCurrency().getId() != null) {
            billReq.setCurrencyID(info.getCurrency().getId().toString());
        } else {
            billReq.setCurrencyID("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC");
        }
        billReq.setCompanyID(info.getCompany().getId().toString());
        billReq.setBizDate(info.getBizDate());
        billReq.setDescription(info.getAbstractName());
        billReq.setRecOrgName(info.getRecOrgName());
        billReq.setTaxNumber(info.getTaxNumber());
        billReq.setAddress(info.getAddress());
        billReq.setBankAccount(info.getBankAccount());
        billReq.setIsPurchaseInvoice(info.isIsPurchaseInvoice());
        billReq.setDiffTax(info.isIsDiffTax());
        billReq.setSplit(info.getBoolean("KEY_IS_SPLIT"));
        billReq.setVehicle(info.isIsVehicle());
        billReq.setAgentName(info.getAgentName());
        billReq.setAgentIDType(info.getAgentIDType());
        billReq.setAgentIDNumber(info.getAgentIDNumber());
        billReq.setAgentCountry(info.getAgentCountry());
        billReq.setTaxIDNumber(info.getTaxIDNumber());
        billReq.setSpecService(info.getSpecificService());
        billReq.setSpecificInformation(info.getSpecificInformation());
        billReq.setObjectValue((IObjectValue)info);
        try {
            TaxManageCustomerImpl.getBillReqInfoFromReDevelop(billReq, info);
        }
        catch (Throwable ex) {
            logger.error((Object)ex.getMessage(), ex);
        }
        MakeInvoiceReqEntryCollection taxBillEntries = info.getEntries();
        int size = taxBillEntries.size();
        for (int idx = 0; idx < size; ++idx) {
            billReq.getEntrys().add(this.getBillEntryReqInfo((IObjectValue)taxBillEntries.get(idx)));
        }
        return billReq;
    }

    @Override
    protected BillEntryReqInfo getBillEntryReqInfo(IObjectValue objectValue) throws EASBizException, BOSException {
        boolean isExistDeductRow;
        BillEntryReqInfo billEntryReq = new BillEntryReqInfo();
        MakeInvoiceReqEntryInfo reqEntry = (MakeInvoiceReqEntryInfo)objectValue;
        if (reqEntry.getMaterial() != null) {
            billEntryReq.setMaterialID(reqEntry.getMaterial().getId().toString());
            billEntryReq.setMaterialName(reqEntry.getMaterial().getName());
            billEntryReq.setMaterialNumber(reqEntry.getMaterial().getNumber());
        }
        if (reqEntry.getExpenseItem() != null) {
            billEntryReq.setExpenseItemID(reqEntry.getExpenseItem().getId().toString());
            billEntryReq.setMaterialName(reqEntry.getExpenseItem().getName());
            billEntryReq.setMaterialNumber(reqEntry.getExpenseItem().getNumber());
        }
        if (reqEntry.getProductCode() != null) {
            billEntryReq.setProductCode(reqEntry.getProductCode());
            if (StringUtils.isEmpty((String)billEntryReq.getMaterialID()) && StringUtils.isEmpty((String)billEntryReq.getExpenseItemID()) && reqEntry.getProductCode().getMaterial() != null) {
                billEntryReq.setMaterialID(reqEntry.getProductCode().getMaterial().getId().toString());
                billEntryReq.setMaterialName(reqEntry.getProductCode().getMaterial().getName());
                billEntryReq.setMaterialNumber(reqEntry.getProductCode().getMaterial().getNumber());
            }
        }
        billEntryReq.setModel(reqEntry.getSpecs());
        billEntryReq.setBillEntryID(reqEntry.getId().toString());
        billEntryReq.put("parentNumber", reqEntry.getParent().getNumber());
        billEntryReq.setSrcEntryID(reqEntry.getSourceBillEntryId());
        billEntryReq.setEntryAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setInvoiceAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setUsedAmount(BigDecimal.ZERO);
        if (reqEntry.get("deductAmt") != null) {
            billEntryReq.setDeductAmt((BigDecimal)reqEntry.get("deductAmt"));
            isExistDeductRow = true;
        } else {
            isExistDeductRow = false;
        }
        billEntryReq.setQty(reqEntry.getQty());
        billEntryReq.setBaseQty(reqEntry.getBaseQty());
        billEntryReq.setInvoiceQty(reqEntry.getQty());
        billEntryReq.setUsedQuantity(BigDecimal.ZERO);
        billEntryReq.setTaxPrice(reqEntry.getPrice());
        billEntryReq.setNoTaxAmount(reqEntry.getPriceExcludingTax());
        billEntryReq.setNoTaxPrice(reqEntry.getNoTaxPrice());
        if (reqEntry.getUnit() != null) {
            billEntryReq.setMeasureUnitID(reqEntry.getUnit().getId().toString());
        }
        billEntryReq.setMakeInvoiceUnit(reqEntry.getUnitName());
        billEntryReq.setTaxRate(reqEntry.getTaxRate().divide(new BigDecimal(100)));
        billEntryReq.setTax(reqEntry.getTax());
        billEntryReq.setTaxAmount(reqEntry.getPriceIncludingTax());
        billEntryReq.setSeq(reqEntry.getSeq());
        if (reqEntry.getQty() == null) {
            reqEntry.setQty(BigDecimal.ZERO);
        }
        billEntryReq.setBoolean("KEY_IS_CONSTANTQTY", reqEntry.getBoolean("KEY_IS_COMBIN"));
        billEntryReq.setIsQtyZero(reqEntry.isIsQtyZero());
        if (BigDecimal.ZERO.compareTo(reqEntry.getQty()) != 0) {
            String key = (String)reqEntry.get("combinKey");
            if (isExistDeductRow || reqEntry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                BigDecimal actualPrice = reqEntry.getPriceIncludingTax().divide(reqEntry.getQty(), this.combinePricePrecision, 4);
                BigDecimal realPrice = reqEntry.getPriceExcludingTax().divide(reqEntry.getQty(), this.combinePricePrecision, 4);
                billEntryReq.setActualPrice(actualPrice);
                billEntryReq.setRealPrice(realPrice);
            } else {
                billEntryReq.setActualPrice(reqEntry.getActualTaxPrice());
                billEntryReq.setRealPrice(reqEntry.getActualPrice());
            }
        } else {
            billEntryReq.setActualPrice(BigDecimal.ZERO);
            billEntryReq.setRealPrice(BigDecimal.ZERO);
        }
        billEntryReq.setProductName(reqEntry.getProductName());
        billEntryReq.setTaxClassificationCode(reqEntry.getTaxClassificationCode());
        billEntryReq.setObjectValue(objectValue);
        try {
            TaxManageCustomerImpl.getBillEntryReqInfoFromReDevelop(billEntryReq, reqEntry);
        }
        catch (Throwable ex) {
            logger.error((Object)ex.getMessage(), ex);
        }
        return billEntryReq;
    }

    @Override
    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("customer.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("specificInformation.id"));
        sic.add(new SelectorItemInfo("specificInformation.*"));
        sic.add(new SelectorItemInfo("specificInformation.entries.id"));
        sic.add(new SelectorItemInfo("specificInformation.entries.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.parent.number"));
        sic.add(new SelectorItemInfo("entries.productCode.*"));
        sic.add(new SelectorItemInfo("entries.productCode.taxClassificationCode.id"));
        sic.add(new SelectorItemInfo("entries.productCode.taxClassificationCode.name"));
        sic.add(new SelectorItemInfo("entries.productCode.taxClassificationCode.number"));
        sic.add(new SelectorItemInfo("entries.productCode.taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("entries.productCode.material.id"));
        sic.add(new SelectorItemInfo("entries.productCode.material.name"));
        sic.add(new SelectorItemInfo("entries.productCode.material.model"));
        sic.add(new SelectorItemInfo("entries.productCode.material.number"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.id"));
        sic.add(new SelectorItemInfo("entries.expenseItem.number"));
        sic.add(new SelectorItemInfo("entries.expenseItem.name"));
        sic.add(new SelectorItemInfo("entries.measureUnit.*"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.addObjectCollection((IObjectCollection)InvoicePluginUtil.getEntryMeasureUnitSelector(this.ctx, "AC368D2D"));
        return sic;
    }

    @Override
    protected void doEntryDiscount(IObjectValue obj) throws EASBizException, BOSException {
        BigDecimal BIGDECIMAL_ONEHUNDRED = new BigDecimal("100.0");
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)obj;
        MakeInvoiceReqEntryCollection entrys = info.getEntries();
        MakeInvoiceReqEntryCollection newEntrys = new MakeInvoiceReqEntryCollection();
        int entrySeq = 1;
        MakeInvoiceReqEntryInfo entry = null;
        boolean isSplit = this.getIsSplitPram(info);
        info.setBoolean("KEY_IS_SPLIT", isSplit);
        if (!isSplit) {
            return;
        }
        if (info.isIsDiffTax()) {
            for (int i = 0; i < entrys.size(); ++i) {
                boolean isExistDeductRow;
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                entry.setSeq(entrySeq);
                ++entrySeq;
                if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) == 0) continue;
                BigDecimal oldTaxAmt = entry.getTax();
                BigDecimal discountAmt = entry.getDiscountAmount();
                BigDecimal amt = entry.getPriceIncludingTax();
                BigDecimal totalAmt = discountAmt.add(amt);
                BigDecimal deductAmt = BigDecimal.ZERO;
                BigDecimal taxRate = entry.getTaxRate().divide(BIGDECIMAL_ONEHUNDRED);
                if (entry.get("deductAmt") != null) {
                    deductAmt = (BigDecimal)entry.get("deductAmt");
                    isExistDeductRow = true;
                } else {
                    isExistDeductRow = false;
                }
                entry.setPriceIncludingTax(totalAmt);
                entry.setTax(totalAmt.subtract(deductAmt).divide(taxRate.add(BigDecimal.ONE), 10, 4).multiply(taxRate).setScale(2, RoundingMode.HALF_UP));
                entry.setPriceExcludingTax(entry.getPriceIncludingTax().subtract(entry.getTax()));
                if (BigDecimal.ZERO.compareTo(entry.getQty()) != 0) {
                    String key = (String)entry.get("combinKey");
                    if (isExistDeductRow || entry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                        BigDecimal taxPrice = entry.getPriceIncludingTax().divide(entry.getQty(), this.combinePricePrecision, 4);
                        BigDecimal price = entry.getPriceExcludingTax().divide(entry.getQty(), this.combinePricePrecision, 4);
                        entry.setPrice(taxPrice);
                        entry.setNoTaxPrice(price);
                    }
                } else {
                    entry.setPrice(BigDecimal.ZERO);
                    entry.setNoTaxPrice(BigDecimal.ZERO);
                }
                MakeInvoiceReqEntryInfo newEntry = (MakeInvoiceReqEntryInfo)entry.clone();
                entry.setSourceBillEntryId(null);
                newEntry.setSourceBillEntryId(entry.getId().toString());
                newEntry.setId(BOSUuid.create((String)"BC91693F"));
                newEntry.setSeq(entrySeq);
                ++entrySeq;
                newEntry.setQty(BigDecimal.ZERO);
                newEntry.setBaseQty(BigDecimal.ZERO);
                newEntry.setNoTaxPrice(BigDecimal.ZERO);
                newEntry.setPrice(BigDecimal.ZERO);
                newEntry.setActualTaxPrice(BigDecimal.ZERO);
                newEntry.setActualPrice(BigDecimal.ZERO);
                newEntry.put("deductAmt", null);
                BigDecimal totalAmt2 = discountAmt.negate();
                newEntry.setPriceIncludingTax(totalAmt2);
                newEntry.setTax(oldTaxAmt.subtract(entry.getTax()));
                newEntry.setPriceExcludingTax(totalAmt2.subtract(newEntry.getTax()));
                newEntrys.add(newEntry);
            }
        } else {
            for (int i = 0; i < entrys.size(); ++i) {
                entry = entrys.get(i);
                entry.setSourceBillEntryId(null);
                entry.setSeq(entrySeq);
                ++entrySeq;
                if (BigDecimal.ZERO.compareTo(entry.getDiscountAmount()) == 0) continue;
                BigDecimal oldNoTaxAmt = entry.getPriceExcludingTax();
                BigDecimal discountAmt = entry.getDiscountAmount();
                BigDecimal amt = entry.getPriceIncludingTax();
                BigDecimal totalAmt = discountAmt.add(amt);
                entry.setPriceIncludingTax(totalAmt);
                entry.setPriceExcludingTax(entry.getPriceIncludingTax().divide(entry.getTaxRate().divide(BIGDECIMAL_ONEHUNDRED).add(BigDecimal.ONE), 2, 4));
                entry.setTax(entry.getPriceIncludingTax().subtract(entry.getPriceExcludingTax()));
                if (BigDecimal.ZERO.compareTo(entry.getQty()) == 0) {
                    entry.setNoTaxPrice(BigDecimal.ZERO);
                    entry.setPrice(BigDecimal.ZERO);
                } else {
                    String key = (String)entry.get("combinKey");
                    if (entry.getBoolean("KEY_IS_COMBIN") && (this.getIsNeedCalMap().size() == 0 || this.getIsNeedCalMap().get(key) == null || this.getIsNeedCalMap().get(key).booleanValue())) {
                        entry.setPrice(entry.getPriceIncludingTax().divide(entry.getQty(), this.combinePricePrecision, 4));
                        entry.setNoTaxPrice(entry.getPriceExcludingTax().divide(entry.getQty(), this.combinePricePrecision, 4));
                    }
                }
                MakeInvoiceReqEntryInfo newEntry = (MakeInvoiceReqEntryInfo)entry.clone();
                entry.setSourceBillEntryId(null);
                newEntry.setSourceBillEntryId(entry.getId().toString());
                newEntry.setId(BOSUuid.create((String)"BC91693F"));
                newEntry.setSeq(entrySeq);
                ++entrySeq;
                newEntry.setQty(BigDecimal.ZERO);
                newEntry.setNoTaxPrice(BigDecimal.ZERO);
                newEntry.setPrice(BigDecimal.ZERO);
                BigDecimal totalAmt2 = newEntry.getDiscountAmount().negate();
                newEntry.setPriceIncludingTax(totalAmt2);
                newEntry.setPriceExcludingTax(oldNoTaxAmt.subtract(entry.getPriceExcludingTax()));
                newEntry.setTax(totalAmt2.subtract(newEntry.getPriceExcludingTax()));
                newEntrys.add(newEntry);
            }
        }
        entrys.addCollection(newEntrys);
        entrys.sort("seq");
    }

    @Override
    protected void doEntryDiscount() throws EASBizException, BOSException {
        Iterator<String> iterator = this.getCombinBill().keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)this.getCombinBill().get(key);
            this.doEntryDiscount((IObjectValue)info);
            MakeInvoiceReqCollection splitBillColl = (MakeInvoiceReqCollection)((Object)info.get("splitBillColl"));
            if (splitBillColl == null || splitBillColl.size() <= 0) continue;
            for (int j = 0; j < splitBillColl.size(); ++j) {
                this.doEntryDiscount((IObjectValue)splitBillColl.get(j));
            }
        }
    }

    private String getInvoiceType(MakeInvoiceReqInfo info, String reqInvoiceType) throws EASBizException {
        String billName = (String)this.ctx.get((Object)"billName");
        if (!StringUtils.isEmpty((String)billName) && ("0".equals(reqInvoiceType) || reqInvoiceType == null && info.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE && info.getInvoiceType() != null)) {
            return info.getInvoiceType().getValue();
        }
        return this.getInvoiceType(reqInvoiceType);
    }

    private String getInvoiceType(String reqInvoiceType) {
        PayInvoiceTypeEnum retValue = null;
        if ("1".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if ("2".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if ("3".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if ("4".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if ("5".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if ("6".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        }
        if (retValue == null) {
            return null;
        }
        return retValue.getValue();
    }

    @Override
    public String buildErrorBillMsg() throws BOSException {
        Iterator iterator = this.getErrorMsgMap().keySet().iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String billid = iterator.next().toString();
            idSet.add(billid);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(this.getSelector());
        MakeInvoiceReqCollection billColl = MakeInvoiceReqFactory.getLocalInstance(this.getCtx()).getMakeInvoiceReqCollection(ev);
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < billColl.size(); ++i) {
            MakeInvoiceReqInfo info = billColl.get(i);
            String id = info.getId().toString();
            msg.append(info.getNumber() + ": " + this.getErrorMsgMap().get(id)).append("\r\n");
        }
        return msg.toString();
    }

    protected boolean getIsSplitPram(MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        if (this.getIsSplitMap().containsKey(info.getId().toString())) {
            return this.getIsSplitMap().get(info.getId().toString());
        }
        String companyId = info.getCompany().getId().toString();
        boolean isSplit = IMUtils.getBooleanParam(this.getCtx(), companyId, "VATM006");
        MakeInvoiceParam param = this.getParams();
        String invoiceType = param.getInvoiceType();
        if (info.getAsstActType() != null && ("T_BD_Supplier".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject()) || "T_BD_Customer".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject()))) {
            String custID;
            HashMap<String, String> params = new HashMap<String, String>();
            if (info.getAsstActType() != null && "T_BD_Customer".equalsIgnoreCase(info.getAsstActType().getRealtionDataObject())) {
                custID = StringUtils.isEmpty((String)info.getAsstActID()) ? "CUSTOMER_EMPTY" : info.getAsstActID();
                params.put("customerId", custID);
            } else {
                custID = StringUtils.isEmpty((String)info.getAsstActID()) ? "CUSTOMER_EMPTY" : info.getAsstActID();
                params.put("customerId", custID);
            }
            String realInvoiceType = this.getInvoiceType(info, invoiceType);
            params.put("invoiceType", realInvoiceType);
            if (companyId != null) {
                params.put("companyId", companyId);
            }
            params.put("receiveCompany", info.getRecOrgName());
            Map ret = new HashMap();
            ret = CustomerTaxFactory.getLocalInstance(this.ctx).getCustomerTaxInfo(params);
            CustomerTaxInfo customertaxInfo = (CustomerTaxInfo)ret.get("value");
            AbstractCustomerTaxEntryInfo entryInfo = null;
            if (customertaxInfo != null && customertaxInfo.getEntries().size() > 0) {
                entryInfo = customertaxInfo.getEntries().get(0);
            }
            if (entryInfo != null) {
                String value = entryInfo.getDiscountType().getValue();
                if ("1".equals(value)) {
                    isSplit = true;
                } else if ("2".equals(value)) {
                    isSplit = false;
                }
            }
        }
        this.getIsSplitMap().put(info.getId().toString(), isSplit);
        return isSplit;
    }

    @Override
    protected void buildCombinRule(String ruleID, ArrayList<String> headProp, ArrayList<String> entryProp) throws EASBizException, BOSException {
        if (ruleID == null || "".equals(ruleID)) {
            headProp.add("id");
            headProp.add("isDiffTax");
            headProp.add("invoiceType");
            headProp.add("specificService");
            entryProp.add("id");
        } else {
            CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, ruleID);
            if (combinRule == null || combinRule.getCombinFields() == null) {
                headProp.add("id");
                headProp.add("isDiffTax");
                headProp.add("invoiceType");
                headProp.add("specificService");
                entryProp.add("id");
            } else {
                String[] properties = combinRule.getCombinFields().split("_");
                for (int i = 0; i < properties.length; ++i) {
                    String value = properties[i];
                    String[] tempValue = value.split("\\.");
                    if (tempValue.length > 1) {
                        if (entryProp.contains(tempValue[1])) continue;
                        entryProp.add(tempValue[1]);
                        continue;
                    }
                    if (headProp.contains(value)) continue;
                    headProp.add(value);
                }
            }
        }
        if (headProp.isEmpty()) {
            headProp.add("id");
            headProp.add("isDiffTax");
            headProp.add("invoiceType");
            headProp.add("specificService");
        }
        if (!headProp.contains("isDiffTax")) {
            headProp.add("isDiffTax");
        }
        if (!headProp.contains("invoiceType")) {
            headProp.add("invoiceType");
        }
        if (!headProp.contains("specificService")) {
            headProp.add("specificService");
        }
        if (entryProp.isEmpty()) {
            entryProp.add("id");
            entryProp.add("deductRow");
        }
        if (!entryProp.contains("deductRow")) {
            entryProp.add("deductRow");
        }
    }

    @Override
    protected String getSrcTable() {
        return "T_IM_MakeInvoiceReq";
    }
}

