/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.tm.im.CombinRuleSettingCollection;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CombinRuleStatusEnum;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.app.AbstractCombinRuleSettingControllerBean;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CombinRuleSettingControllerBean
extends AbstractCombinRuleSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.CombinRuleSettingControllerBean");

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CombinRuleSettingInfo info = (CombinRuleSettingInfo)model;
        if (pk != null && !this._exists(ctx, pk)) {
            pk = null;
            info.setId(null);
        }
        this.innerSave(ctx, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.innerSave(ctx, model);
    }

    private IObjectPK innerSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CombinRuleSettingInfo info = (CombinRuleSettingInfo)model;
        if (StringUtils.isEmpty((String)info.getCombinFieldsName())) {
            info.setCombinFields(null);
        }
        if (StringUtils.isEmpty((String)info.getSplitFieldsName())) {
            info.setSplitFields(null);
        }
        if (!StringUtils.isEmpty((String)info.getCombinFieldsName()) && info.getCombinFields().length() > 500) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "CombinFields_toLong", "" + info.getCombinFields().length())});
        }
        if (!StringUtils.isEmpty((String)info.getSplitFields()) && info.getSplitFields().length() > 500) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "SplitFields_toLong", "" + info.getSplitFields().length())});
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        return pk;
    }

    @Override
    protected Map _getCombinRuleByType(Context ctx, String srcBosType) throws BOSException, EASBizException {
        String makeInvoiceType = "412A6F98";
        String sql = "select fid, fbillbosType, fisintax from T_IM_CombinRuleSetting where fbillbosType in ( ?,? ) and fstatus = 0";
        HashMap<String, ArrayList<CombinRuleSettingInfo>> retValue = new HashMap<String, ArrayList<CombinRuleSettingInfo>>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{srcBosType, makeInvoiceType});
        try {
            while (rs.next()) {
                String bosType = rs.getString("fbillbosType");
                String fid = rs.getString("fid");
                boolean fisintax = rs.getBoolean("fisintax");
                CombinRuleSettingInfo info = new CombinRuleSettingInfo();
                info.setId(BOSUuid.read((String)fid));
                info.setIsInTax(fisintax);
                info.setBillBosType(bosType);
                ArrayList<CombinRuleSettingInfo> value = (ArrayList<CombinRuleSettingInfo>)retValue.get(bosType);
                if (value == null) {
                    value = new ArrayList<CombinRuleSettingInfo>();
                    value.add(info);
                    retValue.put(bosType, value);
                    continue;
                }
                value.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retValue;
    }

    @Override
    protected Map _getCombinRuleByType(Context ctx, String srcBosType, String destBosType) throws BOSException, EASBizException {
        String sql = "select fid, fbillbosType, fisintax from T_IM_CombinRuleSetting where fbillbosType in ( ?,? ) and fstatus = 0";
        HashMap<String, ArrayList<CombinRuleSettingInfo>> retValue = new HashMap<String, ArrayList<CombinRuleSettingInfo>>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{srcBosType, destBosType});
        try {
            while (rs.next()) {
                String bosType = rs.getString("fbillbosType");
                String fid = rs.getString("fid");
                boolean fisintax = rs.getBoolean("fisintax");
                CombinRuleSettingInfo info = new CombinRuleSettingInfo();
                info.setId(BOSUuid.read((String)fid));
                info.setIsInTax(fisintax);
                info.setBillBosType(bosType);
                ArrayList<CombinRuleSettingInfo> value = (ArrayList<CombinRuleSettingInfo>)retValue.get(bosType);
                if (value == null) {
                    value = new ArrayList<CombinRuleSettingInfo>();
                    value.add(info);
                    retValue.put(bosType, value);
                    continue;
                }
                value.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return retValue;
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CombinRuleSettingInfo info = this.getCombinRuleSettingInfo(ctx, pk);
        if (info.getStatus() == CombinRuleStatusEnum.USING) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMBINRULESETTING_DELETE_ERROR", info.getRuleName())});
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"D4C58B67"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getRuleName(), "im_combinRuleSetting_delete", info.getCU().getId().toString());
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected boolean _setConbinRuleStatus(Context ctx, Map param) throws BOSException {
        ArrayList ids = (ArrayList)param.get("selectIds");
        String status = (String)param.get("status");
        int state = 0;
        if (!"enable".equals(status)) {
            state = 1;
        }
        StringBuffer builder = new StringBuffer();
        builder.append(" UPDATE T_IM_CombinRuleSetting SET FStatus=");
        builder.append(state);
        builder.append(" WHERE  fid in (").append(CollectionUtil.convertList2String(ids)).append(")");
        DbUtil.execute((Context)ctx, (String)builder.toString());
        return true;
    }

    @Override
    protected ArrayList _setActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        CombinRuleSettingCollection coll = null;
        coll = this.getCombinRuleSettingColl(ctx, pks);
        CombinRuleSettingInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        String updateNumbers = "";
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IObjectPK logPk = LogUtils.beginLog(ctx, "setActive", BOSObjectType.create((String)"D4C58B67"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getRuleName(), "im_combinRuleSetting_active", info.getCU().getId().toString());
            if (CombinRuleStatusEnum.USING.equals((Object)info.getStatus())) {
                errors.add(IMUtils.getIMResource(ctx, "CANNOT_ENABLE", info.getRuleName()));
                continue;
            }
            updateNumbers = updateNumbers + "'" + info.getId().toString() + "',";
            LogUtils.afterLog(ctx, logPk);
        }
        int statusValue = 0;
        this.updateStatus(ctx, updateNumbers, statusValue);
        return errors;
    }

    @Override
    protected ArrayList<String> _setUnActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        CombinRuleSettingCollection coll = this.getCombinRuleSettingColl(ctx, pks);
        CombinRuleSettingInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        String updateNumbers = "";
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IObjectPK logPk = LogUtils.beginLog(ctx, "setUnActive", BOSObjectType.create((String)"D4C58B67"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getRuleName(), "im_combinRuleSetting_unactive", info.getCU().getId().toString());
            if (CombinRuleStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
                errors.add(IMUtils.getIMResource(ctx, "CANNOT_DISABLE", info.getRuleName()));
                continue;
            }
            updateNumbers = updateNumbers + "'" + info.getId().toString() + "',";
            LogUtils.afterLog(ctx, logPk);
        }
        int statusValue = 1;
        this.updateStatus(ctx, updateNumbers, statusValue);
        return errors;
    }

    private CombinRuleSettingCollection getCombinRuleSettingColl(Context ctx, ArrayList pks) throws BOSException {
        CombinRuleSettingCollection coll = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(pks), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("ruleName"));
        viewInfo.getSelector().add(new SelectorItemInfo("cu.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("status"));
        coll = this.getCombinRuleSettingCollection(ctx, viewInfo);
        return coll;
    }

    private void updateStatus(Context ctx, String updateNumbers, int statusValue) throws BOSException {
        if (updateNumbers.length() > 0) {
            updateNumbers = updateNumbers.substring(0, updateNumbers.length() - 1);
            String updateSql = "update T_IM_CombinRuleSetting set FStatus = " + statusValue + " where fid in (" + updateNumbers + ")";
            DbUtil.execute((Context)ctx, (String)updateSql);
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CombinRuleSettingInfo info = (CombinRuleSettingInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)"D4C58B67"));
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "addNew", BOSObjectType.create((String)"D4C58B67"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getRuleName(), "im_combinRuleSetting_new", ContextUtil.getCurrentCtrlUnit((Context)ctx).getCU().getId().toString());
        IObjectPK pk = super._addnew(ctx, model);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CombinRuleSettingInfo info = (CombinRuleSettingInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "update", BOSObjectType.create((String)"D4C58B67"), (IObjectPK)new ObjectUuidPK(info.getId()), info.getRuleName(), "im_combinRuleSetting_update", info.getCU().getId().toString());
        super._update(ctx, pk, model);
        LogUtils.afterLog(ctx, logPk);
    }
}

