/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.TaxManageCustomerImpl;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.app.AbstractGenerateInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.app.MakeInvoiceGroupStrategy;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GenerateMakeInvoiceHandler
extends AbstractGenerateInvoiceReqHandler {
    private Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.GenerateMakeInvoiceHandler");
    protected Map<String, Map<String, Set>> destBillEntryRelation = new HashMap<String, Map<String, Set>>();
    private LowTimer timer = new LowTimer();

    public GenerateMakeInvoiceHandler(Context ctx, InvoiceReqInfo invoiceReq) {
        super(ctx, invoiceReq);
    }

    @Override
    protected ArrayList handleBills(List exList) throws Exception {
        String combinRuleID = this.invoiceReq.getDestCombinRuleID();
        CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(this.ctx, combinRuleID);
        this.timer.reset();
        List<MakeInvoiceInfo> invoiceInfos = this.invoiceReq2MakeInvoiceBills(this.invoiceReq.getBills(), combinRule, exList);
        if (invoiceInfos.isEmpty()) {
            return null;
        }
        this.calInvoiceFields(invoiceInfos);
        this.logger.error((Object)("\u5f00\u7968\u5355\u6309\u5206\u5f55\u9650\u989d\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        ArrayList<MakeInvoiceInfo> afterGroupList = new ArrayList<MakeInvoiceInfo>();
        MakeInvoiceInfo mkInfo = null;
        BigDecimal limitAmt = BigDecimal.ZERO;
        List<MakeInvoiceInfo> afterGroupInvoice = null;
        for (int i = 0; i < invoiceInfos.size(); ++i) {
            mkInfo = invoiceInfos.get(i);
            limitAmt = mkInfo.getLimitAmt();
            try {
                afterGroupInvoice = MakeInvoiceGroupStrategy.groupEntry(this.ctx, this.destBillRelation, mkInfo, limitAmt, this.discountAmtMap, this.destMap);
            }
            catch (IMException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)((Object)e));
                exList.add(e);
                continue;
            }
            afterGroupList.addAll(afterGroupInvoice);
        }
        this.logger.error((Object)("\u5f00\u7968\u5355\u6309\u5355\u9650\u989d\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        String combineDiscountRow = IMFacadeFactory.getLocalInstance(this.ctx).getParamByKey("combineDiscountRow");
        if ("1".equals(combineDiscountRow)) {
            this.combinBizBillByRuleNew(afterGroupList, combinRule);
        } else {
            this.combinBizBillByRule(afterGroupList, combinRule);
        }
        this.logger.error((Object)("\u5f00\u7968\u5355\u4e8c\u6b21\u5408\u5e76\u5206\u5f55\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.removeZeroEntres(afterGroupList, exList);
        this.timer.reset();
        this.checkInvoceLimitNum(afterGroupList, this.invoiceReq);
        this.calInvoiceFields(afterGroupList);
        this.logger.error((Object)("\u5f00\u7968\u5355\u8d85\u9650\u884c\u62c6\u5206\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        ArrayList ids = IMInvoiceFacadeFactory.getLocalInstance(this.ctx).makeInvoiceSaveRelation(this.invoiceReq, this.destBillRelation, afterGroupList);
        this.logger.error((Object)("\u6784\u9020\u4e1a\u52a1\u5355\u636e\u8ddf\u5f00\u7968\u5355\u62c6\u5206\u5408\u5e76\u5173\u7cfb\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        this.carryCustomerMailingBd2Invoice(ids, afterGroupList);
        this.logger.error((Object)("\u643a\u5e26\u5f00\u7968\u3001\u6536\u7968\u4fe1\u606f \u5230\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.timer.reset();
        List errorID = this.submitMakeInvoice(afterGroupList, exList);
        this.logger.error((Object)("\u63d0\u4ea4\u3001\u5ba1\u6838\u5f00\u7968\u5355\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue()));
        this.doOtherErrorInvoice(errorID, exList);
        this.getResp().setMkFailBills((ArrayList)errorID);
        this.remvoeErrorID(ids, errorID);
        return ids;
    }

    private List<MakeInvoiceInfo> invoiceReq2MakeInvoiceBills(List<BillReqInfo> bills, CombinRuleSettingInfo combinRule, List exList) throws BOSException, IMException {
        ArrayList<MakeInvoiceInfo> retValue = new ArrayList<MakeInvoiceInfo>();
        HashMap<String, ArrayList<MakeInvoiceInfo>> successInfo = new HashMap<String, ArrayList<MakeInvoiceInfo>>();
        ArrayList bizFailBills = this.getResp().getBizFailBills();
        int size = bills.size();
        for (int idx = 0; idx < size; ++idx) {
            String[] bizBillNumbers = bills.get(idx).getBillNumber().split(";");
            String bizBillNumber = "";
            for (int i = 0; i < bizBillNumbers.length; ++i) {
                bizBillNumber = bizBillNumbers[i];
                if (!bizFailBills.contains(bizBillNumber)) continue;
            }
            MakeInvoiceInfo info = null;
            try {
                info = this.invoiceReq2MakeInvoiceInfo(bills.get(idx), combinRule.isIsInTax());
            }
            catch (EASBizException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                ArrayList tempList = null;
                for (int i = 0; i < bizBillNumbers.length; ++i) {
                    this.getResp().getBizFailBills().add(bizBillNumber);
                    tempList = (ArrayList)successInfo.get(bizBillNumber);
                    if (tempList == null) continue;
                    for (int j = 0; j < tempList.size(); ++j) {
                        Object obj = tempList.get(j);
                        retValue.remove(obj);
                    }
                }
                exList.add(e);
            }
            if (info == null) continue;
            for (int i = 0; i < bizBillNumbers.length; ++i) {
                bizBillNumber = bizBillNumbers[i];
                ArrayList<MakeInvoiceInfo> reqInfoList = (ArrayList<MakeInvoiceInfo>)successInfo.get(bizBillNumber);
                if (reqInfoList == null) {
                    reqInfoList = new ArrayList<MakeInvoiceInfo>();
                }
                reqInfoList.add(info);
                successInfo.put(bizBillNumber, reqInfoList);
            }
            retValue.add(info);
        }
        return retValue;
    }

    private MakeInvoiceInfo invoiceReq2MakeInvoiceInfo(BillReqInfo billReq, boolean isInTax) throws BOSException, EASBizException {
        String assActBosType;
        UsedCarInvoiceReqInfo invoiceReqInfo = (UsedCarInvoiceReqInfo)billReq.getObjectValue();
        BigDecimal limitAmt = this.getInvoiceLimitAmtByType(this.invoiceReq.getInvoiceType(), invoiceReqInfo.getCompany().getId().toString());
        MakeInvoiceInfo invoice = MakeInvoiceInfo.createMakeInvoiceInfo();
        invoice.setInvoiceType(this.getInvoiceType(this.invoiceReq.getInvoiceType()));
        if (invoice.getInvoiceType() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_INVOICETYPE_ISNULL", this.ctx.getLocale(), new Object[]{billReq.getBillNumber()})});
        }
        invoice.setIsContainTax(isInTax);
        invoice.setSplit(invoiceReqInfo.getBoolean("KEY_IS_SPLIT"));
        Map paramMap = IMUtils.getParam(this.ctx, invoiceReqInfo.getCompany().getId().toString(), new String[]{"VATM010", "VATM015"});
        int limitSplitMethod = IMUtils.getIntegerValue((String)paramMap.get("VATM010"));
        invoice.setLimitSplitMethod(limitSplitMethod);
        int goldenTaxControl = -1;
        goldenTaxControl = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoice.getInvoiceType()) ? 2 : IMUtils.getIntegerValue((String)paramMap.get("VATM015"));
        invoice.setGoldenTaxControl(goldenTaxControl);
        Map<String, String> taxControlMap = IMUtils.getTaxControlParam(this.ctx, goldenTaxControl, new String[]{"diffFactor", "allowDiffMax"});
        BigDecimal allowDiffMax = IMUtils.getDecimalValue(taxControlMap.get("allowDiffMax"));
        invoice.setAllowDiffMax(allowDiffMax);
        BigDecimal diffFactor = IMUtils.getDecimalValue(taxControlMap.get("diffFactor"));
        invoice.setDiffFactor(diffFactor);
        String descript = invoiceReqInfo.getDescription();
        String[] ids = descript.split("_");
        ArrayList<String> srcBillID = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            srcBillID.add(ids[i]);
        }
        this.destBillRelation.put(invoice.getId().toString(), srcBillID);
        invoice.setLimitAmt(limitAmt);
        invoice.setApplicateDate(new Date());
        invoice.setApplicant(ContextUtil.getCurrentUserInfo((Context)this.ctx));
        invoice.setRemark(invoiceReqInfo.getRemark());
        invoice.setBizDate(new Date());
        invoice.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        if (!StringUtils.isEmpty((String)invoiceReqInfo.getAsstActID()) && "37C67DFC".equalsIgnoreCase(assActBosType = BOSUuid.read((String)invoiceReqInfo.getAsstActID()).getType().toString())) {
            invoice.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        }
        invoice.setCompany(invoiceReqInfo.getCompany());
        invoice.setTaxNumber(invoiceReqInfo.getBuyerCardNo());
        invoice.setReceiveCompany(invoiceReqInfo.getBuyerName());
        invoice.setAddress(this.getStringValue(invoiceReqInfo.getBuyerAddress()) + this.getStringValue(invoiceReqInfo.getBuyerPhoneNumber()));
        invoice.setBankAccount(invoiceReqInfo.getBankAccount());
        this.beforSetCustomerInfo(invoice, billReq);
        this.overrideSetCustomerInfo(invoice, billReq);
        this.afterSetCustomerInfo(invoice, billReq);
        invoice.setCurrency(invoiceReqInfo.getCurrency());
        if (invoice.getCurrency() == null) {
            CurrencyInfo currencyInfo = new CurrencyInfo();
            currencyInfo.setId(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            invoice.setCurrency(currencyInfo);
        }
        invoice.setStatus(InvoiceBillStatus.TEMPSTROE);
        invoice.setSrcSystem(InvoiceSrcSystem.SYSTEM);
        invoice.setIsVehicle(true);
        invoice.setIsRedVoice(false);
        invoice.setIsDelete(false);
        invoice.setIsPrint(false);
        this.beforSetInvoiceOrgId(invoice, billReq);
        this.overrideSetInvoiceOrgId(invoice, billReq);
        this.afterSetInvoiceOrgId(invoice, billReq);
        List<BillEntryReqInfo> billEntries = billReq.getEntrys();
        HashMap<String, String> idRelation = new HashMap<String, String>();
        int size = billEntries.size();
        for (int i = 0; i < size; ++i) {
            BillEntryReqInfo entry = billEntries.get(i);
            idRelation.put(entry.getBillEntryID(), entry.getSrcEntryID());
        }
        ArrayList<EASBizException> exceptions = new ArrayList<EASBizException>();
        int size2 = billEntries.size();
        for (int i = 0; i < size2; ++i) {
            try {
                this.invoiceReqEntry2MakeInvoiceEntry(invoice, billReq, billEntries.get(i), idRelation);
                continue;
            }
            catch (EASBizException e) {
                exceptions.add(e);
            }
        }
        if (exceptions.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < exceptions.size(); ++i) {
                Exception e = (Exception)exceptions.get(i);
                sb.append(e.getMessage()).append("\r\n");
            }
            throw new IMException(IMException.ERRORMSG, new Object[]{sb.toString()});
        }
        MakeInvoiceEntryCollection entrys = invoice.getEntries();
        size2 = entrys.size();
        if (size2 == 0) {
            return null;
        }
        MakeInvoiceEntryInfo entry = null;
        MakeInvoiceEntryCollection newEntrs = new MakeInvoiceEntryCollection();
        MakeInvoiceInfo oldInvoice = (MakeInvoiceInfo)invoice.clone();
        MakeInvoiceEntryCollection oldEntrys = oldInvoice.getEntries();
        for (int i = 0; i < size2; ++i) {
            entry = entrys.get(i);
            if (this.destMap.containsKey(entry.getId().toString()) || this.srcMap.containsKey(entry.getId().toString())) {
                if (this.srcMap.containsKey(entry.getId().toString())) {
                    entry.setBillRowType(RowType.DISCOUNTED_ROW);
                } else if (this.destMap.containsKey(entry.getId().toString())) {
                    entry.setBillRowType(RowType.DISCOUNT_ROW);
                    entry.setSpecs(null);
                    entry.setMeasureUnit(null);
                    entry.setMakeInvoiceUnit(null);
                }
            }
            MakeInvoiceEntryInfo entryInfo = (MakeInvoiceEntryInfo)entry.clone();
            this.splitLimitAmtEntry(invoice, oldEntrys, newEntrs, entry, entryInfo);
        }
        newEntrs.addCollection(invoice.getEntries());
        invoice.getEntries().clear();
        invoice.getEntries().addCollection(newEntrs);
        return invoice;
    }

    private MakeInvoiceEntryInfo invoiceReqEntry2MakeInvoiceEntry(MakeInvoiceInfo makeInvoice, BillReqInfo billReq, BillEntryReqInfo entryReq, Map idRelation) throws EASBizException, BOSException {
        MakeInvoiceEntryInfo entry = MakeInvoiceEntryInfo.createMakeInvoiceEntryInfo(makeInvoice);
        entry.setTaxClassificationCode(entryReq.getTaxClassificationCode());
        entry.setProduceName(entryReq.getProductName());
        entry.setSpecs(entryReq.getModel());
        boolean isSplit = makeInvoice.isSplit();
        this.fillProductCode(makeInvoice, entry, entryReq.getProductCode());
        String billEntryID = entryReq.getBillEntryID();
        String unitID = entryReq.getMeasureUnitID();
        if (unitID != null) {
            MeasureUnitInfo unitInfo = new MeasureUnitInfo();
            unitInfo.setId(BOSUuid.read((String)unitID));
            entry.setMeasureUnit(unitInfo);
        }
        entry.setMakeInvoiceUnit(entryReq.getMakeInvoiceUnit());
        entry.setNoTaxPrice(entryReq.getNoTaxPrice());
        entry.setPrice(entryReq.getTaxPrice());
        if (!isSplit) {
            entry.setNoTaxPrice(entryReq.getRealPrice());
            entry.setPrice(entryReq.getActualPrice());
        }
        entry.setQuantity(entryReq.getQty());
        entry.setNoTaxAmt(entryReq.getNoTaxAmount());
        entry.setTaxRate(entryReq.getTaxRate());
        entry.setTaxAmt(entryReq.getTax());
        entry.setPriceTax(entryReq.getTaxAmount());
        entry.setSeq(entryReq.getSeq());
        this.checkPolicies(entry);
        makeInvoice.getEntries().add(entry);
        Object srcId = idRelation.get(billEntryID);
        if (srcId == null) {
            idRelation.put(billEntryID, entry.getId().toString());
        } else {
            Object newParentMkEntryID = idRelation.get(srcId.toString());
            entry.setSourceBillEntryId(newParentMkEntryID.toString());
            this.destMap.put(entry.getId().toString(), entry.getSourceBillEntryId());
            this.srcMap.put(entry.getSourceBillEntryId(), entry.getId().toString());
            this.discountAmtMap.put(entry.getSourceBillEntryId(), entry.getNoTaxAmt());
            entry.setBillRowType(RowType.DISCOUNT_ROW);
        }
        return entry;
    }

    private void beforSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforSetCustomerInfo(this.ctx, invoice, billReq);
    }

    private void overrideSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetCustomerInfo(this.ctx, invoice, billReq)) {
            this.setCustomerInfo(invoice, billReq);
        }
    }

    private void afterSetCustomerInfo(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterCustomerInfo(this.ctx, invoice, billReq);
    }

    private void setCustomerInfo(MakeInvoiceInfo makeInvoice, BillReqInfo billReq) throws BOSException, EASBizException {
        Map ret;
        CustomerTaxInfo customerTax;
        UsedCarInvoiceReqInfo invoiceReqInfo = (UsedCarInvoiceReqInfo)billReq.getObjectValue();
        String asstActID = invoiceReqInfo.getAsstActID();
        if (CurrentAccountType.SUPPLIER == makeInvoice.getCurrentAccountType() && !StringUtils.isEmpty((String)asstActID)) {
            SupplierInfo info = new SupplierInfo();
            info.setId(BOSUuid.read((String)asstActID));
            makeInvoice.setCurrAcctSupplier(info);
            return;
        }
        if (CurrentAccountType.CUSTOMER == makeInvoice.getCurrentAccountType() && !StringUtils.isEmpty((String)asstActID)) {
            CustomerInfo info = new CustomerInfo();
            info.setId(BOSUuid.read((String)asstActID));
            makeInvoice.setCurrAcctCustomer(info);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String custID = StringUtils.isEmpty((String)asstActID) ? "empty" : asstActID;
        params.put("customerId", custID);
        params.put("invoiceType", makeInvoice.getInvoiceType().getValue());
        params.put("receiveCompany", makeInvoice.getReceiveCompany());
        if (makeInvoice.getCompany() != null) {
            params.put("companyId", makeInvoice.getCompany().getId().toString());
        }
        if ((customerTax = (CustomerTaxInfo)(ret = CustomerTaxFactory.getLocalInstance(this.ctx).getCustomerTaxInfo(params)).get("value")) != null) {
            if (makeInvoice.getReceiveCompany() == null || "".equals(makeInvoice.getReceiveCompany())) {
                makeInvoice.setReceiveCompany(customerTax.getRecCompanyName());
                makeInvoice.setTaxNumber(customerTax.getTaxNumber());
                makeInvoice.setAddress(customerTax.getAddressTel());
                makeInvoice.setBankAccount(customerTax.getBankAccount());
            }
            makeInvoice.setCustomerTax(customerTax);
            CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
            CustomerTaxEntryCollection coll = customerTax.getEntries();
            int size = coll.size();
            for (int j = 0; j < size && !(entryInfo = coll.get(j)).getInvoiceType().getValue().equals(makeInvoice.getInvoiceType().getValue()); ++j) {
            }
            this.logger.error((Object)("method setCustomerInfo: entryInfo.getLimitAmt()" + entryInfo.getLimitAmt() + ",makeInvoice.getLimitAmt()" + makeInvoice.getLimitAmt()));
            if (entryInfo.getLimitAmt() != null && entryInfo.getLimitAmt().compareTo(BigDecimal.ZERO) > 0 && entryInfo.getLimitAmt().compareTo(makeInvoice.getLimitAmt()) < 0) {
                makeInvoice.setLimitAmt(entryInfo.getLimitAmt());
            }
            if ("1" == entryInfo.getDiscountType().getValue()) {
                makeInvoice.setSplit(true);
            } else if ("2" == entryInfo.getDiscountType().getValue()) {
                makeInvoice.setSplit(false);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("2".equals(makeInvoice.getInvoiceType().getValue()) || "3".equals(makeInvoice.getInvoiceType().getValue())) {
            String companyOrgId = billReq.getCompanyID();
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)companyOrgId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("customer", (Object)asstActID, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            view.setSelector(selector);
            CustomerCompanyInfoCollection custCompany = CustomerCompanyInfoFactory.getLocalInstance((Context)this.ctx).getCustomerCompanyInfoCollection(view);
            if (custCompany.size() > 0) {
                CustomerCompanyInfoInfo info = custCompany.get(0);
                makeInvoice.setCellphone(info.getMobile());
            }
        }
    }

    protected void carryCustomerMailingBd2Invoice(ArrayList ids, List<MakeInvoiceInfo> invoiceCol) throws BOSException, EASBizException {
        if (ids.size() == 0) {
            return;
        }
        for (int j = 0; j < invoiceCol.size(); ++j) {
            MakeInvoiceInfo mkInvoice = invoiceCol.get(j);
            this.carryCustomerMaillingInfo(mkInvoice);
        }
    }

    private void beforSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.beforeSetInvoiceOrgId(this.ctx, invoice, billReq);
    }

    private void overrideSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        if (!TaxManageCustomerImpl.overrideSetInvoiceOrgId(this.ctx, invoice, billReq)) {
            UsedCarInvoiceReqInfo invoiceReqInfo = (UsedCarInvoiceReqInfo)billReq.getObjectValue();
            invoice.setMakeInvoiceOrgID(invoiceReqInfo.getCompany().getId().toString());
        }
    }

    private void afterSetInvoiceOrgId(MakeInvoiceInfo invoice, BillReqInfo billReq) throws EASBizException, BOSException {
        TaxManageCustomerImpl.afterSetInvoiceOrgId(this.ctx, invoice, billReq);
    }

    private PayInvoiceTypeEnum getInvoiceType(String reqInvoiceType) {
        PayInvoiceTypeEnum retValue = null;
        if ("2".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if ("3".equals(reqInvoiceType)) {
            retValue = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        }
        return retValue;
    }

    @Override
    public BigDecimal getInvoiceLimitAmtByType(String invoiceType, String companyId) throws EASBizException, BOSException {
        String paramNumber = "VATM002";
        if ("2".equals(invoiceType)) {
            paramNumber = "VATM002";
        } else if ("3".equals(invoiceType)) {
            paramNumber = "VATM016";
        }
        return IMUtils.getDecimalParam(this.ctx, companyId, new String[]{paramNumber});
    }

    @Override
    protected void checkInvoiceReq() throws IMException {
        InvoiceReqUtils.checkInvoiceReq(this.invoiceReq, null);
    }

    private String getStringValue(String value) {
        return IMUtils.isEmpty(value) ? "" : value;
    }
}

