/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.app.utils.TMLicenseUtils;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceRedFacadeFactory;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.SpecificInformationEntryCollection;
import com.kingdee.eas.tm.im.SpecificInformationEntryInfo;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.app.AbstractBuildInvoiceReq;
import com.kingdee.eas.tm.im.app.AbstractGenerateInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.AbstractIMInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4Ar;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4MKRequest;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4NewMKRequest;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4UsedCar;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4UsedCarToMake;
import com.kingdee.eas.tm.im.app.BuildInvoiceReq4Vehicle;
import com.kingdee.eas.tm.im.app.GenerateInvoiceHandler;
import com.kingdee.eas.tm.im.app.GenerateMakeInvoiceHandler;
import com.kingdee.eas.tm.im.app.GenerateUsedCarInvoiceHandler;
import com.kingdee.eas.tm.im.app.GenerateVehicleInvoiceHandler;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.app.PrintInvoiceListReqHandler;
import com.kingdee.eas.tm.im.app.PrintInvoiceReqHandler;
import com.kingdee.eas.tm.im.app.QueryInvoiceReqHandler;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.common.writeback.WriteBackFacadeFactory;
import com.kingdee.eas.tm.im.common.writeback.app.handler.ExpressInfoDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.IExpressInfoDisposer;
import com.kingdee.eas.tm.im.util.EncryptUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.ws.msg.parser.AddExpressInfoParser;
import com.kingdee.eas.tm.im.ws.msg.parser.DelExpressInfoParser;
import com.kingdee.eas.tm.im.ws.msg.parser.ExpressInfoParser;
import com.kingdee.eas.tm.im.ws.msg.resq.ExpressInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IMInvoiceFacadeControllerBean
extends AbstractIMInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IMInvoiceFacadeControllerBean");

    @Override
    protected InvoiceRespInfo _list(Context ctx, InvoiceReqInfo req) throws BOSException, EASBizException {
        QueryInvoiceReqHandler reqHandler = new QueryInvoiceReqHandler(ctx, req);
        return reqHandler.handle();
    }

    @Override
    protected ArrayList _getInvoiceID(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        MakeInvoiceCollection invoiceColl = this.getInvoiceByBills(ctx, ids);
        if (invoiceColl.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND", new String[0])});
        }
        ArrayList<String> retValue = new ArrayList<String>();
        for (int i = 0; i < invoiceColl.size(); ++i) {
            retValue.add(invoiceColl.get(i).getId().toString());
        }
        return retValue;
    }

    @Override
    protected InvoiceRespInfo _printInvoice(Context ctx, InvoiceReqInfo req) throws BOSException, EASBizException {
        PrintInvoiceReqHandler reqHandler = new PrintInvoiceReqHandler(ctx, req);
        return reqHandler.handle();
    }

    @Override
    protected InvoiceRespInfo _printInvoiceList(Context ctx, InvoiceReqInfo req) throws BOSException, EASBizException {
        PrintInvoiceListReqHandler reqHandler = new PrintInvoiceListReqHandler(ctx, req);
        return reqHandler.handle();
    }

    @Override
    protected InvoiceRespInfo _makeInvoice(Context ctx, MakeInvoiceParam params) {
        InvoiceRespInfo resp = new InvoiceRespInfo();
        try {
            if (!"GUI".equals(params.getActionSystem())) {
                this._checkIMKLicense(ctx);
            }
            this.checkIMC001(ctx, params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ArrayList<String> ids = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)params.getBilBillIds())) {
                String[] billIds = params.getBilBillIds().split(",");
                int j = billIds.length;
                for (int i = 0; i < j; ++i) {
                    ids.add(billIds[i]);
                }
                if (ids.size() > 0) {
                    resp.setBizFailBills(ids);
                }
            }
            resp.setErrorMsg(this.getErrorMsg(e));
            return resp;
        }
        try {
            if (StringUtils.isEmpty((String)params.getBilBillIds()) || StringUtils.isEmpty((String)params.getSrcSystem())) {
                resp.setErrorMsg(IMUtils.getIMResource(ctx, "BILL_IS_NULL", new String[0]));
                return resp;
            }
            AbstractBuildInvoiceReq builder = null;
            if (IMConstant.SRCTYPE_FI_AR.equals(params.getSrcSystem())) {
                builder = new BuildInvoiceReq4Ar(ctx, params);
            } else if (IMConstant.SRCTYPE_IM_REQ.equals(params.getSrcSystem())) {
                builder = new BuildInvoiceReq4MKRequest(ctx, params);
            } else if (IMConstant.SRCTYPE_IM_INVOICEREQ.equals(params.getSrcSystem())) {
                builder = new BuildInvoiceReq4NewMKRequest(ctx, params);
            } else if (IMConstant.SRCTYPE_IM_VEHICLEREQ.equals(params.getSrcSystem())) {
                builder = new BuildInvoiceReq4Vehicle(ctx, params);
            } else if (IMConstant.SRCTYPE_IM_USEDCARREQ.equals(params.getSrcSystem())) {
                builder = "1".equals(params.getInvoiceType()) ? new BuildInvoiceReq4UsedCar(ctx, params) : new BuildInvoiceReq4UsedCarToMake(ctx, params);
            } else {
                throw new BOSException("IMInvoiceFacadeControllerBean._makeInvoice srcSystem\uff1a" + params.getSrcSystem() + " involid!");
            }
            InvoiceReqInfo req = builder.getInvoiceReqInfo();
            if (req != null && req.getBills() != null && req.getBills().size() != 0) {
                resp = this.buildMakeInvoice(ctx, req);
            }
            if (builder.getErrorMsgMap().size() > 0 || builder.getErrorMsgEntryMap().size() > 0) {
                String errorMsg = this.buildErrorBillMsgWithNewTax(builder);
                resp.setBizFailBills(builder.getFailBills());
                resp.setErrorMsg(errorMsg);
            }
            if (!(resp.getMkSucessBillIds() != null && resp.getMkSucessBillIds().size() != 0 || resp.getBizFailBills() != null && resp.getBizFailBills().size() != 0 || StringUtils.isEmpty((String)resp.getErrorMsg()) || resp.getMkFailBills() != null && resp.getMkFailBills().size() != 0)) {
                ArrayList<String> ids = new ArrayList<String>();
                if (!StringUtils.isEmpty((String)params.getBilBillIds())) {
                    String[] billIds = params.getBilBillIds().split(",");
                    int j = billIds.length;
                    for (int i = 0; i < j; ++i) {
                        ids.add(billIds[i]);
                    }
                    if (ids.size() > 0) {
                        resp.setBizFailBills(ids);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            resp.setErrorMsg(this.getErrorMsg(e));
        }
        return resp;
    }

    protected String buildErrorBillMsgWithNewTax(AbstractBuildInvoiceReq builder) throws BOSException {
        String errorMsg = "";
        try {
            Method method = builder.getClass().getDeclaredMethod("buildErrorBillMsg", new Class[0]);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)builder);
            Object value = txInvoker.invoke(method, new Object[0], 3);
            errorMsg = value.toString();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
        return errorMsg;
    }

    private InvoiceRespInfo buildMakeInvoice(Context ctx, InvoiceReqInfo req) throws BOSException, EASBizException {
        AbstractGenerateInvoiceReqHandler reqHandler = null;
        reqHandler = "B4E229F6".equals(req.getBosType()) ? new GenerateVehicleInvoiceHandler(ctx, req) : ("0CADF79B".equals(req.getBosType()) ? ("1".equals(req.getInvoiceType()) ? new GenerateUsedCarInvoiceHandler(ctx, req) : new GenerateMakeInvoiceHandler(ctx, req)) : new GenerateInvoiceHandler(ctx, req));
        return reqHandler.handle();
    }

    @Override
    protected ArrayList _buildPwyParam(Context ctx, ArrayList ids, PwyServiceType serviceType, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        return this.innerBuildPwyParam(ctx, ids, serviceType, ownerSystem, null);
    }

    @Override
    protected ArrayList _buildPwyParamEx(Context ctx, ArrayList ids, PwyServiceType serviceType, TransSrcSystemEnum owerSystem, Map otherParams) throws BOSException, EASBizException {
        return this.innerBuildPwyParam(ctx, ids, serviceType, owerSystem, otherParams);
    }

    protected ArrayList innerBuildPwyParam(Context ctx, ArrayList ids, PwyServiceType serviceType, TransSrcSystemEnum ownerSystem, Map otherParams) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            PwyInvokeParam invokeParam;
            String mkBillID = ids.get(i).toString();
            MakeInvoiceInfo invoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkBillID), MakeInvoiceInfo.getMakeSelector());
            try {
                if (PwyServiceType.OPR_INV_PAPER_MAKE.equals((Object)serviceType)) {
                    MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeMake(invoice.getId().toString());
                } else if (PwyServiceType.OPR_INV_PAPER_CANCEL.equals((Object)serviceType)) {
                    MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeCancel(invoice.getId().toString());
                } else if (PwyServiceType.OPR_INV_RELECT_MAKE.equals((Object)serviceType) || PwyServiceType.OPR_INV_DISKELECT_MAKE.equals((Object)serviceType)) {
                    MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeElecMake(invoice.getId().toString());
                }
                if (invoice.getDrawertxt() == null) {
                    invoice.setDrawer((UserInfo)ctx.get((Object)"UserInfo"));
                    invoice.setDrawertxt(((UserInfo)ctx.get((Object)"UserInfo")).getName());
                }
                PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
                actionParam.setParams(otherParams);
                invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            }
            catch (EASBizException e) {
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("error", "exception");
                resultMap.put("exception", e.getMessage());
                resultMap.put("billId", invoice.getId().toString());
                resultMap.put("number", invoice.getNumber());
                retList.add(resultMap);
                continue;
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    @Override
    protected ArrayList _buildPwyPrintParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        return this.buildPwyPrintParam(ctx, false, ids, ownerSystem);
    }

    @Override
    protected ArrayList _buildPwyPrintListParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        return this.buildPwyPrintParam(ctx, true, ids, ownerSystem);
    }

    private ArrayList buildPwyPrintParam(Context ctx, boolean isPrintList, ArrayList ids, TransSrcSystemEnum ownerSystem) throws EASBizException, BOSException {
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        HashSet idSet = IMUtils.list2Set(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        HashSet<String> invoiceTypeSet = new HashSet<String>();
        invoiceTypeSet.add("2");
        invoiceTypeSet.add("3");
        invoiceTypeSet.add("4");
        invoiceTypeSet.add("5");
        filter.getFilterItems().add(new FilterItemInfo("invoiceType", invoiceTypeSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        if (mkInvoiceCol.size() > 0) {
            throw new IMException(IMException.HAS_OTHER_INVOICE);
        }
        PwyServiceType serviceType = PwyServiceType.OPR_INV_PAPER_PRINT_INV;
        String permItem = "im_makeInvoice_printinvoice";
        if (isPrintList) {
            serviceType = PwyServiceType.OPR_INV_PAPER_PRINT_LIST;
            permItem = "im_makeInvoice_printinvoicelist";
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> retValue = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < ids.size(); ++i) {
            String invoiceID = ids.get(i).toString();
            MakeInvoiceInfo invoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceID), MakeInvoiceInfo.getMakeSelector());
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), permItem);
            PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            resultMap = new HashMap();
            resultMap.put("invoiceNo", invoice.getInvoiceNo());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("id", invoice.getId().toString());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retValue.add(resultMap);
        }
        return retValue;
    }

    private String getErrorMsg(Exception e) {
        String retValue = new String();
        retValue = e instanceof NullPointerException ? e.getClass().getName() + ":" + e.getStackTrace()[0].toString() : e.getMessage();
        return retValue;
    }

    @Override
    protected Map _checkBeforePrint(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList orderIds = new ArrayList();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (idSet.size() > 0) {
            if (!this.isAllPrint(ctx, idSet, true)) {
                errorMsg = errorMsg + IMUtils.getIMResource(ctx, "INVOICE_ISNOT_ALLPRINT", new String[0]);
            }
            if (!"".equals(errorMsg = errorMsg + this.isSeqPrint(ctx, idSet, false, false, orderIds))) {
                retMap.put("errorMsg", errorMsg);
            } else {
                String successMsg = this.getSuccessMessage(ctx, idSet);
                retMap.put("successMsg", successMsg);
                retMap.put("orderIds", orderIds);
            }
        }
        return retMap;
    }

    private String isSeqPrint(Context ctx, Set idSet, boolean isPrintList, boolean isRePrint, ArrayList orderIds) throws BOSException {
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        int size = mkInvoiceCol.size();
        MakeInvoiceInfo invoice0 = mkInvoiceCol.get(0);
        if (size == 0 || invoice0 == null || invoice0.getInvoiceNumber() == null) {
            return IMUtils.getIMResource(ctx, "INVOICENUMBER_HAVENULLVALUE", new String[0]);
        }
        if (!isPrintList) {
            String invoiceNumber0 = invoice0.getInvoiceNumber();
            for (int idx = 1; idx < size; ++idx) {
                if (invoiceNumber0.equals(mkInvoiceCol.get(idx).getInvoiceNumber())) continue;
                return IMUtils.getIMResource(ctx, "NOT_SUPPORT_MULTINUMBERPRINT", new String[0]);
            }
        }
        for (int i = 0; i < mkInvoiceCol.size(); ++i) {
            orderIds.add(mkInvoiceCol.get(i).getId().toString());
        }
        if (!isPrintList) {
            String invoiceNoStart = invoice0.getInvoiceNo();
            String invoiceNoEnd = mkInvoiceCol.get(size - 1).getInvoiceNo();
            if (invoiceNoStart == null || invoiceNoEnd == null) {
                return IMUtils.getIMResource(ctx, "INVOICENO_HAVENULLVALUE", new String[0]);
            }
            BigInteger noEnd = new BigInteger(invoiceNoEnd);
            BigInteger noStart = new BigInteger(invoiceNoStart);
            BigInteger noDiff = noEnd.subtract(noStart);
            if (noDiff.intValue() != size - 1) {
                String retValue = IMUtils.getIMResource(ctx, "INVOICE_ISNOT_SEQPRINT", new String[0]);
                if (isRePrint) {
                    retValue = IMUtils.getIMResource(ctx, "INVOICE_ISNOTSEQ_CANNOTREPRINT", new String[0]);
                }
                return retValue;
            }
        }
        return "";
    }

    private boolean isAllPrint(Context ctx, Set idSet, boolean isPrint) throws BOSException {
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isPrint", (Object)isPrint, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        return mkInvoiceCol.size() == 0;
    }

    private String getSuccessMessage(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        sic.add(new SelectorItemInfo("invoiceType"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        MakeInvoiceCollection mkInvoiceCol = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        MakeInvoiceInfo invoice0 = mkInvoiceCol.get(0);
        String successMsg = "";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICETYPE", new String[0]) + "\uff1a" + invoice0.getInvoiceType() + "\n";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICENUMBER", new String[0]) + "\uff1a" + invoice0.getInvoiceNumber() + "\n";
        successMsg = successMsg + IMUtils.getIMResource(ctx, "INVOICENO", new String[0]) + "\uff1a" + invoice0.getInvoiceNo();
        return successMsg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MakeInvoiceCollection getInvoiceByBills(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        Set<String> invoiceNoSet = this.getInvoiceNoListByAROtherBillIDSet(ctx, ids);
        MakeInvoiceCollection invoiceColl = new MakeInvoiceCollection();
        if (ids.size() == 0) {
            return invoiceColl;
        }
        String selectSQL = "SELECT relation.FInvoiceBillID as invoiceID FROM T_IM_MakeInvoiceRelation as relation  INNER JOIN T_IM_MakeInvoice as mkBill on mkBill.fid = relation.FInvoiceBillID  WHERE relation.FBizBillID IN (" + InvoiceReqUtils.concat(ids) + ") and mkBill.FStatus = '4' and mkBill.FInvoiceNo in (" + InvoiceReqUtils.concat(invoiceNoSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        try {
            while (rs.next()) {
                try {
                    String invoiceID = rs.getString("invoiceID");
                    MakeInvoiceInfo invoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoiceID), MakeInvoiceInfo.getPrintSelector());
                    invoiceColl.add(invoice);
                }
                catch (ObjectNotFoundException e) {
                    throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "QUERYINVOICE_FAILURE", new String[0])});
                    return invoiceColl;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private Set<String> getInvoiceNoListByAROtherBillIDSet(Context ctx, ArrayList billIdSet) throws BOSException {
        String billID = (String)billIdSet.get(0);
        String bosType = BOSUuid.read((String)billID).getType().toString();
        String tableName = bosType.equals("FC910EF3") ? "t_ar_otherbill" : "t_im_makeInvoiceReq";
        try {
            String selectSQL = "select FInvoiceNo from " + tableName + " where fid in (" + InvoiceReqUtils.concat(billIdSet) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            HashSet<String> invoiceNoSet = new HashSet<String>();
            while (rs.next()) {
                String invoiceNo = rs.getString("FInvoiceNo");
                if (invoiceNo == null || "".equals(invoiceNo)) continue;
                String[] invoiceNoArr = invoiceNo.split(";");
                for (int i = 0; i < invoiceNoArr.length; ++i) {
                    invoiceNoSet.add(invoiceNoArr[i]);
                }
            }
            return invoiceNoSet;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    protected Map _downLoadRedInvoice(Context ctx, ArrayList jsonData) throws BOSException, EASBizException {
        Map result = new HashMap();
        ctx.put((Object)"ctx_company", jsonData.get(0));
        for (int i = 1; i < jsonData.size(); ++i) {
            String jsonStr = jsonData.get(i).toString();
            result = IMInvoiceRedFacadeFactory.getLocalInstance(ctx).parseDownLoadRedInvoice(jsonStr);
        }
        return result;
    }

    @Override
    protected Map _checkBeforeRePrint(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList orderIds = new ArrayList();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (idSet.size() > 0) {
            if (!this.isAllPrint(ctx, idSet, false)) {
                errorMsg = errorMsg + IMUtils.getIMResource(ctx, "HAVE_INVOICE_NOTPRINT", new String[0]);
            }
            if (!"".equals(errorMsg = errorMsg + this.isSeqPrint(ctx, idSet, false, true, orderIds))) {
                retMap.put("errorMsg", errorMsg);
            } else {
                String successMsg = this.getSuccessMessage(ctx, idSet);
                retMap.put("successMsg", successMsg);
                retMap.put("orderIds", orderIds);
            }
        }
        return retMap;
    }

    @Override
    protected List _buildMailOrderParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        MakeInvoiceCollection invoices = this.getInvoices(ctx, ids);
        HashMap<String, CustomerMailingEntryInfo> senderMailDataCache = new HashMap<String, CustomerMailingEntryInfo>();
        MakeInvoiceInfo invoice = null;
        String billID = null;
        IObjectPK logPK = null;
        Iterator it = invoices.iterator();
        while (it.hasNext()) {
            invoice = (MakeInvoiceInfo)it.next();
            billID = invoice.getId().toString();
            try {
                String logItemName = "im_mkInvoice_mailorder";
                String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
                String logDetail = invoice.getNumber();
                logPK = LogUtils.beginLog(ctx, actionName, invoice.getBOSType(), (IObjectPK)new ObjectUuidPK(billID), logDetail, logItemName, invoice.getCompany().getId().toString());
                this.checkBeforeMailOrder(ctx, invoice, senderMailDataCache);
            }
            catch (EASBizException e) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("error", "exception");
                resultMap.put("exception", invoice.getNumber() + ":" + e.getMessage());
                resultMap.put("billId", billID);
                resultMap.put("number", invoice.getNumber());
                resultMap.put("info", invoice);
                retList.add(resultMap);
                continue;
            }
            CustomerMailingEntryInfo mailingEntryInfo = CustomerMailingFactory.getLocalInstance(ctx).getSenderMailData(invoice.getCompany().getId().toString(), invoice.getDrawertxt(), senderMailDataCache, null);
            HashMap<String, CustomerMailingEntryInfo> params = new HashMap<String, CustomerMailingEntryInfo>();
            params.put("mailingEntryInfo", mailingEntryInfo);
            PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_MAIL_ORDER, ownerSystem, null, invoice.getId().toString(), params);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            invokeParam.setLogPK(logPK.toString());
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    protected MakeInvoiceCollection getInvoices(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = MakeInvoiceInfo.getMakeSelector();
        view.setSelector(sic);
        MakeInvoiceCollection invoices = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        return invoices;
    }

    protected void checkBeforeMailOrder(Context ctx, MakeInvoiceInfo invoice, Map<String, CustomerMailingEntryInfo> senderMailDataCache) throws BOSException, EASBizException {
        String companyID = invoice.getCompany().getId().toString();
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(companyID, "im_makeInvoice_mailorder");
        if (!invoice.getStatus().equals((Object)InvoiceBillStatus.MAKED)) {
            throw new IMException(IMException.EXPRESSORDERSTATUS_ERROR);
        }
        if (StringUtils.isEmpty((String)invoice.getDrawertxt())) {
            throw new IMException(IMException.DRAWERISNULL);
        }
        CustomerMailingEntryInfo mailEntryInfo = CustomerMailingFactory.getLocalInstance(ctx).getSenderMailData(companyID, invoice.getDrawertxt(), senderMailDataCache, null);
        if (mailEntryInfo == null) {
            throw new IMException(IMException.MAILISNULL);
        }
    }

    @Override
    protected void _parseExpressInfo(Context ctx, String dataJSON) throws BOSException, EASBizException {
        JSONObject json = null;
        String type = null;
        try {
            json = new JSONObject(dataJSON);
            type = json.getString("type");
        }
        catch (JSONException e1) {
            throw new BOSException((Throwable)e1);
        }
        ExpressInfoParser parser = this.getExpressInfoParser(type);
        ExpressInfo expressInfo = null;
        try {
            expressInfo = (ExpressInfo)parser.parse(ctx, dataJSON);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        if (expressInfo != null) {
            IExpressInfoDisposer disposer = this.getExpressInfoDisposer();
            disposer.dispose(ctx, expressInfo);
        }
    }

    protected ExpressInfoParser getExpressInfoParser(String type) {
        ExpressInfoParser parser = null;
        if ("FILLEXPNUM".equals(type)) {
            parser = new AddExpressInfoParser();
        } else if ("DELEXP".equals(type)) {
            parser = new DelExpressInfoParser();
        }
        return parser;
    }

    protected IExpressInfoDisposer getExpressInfoDisposer() {
        return new ExpressInfoDisposer();
    }

    @Override
    protected Map _checkBeforePrintList(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList orderIds = new ArrayList();
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String errorMsg = "";
        if (idSet.size() > 0) {
            if (!"".equals(errorMsg = errorMsg + this.isSeqPrint(ctx, idSet, true, false, orderIds))) {
                retMap.put("errorMsg", errorMsg);
            } else {
                String successMsg = this.getSuccessMessage(ctx, idSet);
                retMap.put("successMsg", successMsg);
                retMap.put("orderIds", orderIds);
            }
        }
        return retMap;
    }

    @Override
    protected String _encryptAES(Context ctx, String content, String key) throws BOSException, EASBizException {
        try {
            return EncryptUtil.encrypt(content, key);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected MakeInvoiceInfo getMakeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) {
        MakeInvoiceInfo invoiceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        MakeInvoiceCollection coll = null;
        try {
            coll = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
            if (coll != null && coll.size() > 0) {
                invoiceInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return invoiceInfo;
    }

    @Override
    protected ArrayList _autoBuildPwyParam(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        ArrayList retList = new ArrayList();
        for (int i = 0; i < ids.size(); ++i) {
            PwyServiceType serviceType;
            MakeInvoiceInfo invoice;
            block7: {
                String mkBillID = ids.get(i).toString();
                invoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(mkBillID), MakeInvoiceInfo.getMakeSelector());
                serviceType = PwyServiceType.OPR_INV_PAPER_MAKE;
                if (invoice.getInvoiceType() == PayInvoiceTypeEnum.ELECTRONICINVOICE) {
                    serviceType = PwyServiceType.OPR_INV_DISKELECT_MAKE;
                }
                try {
                    if (PwyServiceType.OPR_INV_PAPER_MAKE.equals((Object)serviceType)) {
                        MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeMake(invoice.getId().toString());
                        break block7;
                    }
                    if (PwyServiceType.OPR_INV_PAPER_CANCEL.equals((Object)serviceType)) {
                        MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeCancel(invoice.getId().toString());
                        break block7;
                    }
                    if (!PwyServiceType.OPR_INV_RELECT_MAKE.equals((Object)serviceType) && !PwyServiceType.OPR_INV_DISKELECT_MAKE.equals((Object)serviceType)) break block7;
                    MakeInvoiceFactory.getLocalInstance(ctx).checkBeforeElecMake(invoice.getId().toString());
                }
                catch (EASBizException e) {
                    HashMap<String, String> resultMap = new HashMap<String, String>();
                    resultMap.put("error", "exception");
                    resultMap.put("exception", e.getMessage());
                    resultMap.put("billId", invoice.getId().toString());
                    resultMap.put("number", invoice.getNumber());
                    retList.add(resultMap);
                    continue;
                }
            }
            if (invoice.getDrawertxt() == null) {
                invoice.setDrawer((UserInfo)ctx.get((Object)"UserInfo"));
                invoice.setDrawertxt(((UserInfo)ctx.get((Object)"UserInfo")).getName());
            }
            PwyActionParam actionParam = new PwyActionParam(serviceType, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), null);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("billId", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retList.add(resultMap);
        }
        return retList;
    }

    @Override
    protected Map _buildMailOrderSearchPwyParam(Context ctx, String id) throws BOSException, EASBizException {
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
        CoreBaseInfo value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value.get("company");
        String companyID = company.getId().toString();
        String bosType = BOSUuid.read((String)id).getType().toString();
        String logItemName = "im_mkInvoice_mailordersearch";
        if ("AC368D2D".equals(bosType)) {
            logItemName = "im_makeInvoiceReq_mailordersearch";
        }
        String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
        String logDetail = value.getString("number");
        IObjectPK logPK = LogUtils.beginLog(ctx, actionName, BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(id), logDetail, logItemName, companyID);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String errorMsg = null;
        try {
            String permissonName = "im_makeInvoice_mailordersearch";
            if ("AC368D2D".equals(bosType)) {
                permissonName = "im_makeInvoiceReq_mailordersearch";
            }
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(companyID, permissonName);
            this.checkBeforeMailOrderSearch(ctx, (IObjectValue)value);
        }
        catch (Exception e) {
            errorMsg = value.getString("number") + ":" + e.getMessage();
            ret.put("errorMsg", errorMsg);
            return ret;
        }
        String expressBillNum = value.getString("expressBillNum");
        ArrayList expressBillNums = new ArrayList();
        expressBillNums.addAll(Arrays.asList((Object[])expressBillNum.split(";")));
        ret.put("companyID", companyID);
        ret.put("expressBillNums", expressBillNums);
        ret.put("logPK", logPK.toString());
        LogUtils.afterLog(ctx, logPK);
        return ret;
    }

    protected void checkBeforeMailOrderSearch(Context ctx, IObjectValue value) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value.get("company");
        String companyID = company.getId().toString();
        if (StringUtils.isEmpty((String)value.getString("expressBillNum"))) {
            throw new IMException(IMException.EXPRESSBILLNUM_NULL);
        }
    }

    @Override
    protected void _checkIMKLicense(Context ctx) throws BOSException, EASBizException {
        String[] moduleName = new String[]{"TDM", "IMK"};
        String[] moduleChineseName = new String[]{IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "TDM", ctx.getLocale()), IMUtils.getString("com.kingdee.eas.tm.im.IMResource", "IMK", ctx.getLocale())};
        String uiName = "com.kingdee.eas.tm.im.client.MakeInvoiceEditUI";
        TMLicenseUtils.chekLicense((Context)ctx, (String[])moduleName, (String[])moduleChineseName, (String)uiName);
    }

    protected void checkIMC001(Context ctx, MakeInvoiceParam params) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        if (!StringUtils.isEmpty((String)params.getBilBillIds())) {
            String[] billIds = params.getBilBillIds().split(",");
            int j = billIds.length;
            for (int i = 0; i < j; ++i) {
                ids.add(billIds[i]);
            }
        }
        if (ids.isEmpty()) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        ev.setSelector(sic);
        OtherBillCollection coll = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection(ev);
        HashSet<String> companyIDs = new HashSet<String>();
        HashMap<String, String> companyID2Name = new HashMap<String, String>();
        if (coll != null && !coll.isEmpty()) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i).getCompany() == null) continue;
                companyIDs.add(coll.get(i).getCompany().getId().toString());
                companyID2Name.put(coll.get(i).getCompany().getId().toString(), coll.get(i).getCompany().getName());
            }
        }
        Iterator it = companyIDs.iterator();
        String companyID = null;
        boolean isUseSIM = false;
        String[] paramNumber = new String[]{"IMC001"};
        IIMFacade iIMFacade = IMFacadeFactory.getLocalInstance(ctx);
        Map paramMap = null;
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            companyID = (String)it.next();
            isUseSIM = false;
            paramMap = iIMFacade.getParam(companyID, paramNumber);
            if (paramMap.get("IMC001") != null && Boolean.valueOf((String)paramMap.get("IMC001")).booleanValue()) {
                isUseSIM = true;
            }
            if (!isUseSIM) continue;
            sb.append((String)companyID2Name.get(companyID)).append("\u3001");
        }
        if (sb.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{sb.substring(0, sb.length() - 1) + "\uff1a" + ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"IMC001_ISOPEN", (Locale)ctx.getOriginLocale())});
        }
    }

    @Override
    protected Map _checkBeforeElecTicketResend(Context ctx, ArrayList idSet) throws BOSException, EASBizException {
        MakeInvoiceCollection invoiceColl = this.getInvoices(ctx, idSet);
        if (invoiceColl.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND", new String[0])});
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        MakeInvoiceInfo invoice = null;
        StringBuffer errorMsg = new StringBuffer();
        String recBillEmail = "";
        String cellphone = "";
        for (int i = 0; i < invoiceColl.size(); ++i) {
            invoice = invoiceColl.get(i);
            String companyID = invoice.getCompany().getId().toString();
            String bosType = BOSUuid.read((String)invoice.getId().toString()).getType().toString();
            String logItemName = "im_mkInvoice_elecTicketResend";
            String actionName = IMUtils.getString("com.kingdee.eas.tm.im.LogResource", logItemName, ctx.getLocale());
            String logDetail = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LogDetail", IMUtils.getLocale(), new Object[]{invoice.getInvoiceNo(), invoice.getInvoiceNumber()});
            IObjectPK logPK = LogUtils.beginLog(ctx, actionName, BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(invoice.getId().toString()), logDetail, logItemName, companyID);
            retMap.put(invoice.getId().toString(), logPK);
        }
        boolean isConsistent = true;
        for (int i = 0; i < invoiceColl.size(); ++i) {
            invoice = invoiceColl.get(i);
            String companyID = invoice.getCompany().getId().toString();
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(companyID, "im_makeInvoice_elecTicketResend");
            if (!(InvoiceBillStatus.MAKED.equals((Object)invoice.getStatus()) && (PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoice.getInvoiceType())))) {
                errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ElecTicketResend_StatusError", ctx.getLocale(), new Object[]{invoice.getNumber()}));
                continue;
            }
            if (InvoiceSrcSystem.PWYDOWNLOAD.equals((Object)invoice.getSrcSystem())) {
                errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ElecTicketResend_srcError", ctx.getLocale(), new Object[]{invoice.getNumber()}));
                continue;
            }
            if (i == 0) {
                recBillEmail = this.formatString(invoice.getRecBillEmail());
                cellphone = this.formatString(invoice.getCellphone());
                continue;
            }
            if (recBillEmail.equals(this.formatString(invoice.getRecBillEmail())) && cellphone.equals(this.formatString(invoice.getCellphone()))) continue;
            isConsistent = false;
        }
        retMap.put("errorMsg", errorMsg.toString());
        retMap.put("isConsistent", isConsistent);
        retMap.put("recBillEmail", recBillEmail);
        retMap.put("cellphone", cellphone);
        return retMap;
    }

    private String formatString(String str) {
        return str == null ? "" : str;
    }

    @Override
    protected ArrayList _buildElecTicketResend(Context ctx, ArrayList ids, TransSrcSystemEnum ownerSystem) throws BOSException, EASBizException {
        MakeInvoiceInfo invoice = null;
        HashMap<String, String> params = null;
        MakeInvoiceCollection invoiceColl = this.getInvoices(ctx, ids);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> retValue = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; i < invoiceColl.size(); ++i) {
            invoice = invoiceColl.get(i);
            params = new HashMap<String, String>();
            params.put("serialNum", PwyHelper.md5(invoice.getId().toString()));
            params.put("invoiceCode", invoice.getInvoiceNumber());
            params.put("invoiceNo", invoice.getInvoiceNo());
            params.put("phoneNumber", IMUtils.isEmpty(invoice.getCellphone()) ? "" : invoice.getCellphone());
            params.put("email", IMUtils.isEmpty(invoice.getRecBillEmail()) ? "" : invoice.getRecBillEmail());
            PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_RELECT_RESEND, ownerSystem, invoice.getCompany().getId().toString(), invoice.getId().toString(), params);
            PwyInvokeParam invokeParam = PwyServiceFacadeFactory.getLocalInstance(ctx).invoke(actionParam);
            resultMap = new HashMap();
            resultMap.put("id", invoice.getId().toString());
            resultMap.put("number", invoice.getNumber());
            resultMap.put("info", invoice);
            resultMap.put("invokeParam", invokeParam);
            retValue.add(resultMap);
        }
        return retValue;
    }

    @Override
    protected Map _beginPrintInvoiceLog(Context ctx, Set idSet, String opType) throws BOSException {
        HashMap<String, IObjectPK> logPkMap = new HashMap<String, IObjectPK>();
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        MakeInvoiceInfo info = null;
        String methodName = "";
        String logItemName = "";
        if (mkInvoiceCol != null && mkInvoiceCol.size() > 0) {
            int size = mkInvoiceCol.size();
            for (int i = 0; i < size; ++i) {
                info = mkInvoiceCol.get(i);
                if (opType.equals("printList")) {
                    methodName = "printList";
                    logItemName = "im_mkInvoice_printInvoiceList";
                } else if (opType.equals("rePrintInvoice")) {
                    methodName = "rePrintInvoice";
                    logItemName = "im_mkInvoice_rePrintInvoice";
                } else if (opType.equals("printInvoice")) {
                    methodName = "printInvoice";
                    logItemName = "im_mkInvoice_printInvoice";
                }
                IObjectPK logPk = LogUtils.beginLog(ctx, methodName, BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), logItemName, info.getCompany().getId().toString());
                logPkMap.put(info.getId().toString(), logPk);
            }
        }
        return logPkMap;
    }

    @Override
    protected ArrayList _makeInvoiceSaveRelation(Context ctx, InvoiceReqInfo invoiceReq, Map destBillRelation, List invoiceColl) throws BOSException, EASBizException {
        ArrayList idList = this.saveMakeInvoice(ctx, invoiceColl);
        this.saveBillRelattion(ctx, invoiceReq, destBillRelation);
        return idList;
    }

    protected void saveBillRelattion(Context ctx, InvoiceReqInfo invoiceReq, Map destBillRelation) throws BOSException, EASBizException {
        String updateSql;
        String[] arr;
        Map<String, String> groupIDMap = this.processDestBillRelation(ctx, invoiceReq, destBillRelation);
        if (groupIDMap.size() == 0) {
            return;
        }
        ArrayList<String> allBizBillIDList = new ArrayList<String>();
        String insertSql = "insert into T_IM_MakeInvoiceRelation(FID, FSrcBosType, FBizBillID, FInvoiceBillID, FAmount, FQty, FGroupID, FOperateTime,FCombinID) values (?, ?, ?, ?, ?, ?, ?, ?,?)";
        Set keys = destBillRelation.keySet();
        Iterator iterator = keys.iterator();
        String groupID = BOSUuid.create((String)"55555555").toString();
        Timestamp operateTime = new Timestamp(new Date().getTime());
        HashSet<String> invoiceIdSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String makeBillID = (String)iterator.next();
            invoiceIdSet.add(makeBillID);
            ArrayList bizIds = (ArrayList)destBillRelation.get(makeBillID);
            Object[][] params = new Object[bizIds.size()][9];
            String combinID = BOSUuid.create((String)"44444444").toString();
            for (int i = 0; i < bizIds.size(); ++i) {
                params[i][0] = BOSUuid.create((String)"0EBBB5B4").toString();
                params[i][1] = invoiceReq.getBosType();
                params[i][2] = bizIds.get(i).toString();
                params[i][3] = makeBillID;
                params[i][4] = BigDecimal.ZERO;
                params[i][5] = BigDecimal.ZERO;
                params[i][6] = groupIDMap.get(bizIds.get(i).toString()) + groupID;
                params[i][7] = operateTime;
                params[i][8] = combinID;
                IMUtils.traceUpAndDown(ctx, bizIds.get(i).toString(), invoiceReq.getBosType(), makeBillID, "412A6F98");
                if (allBizBillIDList.contains(bizIds.get(i).toString())) continue;
                allBizBillIDList.add(bizIds.get(i).toString());
            }
            DBUtil.executeBatch((Context)ctx, (String)insertSql, (Object[][])params);
        }
        if (allBizBillIDList.size() == 0) {
            return;
        }
        String srcBillBosType = BOSUuid.read((String)((String)allBizBillIDList.get(0))).getType().toString();
        if (!srcBillBosType.isEmpty() && "FC910EF3".equals(srcBillBosType)) {
            this.reWriteAROtherBill(ctx, allBizBillIDList);
        }
        if (!srcBillBosType.isEmpty() && "3D667D4A".equals(srcBillBosType)) {
            arr = allBizBillIDList.toArray(new String[allBizBillIDList.size()]);
            updateSql = "update T_IM_TaxSeparation set fstatus = 1 where fid in" + IMUtils.getInStringFromArray(arr);
            DBUtil.executeUpdate((Context)ctx, (String)updateSql, null);
        }
        if (!srcBillBosType.isEmpty() && "AC368D2D".equals(srcBillBosType)) {
            arr = allBizBillIDList.toArray(new String[allBizBillIDList.size()]);
            updateSql = "update T_IM_MakeInvoiceReq set FIsMakeInoviced = 1 where fid in" + IMUtils.getInStringFromArray(arr);
            DBUtil.executeUpdate((Context)ctx, (String)updateSql, null);
        }
        if (!srcBillBosType.isEmpty() && "0CADF79B".equals(srcBillBosType)) {
            arr = allBizBillIDList.toArray(new String[allBizBillIDList.size()]);
            updateSql = "update T_IM_UsedCarInvoiceReq set FIsMakeInvoiced = 1 where fid in" + IMUtils.getInStringFromArray(arr);
            DBUtil.executeUpdate((Context)ctx, (String)updateSql, null);
        }
        if ("FC910EF3".equals(srcBillBosType)) {
            WriteBackFacadeFactory.getLocalInstance(ctx).dispose2Order("genInvoice", invoiceIdSet);
        }
    }

    private void reWriteAROtherBill(Context ctx, List<String> allBizBillIDList) throws BOSException {
        try {
            String[] arr = allBizBillIDList.toArray(new String[allBizBillIDList.size()]);
            String updateSql = "update t_ar_otherbill set FIsMakeInvoiced = 1 where fid in" + IMUtils.getInStringFromArray(arr);
            DBUtil.executeUpdate((Context)ctx, (String)updateSql, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected ArrayList saveMakeInvoice(Context ctx, List<MakeInvoiceInfo> invoiceColl) throws EASBizException, BOSException {
        IMakeInvoice facade = MakeInvoiceFactory.getLocalInstance(ctx);
        ArrayList<String> invoiceIdList = new ArrayList<String>();
        for (int i = 0; i < invoiceColl.size(); ++i) {
            IObjectPK id;
            SpecificInformationInfo specInfo;
            MakeInvoiceInfo info = invoiceColl.get(i);
            if (info.getSpecificInformation() != null && (specInfo = (SpecificInformationInfo)info.getSpecificInformation().clone()) != null && specInfo.getId() != null) {
                specInfo.setId(BOSUuid.create((String)"5E6919D3"));
                SpecificInformationEntryCollection coll = specInfo.getEntries();
                SpecificInformationEntryInfo entry = null;
                int size = coll.size();
                for (int j = 0; j < size; ++j) {
                    entry = coll.get(j);
                    entry.setId(BOSUuid.create((String)"506D2A5F"));
                }
                info.setSpecificInformation(specInfo);
            }
            if (invoiceIdList.contains((id = facade.saveNoSetting(info)).toString())) continue;
            invoiceIdList.add(id.toString());
        }
        return invoiceIdList;
    }

    protected Map<String, String> processDestBillRelation(Context ctx, InvoiceReqInfo invoiceReq, Map destBillRelation) throws BOSException {
        try {
            Set keys = destBillRelation.keySet();
            HashSet<String> existIDs = new HashSet<String>();
            HashSet<String> notExistIDs = new HashSet<String>();
            String selectSQL = "select fid from t_im_makeinvoice where fid in" + IMUtils.getInStringFromSet(keys);
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSQL, null);
            while (rs.next()) {
                String mkBillID = rs.getString("fid");
                existIDs.add(mkBillID);
            }
            for (String id : keys) {
                if (existIDs.contains(id)) continue;
                notExistIDs.add(id);
            }
            keys.removeAll(notExistIDs);
            String ruleID = invoiceReq.getSrcCombinRuleID();
            CombinRuleSettingInfo combinRule = IMUtils.getCombinRule(ctx, ruleID);
            String[] properties = new String[]{"id"};
            if (combinRule != null && combinRule.getCombinFields() != null) {
                properties = combinRule.getCombinFields().split("_");
            }
            ArrayList<String> headProp = new ArrayList<String>();
            for (int i = 0; i < properties.length; ++i) {
                String value = properties[i];
                String[] tempValue = value.split("\\.");
                if (tempValue.length > 1 || headProp.contains(value)) continue;
                headProp.add(value);
            }
            HashMap<String, String> groupIDMap = new HashMap<String, String>();
            Set allMkIDs = destBillRelation.keySet();
            Iterator ite = allMkIDs.iterator();
            HashSet bizIDSet = new HashSet();
            while (ite.hasNext()) {
                String makeBillID = (String)ite.next();
                ArrayList bizIds = (ArrayList)destBillRelation.get(makeBillID);
                bizIDSet.addAll(bizIds);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", bizIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            if (headProp.size() > 0) {
                int size = headProp.size();
                for (int i = 0; i < size; ++i) {
                    sic.add(new SelectorItemInfo((String)headProp.get(i)));
                }
            }
            view.setSelector(sic);
            IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(BOSObjectType.create((String)invoiceReq.getBosType()), view);
            IObjectValue object = null;
            for (int i = 0; i < collection.size(); ++i) {
                object = collection.getObject(i);
                String groupID = IMUtils.buildKey(headProp, object);
                groupIDMap.put(object.get("id").toString(), groupID);
            }
            return groupIDMap;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _encryptAES128(Context ctx, String content, String password) throws BOSException, EASBizException {
        try {
            return EncryptUtil.encrypt(content, password);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

