/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IncomeInvoiceService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.IncomeInvoiceService");
    private Context ctx = null;

    public IncomeInvoiceService(Context ctx) {
        this.ctx = ctx;
    }

    protected Map createIncomeInvoiceForOtherBill(Map params) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        IncomeInvoiceInfo invoiceInfo = null;
        IncomeInvoiceEntryInfo invoiceEntryInfo = null;
        boolean isAddNew = false;
        String otherBillId = (String)params.get("otherBillId");
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        if (invoiceCode == null || invoiceNumber == null) {
            return ret;
        }
        invoiceInfo = this.getIncomeInvoiceInfo(invoiceCode, invoiceNumber);
        if (invoiceInfo == null) {
            invoiceInfo = new IncomeInvoiceInfo();
            isAddNew = true;
        }
        OtherBillInfo otherbill = OtherBillFactory.getLocalInstance((Context)this.ctx).getOtherBillInfo((IObjectPK)new ObjectUuidPK(otherBillId), this.getOtherBillSelector());
        this.buildHead(invoiceInfo, otherbill, params);
        invoiceInfo.getEntries().clear();
        OtherBillentryInfo otherbillEntry = null;
        BigDecimal amount = new BigDecimal(0);
        BigDecimal tax = new BigDecimal(0);
        BigDecimal amountTax = new BigDecimal(0);
        int size = otherbill.getEntries().size();
        for (int i = 0; i < size; ++i) {
            otherbillEntry = (OtherBillentryInfo)otherbill.getEntries().getObject(i);
            invoiceEntryInfo = this.buildEntry(invoiceInfo, otherbillEntry, params);
            invoiceInfo.getEntries().add(invoiceEntryInfo);
            amount = amount.add(invoiceEntryInfo.getMoney());
            tax = tax.add(invoiceEntryInfo.getTaxAmt());
            amountTax = amountTax.add(invoiceEntryInfo.getTaxTotal());
        }
        invoiceInfo.setAmount(amount);
        invoiceInfo.setTax(tax);
        invoiceInfo.setAmountTax(amountTax);
        if (isAddNew) {
            IncomeInvoiceFactory.getLocalInstance(this.ctx).addnew((CoreBaseInfo)invoiceInfo);
        } else {
            IncomeInvoiceFactory.getLocalInstance(this.ctx).update((IObjectPK)new ObjectUuidPK(invoiceInfo.getId().toString()), (CoreBaseInfo)invoiceInfo);
        }
        IMUtils.traceUpAndDown(this.ctx, invoiceInfo.getId().toString(), "1343913D", otherBillId, "48DA3A71");
        return ret;
    }

    private SelectorItemCollection getOtherBillSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entry.*"));
        selector.add(new SelectorItemInfo("entry.material.*"));
        return selector;
    }

    private void buildHead(IncomeInvoiceInfo info, OtherBillInfo otherbill, Map params) {
        String invoiceCode = (String)params.get("invoiceCode");
        String invoiceNumber = (String)params.get("invoiceNumber");
        Date bizDate = (Date)params.get("bizDate");
        PayInvoiceTypeEnum invoiceType = (PayInvoiceTypeEnum)params.get("invoiceType");
        String billingCompany = (String)params.get("billingCompany");
        String taxNumber = (String)params.get("taxNumber");
        String contact = (String)params.get("contact");
        String bankInformation = (String)params.get("bankInformation");
        info.setInvoiceCode(invoiceCode);
        info.setInvoiceNumber(invoiceNumber);
        info.setBizDate(bizDate);
        info.setInvoiceType(invoiceType);
        info.setBillingCompany(billingCompany);
        info.setTaxNumber(taxNumber);
        info.setContact(contact);
        info.setBankInformation(bankInformation);
        info.setCompany(otherbill.getCompany());
        info.setCurrentAccountType(CurrentAccountType.SUPPLIER);
        info.setCurrAcctSupplier(this.getSupplier(this.ctx, otherbill.getAsstActID()));
        info.setStatus(IncomeStatusEnum.NORMAL);
    }

    private IncomeInvoiceEntryInfo buildEntry(IncomeInvoiceInfo info, OtherBillentryInfo otherbillEntry, Map params) {
        IncomeInvoiceEntryInfo entryInfo = new IncomeInvoiceEntryInfo();
        entryInfo.setProductName(otherbillEntry.getMaterial().getName());
        entryInfo.setSpecs(otherbillEntry.getMaterial().getModel());
        entryInfo.setQuantity(otherbillEntry.getQuantity());
        entryInfo.setTaxExcluded(otherbillEntry.getPrice());
        entryInfo.setTaxPrice(otherbillEntry.getTaxPrice());
        entryInfo.setMoney(otherbillEntry.getAmount());
        entryInfo.setTaxAmt(otherbillEntry.getTaxAmount());
        entryInfo.setTaxRate(otherbillEntry.getTaxRate());
        entryInfo.setTaxTotal(otherbillEntry.getRecievePayAmount());
        return entryInfo;
    }

    private SupplierInfo getSupplier(Context ctx, String supplierId) {
        SupplierInfo supplierInfo = null;
        try {
            supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierId));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return supplierInfo;
    }

    private IncomeInvoiceInfo getIncomeInvoiceInfo(String invoiceCode, String invoiceNumber) {
        IncomeInvoiceInfo invoiceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = null;
        try {
            coll = IncomeInvoiceFactory.getLocalInstance(this.ctx).getIncomeInvoiceCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        }
        return invoiceInfo;
    }
}

