/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.InvoiceCombinRuleCollection;
import com.kingdee.eas.tm.im.InvoiceCombinRuleInfo;
import com.kingdee.eas.tm.im.InvoiceCombinRuleType;
import com.kingdee.eas.tm.im.app.AbstractInvoiceCombinRuleControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import org.apache.log4j.Logger;

public class InvoiceCombinRuleControllerBean
extends AbstractInvoiceCombinRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.InvoiceCombinRuleControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.dealBeforeSave(ctx, model);
        return super._save(ctx, model);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.dealBeforeSave(ctx, model);
        super._save(ctx, pk, model);
    }

    private void dealBeforeSave(Context ctx, InvoiceCombinRuleInfo rule) throws EASBizException, BOSException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        InvoiceCombinRuleInfo ruleDB = null;
        ruleDB = (InvoiceCombinRuleInfo)this._getRuleByCreator(ctx, user.getId().toString());
        if (ruleDB != null) {
            rule.setId(ruleDB.getId());
            rule.setCreator(user);
        }
    }

    private void dealBeforeSave(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        this.dealBeforeSave(ctx, (InvoiceCombinRuleInfo)model);
    }

    @Override
    protected IObjectValue _getRuleByCreator(Context ctx, String creatorId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("creator.id", (Object)creatorId, CompareType.EQUALS));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("type"));
        selectors.add(new SelectorItemInfo("isList"));
        selectors.add(new SelectorItemInfo("creator.*"));
        view.setFilter(filter);
        view.setSelector(selectors);
        InvoiceCombinRuleInfo rule = null;
        try {
            InvoiceCombinRuleCollection ruleCol = this.getInvoiceCombinRuleCollection(ctx, view);
            if (ruleCol.size() > 0) {
                rule = ruleCol.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (rule == null) {
            rule = new InvoiceCombinRuleInfo();
            rule.setType(InvoiceCombinRuleType.NSM);
            rule.setIsList(false);
            rule.setCreator(UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(creatorId)));
        }
        return rule;
    }
}

