/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.tm.im.DeductRowEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqAlgorithm;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillRelationOptionEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqException;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.common.calculate.PropertyCalculator;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceReqAlgorithmForInfo
extends MakeInvoiceReqAlgorithm {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceReqAlgorithmForInfo");
    private MakeInvoiceReqInfo info = null;
    private ExchangeRateInfo rateInfo = null;
    private int localAmountPrecision = 2;
    private int amountPrecision = 2;
    protected Map paramMap = new HashMap();

    public MakeInvoiceReqAlgorithmForInfo(MakeInvoiceReqInfo info, Context ctx) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRateInfo;
        this.info = info;
        this.ctx = ctx;
        if (info.getCompany() != null) {
            String companyID = info.getCompany().getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(companyID);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("isOnlyUnion"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            info.setCompany(company);
            this.localAmountPrecision = info.getCompany().getBaseCurrency().getPrecision();
            this.initParam(ctx, company.getId().toString());
        }
        if ((exchangeRateInfo = IMUtils.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), info.getBizDate())) == null) {
            exchangeRateInfo = this.getDefaultExchangeRateInfo();
        }
        this.rateInfo = exchangeRateInfo;
        if (info.getCurrency() != null) {
            String currencyID = info.getCurrency().getId().toString();
            CurrencyInfo currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("SELECT id,name,number,precision WHERE id = '" + currencyID + "'");
            info.setCurrency(currency);
            this.amountPrecision = info.getCurrency().getPrecision();
        }
    }

    private void initParam(Context ctx, String companyId) throws EASBizException, BOSException {
        String[] paramNumbers = new String[]{"VATM001", "DISCOUNTRATEPRECISION"};
        this.paramMap = IMUtils.getParam(ctx, companyId, paramNumbers);
    }

    public void revalue() throws EASBizException, BOSException {
        if (this.isBotp()) {
            return;
        }
        this.reCalculate();
    }

    public void revalue4Botp() throws EASBizException, BOSException {
        this.checkBotp(this.info);
        this.setDefaultValue4Botp(this.info);
        boolean isBillRelatin = MakeInvoiceReqBillRelationOptionEnum.BRINGIN.equals((Object)this.info.getBillRelationOption());
        if (!isBillRelatin) {
            this.reCalculate4Botp();
        }
    }

    public void revalue4DataUpgrade() throws EASBizException, BOSException {
        this.calTotalFields();
    }

    private void checkBotp(MakeInvoiceReqInfo info) throws EASBizException {
        if (info.get("isInTax") == null) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.BOTP_ISINTAXNOTCONFIG);
        }
        if (info.get("currency") == null) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.BOTP_CURRENCYNOTCONFIG);
        }
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.BOTP_ENTRIESNULL);
        }
        if (info.isIsInTax()) {
            if (info.getEntries().get(0).get("price") == null && info.getEntries().get(0).get("priceIncludingTax") == null) {
                throw new MakeInvoiceReqException(MakeInvoiceReqException.BOTP_TAXPRICEORTAXAMOUNTNOTCONFIG);
            }
        } else if (info.getEntries().get(0).get("noTaxPrice") == null && info.getEntries().get(0).get("priceExcludingTax") == null) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.BOTP_PRICEORAMOUNTNOTCONFIG);
        }
    }

    private void setDefaultValue4Botp(MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        info.setConvertMode(this.rateInfo.getConvertMode());
        if (info.getExchangeRate() == null) {
            info.setExchangeRate(this.rateInfo.getConvertRate());
        }
        info.setIsBotp(true);
        if (info.isEASBizType()) {
            this.matchDefaultValue4Botp(info);
        } else {
            MakeInvoiceReqEntryInfo entryInfo = null;
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                entryInfo = (MakeInvoiceReqEntryInfo)it.next();
                if (entryInfo.getUnitName() != null || entryInfo.getUnit() == null) continue;
                entryInfo.setUnitName(entryInfo.getUnit().getName());
            }
        }
    }

    protected void matchDefaultValue4Botp(MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        AsstActTypeInfo asstActTypeInfo = info.getAsstActType();
        if (asstActTypeInfo != null && asstActTypeInfo.getId() != null) {
            asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)this.ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeInfo.getId()));
            String relationDataObj = asstActTypeInfo.getRealtionDataObject();
            if ("T_BD_Supplier".equalsIgnoreCase(relationDataObj)) {
                boolean isSetSuccess = false;
                if (StringUtils.isEmpty((String)info.getRecOrgName()) || StringUtils.isEmpty((String)info.getAddress()) || StringUtils.isEmpty((String)info.getTaxNumber()) || StringUtils.isEmpty((String)info.getBankAccount())) {
                    isSetSuccess = this.setCustomerTaxOrSupplier(info);
                }
                if (!isSetSuccess && StringUtils.isEmpty((String)info.getRecOrgName()) && StringUtils.isEmpty((String)info.getTaxNumber()) && info.isIsPurchaseInvoice()) {
                    SupplierInfo supplierInfo;
                    info.setRecOrgName(info.getAsstActName());
                    if (info.getAsstActID() != null && (supplierInfo = SupplierFactory.getLocalInstance((Context)this.ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getAsstActID()))) != null) {
                        info.setTaxNumber(supplierInfo.getTaxRegisterNo());
                    }
                }
            } else if ("T_BD_Customer".equalsIgnoreCase(relationDataObj)) {
                if (StringUtils.isEmpty((String)info.getRecOrgName()) || StringUtils.isEmpty((String)info.getAddress()) || StringUtils.isEmpty((String)info.getTaxNumber()) || StringUtils.isEmpty((String)info.getBankAccount())) {
                    this.setCustomerTaxOrSupplier(info);
                }
                if (info.getDisInvoicer() == null && info.getRecBillPhone() == null && info.getRecBillComName() == null && info.getRecBillAdress() == null && info.getMailNumber() == null && info.getRecBillEmail() == null && info.getExpressBillNum() == null && info.getMailDate() == null) {
                    this.carryCustomerMaillingInfo(info, this.ctx);
                }
            } else {
                info.setAsstActType(null);
                if (StringUtils.isEmpty((String)info.getRecOrgName())) {
                    info.setRecOrgName(info.getAsstActName());
                }
                info.setAsstActID(null);
                info.setAsstActName(null);
                info.setAsstActNumber(null);
            }
        }
        MakeInvoiceReqEntryInfo entryInfo = null;
        Iterator it = info.getEntries().iterator();
        while (it.hasNext()) {
            ProductCodeInfo productCodeInfo;
            entryInfo = (MakeInvoiceReqEntryInfo)it.next();
            if (entryInfo.getUnitName() == null && entryInfo.getUnit() != null) {
                entryInfo.setUnitName(entryInfo.getUnit().getName());
            }
            String materialID = null;
            String expenseTypeID = null;
            if (entryInfo.getMaterial() != null) {
                entryInfo.setMaterial(this.getMaterial(this.ctx, entryInfo.getMaterial().getId().toString()));
                materialID = entryInfo.getMaterial().getId().toString();
                if (StringUtils.isEmpty((String)entryInfo.getProductName())) {
                    entryInfo.setProductName(entryInfo.getMaterial().getName());
                }
            } else {
                if (entryInfo.getExpenseItem() == null) continue;
                entryInfo.setExpenseItem(this.getExpenseType(this.ctx, entryInfo.getExpenseItem().getId().toString()));
                expenseTypeID = entryInfo.getExpenseItem().getId().toString();
                if (StringUtils.isEmpty((String)entryInfo.getProductName())) {
                    entryInfo.setProductName(entryInfo.getExpenseItem().getName());
                }
            }
            String customerId = null;
            if (asstActTypeInfo != null && "T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
                customerId = info.getAsstActID();
            }
            if ((productCodeInfo = ProductCodeFactory.getLocalInstance(this.ctx).getMatchProduct(customerId, info.getCompany().getId().toString(), materialID, expenseTypeID, entryInfo.getTaxRate(), info.isIsVehicle(), info.isIsDiffTax())) != null) {
                entryInfo.setProductCode(productCodeInfo);
                entryInfo.setProductName(productCodeInfo.getName());
                if (info.isIsDiffTax()) {
                    entryInfo.setDeductRow(DeductRowEnum.DeductRow);
                    entryInfo.setIsQtyZero(true);
                    entryInfo.setQty(BigDecimal.ZERO);
                    entryInfo.setBaseQty(BigDecimal.ZERO);
                    entryInfo.setPrice(BigDecimal.ZERO);
                    entryInfo.setNoTaxPrice(BigDecimal.ZERO);
                    entryInfo.setActualPrice(BigDecimal.ZERO);
                    entryInfo.setActualTaxPrice(BigDecimal.ZERO);
                } else {
                    entryInfo.setDeductRow(null);
                }
                if (productCodeInfo.getTaxClassificationCode() == null) continue;
                entryInfo.setTaxClassificationCode(productCodeInfo.getTaxClassificationCode().getMergeCode());
                continue;
            }
            if (!info.isIsDiffTax()) continue;
            productCodeInfo = ProductCodeFactory.getLocalInstance(this.ctx).getMatchProduct(customerId, info.getCompany().getId().toString(), materialID, expenseTypeID, entryInfo.getTaxRate(), info.isIsVehicle(), false);
            entryInfo.setDeductRow(DeductRowEnum.NotDeductRow);
            if (productCodeInfo == null) continue;
            entryInfo.setProductCode(productCodeInfo);
            entryInfo.setProductName(productCodeInfo.getName());
            if (productCodeInfo.getTaxClassificationCode() == null) continue;
            entryInfo.setTaxClassificationCode(productCodeInfo.getTaxClassificationCode().getMergeCode());
        }
    }

    private boolean setCustomerTaxOrSupplier(MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        boolean isSetSuccess = false;
        String invoiceType = info.getInvoiceType() != null ? info.getInvoiceType().getValue() : null;
        boolean isEntryDefaultCustomerTax = false;
        boolean isDefaultCustomerTax = false;
        if (StringUtils.isEmpty((String)invoiceType) || "-1".equals(invoiceType)) {
            isEntryDefaultCustomerTax = true;
        } else if (info.getSourceBillType() != MakeInvoiceReqBillTypeEnum.OtherReceiveBill) {
            isDefaultCustomerTax = true;
        }
        if (isEntryDefaultCustomerTax || isDefaultCustomerTax) {
            IObjectCollection col;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("customerId", info.getAsstActID());
            params.put("companyId", info.getCompany().getId().toString());
            params.put("invoiceType", invoiceType);
            Map ret = CustomerTaxFactory.getLocalInstance(this.ctx).getCustomerTaxInfo(params);
            CustomerTaxInfo customerTaxInfo = (CustomerTaxInfo)ret.get("value");
            if (customerTaxInfo != null && (col = (IObjectCollection)customerTaxInfo.get("entries")).size() != 0) {
                boolean isDefault = (Boolean)col.getObject(0).get("isDefault");
                if (isEntryDefaultCustomerTax && isDefault) {
                    this.setCustomerTaxInfo(info, customerTaxInfo);
                    info.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)((String)col.getObject(0).get("invoiceType"))));
                    isSetSuccess = true;
                } else if (isDefaultCustomerTax) {
                    this.setCustomerTaxInfo(info, customerTaxInfo);
                    isSetSuccess = true;
                }
            }
        }
        return isSetSuccess;
    }

    private void setCustomerTaxInfo(MakeInvoiceReqInfo info, CustomerTaxInfo customerTaxInfo) {
        info.setRecOrgName((String)customerTaxInfo.get("recCompanyName"));
        info.setTaxNumber((String)customerTaxInfo.get("taxNumber"));
        info.setBankAccount((String)customerTaxInfo.get("bankAccount"));
        info.setAddress((String)customerTaxInfo.get("addressTel"));
    }

    public void carryCustomerMaillingInfo(MakeInvoiceReqInfo info, Context ctx) throws EASBizException, BOSException {
        if (info.getCompany() == null || info.getAsstActID() == null) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("comOrgUnitId", info.getCompany().getId().toString());
        param.put("customerId", info.getAsstActID());
        Map entryMap = CustomerMailingFactory.getLocalInstance(ctx).getDefaultCustomerMailInfo(param);
        CustomerMailingEntryInfo defaultEntry = null;
        if (entryMap.get("defaultEntry") != null) {
            defaultEntry = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
            info.setDisInvoicer(defaultEntry.getContacts());
            info.setRecBillComName(defaultEntry.getCompanyName());
            info.setRecBillAdress(defaultEntry.getAddress());
            info.setRecBillPhone(defaultEntry.getTelephone());
            info.setRecBillEmail(defaultEntry.getMailbox());
            info.setMailNumber(defaultEntry.getPostalcode());
        }
    }

    protected void reCalculate() throws EASBizException, BOSException {
        this.reCalQtyFields();
        this.reCalEntryFields();
        this.calTotalFields();
    }

    protected void reCalculate4Botp() throws EASBizException, BOSException {
        this.reCalEntryFields();
        this.calTotalFields();
    }

    private void reCalQtyFields() throws EASBizException, BOSException {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calQtyByBaseQty(i);
        }
    }

    protected void reCalEntryFields() throws EASBizException, BOSException {
        PropertyCalculator siCalculator = null;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            BigDecimal taxAmount;
            siCalculator = this.getPropertyCalculator(i);
            if (this.isIsQtyZero(i).booleanValue()) {
                siCalculator.evalForEntry("qty=0", this.getQtyPrecision(i));
                siCalculator.evalForEntry("baseQty=0", this.getBaseQtyPrecision(i));
                siCalculator.evalForEntry("taxPrice=0", this.getPricePrecision(i));
                siCalculator.evalForEntry("price=0", this.getPricePrecision(i));
                siCalculator.evalForEntry("actualPrice=0", this.getPricePrecision(i));
                siCalculator.evalForEntry("actualTaxPrice=0", this.getPricePrecision(i));
                siCalculator.evalForEntry("discountRate=0", 2);
                siCalculator.evalForEntry("discountAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("discountAmountLocal=0", this.getAmountPrecision());
                if (SysConstant.BIGZERO.compareTo(siCalculator.getBigDecimal("taxAmount")) != 0) {
                    taxAmount = siCalculator.getBigDecimal("taxAmount");
                    siCalculator.evalForEntry("taxAmount=" + taxAmount, this.getAmountPrecision());
                    this.calByTaxAmount(i);
                    continue;
                }
                siCalculator.evalForEntry("taxAmount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("localTaxAmount=0", this.getLocalAmountPrecision());
                siCalculator.evalForEntry("tax=0", this.getAmountPrecision());
                siCalculator.evalForEntry("localTax=0", this.getLocalAmountPrecision());
                siCalculator.evalForEntry("amount=0", this.getAmountPrecision());
                siCalculator.evalForEntry("localAmount=0x", this.getLocalAmountPrecision());
                continue;
            }
            if (this.isInTax() || this.ignoreBaseAlgorithm(i)) {
                if (SysConstant.BIGZERO.compareTo(this.getTaxPrice(i)) != 0) {
                    BigDecimal taxPrice = this.getTaxPrice(i).abs();
                    siCalculator.evalForEntry("taxPrice=" + taxPrice, this.getPricePrecision(i));
                    this.calByTaxPrice(i);
                    continue;
                }
                if (SysConstant.BIGZERO.compareTo(siCalculator.getBigDecimal("taxAmount")) != 0) {
                    taxAmount = siCalculator.getBigDecimal("taxAmount");
                    siCalculator.evalForEntry("taxAmount=" + taxAmount, this.getAmountPrecision());
                    this.calByTaxAmount(i);
                    continue;
                }
                siCalculator.evalForEntry("taxPrice=0", this.getPricePrecision(i));
                this.calByTaxPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(this.getPrice(i)) != 0) {
                BigDecimal price = this.getPrice(i).abs();
                siCalculator.evalForEntry("price=" + price, this.getPricePrecision(i));
                this.calByPrice(i);
                continue;
            }
            if (SysConstant.BIGZERO.compareTo(siCalculator.getBigDecimal("amount")) != 0) {
                BigDecimal amount = siCalculator.getBigDecimal("amount");
                siCalculator.evalForEntry("amount=" + amount, this.getAmountPrecision());
                this.calByAmount(i);
                continue;
            }
            siCalculator.evalForEntry("price=0", this.getPricePrecision(i));
            this.calByPrice(i);
        }
    }

    @Override
    protected boolean ignoreBaseAlgorithm(int i) {
        return this.isBotp() && SysConstant.BIGZERO.compareTo(this.getQty(i)) == 0;
    }

    @Override
    protected boolean ignoreCalLocalTaxAmount(int i) {
        PropertyCalculator siCalculator = this.getPropertyCalculator(i);
        return this.isBotp() && siCalculator.getBigDecimal("localTaxAmount") != null && siCalculator.getBigDecimal("localTaxAmount").compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    protected PropertyCalculator getPropertyCalculator(int i) {
        MakeInvoiceReqEntryInfo entry = this.info.getEntries().get(i);
        PropertyCalculator siCalculator = new PropertyCalculator((IObjectValue)entry, this.fieldMap);
        return siCalculator;
    }

    @Override
    protected int getEntrySize() {
        return this.info.getEntries().size();
    }

    @Override
    protected boolean isInTax() {
        return this.info.isIsInTax();
    }

    @Override
    protected ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return this.nullToZero(this.info.getExchangeRate());
    }

    @Override
    public int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    @Override
    public int getAmountPrecision() {
        return this.amountPrecision;
    }

    @Override
    protected void setTotalAmount(BigDecimal totalAmount) {
        this.info.setPriceExcludingTax(totalAmount);
    }

    @Override
    protected void setTotalTax(BigDecimal totalTax) {
        this.info.setTax(totalTax);
    }

    @Override
    protected void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setPriceIncludingTax(totalTaxAmount);
    }

    @Override
    protected void setTotalLocalAmount(BigDecimal totalLocalAmount) {
        this.info.setPriceExcludingTaxLocal(totalLocalAmount);
    }

    @Override
    protected void setTotalLocalTax(BigDecimal totalLocalTax) {
        this.info.setTaxLocal(totalLocalTax);
    }

    @Override
    protected void setTotalLocalTaxAmount(BigDecimal totalLocalTaxAmount) {
        this.info.setPriceIncludingTaxLocal(totalLocalTaxAmount);
    }

    @Override
    protected boolean isBotp() {
        return this.info.isIsBotp();
    }

    @Override
    public int getDefaultDiscountRatePrecision(int i) {
        Object value = this.paramMap.get("DISCOUNTRATEPRECISION");
        int discountRatePrecision = 4;
        if (value != null) {
            discountRatePrecision = Integer.parseInt(value.toString());
        }
        return discountRatePrecision;
    }
}

