/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.im.DeductRowEnum;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqException;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.AbstractMakeInvoiceReqControllerBean;
import com.kingdee.eas.tm.im.app.MakeInvoiceReqAlgorithmForInfo;
import com.kingdee.eas.tm.im.common.comm.service.util.SIMOpenApiUtil;
import com.kingdee.eas.tm.im.common.writeback.WriteBackFacadeFactory;
import com.kingdee.eas.tm.im.util.Collection2MapUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.SIMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MakeInvoiceReqControllerBean
extends AbstractMakeInvoiceReqControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceReqControllerBean");
    private static final int PRODUCTNAME_MAX_LENGTH = 200;
    private static final String NEXTLINE = ";\r\n";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        this.dealDefaultDataBeforeSave(ctx, info);
        this.checkBeforeSave(ctx, info);
        if (IMKBizTypeEnum.IERP.equals((Object)info.getBizType())) {
            SIMUtils.checkInvoiceBeforeSave(ctx, info);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            info = this.getNewNumber(ctx, info, info.getCompany().getId().toString(), null);
        } else {
            info.setNumber(this.trimStr(info.getNumber()));
        }
        this.reCalculate(ctx, info);
        this.handleAsstActName(info);
        this.trimInfo(info);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        super._checkNumberDup(ctx, null, (IObjectValue)info);
        this.dispose(ctx, info, "restore");
        this.setBizYearMonthNull(info);
        this.updateSpecificInformationInfo(ctx, model);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        this.dispose(ctx, info, "save");
        if (IMKBizTypeEnum.IERP.equals((Object)info.getBizType())) {
            SIMUtils.oneStepMakeInvoiceWithSave(ctx, info);
        }
        return pk;
    }

    private void dealDefaultDataBeforeSave(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        boolean isDiffTax;
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        } else {
            info.setId(BOSUuid.create((String)"AC368D2D"));
        }
        if (info.getSrcSystem() == null) {
            info.setSrcSystem(MakeInvoiceReqSrcSystem.MANUAL);
        }
        if (info.getBizType() == null) {
            info.setBizType(IMKBizTypeEnum.EAS);
        }
        if (isDiffTax = info.isIsDiffTax()) {
            int len = info.getEntries().size();
            for (int i = 0; i < len; ++i) {
                this.dealDefaultEntryData(ctx, info.getEntries().get(i));
            }
        }
    }

    private void setBizYearMonthNull(MakeInvoiceReqInfo info) {
        if (info.getBizYear() == 0) {
            info.put("bizYear", null);
        }
        if (info.getBizMonth() == 0) {
            info.put("bizMonth", null);
        }
    }

    protected void checkBeforeSave(Context ctx, MakeInvoiceReqInfo info) throws IMException {
        if (!info.getStatus().equals((Object)MakeInvoiceReqStatusEnum.TEMPSTROE)) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "NOTADDORSAVE", new String[0])});
        }
        MakeInvoiceReqEntryCollection entries = info.getEntries();
        StringBuffer errorMsg = new StringBuffer();
        if (entries == null || entries.size() == 0) {
            return;
        }
        for (int i = 0; i < entries.size(); ++i) {
            StringBuffer entryErrorMsg = new StringBuffer();
            MakeInvoiceReqEntryInfo entry = entries.get(i);
            if (info.isEASBizType() && StringUtils.isEmpty((String)entry.getProductName())) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRODUCTNAME", (Locale)ctx.getLocale()));
            }
            if (entryErrorMsg.length() > 0) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_MSG", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, entryErrorMsg.substring(0, entryErrorMsg.length() - 1)}));
            }
            if (!info.isEASBizType() || StringUtils.isEmpty((String)entry.getProductName()) || entry.getProductName().length() <= 200) continue;
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRODUCTNAMETOOLONG", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1}));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void submit(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        MakeInvoiceReqInfo makeInvoiceReqInfo = (MakeInvoiceReqInfo)model;
        if (model == null) {
            makeInvoiceReqInfo = this.getMakeInvoiceReqInfo(ctx, pk, this.getSelector());
        }
        if (StringUtils.isEmpty((String)makeInvoiceReqInfo.getNumber())) {
            makeInvoiceReqInfo = this.getNewNumber(ctx, makeInvoiceReqInfo, makeInvoiceReqInfo.getCompany().getId().toString(), null);
        } else {
            makeInvoiceReqInfo.setNumber(this.trimStr(makeInvoiceReqInfo.getNumber()));
        }
        this.submit(ctx, (CoreBaseInfo)makeInvoiceReqInfo);
    }

    public IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        this.dealDefaultDataBeforeSubmit(ctx, info);
        if (info.getCompany() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_makeInvoiceReq_submit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (MakeInvoiceReqStatusEnum.AUDITED == info.getStatus() || MakeInvoiceReqStatusEnum.DELETED == info.getStatus()) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.SUBMIT_ERROR);
        }
        if (IMKBizTypeEnum.IERP.equals((Object)info.getBizType())) {
            SIMUtils.checkInvoiceBeforeSubmit(ctx, info);
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            info = this.getNewNumber(ctx, info, info.getCompany().getId().toString(), null);
        } else {
            info.setNumber(this.trimStr(info.getNumber()));
        }
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        }
        info.setStatus(MakeInvoiceReqStatusEnum.SUBMITED);
        if (this.isCheckTCCInSubmit(ctx)) {
            this.checkTaxClassificationCodeRequired(info);
        }
        if (info.getSpecificService() != null && !SpecificServiceEnum.Normal.equals((Object)info.getSpecificService()) && info.getSpecificInformation() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.SpecificInformationResource", (String)"SpecInfomation_NOTNULL", (Locale)ctx.getLocale())});
        }
        this.reCalculate(ctx, info);
        if (!MakeInvoiceReqSrcSystem.UPGRADE.equals((Object)info.getSrcSystem())) {
            this.checkInfoValid(ctx, info);
        }
        this.handleAsstActName(info);
        this.trimInfo(info);
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        super._checkNumberDup(ctx, null, (IObjectValue)info);
        this.dispose(ctx, info, "restore");
        this.updateSpecificInformationInfo(ctx, (IObjectValue)info);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.dispose(ctx, info, "submit");
        if (IMKBizTypeEnum.IERP.equals((Object)info.getBizType())) {
            SIMUtils.immediateMakeInvoiceWithSubmit(ctx, info);
        }
        return pk;
    }

    private void checkStatusEqualsInDB(Context ctx, MakeInvoiceReqInfo info) throws BOSException, IMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        view.setSelector(sic);
        MakeInvoiceReqCollection reqInfos = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
        if (reqInfos.size() == 1 && reqInfos.get(0).getStatus() != null && !reqInfos.get(0).getStatus().equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + " : " + IMUtils.getIMResource(ctx, "BillStatusChange", new String[0])});
        }
    }

    private void dealDefaultDataBeforeSubmit(Context ctx, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        boolean isDiffTax;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)"AC368D2D"));
        }
        if (isDiffTax = info.isIsDiffTax()) {
            int len = info.getEntries().size();
            for (int i = 0; i < len; ++i) {
                this.dealDefaultEntryData(ctx, info.getEntries().get(i));
            }
        }
        if (info.getBizType() == null) {
            info.setBizType(IMKBizTypeEnum.EAS);
        }
    }

    private void dealDefaultEntryData(Context ctx, MakeInvoiceReqEntryInfo entryInfo) {
        if (entryInfo.getTax() == null) {
            entryInfo.setTax(BigDecimal.ZERO);
        }
        if (entryInfo.getTaxRate() == null) {
            entryInfo.setTaxRate(BigDecimal.ZERO);
        }
        if (!(entryInfo.getDeductRow() instanceof DeductRowEnum)) {
            entryInfo.put("deductRow", null);
        }
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            return super.submit(ctx, model);
        }
        catch (MissMatchParticipantException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"HAVENO_MULTIAPPROVE_ASSIGNMENT", (Locale)ctx.getLocale())});
        }
        catch (MatchAssignmentException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_WFMatch", (Locale)ctx.getLocale())});
        }
        catch (AlreadyInProcessQueueException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)ctx.getLocale())});
        }
    }

    protected void reCalculate(Context ctx, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        StringBuffer errorMsg = new StringBuffer();
        String number = info.getNumber();
        if (info.getCompany() == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{(StringUtils.isEmpty((String)number) ? "" : number + " : ") + IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
        }
        if (StringUtils.isEmpty((String)number)) {
            number = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)info, info.getCompany().getId().toString());
            if (number == null) {
                errorMsg.append(IMUtils.getIMResource(ctx, "BILLNUMBER", new String[0])).append(NEXTLINE);
            }
            info.setNumber(number);
        }
        if (info.getBizDate() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "APPLICATEDATEISNULL", new String[0])).append(NEXTLINE);
        }
        if (info.getCurrency() == null) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"CURRENCY_ISNULL", (Locale)ctx.getLocale())).append(NEXTLINE);
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        MakeInvoiceReqAlgorithmForInfo algorithmForInfo = new MakeInvoiceReqAlgorithmForInfo(info, ctx);
        if (MakeInvoiceReqSrcSystem.UPGRADE.equals((Object)info.getSrcSystem())) {
            algorithmForInfo.revalue4DataUpgrade();
        } else if (MakeInvoiceReqSrcSystem.DOWNLOAD.equals((Object)info.getSrcSystem()) || MakeInvoiceReqSrcSystem.EXCEL.equals((Object)info.getSrcSystem())) {
            algorithmForInfo.revalue();
        } else if (MakeInvoiceReqSrcSystem.SYSTEM.equals((Object)info.getSrcSystem()) && info.getPriceExcludingTax() != null) {
            algorithmForInfo.revalue4DataUpgrade();
        }
    }

    private void handleAsstActName(MakeInvoiceReqInfo info) {
        if (StringUtils.isEmpty((String)info.getAsstActName())) {
            info.setAsstActID(null);
            info.setAsstActNumber(null);
        }
    }

    private void trimInfo(MakeInvoiceReqInfo info) {
        info.setRecOrgName(this.trimStr(info.getRecOrgName()));
        info.setTaxNumber(this.trimStr(info.getTaxNumber()));
        info.setAddress(this.trimStr(info.getAddress()));
        info.setBankAccount(this.trimStr(info.getBankAccount()));
        info.setDisInvoicer(this.trimStr(info.getDisInvoicer()));
        info.setMailNumber(this.trimStr(info.getMailNumber()));
        info.setRecBillComName(this.trimStr(info.getRecBillComName()));
        info.setRecBillAdress(this.trimStr(info.getRecBillAdress()));
        info.setRecBillEmail(this.trimStr(info.getRecBillEmail()));
        info.setRecBillPhone(this.trimStr(info.getRecBillPhone()));
        info.setExpressBillNum(this.trimStr(info.getExpressBillNum()));
        info.setAbstractName(this.trimStr(info.getAbstractName()));
        info.setAgentName(this.trimStr(info.getAgentName()));
        info.setAgentIDNumber(this.trimStr(info.getAgentIDNumber()));
        info.setTaxIDNumber(this.trimStr(info.getTaxIDNumber()));
    }

    private String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MakeInvoiceReqInfo makeInvoiceReqInfo = this.getMakeInvoiceReqInfo(ctx, pk, this.getSelector());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(makeInvoiceReqInfo.getCompany().getId().toString(), "im_makeInvoiceReq_audit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "passAudit", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(makeInvoiceReqInfo.getId().toString()), makeInvoiceReqInfo.getNumber(), "im_makeInvoiceReq_audit", makeInvoiceReqInfo.getCompany().getId().toString());
        if (makeInvoiceReqInfo.getStatus() != MakeInvoiceReqStatusEnum.SUBMITED) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.AUDIT_ERROR);
        }
        this.checkTaxClassificationCodeRequired(makeInvoiceReqInfo);
        makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.AUDITED);
        makeInvoiceReqInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        makeInvoiceReqInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        if (makeInvoiceReqInfo.getPlanInvoiceDate() == null || makeInvoiceReqInfo.getAuditTime().compareTo(makeInvoiceReqInfo.getPlanInvoiceDate()) > 0) {
            makeInvoiceReqInfo.setPlanInvoiceDate(makeInvoiceReqInfo.getAuditTime());
        }
        this.billPush(ctx, makeInvoiceReqInfo);
        this._update(ctx, pk, (IObjectValue)makeInvoiceReqInfo);
        LogUtils.afterLog(ctx, logPk);
    }

    private void checkTaxClassificationCodeRequired(MakeInvoiceReqInfo mkReqInfo) throws IMException {
        if (mkReqInfo.isIERPBizType()) {
            return;
        }
        MakeInvoiceReqEntryCollection mkReqEntryColl = null;
        if (mkReqInfo != null) {
            mkReqEntryColl = mkReqInfo.getEntries();
            StringBuffer sb = new StringBuffer();
            int size = mkReqEntryColl.size();
            for (int i = 0; i < size; ++i) {
                if (!StringUtils.isEmpty((String)mkReqEntryColl.get(i).getTaxClassificationCode())) continue;
                MakeInvoiceReqException e = new MakeInvoiceReqException(MakeInvoiceReqException.TAXCLASSIFICATIONCODE_REQUIRED, new Object[]{i + 1});
                sb.append(e.getMessage() + "\r\n");
            }
            if (sb.length() > 1) {
                throw new IMException(IMException.ERRORMSG, new Object[]{sb.toString()});
            }
        }
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        MakeInvoiceReqInfo makeInvoiceReqInfo = this.getMakeInvoiceReqInfo(ctx, pk, this.getSelector());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(makeInvoiceReqInfo.getCompany().getId().toString(), "im_makeInvoiceReq_unaudit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "unpassAudit", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(makeInvoiceReqInfo.getId().toString()), makeInvoiceReqInfo.getNumber(), "im_makeInvoiceReq_unaudit", makeInvoiceReqInfo.getCompany().getId().toString());
        if (makeInvoiceReqInfo.getStatus() != MakeInvoiceReqStatusEnum.AUDITED) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.UNAUDIT_ERROR);
        }
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(makeInvoiceReqInfo.getId().toString());
        this.checkHasLowerBill(ctx, idSet);
        makeInvoiceReqInfo.setAuditor(null);
        makeInvoiceReqInfo.setAuditTime(null);
        makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        this._update(ctx, pk, (IObjectValue)makeInvoiceReqInfo);
        this.billWithdraw(ctx, makeInvoiceReqInfo);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void billPush(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        if (info.isEASBizType()) {
            return;
        }
        HashMap<String, MakeInvoiceReqCollection> params = new HashMap<String, MakeInvoiceReqCollection>();
        MakeInvoiceReqCollection coll = new MakeInvoiceReqCollection();
        coll.addObject((IObjectValue)info);
        params.put("coll", coll);
        SIMOpenApiUtil.invokeSIMOpenApi(ctx, PwyServiceType.OPR_SIM_OPENAPI_BILL_PUSH, info.getCompany(), params);
    }

    protected void billWithdraw(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        if (info.isEASBizType()) {
            return;
        }
        HashMap<String, MakeInvoiceReqCollection> params = new HashMap<String, MakeInvoiceReqCollection>();
        MakeInvoiceReqCollection coll = new MakeInvoiceReqCollection();
        coll.addObject((IObjectValue)info);
        params.put("coll", coll);
        SIMOpenApiUtil.invokeSIMOpenApi(ctx, PwyServiceType.OPR_SIM_OPENAPI_BILL_WITHDRAW, info.getCompany(), params);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.setBizYearMonthNull((MakeInvoiceReqInfo)model);
        this.updateSpecificInformationInfo(ctx, model);
        super._update(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceReqInfo makeInvoiceReqInfo = (MakeInvoiceReqInfo)model;
        if (model == null) {
            makeInvoiceReqInfo = this.getMakeInvoiceReqInfo(ctx, pk);
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(makeInvoiceReqInfo.getCompany().getId().toString(), "im_makeInvoiceReq_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        IObjectPK logPk = LogUtils.beginLog(ctx, "cancel", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(makeInvoiceReqInfo.getId().toString()), makeInvoiceReqInfo.getNumber(), "im_makeInvoiceReq_cancel", makeInvoiceReqInfo.getCompany().getId().toString());
        if (makeInvoiceReqInfo.getStatus() != MakeInvoiceReqStatusEnum.AUDITED) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.CANCEL_ERROR);
        }
        if (makeInvoiceReqInfo.isEASBizType()) {
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(makeInvoiceReqInfo.getId().toString());
            this.checkHasMakeInvoice(ctx, idSet);
        }
        makeInvoiceReqInfo.setDeletedUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        makeInvoiceReqInfo.setDeletedTime(new Timestamp(System.currentTimeMillis()));
        makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.DELETED);
        this._update(ctx, pk, (IObjectValue)makeInvoiceReqInfo);
        this.dispose(ctx, makeInvoiceReqInfo, "cancel");
        LogUtils.afterLog(ctx, logPk);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = this.getMakeInvoiceReqInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_makeInvoiceReq_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (info.getStatus() == MakeInvoiceReqStatusEnum.DELETED && this.checkIsPreMakeInvoice(ctx, info.getId().toString())) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.DELETE_CHECK_ISINVOICED);
        }
        if (info.getStatus() == MakeInvoiceReqStatusEnum.AUDITED) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.DELETE_ERROR);
        }
        this.dispose(ctx, info, "delete");
        this.recycleNumber(ctx, pk, info);
        this.deleteSpecDataByBizBill(ctx, info);
        super._delete(ctx, pk);
    }

    protected void deleteSpecDataByBizBill(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        SpecificInformationInfo specInfo = info.getSpecificInformation();
        if (specInfo != null && specInfo.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
            boolean isExistOtherRef = MakeInvoiceReqFactory.getLocalInstance(ctx).exists(filter);
            if (!isExistOtherRef) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
            }
        }
    }

    private boolean checkIsPreMakeInvoice(Context ctx, String billId) throws BOSException, EASBizException {
        String selectSQL = "select FBizBillID from t_im_makeinvoicerelation where FSrcBosType='AC368D2D' and finvoicebillid = '" + billId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        try {
            if (rs.next()) {
                String bizBillID = rs.getString("fbizbillid");
                MakeInvoiceReqInfo reqInfo = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqInfo((IObjectPK)new ObjectUuidPK(bizBillID));
                if (reqInfo.getSourceBillType() == MakeInvoiceReqBillTypeEnum.SaleOrder) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void addSameCoreBillEntrySeqLock(Context ctx, String id) throws EASBizException, BOSException {
        StringBuffer lockSQL = new StringBuffer();
        lockSQL.append(" update T_IM_MAKEINVOICEREQENTRY set FID = FID where FCoreBillEntryId  in ");
        lockSQL.append(" (SELECT FCoreBillEntryId FROM T_IM_MAKEINVOICEREQENTRY");
        lockSQL.append("  WHERE FParentID = ?)");
        DbUtil.execute((Context)ctx, (String)lockSQL.toString(), (Object[])new Object[]{id});
    }

    protected void dispose(Context ctx, MakeInvoiceReqInfo info, String action) throws EASBizException, BOSException {
        if (info == null || info.getId() == null || info.getSourceBillId() == null) {
            return;
        }
        this.addSameCoreBillEntrySeqLock(ctx, info.getId().toString());
        if ("restore".equals(action)) {
            String billId = info.getId().toString();
            if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(billId))) {
                return;
            }
            int entrySize = info.getEntries().size();
            int dbEntrySize = 0;
            String sql = "select count(1) as totalCount from t_im_makeinvoicereqEntry where fparentid = '" + billId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    dbEntrySize = rs.getInt("totalCount");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (entrySize == dbEntrySize) {
                return;
            }
        }
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose(action, (IObjectValue)info);
    }

    protected void checkHasLowerBill(Context ctx, Set<String> idSet) throws BOSException, IMException {
        if (idSet.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select fbizbillid from t_im_makeinvoicerelation t1");
        sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"HAVE_INVOICEBILL", (Locale)ctx.getLocale())});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkHasMakeInvoice(Context ctx, Set<String> idSet) throws BOSException, IMException {
        if (idSet.isEmpty()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select fbizbillid from t_im_makeinvoicerelation t1 ");
        sb.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
        sb.append(" inner join t_im_makeInvoiceReq src on t1.fbizbillid = src.fid");
        sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
        sb.append(" and (");
        sb.append(" src.FInvoicedAmt <> 0");
        sb.append(" or  ");
        sb.append(" t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus in ('1','2','3') ) ");
        sb.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"SOMEBILL_HAVE_INVOICE", (Locale)ctx.getLocale())});
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void checkInfoValid(Context ctx, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        StringBuffer errorMsg = new StringBuffer();
        if (info.isIsPurchaseInvoice() && info.isEASBizType() && ("1".equals(info.getInvoiceType().getValue()) || "3".equals(info.getInvoiceType().getValue()) || "5".equals(info.getInvoiceType().getValue()))) {
            errorMsg.append(IMUtils.getIMResource(ctx, "INVOICETYPE_ERROR", new String[0])).append(NEXTLINE);
        }
        if (info.getExchangeRate() == null) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"EXCHANGERATE_ISNULL", (Locale)ctx.getLocale())).append(NEXTLINE);
        }
        if (info.isEASBizType() && info.getInvoiceType() != null && ("1".equals(info.getInvoiceType().getValue()) || "3".equals(info.getInvoiceType().getValue()) || "5".equals(info.getInvoiceType().getValue())) && (info.getTaxNumber() == null || "".equals(info.getTaxNumber().trim()))) {
            errorMsg.append(info.getInvoiceType().getAlias() + IMUtils.getIMResource(ctx, "TAXNUMBERISNULL", new String[0])).append(NEXTLINE);
        }
        if (info.isEASBizType() && info.getInvoiceType() != null && ("1".equals(info.getInvoiceType().getValue()) || "3".equals(info.getInvoiceType().getValue()))) {
            if (info.getAddress() == null || "".equals(info.getAddress().trim())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "ADDRESSTELISNULL", new String[0])).append(NEXTLINE);
            }
            if (info.getBankAccount() == null || "".equals(info.getBankAccount().trim())) {
                errorMsg.append(IMUtils.getIMResource(ctx, "BANKACCOUNTISNULL", new String[0])).append(NEXTLINE);
            }
        }
        if (info.isEASBizType() && info.getInvoiceType() != null && info.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE && !StringUtils.isEmpty((String)info.getAsstActName()) && StringUtils.isEmpty((String)info.getRecOrgName())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"RECORGNAME_ISNULL", (Locale)ctx.getLocale())).append(NEXTLINE);
        }
        if (info.isEASBizType() && StringUtils.isEmpty((String)info.getAsstActName()) && StringUtils.isEmpty((String)info.getRecOrgName())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ASSTACTNAME_RECORGNAME_ISNULL", (Locale)ctx.getLocale())).append(NEXTLINE);
        }
        if (info.isIsPurchaseInvoice() && info.isIsVehicle()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", ctx.getLocale()));
        }
        if (info.isIsPurchaseInvoice() && info.isIsDiffTax()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFPCEZS_REPEAT", ctx.getLocale()));
        }
        this.checkEntryInfo(ctx, info, errorMsg);
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        this.checkHasMaterialAndExpenseItem(info);
    }

    protected void checkHasMaterialAndExpenseItem(MakeInvoiceReqInfo info) throws MakeInvoiceReqException {
        if (info.isEASBizType()) {
            return;
        }
        boolean hasMaterial = false;
        boolean hasExpenseItem = false;
        MakeInvoiceReqEntryInfo entryInfo = null;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getMaterial() != null) {
                hasMaterial = true;
            }
            if (entryInfo.getExpenseItem() != null) {
                hasExpenseItem = true;
            }
            if (!hasMaterial || !hasExpenseItem) continue;
            throw new MakeInvoiceReqException(MakeInvoiceReqException.EXP_HAS_MATERIAL_EXPENSEITEM);
        }
    }

    private void checkEntryInfo(Context ctx, MakeInvoiceReqInfo makeInvoiceReqInfo, StringBuffer errorMsg) throws EASBizException, BOSException {
        MakeInvoiceReqEntryCollection entries;
        boolean isVATInvoice = false;
        if (makeInvoiceReqInfo.getInvoiceType() != null) {
            boolean bl = isVATInvoice = "1".equals(makeInvoiceReqInfo.getInvoiceType().getValue()) || "3".equals(makeInvoiceReqInfo.getInvoiceType().getValue());
        }
        if ((entries = makeInvoiceReqInfo.getEntries()) == null || entries.size() == 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_ERROR", (Locale)ctx.getLocale())});
        }
        Map<String, TaxClassificationCodeInfo> tccMap = null;
        if (makeInvoiceReqInfo.isIsVehicle()) {
            MakeInvoiceReqEntryInfo entry = null;
            HashSet<String> tccCodeSet = new HashSet<String>();
            for (int i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (StringUtils.isEmpty((String)entry.getTaxClassificationCode())) continue;
                tccCodeSet.add(entry.getTaxClassificationCode());
            }
            tccMap = Collection2MapUtils.getTaxClassificationCodeInfoMap(ctx, tccCodeSet);
        }
        Map ParamMap = IMUtils.getParam(ctx, makeInvoiceReqInfo.getCompany().getId().toString(), new String[]{"VATM020"});
        boolean vatm20 = Boolean.valueOf(ParamMap.get("VATM020").toString());
        TaxClassificationCodeCollection taxClassCodeColl = null;
        HashSet<String> taxClassCodeSet = new HashSet<String>();
        HashMap<String, String> taxClassCodeMap = new HashMap<String, String>();
        if (vatm20) {
            for (int i = 0; i < entries.size(); ++i) {
                MakeInvoiceReqEntryInfo entry = entries.get(i);
                String taxClassCode = entry.getTaxClassificationCode();
                if (StringUtils.isEmpty((String)taxClassCode)) continue;
                taxClassCodeSet.add(taxClassCode);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("mergeCode"));
            sic.add(new SelectorItemInfo("simpleName"));
            view.setSelector(sic);
            filter.getFilterItems().add(new FilterItemInfo("mergeCode", taxClassCodeSet, CompareType.INCLUDE));
            view.setFilter(filter);
            taxClassCodeColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(view);
            for (int i = 0; i < taxClassCodeColl.size(); ++i) {
                taxClassCodeMap.put(taxClassCodeColl.get(i).getMergeCode(), taxClassCodeColl.get(i).getSimpleName());
            }
        }
        StringBuffer rateNotZeroMessage = new StringBuffer();
        StringBuffer diffTaxMsg = new StringBuffer();
        boolean isDiffTax = makeInvoiceReqInfo.isIsDiffTax();
        boolean hasNotDeductRow = false;
        for (int i = 0; i < entries.size(); ++i) {
            TaxClassificationCodeInfo tccInfo;
            StringBuffer entryErrorMsg = new StringBuffer();
            MakeInvoiceReqEntryInfo entry = entries.get(i);
            if (isDiffTax && DeductRowEnum.DeductRow.equals((Object)entry.getDeductRow()) && (entry.getTaxRate().compareTo(BigDecimal.ZERO) != 0 || entry.getTax().compareTo(BigDecimal.ZERO) != 0)) {
                diffTaxMsg.setLength(0);
                diffTaxMsg.append(IMUtils.getIMResource(ctx, "ENTRYLINE", i + 1 + ""));
                diffTaxMsg.append(":");
                diffTaxMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"DeductRowTaxANDRateMustZero", (Locale)ctx.getLocale()));
                errorMsg.append(diffTaxMsg);
                errorMsg.append("\r\n");
            }
            if (!hasNotDeductRow && DeductRowEnum.NotDeductRow.equals((Object)entry.getDeductRow())) {
                hasNotDeductRow = true;
            }
            if (makeInvoiceReqInfo.isEASBizType() && isVATInvoice && !DeductRowEnum.DeductRow.equals((Object)entry.getDeductRow()) && (entry.getTaxRate() == null || BigDecimal.ZERO.compareTo(entry.getTaxRate()) == 0)) {
                rateNotZeroMessage.setLength(0);
                rateNotZeroMessage.append(IMUtils.getIMResource(ctx, "ENTRYLINE", i + 1 + ""));
                rateNotZeroMessage.append(IMUtils.getIMResource(ctx, "VATRATEISZERO", new String[0])).append(NEXTLINE);
                errorMsg.append(rateNotZeroMessage.toString());
            }
            if (isDiffTax && entry.getDeductRow() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_DEDUCTROW", (Locale)ctx.getLocale()));
            }
            if (makeInvoiceReqInfo.isEASBizType() && entry.getProductName() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRODUCTNAME", (Locale)ctx.getLocale()));
            }
            if (entry.getQty() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_QTY", (Locale)ctx.getLocale()));
            } else if (!entry.isIsQtyZero() && entry.getQty() != null && BigDecimal.ZERO.compareTo(entry.getQty()) == 0) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_QTY", (Locale)ctx.getLocale()));
            }
            if (entry.getNoTaxPrice() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_NOTAXPRICE", (Locale)ctx.getLocale()));
            } else if (!entry.isIsQtyZero() && !entry.isIsPresent() && entry.getNoTaxPrice() != null && BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_NOTAXPRICE", (Locale)ctx.getLocale()));
            }
            if (entry.getPrice() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRICE", (Locale)ctx.getLocale()));
            } else if (!entry.isIsQtyZero() && !entry.isIsPresent() && entry.getPrice() != null && BigDecimal.ZERO.compareTo(entry.getPrice()) == 0) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRICE", (Locale)ctx.getLocale()));
            }
            if (entry.getPriceExcludingTax() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRICEEXCLUDINGTAX", (Locale)ctx.getLocale()));
            }
            if (entry.getTax() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_TAX", (Locale)ctx.getLocale()));
            }
            if (entry.getPriceIncludingTax() == null) {
                entryErrorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRICEINCLUDINGTAX", (Locale)ctx.getLocale()));
            }
            if (entryErrorMsg.length() > 0) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_MSG", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, entryErrorMsg.substring(0, entryErrorMsg.length() - 1)}));
            }
            if (makeInvoiceReqInfo.isEASBizType() && !StringUtils.isEmpty((String)entry.getProductName()) && entry.getProductName().length() > 200) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"ENTRY_PRODUCTNAMETOOLONG", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1})).append(NEXTLINE);
            }
            if (vatm20) {
                int taxClassCodeLength = 0;
                Object taxSimpleName = taxClassCodeMap.get(entry.getTaxClassificationCode());
                taxClassCodeLength = taxSimpleName != null ? IMUtils.getStringlength(entry.getProductName()) + IMUtils.getStringlength((String)taxSimpleName) : IMUtils.getStringlength(entry.getProductName());
                if (taxClassCodeLength > 90) {
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"TAXCLASSCODE_TOLONG", (Locale)ctx.getLocale(), (Object[])new Object[]{i + 1, "" + taxClassCodeLength}));
                }
            }
            if (!makeInvoiceReqInfo.isIsVehicle()) continue;
            StringBuffer vehicleLineMsg = new StringBuffer();
            String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_REQBILL", ctx.getLocale());
            if (entry.getPrice() == null || entry.getNoTaxPrice() == null || entry.getQty() == null || BigDecimal.ZERO.compareTo(entry.getPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getQty()) == 0) {
                vehicleLineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", ctx.getLocale())).append("\u3001");
            }
            if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = tccMap.get(entry.getTaxClassificationCode())) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                vehicleLineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", ctx.getLocale())).append("\u3001");
            }
            if (vehicleLineMsg.length() <= 0) continue;
            String line = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_LINE_MSG", ctx.getLocale(), new Object[]{i + 1});
            String msg = line + "\uff0c" + billMsg + vehicleLineMsg.substring(0, vehicleLineMsg.length() - 1);
            errorMsg.append(msg).append(NEXTLINE);
        }
        if (isDiffTax && !hasNotDeductRow) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"MustHasOneNotDeductRow", (Locale)ctx.getLocale()));
        }
        BigDecimal deductAmtTotal = BigDecimal.ZERO;
        BigDecimal notDeductAmtTotal = BigDecimal.ZERO;
        if (isDiffTax) {
            for (int i = 0; i < entries.size(); ++i) {
                MakeInvoiceReqEntryInfo entry = entries.get(i);
                if (DeductRowEnum.DeductRow.equals((Object)entry.getDeductRow())) {
                    deductAmtTotal = deductAmtTotal.add(entry.getPriceIncludingTax() == null ? BigDecimal.ZERO : entry.getPriceIncludingTax());
                    continue;
                }
                if (!DeductRowEnum.NotDeductRow.equals((Object)entry.getDeductRow())) continue;
                notDeductAmtTotal = notDeductAmtTotal.add(entry.getPriceIncludingTax() == null ? BigDecimal.ZERO : entry.getPriceIncludingTax());
            }
            if (notDeductAmtTotal.compareTo(BigDecimal.ZERO) < 0 && deductAmtTotal.compareTo(BigDecimal.ZERO) > 0 || notDeductAmtTotal.compareTo(BigDecimal.ZERO) > 0 && deductAmtTotal.compareTo(BigDecimal.ZERO) < 0) {
                errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"DEDUCTAMT_SIGN_ERROR", (Locale)ctx.getLocale()));
            }
        }
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, collection);
        HashSet<String> companyIds = new HashSet<String>();
        MakeInvoiceReqInfo info2 = null;
        for (MakeInvoiceReqInfo info2 : collection) {
            if (info2.getCU() != null || info2.getCompany() == null) continue;
            companyIds.add(info2.getCompany().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo companyInfo2 = null;
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        for (CompanyOrgUnitInfo companyInfo2 : companyColl) {
            companyMap.put(companyInfo2.getId().toString(), companyInfo2);
        }
        for (MakeInvoiceReqInfo info2 : collection) {
            if (info2.getCU() == null && info2.getCompany() != null) {
                companyInfo2 = (CompanyOrgUnitInfo)companyMap.get(info2.getCompany().getId().toString());
                info2.setCU(companyInfo2.getCU());
            }
            this.handleInfoAfterTransferform(ctx, info2);
        }
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, objectValue);
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)objectValue;
        if (info.getCompany() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), sic);
            info.setCompany(companyInfo);
        }
        if (info.getCU() == null && info.getCompany() != null) {
            info.setCU(info.getCompany().getCU());
        }
        this.handleInfoAfterTransferform(ctx, info);
    }

    private void handleInfoAfterTransferform(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        info.setSrcSystem(MakeInvoiceReqSrcSystem.SYSTEM);
        if (info.getBizType() == null) {
            info.setBizType(IMKBizTypeEnum.EAS);
        }
        if (info.getSpecificService() == null) {
            info.setSpecificService(SpecificServiceEnum.Normal);
        }
        this.checkIMC001(ctx, info);
        this.readNumber(ctx, info, info.getCompany().getId().toString(), null);
        MakeInvoiceReqAlgorithmForInfo algorithmforInfo = new MakeInvoiceReqAlgorithmForInfo(info, ctx);
        algorithmforInfo.revalue4Botp();
        StringBuffer entryErrorMsg = new StringBuffer();
        MakeInvoiceReqEntryCollection entries = info.getEntries();
        HashMap<String, String> expenseItemSet = new HashMap<String, String>();
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            String sourceBillId;
            MakeInvoiceReqEntryInfo entry = entries.get(i);
            ExpenseTypeInfo expenseTypeInfo = entry.getExpenseItem();
            if (expenseTypeInfo != null) {
                expenseItemSet.put(expenseTypeInfo.getId().toString(), expenseTypeInfo.getName());
            }
            if (StringUtils.isEmpty((String)(sourceBillId = entry.getString("sourcebillid"))) || "C48A423A".equals(BOSUuid.read((String)sourceBillId).getType().toString())) continue;
            sourceBillIdSet.add(sourceBillId);
        }
        if (entryErrorMsg.length() > 1) {
            throw new IMException(IMException.ERRORMSG, new Object[]{entryErrorMsg.toString()});
        }
        Iterator iterator = expenseItemSet.keySet().iterator();
        String sourceBillId = info.getSourceBillId();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)sourceBillId).getType());
        CoreBaseInfo value = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(sourceBillId));
        String sourceBillNumber = value.get("number").toString();
        while (iterator.hasNext()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String key = ((String)iterator.next()).toString();
            filter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)"MakeInvoiceReqBill"));
            filter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)key));
            view.setFilter(filter);
            ExpenseTypeEntryCollection col = ExpenseTypeEntryFactory.getLocalInstance((Context)ctx).getExpenseTypeEntryCollection(view);
            if (col != null && col.size() != 0) continue;
            throw new MakeInvoiceReqException(MakeInvoiceReqException.EXPENSEITEM_VALID, new Object[]{sourceBillNumber, expenseItemSet.get(key)});
        }
        if (sourceBillIdSet.size() > 0) {
            HashMap<Object, Object> yearMap = new HashMap<Object, Object>();
            HashMap<Object, Object> monthMap = new HashMap<Object, Object>();
            iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)sourceBillIdSet.toArray(new String[0])[0]).getType());
            CoreBaseCollection coll = iCoreBase.getCollection("where id in " + IMUtils.getInStringFromSet(sourceBillIdSet));
            for (int i = 0; i < coll.size(); ++i) {
                value = coll.getObject(i);
                yearMap.put(value.get("year"), value.get("year"));
                monthMap.put(value.get("period"), value.get("period"));
            }
            if (yearMap.size() == 1 && monthMap.size() == 1) {
                Integer year = IMUtils.dealZerotoNull((Integer)yearMap.keySet().toArray()[0]);
                Integer month = IMUtils.dealZerotoNull((Integer)monthMap.keySet().toArray()[0]);
                info.put("bizYear", year);
                info.put("bizMonth", month);
            } else {
                info.put("bizYear", null);
                info.put("bizMonth", null);
            }
        }
    }

    protected void checkIMC001(Context ctx, MakeInvoiceReqInfo info) throws BOSException, EASBizException {
        boolean isUseSIM = false;
        String[] paramNumber = new String[]{"IMC001"};
        IIMFacade iIMFacade = IMFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iIMFacade.getParam(info.getCompany().getId().toString(), paramNumber);
        if (paramMap.get("IMC001") != null && Boolean.valueOf((String)paramMap.get("IMC001")).booleanValue()) {
            isUseSIM = true;
        }
        if (isUseSIM) {
            if (IMKBizTypeEnum.EAS.equals((Object)info.getBizType())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{info.getCompany().getName() + "\uff1a" + ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"IMC001_OPEN_BOTP", (Locale)ctx.getOriginLocale())});
            }
        } else if (IMKBizTypeEnum.IERP.equals((Object)info.getBizType())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getCompany().getName() + "\uff1a" + ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceReqResource", (String)"IMC001_CLOSE_BOTP", (Locale)ctx.getOriginLocale())});
        }
    }

    protected MakeInvoiceReqInfo readNumber(Context ctx, MakeInvoiceReqInfo info, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
        if (codeRuleInfo == null) {
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber("AutoNumberFromBTP_" + info.getId());
            } else if (this.isSameNumber(ctx, null, info)) {
                throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getId().toString(), ""});
            }
        } else {
            if (StringUtils.isEmpty((String)strCompanyID)) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
            }
            if (codeRuleInfo.isIsaddnewbreak()) {
                info.setNumber(iCodingRuleManager.readNumber((IObjectValue)info, strCompanyID, customString));
            } else if (codeRuleInfo.isIsAddView()) {
                this.getNewNumber(ctx, info, strCompanyID, customString);
            }
        }
        return info;
    }

    protected MakeInvoiceReqInfo getNewNumber(Context ctx, MakeInvoiceReqInfo info, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (StringUtils.isEmpty((String)strCompanyID)) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
        }
        String number = "";
        number = iCodingRuleManager.getNumber((IObjectValue)info, strCompanyID, customString);
        info.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, info)) {
            return this.getNewNumber(ctx, info, strCompanyID, customString);
        }
        return info;
    }

    protected boolean isSameNumber(Context ctx, IObjectPK pk, BillBaseInfo model) throws EASBizException, BOSException {
        BillBaseInfo info = model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)info.getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (info.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        int size = filter.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return super._exists(ctx, filter);
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("asstActType.*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("deletedUser.*"));
        sic.add(new SelectorItemInfo("simInvoiceType.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.material.*"));
        sic.add(new SelectorItemInfo("entries.unit.*"));
        sic.add(new SelectorItemInfo("entries.baseUnit.*"));
        sic.add(new SelectorItemInfo("specificInformation.*"));
        sic.add(new SelectorItemInfo("specificInformation.entries.*"));
        return sic;
    }

    private void recycleNumber(Context ctx, IObjectPK pk, MakeInvoiceReqInfo info) throws EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqInfo(pk, sic);
        }
        if (info.getNumber() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getNumber());
            }
        }
    }

    protected boolean isCheckTCCInSubmit(Context ctx) {
        boolean isCheck = false;
        try {
            Map result = new HashMap();
            result = TMCommonUtil.getIMTempParamByKey((Context)ctx, (String[])new String[]{"isCheckTCCInSubmit_MakeInvoiceReq"});
            if (!result.isEmpty()) {
                String value = null;
                value = (String)result.get("isCheckTCCInSubmit_MakeInvoiceReq");
                int isCheckInt = Integer.valueOf(value);
                if (1 == isCheckInt) {
                    return true;
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            return isCheck;
        }
        return isCheck;
    }

    protected void updateSpecificInformationInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        if (info.getSpecificService() == null) {
            info.setSpecificService(SpecificServiceEnum.Normal);
        }
        SpecificInformationInfo specInfo = info.getSpecificInformation();
        if (info.getId() != null && specInfo != null && specInfo.getId() != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.NOTEQUALS));
            viewInfo.setFilter(filter);
            MakeInvoiceReqCollection coll = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(viewInfo);
            HashSet<String> deleteSpecIDSet = new HashSet<String>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                deleteSpecIDSet.add(coll.get(i).getSpecificInformation().getId().toString());
            }
            if (deleteSpecIDSet.size() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", deleteSpecIDSet, CompareType.INCLUDE));
                SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
            }
        }
        if (specInfo != null) {
            SpecificInformationFactory.getLocalInstance(ctx).save((CoreBaseInfo)specInfo);
        }
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)model;
        String uiPk = null;
        if ("list".equals(viewType)) {
            uiPk = info.isEASBizType() ? "com.kingdee.eas.tm.im.makeInvoiceReqListPage" : "com.kingdee.eas.tm.imc.SIMMakeInvoiceReqListPage";
        } else if ("edit".equals(viewType)) {
            uiPk = info.isEASBizType() ? "com.kingdee.eas.tm.im.makeInvoiceReqEditPage" : "com.kingdee.eas.tm.imc.SIMMakeInvoiceReqEditPage";
        }
        return uiPk;
    }

    @Override
    protected void _billWithdraw4IERP(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unpassAudit(ctx, pk, null);
    }

    @Override
    protected void _close4IERP(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._cancel(ctx, pk, null);
    }
}

