/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqException;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.app.AbstractMakeInvoiceReqFacadeControllerBean;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MakeInvoiceReqFacadeControllerBean
extends AbstractMakeInvoiceReqFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceReqFacadeControllerBean");

    @Override
    protected void _checkInvoiceInfo(Context ctx, List ids, String invoiceType, boolean isReq) throws BOSException, EASBizException {
        HashSet idSet = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("specificService"));
        sic.add(new SelectorItemInfo("isPurchaseInvoice"));
        sic.add(new SelectorItemInfo("company"));
        view.setSelector(sic);
        MakeInvoiceReqCollection billColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
        boolean isExistPurchaseInvoice = false;
        boolean isNotExistPurchaseInvoice = false;
        String permItemName = isReq ? "im_makeInvoiceReq_Invoiced" : "im_makeInvoiceReq_oneKeyInvoice";
        SpecificServiceEnum specService = null;
        for (int i = 0; i < billColl.size(); ++i) {
            MakeInvoiceReqInfo info = billColl.get(i);
            if (i == 0) {
                specService = info.getSpecificService();
            }
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), permItemName);
            PayInvoiceTypeEnum type = info.getInvoiceType();
            if (type != null && !type.getValue().equals("-1") && !invoiceType.equals(type.getValue())) {
                throw new MakeInvoiceReqException(!isReq ? MakeInvoiceReqException.CHECK_OPTONEKEY_INVOICETYPE : MakeInvoiceReqException.CHECK_OPTSTEP_INVOICETYPE, new Object[]{PayInvoiceTypeEnum.getEnum((String)invoiceType)});
            }
            if (specService == null || !specService.equals((Object)info.getSpecificService())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "MakeInvoiceReq_makeInvoice_SpecificServiceError", new String[0])});
            }
            if (info.isIsPurchaseInvoice()) {
                isExistPurchaseInvoice = true;
                continue;
            }
            isNotExistPurchaseInvoice = true;
        }
        if (isExistPurchaseInvoice && isNotExistPurchaseInvoice) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.CHECK_MAKEINVOICE_PURCHASE);
        }
    }

    @Override
    protected Map _checkInvInfo(Context ctx, List ids, boolean isReq) throws BOSException, EASBizException {
        HashSet idSet = new HashSet(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("specificService"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("isPurchaseInvoice"));
        sic.add(new SelectorItemInfo("company"));
        view.setSelector(sic);
        MakeInvoiceReqCollection billColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
        if (billColl.size() == 0) {
            throw new IMException(IMException.RECORDS_NOTEXISTS);
        }
        boolean isExistPurchaseInvoice = false;
        boolean isNotExistPurchaseInvoice = false;
        boolean isSame = false;
        String permItemName = isReq ? "im_makeInvoiceReq_Invoiced" : "im_makeInvoiceReq_oneKeyInvoice";
        MakeInvoiceReqInfo tempInfo = billColl.get(0);
        if (tempInfo.getInvoiceType() == null || tempInfo.getInvoiceType().equals((Object)PayInvoiceTypeEnum.DEFAULTTYPE)) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.CHECK_NOINVOICE_TYPE);
        }
        SpecificServiceEnum specService = billColl.get(0).getSpecificService();
        for (int i = 0; i < billColl.size(); ++i) {
            MakeInvoiceReqInfo info = billColl.get(i);
            PayInvoiceTypeEnum type = info.getInvoiceType();
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), permItemName);
            if (type == null || PayInvoiceTypeEnum.DEFAULTTYPE.equals((Object)type) || !type.equals((Object)tempInfo.getInvoiceType())) {
                throw new MakeInvoiceReqException(MakeInvoiceReqException.CHECK_INVOICETYPE);
            }
            if (specService == null || !specService.equals((Object)info.getSpecificService())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "MakeInvoiceReq_makeInvoice_SpecificServiceError", new String[0])});
            }
            if (info.isIsPurchaseInvoice()) {
                isExistPurchaseInvoice = true;
                continue;
            }
            isNotExistPurchaseInvoice = true;
        }
        if (isExistPurchaseInvoice && isNotExistPurchaseInvoice) {
            throw new MakeInvoiceReqException(MakeInvoiceReqException.CHECK_MAKEINVOICE_PURCHASE);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invoiceType", tempInfo.getInvoiceType().getValue());
        isSame = true;
        map.put("isSame", isSame);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvoiceRespInfo _generateInvoice(Context ctx, List ids, boolean isPrint, boolean isReq, String invoiceType, Map combinRule) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> logMap = new HashMap<String, IObjectPK>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        MakeInvoiceReqCollection billColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection(view);
        String logItemName = isReq ? "im_makeInvoiceReq_invoice" : "im_makeInvoiceReq_oneKeyInvoice";
        IObjectPK logPk = null;
        MakeInvoiceReqInfo makeInvoiceReqInfo = null;
        int j = billColl.size();
        for (int i = 0; i < j; ++i) {
            makeInvoiceReqInfo = billColl.get(i);
            logPk = LogUtils.beginLog(null, "invoiceReq", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(makeInvoiceReqInfo.getId().toString()), makeInvoiceReqInfo.getNumber(), logItemName, makeInvoiceReqInfo.getCompany().getId().toString());
            logMap.put(makeInvoiceReqInfo.getId().toString(), logPk);
        }
        InvoiceRespInfo resp = null;
        try {
            IMUtils.tryLock(ctx, ids);
            StringBuffer paramID = new StringBuffer();
            for (int i = 0; i < ids.size(); ++i) {
                paramID.append(ids.get(i)).append(",");
            }
            MakeInvoiceParam param = new MakeInvoiceParam();
            param.setBilBillIds(paramID.toString());
            param.setInvoiceType(invoiceType + "");
            param.setPrint(false);
            param.setReq(isReq);
            HashMap otherParams = new HashMap();
            otherParams.put("isConstantQty", combinRule.get("isConstantQty"));
            otherParams.put("constantQty", combinRule.get("constantQty"));
            combinRule.remove("isConstantQty");
            combinRule.remove("constantQty");
            param.setRuleIDs(combinRule);
            param.setOtherParams(otherParams);
            param.setSrcBosType("AC368D2D");
            param.setSrcSystem(IMConstant.SRCTYPE_IM_INVOICEREQ);
            resp = IMInvoiceFacadeFactory.getLocalInstance(ctx).makeInvoice(param);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            resp = new InvoiceRespInfo();
            resp.setErrorMsg(e.getMessage());
            resp.getBizFailBills().clear();
            resp.getBizFailBills().addAll(ids);
        }
        finally {
            IMUtils.releaseLock(ctx, ids);
        }
        if (logMap.size() > 0) {
            ArrayList bizFailBills = resp.getBizFailBills();
            if (bizFailBills != null && bizFailBills.size() > 0) {
                int j2 = bizFailBills.size();
                for (int i = 0; i < j2; ++i) {
                    logMap.remove(String.valueOf(bizFailBills.get(i)));
                }
            }
            for (Map.Entry entry : logMap.entrySet()) {
                LogUtils.afterLog(null, (IObjectPK)entry.getValue());
            }
        }
        return resp;
    }

    @Override
    protected Map _checkBeforePrint(Context ctx, List ids, boolean isPrintList, boolean isRePrint, String sourceType) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        InvoiceReqInfo req = this.getInvoiceReq(ids);
        InvoiceRespInfo resp = isPrintList ? IMInvoiceFacadeFactory.getLocalInstance(ctx).printInvoiceList(req) : IMInvoiceFacadeFactory.getLocalInstance(ctx).printInvoice(req);
        Map<String, String> retValue = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)resp.getErrorMsg())) {
            retValue.put("errorMsg", resp.getErrorMsg());
            return retValue;
        }
        ArrayList invoiceIds = resp.getMkSucessBillIds();
        HashSet invoiceId = new HashSet(invoiceIds);
        retValue = isPrintList ? IMInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrintList(invoiceId) : (isRePrint ? IMInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforeRePrint(invoiceId) : IMInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrint(invoiceId));
        return retValue;
    }

    private InvoiceReqInfo getInvoiceReq(List ids) {
        InvoiceReqInfo req = new InvoiceReqInfo();
        req.setSn(BOSUuid.create((String)"88888888").toString());
        req.setSrcSystem(IMConstant.SRCTYPE_IM_INVOICEREQ);
        String id = null;
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            id = (String)ids.get(i);
            req.getBills().add(this.getBillReqInfo(id));
        }
        return req;
    }

    private BillReqInfo getBillReqInfo(String id) {
        BillReqInfo billReq = new BillReqInfo();
        billReq.setBillId(id);
        return billReq;
    }

    protected ArrayList getMKBillOrderIds(Set invoiceId) throws BOSException {
        ArrayList<String> orderIds = new ArrayList<String>();
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceId, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        for (int i = 0; i < mkInvoiceCol.size(); ++i) {
            orderIds.add(mkInvoiceCol.get(i).getId().toString());
        }
        return orderIds;
    }

    @Override
    protected ExchangeRateInfo _getExchangeRate(Context ctx, Map params) throws BOSException, EASBizException {
        ExchangeRateInfo erInfo = null;
        String exchangeTablePK = (String)params.get("exchangeTablePK");
        String sourceCurrencyID = (String)params.get("sourceCurrencyID");
        String baseCurrencyID = (String)params.get("baseCurrencyID");
        String dateString = (String)params.get("date");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = df.parse(dateString);
        }
        catch (ParseException e) {
            logger.error((Object)"Date parse error");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        erInfo = iexchangRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTablePK), (IObjectPK)new ObjectUuidPK(sourceCurrencyID), (IObjectPK)new ObjectUuidPK(baseCurrencyID), date);
        return erInfo;
    }

    @Override
    protected Map _getCustomerTaxInfo(Context ctx, Map params) throws BOSException, EASBizException {
        Map ret = new HashMap();
        ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params);
        return ret;
    }

    @Override
    protected void _passAudit(Context ctx, String pk) throws BOSException, EASBizException {
        MakeInvoiceReqFactory.getLocalInstance(ctx).passAudit((IObjectPK)new ObjectUuidPK(pk), null);
    }

    @Override
    protected void _unpassAudit(Context ctx, String pk) throws BOSException, EASBizException {
        MakeInvoiceReqFactory.getLocalInstance(ctx).unpassAudit((IObjectPK)new ObjectUuidPK(pk), null);
    }

    @Override
    protected Map _getAsstActType(Context ctx, String realtion) throws BOSException, EASBizException {
        HashMap<String, AsstActTypeInfo> resultMap = new HashMap<String, AsstActTypeInfo>();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("realtionDataObject", (Object)realtion));
        try {
            entityViewInfo.setFilter(filter);
            AsstActTypeCollection col = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(entityViewInfo);
            if (!col.isEmpty()) {
                resultMap.put(realtion, col.get(0));
                return resultMap;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"getAsstActTypeCollection failed.");
        }
        return null;
    }
}

