/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.DeductRowEnum;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.IMakeInvoiceReq;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.SpecificInformationFactory;
import com.kingdee.eas.tm.im.SpecificInformationInfo;
import com.kingdee.eas.tm.im.SpecificServiceEnum;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.ICustomerMailing;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class MakeInvoiceReqImport
extends IMBillImportBase {
    private static final String SUPPLIER_ASSACTTYPE_NUMBER = "T_BD_SUPPLIER";
    private static final String CUSTOMER_ASSACTTYPE_NUMBER = "T_BD_CUSTOMER";
    private MakeInvoiceReqInfo makeInvoiceReqInfo;
    Map<String, MultiMeasureUnitInfo> multiMeasureUnitMap;
    Map<String, MaterialInfo> materialInfoMap;
    Map<String, ExpenseTypeInfo> expenseTypeInfoMap;
    Map<String, ProductCodeInfo> productCodeInfoMap;
    Map<String, String> strMap;
    Map<String, MeasureUnitInfo> measureUnitInfoMap;
    private static final String resClassName = "com.kingdee.eas.tm.im.app.IMImportResource";
    private static int amtPrecision = 2;
    private static int qtyPrecision = IMConstant.QTY_PRECISION;
    private static int pricePrecision = 10;
    private static int discountRatePrecision = 6;
    private Hashtable firstData = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return MakeInvoiceReqFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.makeInvoiceReqInfo = null;
        int k = 0;
        this.multiMeasureUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
        this.materialInfoMap = new HashMap<String, MaterialInfo>();
        this.expenseTypeInfoMap = new HashMap<String, ExpenseTypeInfo>();
        this.productCodeInfoMap = new HashMap<String, ProductCodeInfo>();
        this.measureUnitInfoMap = new HashMap<String, MeasureUnitInfo>();
        this.strMap = new HashMap<String, String>();
        this.strMap.put("YES", IMUtils.getResource(resClassName, "YES", ctx));
        this.strMap.put("NO", IMUtils.getResource(resClassName, "NO", ctx));
        this.strMap.put("PERCENT", IMUtils.getResource(resClassName, "PERCENT", ctx));
        this.strMap.put("PERUNIT", IMUtils.getResource(resClassName, "PERUNIT", ctx));
        this.strMap.put("DeductRow", IMUtils.getResource(resClassName, "DeductRow", ctx));
        this.strMap.put("NotDeductRow", IMUtils.getResource(resClassName, "NotDeductRow", ctx));
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(i);
            if (k == 0) {
                try {
                    this.makeInvoiceReqInfo = this.transmitHead(lineData, ctx);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                if (this.makeInvoiceReqInfo == null) {
                    return null;
                }
            }
            MakeInvoiceReqEntryInfo entryInfo = null;
            try {
                entryInfo = this.transmitEntry(lineData, ctx);
            }
            catch (EASBizException e) {
                String message = IMUtils.getString(resClassName, "Number_EntrySeq_Message", ctx.getLocale(), new Object[]{this.makeInvoiceReqInfo.getNumber(), k + 1});
                throw new TaskExternalException(message + e.getMessage());
            }
            catch (BOSException e) {
                String message = IMUtils.getString(resClassName, "Number_EntrySeq_Message", ctx.getLocale(), new Object[]{this.makeInvoiceReqInfo.getNumber(), k + 1});
                throw new TaskExternalException(message + e.getMessage());
            }
            catch (TaskExternalException e) {
                String message = IMUtils.getString(resClassName, "Number_EntrySeq_Message", ctx.getLocale(), new Object[]{this.makeInvoiceReqInfo.getNumber(), k + 1});
                throw new TaskExternalException(message + e.getMessage());
            }
            this.makeInvoiceReqInfo.getEntries().add(entryInfo);
            ++k;
        }
        return this.makeInvoiceReqInfo;
    }

    private MakeInvoiceReqInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        String recBillEmail;
        String mailNumber;
        String recBillAdress;
        String recBillComName;
        String recBillPhone;
        int charLength;
        String bankAccount;
        String address;
        String taxNumber;
        this.makeInvoiceReqInfo = new MakeInvoiceReqInfo();
        this.setCompany(ctx, lineData);
        this.dealNumber(ctx, lineData);
        this.setPerson(ctx, lineData);
        Date date = this.getDate(ctx, lineData, "FBizDate");
        this.makeInvoiceReqInfo.setBizDate(date);
        this.makeInvoiceReqInfo.setBizType(IMKBizTypeEnum.EAS);
        this.makeInvoiceReqInfo.setIsPurchaseInvoice(this.getBoolean(ctx, "ISPurchaseInvoice_ERROR", this.getString(lineData, "FIsPurchaseInvoice")));
        this.makeInvoiceReqInfo.setIsVehicle(this.getBoolean(ctx, "ISVehicle_ERROR", this.getString(lineData, "FIsVehicle")));
        this.makeInvoiceReqInfo.setIsDiffTax(this.getBoolean(ctx, "ISDIFFTAX_ERROR", this.getString(lineData, "FIsDiffTax")));
        if (this.makeInvoiceReqInfo.isIsPurchaseInvoice() && this.makeInvoiceReqInfo.isIsVehicle()) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", ctx.getLocale()));
        }
        if (this.makeInvoiceReqInfo.isIsPurchaseInvoice() && this.makeInvoiceReqInfo.isIsDiffTax()) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFPCEZS_REPEAT", ctx.getLocale()));
        }
        this.setAccountTypeAndIsPurchase(ctx, lineData, this.makeInvoiceReqInfo);
        this.setAsstAct(ctx, lineData, this.makeInvoiceReqInfo);
        boolean isTaxCustomer = true;
        this.setCurrency(ctx, lineData, this.makeInvoiceReqInfo);
        this.makeInvoiceReqInfo.setSrcSystem(MakeInvoiceReqSrcSystem.EXCEL);
        this.makeInvoiceReqInfo.setIsInTax(this.getBoolean(ctx, "IS_TAX_ERROR", this.getString(lineData, "FIsInTax")));
        this.makeInvoiceReqInfo.setIsPriceWithoutTax(false);
        this.makeInvoiceReqInfo.setInvoiceType(this.getInvoiceType(ctx, lineData));
        if (this.makeInvoiceReqInfo.getSpecificService() != null && !this.makeInvoiceReqInfo.getSpecificService().equals((Object)this.getSpecificService(ctx, lineData))) {
            SpecificInformationInfo specInfo = this.makeInvoiceReqInfo.getSpecificInformation();
            if (specInfo != null && specInfo.getId() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("specificInformation.id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                boolean isExist = MakeInvoiceReqFactory.getLocalInstance(ctx).exists(filter);
                if (isExist) {
                    filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)specInfo.getId().toString(), CompareType.EQUALS));
                    SpecificInformationFactory.getLocalInstance(ctx).delete(filter);
                }
            }
            this.makeInvoiceReqInfo.setSpecificInformation(null);
        }
        this.makeInvoiceReqInfo.setSpecificService(this.getSpecificService(ctx, lineData));
        String recOrgName = this.getString(lineData, "FRecOrgName");
        this.makeInvoiceReqInfo.setRecOrgName(recOrgName == null ? null : recOrgName.trim());
        if (recOrgName != null && !recOrgName.isEmpty()) {
            if (recOrgName.length() > 300) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "BILLTOCOMPANYNAMELENERR", ctx));
            }
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setTaxNumber((taxNumber = this.getString(lineData, "FTaxNumber")) == null ? null : taxNumber.trim());
        if (taxNumber != null && !taxNumber.isEmpty()) {
            if (taxNumber.trim().length() > 100) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "TaxNumber_tooLong", ctx.getLocale()));
            }
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setAddress((address = this.getString(lineData, "FAddress")) == null ? null : address.trim());
        if (address != null && !address.isEmpty()) {
            if (address.trim().length() > 300) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AddressTel_tooLong", ctx.getLocale()));
            }
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setBankAccount((bankAccount = this.getString(lineData, "FBankAccount")) == null ? null : bankAccount.trim());
        if (bankAccount != null && !bankAccount.isEmpty()) {
            if (bankAccount.trim().length() > 300) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BankAccount_tooLong", ctx.getLocale()));
            }
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setIsMail(false);
        String AsstActTypeTable = "";
        if (this.makeInvoiceReqInfo.getAsstActType() != null && this.makeInvoiceReqInfo.getAsstActType().getRealtionDataObject() != null) {
            AsstActTypeTable = this.makeInvoiceReqInfo.getAsstActType().getRealtionDataObject().toUpperCase();
        }
        if (isTaxCustomer && !StringUtils.isEmpty((String)this.makeInvoiceReqInfo.getAsstActID()) && (CUSTOMER_ASSACTTYPE_NUMBER.equals(AsstActTypeTable) || SUPPLIER_ASSACTTYPE_NUMBER.equals(AsstActTypeTable))) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("customerId", this.makeInvoiceReqInfo.getAsstActID());
            if (this.makeInvoiceReqInfo.getCompany() != null) {
                params.put("companyId", this.makeInvoiceReqInfo.getCompany().getId().toString());
            }
            if (this.makeInvoiceReqInfo.getInvoiceType() != PayInvoiceTypeEnum.DEFAULTTYPE) {
                params.put("invoiceType", this.makeInvoiceReqInfo.getInvoiceType().getValue());
            }
            Map ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params);
            IObjectValue customerTaxInfo = (IObjectValue)ret.get("value");
            boolean setCustomerTax = false;
            if (customerTaxInfo != null) {
                if (this.makeInvoiceReqInfo.getInvoiceType() == PayInvoiceTypeEnum.DEFAULTTYPE) {
                    boolean isDefault;
                    IObjectCollection col = (IObjectCollection)customerTaxInfo.get("entries");
                    if (col.size() != 0 && (isDefault = ((Boolean)col.getObject(0).get("isDefault")).booleanValue())) {
                        setCustomerTax = true;
                        this.makeInvoiceReqInfo.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)((String)col.getObject(0).get("invoiceType"))));
                    }
                } else {
                    setCustomerTax = true;
                }
                if (setCustomerTax) {
                    this.makeInvoiceReqInfo.setRecOrgName((String)customerTaxInfo.get("recCompanyName"));
                    this.makeInvoiceReqInfo.setTaxNumber((String)customerTaxInfo.get("taxNumber"));
                    this.makeInvoiceReqInfo.setAddress((String)customerTaxInfo.get("addressTel"));
                    this.makeInvoiceReqInfo.setBankAccount((String)customerTaxInfo.get("bankAccount"));
                }
            }
            if (!setCustomerTax && SUPPLIER_ASSACTTYPE_NUMBER.equals(AsstActTypeTable) && this.makeInvoiceReqInfo.isIsPurchaseInvoice()) {
                SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(this.makeInvoiceReqInfo.getAsstActID()));
                this.makeInvoiceReqInfo.setTaxNumber(supplierInfo.getTaxRegisterNo());
                this.makeInvoiceReqInfo.setRecOrgName(this.makeInvoiceReqInfo.getAsstActName());
            }
        }
        isTaxCustomer = true;
        String disInvoicer = this.getString(lineData, "FDisInvoicer");
        this.makeInvoiceReqInfo.setDisInvoicer(disInvoicer == null ? null : disInvoicer.trim());
        if (!IMUtils.isEmpty(disInvoicer)) {
            isTaxCustomer = false;
        }
        if ((charLength = IMUtils.getStringlength(recBillPhone = this.getString(lineData, "FRecBillPhone"))) > 40) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "RecBillPhone_TooLong", ctx.getLocale()));
        }
        this.makeInvoiceReqInfo.setRecBillPhone(recBillPhone == null ? null : recBillPhone.trim());
        if (!IMUtils.isEmpty(recBillPhone)) {
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setRecBillComName((recBillComName = this.getString(lineData, "FRecBillComName")) == null ? null : recBillComName.trim());
        if (!IMUtils.isEmpty(recBillComName)) {
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setRecBillAdress((recBillAdress = this.getString(lineData, "FRecBillAdress")) == null ? null : recBillAdress.trim());
        if (!IMUtils.isEmpty(recBillAdress)) {
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setMailNumber((mailNumber = this.getString(lineData, "FMailNumber")) == null ? null : mailNumber.trim());
        if (!IMUtils.isEmpty(mailNumber)) {
            isTaxCustomer = false;
        }
        this.makeInvoiceReqInfo.setRecBillEmail((recBillEmail = this.getString(lineData, "FRecBillEmail")) == null ? null : recBillEmail.trim());
        if (!IMUtils.isEmpty(recBillEmail)) {
            isTaxCustomer = false;
        }
        if (CUSTOMER_ASSACTTYPE_NUMBER.equals(AsstActTypeTable) && isTaxCustomer) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("comOrgUnitId", this.makeInvoiceReqInfo.getCompany() == null ? null : this.makeInvoiceReqInfo.getCompany().getId().toString());
            param.put("customerId", this.makeInvoiceReqInfo.getAsstActID() == null ? null : this.makeInvoiceReqInfo.getAsstActID().toString());
            ICustomerMailing iCustomerMailing = CustomerMailingFactory.getLocalInstance(ctx);
            Map entryMap = iCustomerMailing.getDefaultCustomerMailInfo(param);
            CustomerMailingEntryInfo cmEntryInfo = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
            if (cmEntryInfo != null) {
                this.makeInvoiceReqInfo.setDisInvoicer(cmEntryInfo.getContacts());
                this.makeInvoiceReqInfo.setRecBillPhone(cmEntryInfo.getTelephone());
                this.makeInvoiceReqInfo.setMailNumber(cmEntryInfo.getPostalcode());
                this.makeInvoiceReqInfo.setRecBillComName(cmEntryInfo.getCompanyName());
                this.makeInvoiceReqInfo.setRecBillAdress(cmEntryInfo.getAddress());
                this.makeInvoiceReqInfo.setRecBillEmail(cmEntryInfo.getMailbox());
            }
        }
        this.makeInvoiceReqInfo.setAbstractName(this.getString(lineData, "FAbstractName"));
        return this.makeInvoiceReqInfo;
    }

    private void dealStatus(Context ctx, Hashtable lineData) throws TaskExternalException {
        String statusString = this.getString(lineData, "FStatus");
        String status = this.dealStatusToString(statusString, ctx);
        if (status == null || status != null && !"0".equals(status)) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "StatusImportUpdateError", ctx.getLocale()));
        }
        if ("0".equals(status)) {
            this.makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        }
    }

    private String dealStatusToString(String status, Context ctx) {
        String tempStore = IMUtils.getResource(resClassName, "TempStore", ctx);
        if (status != null) {
            if (tempStore.equals(status)) {
                return "0";
            }
            return status;
        }
        return "-1";
    }

    private void setAsstAct(Context ctx, Hashtable lineData, MakeInvoiceReqInfo makeInvoiceReqInfo2) throws TaskExternalException {
        block8: {
            String realtionDataObject = "";
            String asstActNumber = this.getString(lineData, "FAsstActNumber");
            this.makeInvoiceReqInfo.setAsstActID(null);
            this.makeInvoiceReqInfo.setAsstActNumber(null);
            this.makeInvoiceReqInfo.setAsstActName(null);
            if (this.makeInvoiceReqInfo.getAsstActType() != null && makeInvoiceReqInfo2.getAsstActType().getRealtionDataObject() != null) {
                realtionDataObject = makeInvoiceReqInfo2.getAsstActType().getRealtionDataObject().toUpperCase();
            }
            if (StringUtils.isEmpty((String)realtionDataObject) && !StringUtils.isEmpty((String)asstActNumber)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AsstActError", ctx.getLocale()));
            }
            String sql = null;
            if (SUPPLIER_ASSACTTYPE_NUMBER.equals(realtionDataObject)) {
                sql = "select top 1 fid,fnumber,fname_l2 from T_BD_Supplier where fnumber = ?";
            } else if (CUSTOMER_ASSACTTYPE_NUMBER.equals(realtionDataObject)) {
                sql = "select top 1 fid,fnumber,fname_l2 from T_BD_Customer where fnumber = ?";
            }
            try {
                if (IMUtils.isEmpty(asstActNumber)) break block8;
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{asstActNumber});
                if (rs != null && rs.next()) {
                    this.makeInvoiceReqInfo.setAsstActID(rs.getString("fid"));
                    this.makeInvoiceReqInfo.setAsstActNumber(rs.getString("fnumber"));
                    this.makeInvoiceReqInfo.setAsstActName(rs.getString("fname_l2"));
                    break block8;
                }
                throw new TaskExternalException(IMUtils.getString(resClassName, "AsstActNotExists", ctx.getLocale()));
            }
            catch (Exception e) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AsstActNotExists", ctx.getLocale()));
            }
        }
    }

    private PayInvoiceTypeEnum getInvoiceType(Context ctx, Hashtable hsData) throws TaskExternalException {
        String invoiceType = this.getString(hsData, "FInvoiceType");
        String commonInv = IMUtils.getResource(resClassName, "COMMONINVOICE", ctx);
        String valueInv = IMUtils.getResource(resClassName, "VALUEADDEDTAXINV", ctx);
        String electInv = IMUtils.getResource(resClassName, "ELECTRONICINVOICE", ctx);
        String eleInv = IMUtils.getResource(resClassName, "ELEINVOICE", ctx);
        String eleSpeInv = IMUtils.getResource(resClassName, "ELECTRONICSPECIALINVOICE", ctx);
        String digElec = IMUtils.getResource(resClassName, "DIGITALELECTRICITYINVOICE", ctx);
        String digElecSpe = IMUtils.getResource(resClassName, "DIGITALELECTRICITYSPECIALINVOICE", ctx);
        if (this.makeInvoiceReqInfo.isIsPurchaseInvoice() && (valueInv.equals(invoiceType) || "1".equals(invoiceType) || eleSpeInv.equals(invoiceType) || "3".equals(invoiceType) || "".equals(invoiceType) || "-1".equals(invoiceType))) {
            throw new TaskExternalException(IMUtils.getIMResource(ctx, "INVOICETYPE_ERROR", new String[0]));
        }
        PayInvoiceTypeEnum invoiceTypeEnum = null;
        if (commonInv.equals(invoiceType) || "0".equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if (valueInv.equals(invoiceType) || "1".equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
            BigDecimal taxRate = this.getBigDecimal(hsData, "FEntries_taxRate", ctx);
            if (!(this.makeInvoiceReqInfo.isIsDiffTax() || taxRate != null && taxRate.compareTo(BigDecimal.ZERO) != 0)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "TaxInvTaxRateNotZero", ctx.getLocale()));
            }
        } else if (eleSpeInv.equals(invoiceType) || "3".equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
            BigDecimal taxRate = this.getBigDecimal(hsData, "FEntries_taxRate", ctx);
            if (!(this.makeInvoiceReqInfo.isIsDiffTax() || taxRate != null && taxRate.compareTo(BigDecimal.ZERO) != 0)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "TaxInvTaxRateNotZero", ctx.getLocale()));
            }
        } else if (eleInv.equals(invoiceType) || electInv.equals(invoiceType) || "2".equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if ("".equals(invoiceType) || "-1".equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DEFAULTTYPE;
        } else if (digElec.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if (digElecSpe.equals(invoiceType)) {
            invoiceTypeEnum = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        } else {
            try {
                invoiceTypeEnum = PayInvoiceTypeEnum.getEnum((String)invoiceType);
                if (invoiceTypeEnum == null || invoiceTypeEnum.equals((Object)PayInvoiceTypeEnum.DEFAULTTYPE)) {
                    throw new IMException(IMException.INVOICETYPEERROR);
                }
            }
            catch (IMException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        return invoiceTypeEnum;
    }

    private SpecificServiceEnum getSpecificService(Context ctx, Hashtable hsData) throws TaskExternalException {
        String specificService = this.getString(hsData, "FSpecificService");
        SpecificServiceEnum specServiceEnum = null;
        List enums = SpecificServiceEnum.getEnumList();
        for (SpecificServiceEnum enumItem : enums) {
            if (!enumItem.getAlias().equals(specificService)) continue;
            specServiceEnum = enumItem;
            break;
        }
        if (specServiceEnum == null && (specServiceEnum = SpecificServiceEnum.getEnum(specificService)) == null) {
            specServiceEnum = SpecificServiceEnum.Normal;
        }
        return specServiceEnum;
    }

    private boolean getBoolean(Context ctx, String key, String booleanVal) throws TaskExternalException {
        String yes = this.strMap.get("YES");
        String no = this.strMap.get("NO");
        boolean retVal = false;
        if (!IMUtils.isEmpty(booleanVal)) {
            if (yes.equals(booleanVal) || "TRUE".equalsIgnoreCase(booleanVal.trim()) || "1".equalsIgnoreCase(booleanVal)) {
                retVal = true;
            } else if (no.equals(booleanVal) || "FALSE".equalsIgnoreCase(booleanVal.trim()) || "0".equalsIgnoreCase(booleanVal)) {
                retVal = false;
            } else {
                throw new TaskExternalException(IMUtils.getResource(resClassName, key, ctx));
            }
        }
        return retVal;
    }

    protected BigDecimal getBigDecimal(Hashtable hsData, String key, Context ctx) throws TaskExternalException {
        String data = this.getString(hsData, key);
        data = data.replaceAll("[\uff0c,]", "");
        String reg = "(^-?\\d+(\\.\\d+)?$)";
        if (data != null && data.length() > 0) {
            if (data.matches(reg)) {
                return new BigDecimal(data);
            }
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "BigDecimalDataError", ctx.getLocale()));
        }
        return null;
    }

    private void setCurrency(Context ctx, Hashtable lineData, MakeInvoiceReqInfo reqInfo) throws TaskExternalException, EASBizException, BOSException {
        CurrencyInfo info = null;
        String number = ((DataToken)lineData.get((Object)"FCurrency_number")).data.toString();
        if (!IMUtils.isEmpty(number)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            view.setFilter(filter);
            CurrencyCollection coll = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            if (coll != null && coll.size() > 0) {
                info = coll.get(0);
                amtPrecision = info.getPrecision();
            }
        } else {
            throw new TaskExternalException(IMUtils.getString(resClassName, "CurrencyNotExists", ctx.getLocale()));
        }
        if (info == null) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "CurrencyNotExists", ctx.getLocale()));
        }
        BigDecimal exchangeRate = this.getBigDecimal(lineData, "FExchangeRate", ctx);
        CurrencyInfo baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.makeInvoiceReqInfo.getCompany().getBaseCurrency().getId()));
        if (exchangeRate == null) {
            if (info.getId().equals((Object)baseCurrencyInfo.getId())) {
                reqInfo.setExchangeRate(BigDecimal.ONE);
                reqInfo.setCurrency(info);
                return;
            }
            Date date = this.getDate(ctx, lineData, "FBizDate");
            ObjectUuidPK excTablepk = new ObjectUuidPK(reqInfo.getCompany().getBaseExchangeTable().getId());
            ExchangeRateInfo erInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)excTablepk, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectPK)new ObjectUuidPK(baseCurrencyInfo.getId()), date);
            reqInfo.setExchangeRate(erInfo.getConvertRate());
            reqInfo.setCurrency(info);
        } else if (exchangeRate.compareTo(BigDecimal.ZERO) >= 0) {
            if (info.getId().equals((Object)baseCurrencyInfo.getId()) && exchangeRate.intValue() != 1) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "BaseCurrency_ExchangeRateEqOne", ctx.getLocale()));
            }
            reqInfo.setExchangeRate(exchangeRate);
            reqInfo.setCurrency(info);
        } else {
            throw new TaskExternalException(IMUtils.getString(resClassName, "ExchangeRateBiggerZero", ctx.getLocale()));
        }
    }

    private void setAccountTypeAndIsPurchase(Context ctx, Hashtable lineData, MakeInvoiceReqInfo makeInvoiceReqInfo2) throws TaskExternalException {
        AsstActTypeInfo asstActTypeInfo = null;
        String assActTypeNum = this.getString(lineData, "FAsstActType_number");
        if (StringUtils.isEmpty((String)assActTypeNum)) {
            makeInvoiceReqInfo2.setAsstActType(null);
            return;
        }
        String sql = " select top 1 fid, fnumber, fname_l2 , FREALTIONDATAOBJECT from T_BD_AsstActType where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assActTypeNum});
            if (rs == null || !rs.next()) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "AsstActTypeNotExists", ctx.getLocale()));
            }
            asstActTypeInfo = new AsstActTypeInfo();
            asstActTypeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
            asstActTypeInfo.setNumber(rs.getString("fnumber"));
            asstActTypeInfo.setName(rs.getString("fname_l2"));
            asstActTypeInfo.setRealtionDataObject(rs.getString("FREALTIONDATAOBJECT"));
            makeInvoiceReqInfo2.setAsstActType(asstActTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private Date getDate(Context ctx, Hashtable hsData, String fieldName) throws TaskExternalException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object o = ((DataToken)hsData.get((Object)fieldName)).data;
        if (o != null && o.toString().length() > 0) {
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
            }
        }
        if (o == null || !(o instanceof Date)) {
            throw new TaskExternalException(IMUtils.getResource(resClassName, "DATE_ERROR", ctx));
        }
        date = (Date)o;
        return date;
    }

    private void setCompany(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException {
        CompanyOrgUnitInfo comOrgUnitInfo;
        block4: {
            comOrgUnitInfo = null;
            String companyNum = ((DataToken)lineData.get((Object)"FCompany_number")).data.toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNum));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("isOnlyUnion"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            view.setFilter(filter);
            view.setSelector(sic);
            CompanyOrgUnitCollection comOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
            try {
                if (comOrgUnitCollection != null && comOrgUnitCollection.size() > 0) {
                    comOrgUnitInfo = comOrgUnitCollection.get(0);
                    if (comOrgUnitInfo == null) {
                        throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "CompanyNotExists", ctx.getLocale()));
                    }
                    discountRatePrecision = IMUtils.getIntegerParam(ctx, comOrgUnitInfo.getId().toString(), "DISCOUNTRATEPRECISION");
                    discountRatePrecision += 2;
                    break block4;
                }
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "CompanyNotExists", ctx.getLocale()));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        this.makeInvoiceReqInfo.setCompany(comOrgUnitInfo);
    }

    private void setPerson(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException {
        PersonInfo personInfo = null;
        String personNum = this.getString(lineData, "FPerson_number");
        if (StringUtils.isEmpty((String)personNum)) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)personNum));
        view.setFilter(filter);
        PersonCollection personCollection = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view);
        try {
            if (personCollection != null && personCollection.size() > 0) {
                personInfo = personCollection.get(0);
                if (personInfo == null) {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "PersonNotExist", ctx.getLocale()));
                }
            } else {
                throw new TaskExternalException(IMUtils.getString(resClassName, "PersonNotExist", ctx.getLocale()));
            }
            this.makeInvoiceReqInfo.setPerson(personInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void dealNumber(Context ctx, Hashtable lineData) throws BOSException, TaskExternalException, EASBizException {
        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
        boolean isSupporNumberRule = IMUtils.getImportParam(ctx);
        if (isSupporNumberRule && IMUtils.isEmpty((String)number)) {
            String mainOrgId = null;
            CompanyOrgUnitInfo mainOrg = this.makeInvoiceReqInfo.getCompany();
            if (mainOrg == null) {
                return;
            }
            mainOrgId = mainOrg.getString("id");
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!iCodingRuleManager.isExist((IObjectValue)this.makeInvoiceReqInfo, mainOrgId)) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotNubmerRule", ctx.getLocale()));
            }
            number = iCodingRuleManager.getNumber((IObjectValue)this.makeInvoiceReqInfo, mainOrgId, "");
            String statusString = this.getString(lineData, "FStatus");
            String status = this.dealStatusToString(statusString, ctx);
            if (status == null || status != null && !String.valueOf(0).equals(status)) {
                throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "StatusImportUpdateError", ctx.getLocale()));
            }
            this.makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        } else if (number != null && number.toString().trim().length() > 0) {
            MakeInvoiceReqCollection makeInvoiceReqColl = this.getMakeInvoiceReqColl(ctx, number.toString().trim());
            if (this.isSltImportUpdate()) {
                if (makeInvoiceReqColl != null && makeInvoiceReqColl.size() > 0) {
                    this.makeInvoiceReqInfo = makeInvoiceReqColl.get(0);
                    String existCompanyId = String.valueOf(this.makeInvoiceReqInfo.getCompany().getId());
                    this.checkPermission(ctx, existCompanyId);
                    if (this.makeInvoiceReqInfo.getStatus() != null) {
                        String status = String.valueOf(this.makeInvoiceReqInfo.getStatus().getValue());
                        if (!String.valueOf(0).equals(status)) {
                            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotImportUpdateForDone", ctx.getLocale()));
                        }
                        if (MakeInvoiceReqSrcSystem.EXCEL != this.makeInvoiceReqInfo.getSrcSystem()) {
                            throw new TaskExternalException(IMUtils.getString(resClassName, "IMPORTUPDATE_ERROR", ctx.getLocale()));
                        }
                        this.dealStatus(ctx, lineData);
                    }
                }
            } else {
                String existCompanyId = String.valueOf(this.makeInvoiceReqInfo.getCompany().getId());
                this.checkPermission(ctx, existCompanyId);
                String statusString = this.getString(lineData, "FStatus");
                String status = this.dealStatusToString(statusString, ctx);
                if (!String.valueOf(0).equals(status)) {
                    throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "StatusImportAddNewError", ctx.getLocale()));
                }
                this.makeInvoiceReqInfo.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
                if (makeInvoiceReqColl.size() > 0) {
                    String str = IMUtils.getResource(resClassName, "EXIST_SAME_NUMBER", ctx);
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
            }
        } else {
            String str = IMUtils.getResource(resClassName, "NUMBER_IS_ISNULL", ctx);
            throw new TaskExternalException(str);
        }
        this.makeInvoiceReqInfo.setNumber(number.toString().trim());
    }

    private MakeInvoiceReqCollection getMakeInvoiceReqColl(Context ctx, String number) throws BOSException {
        MakeInvoiceReqCollection coll = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection("select *,entries.*,company.*,company.baseCurrency.*,company.baseExchangeTable.*,specificInformation.*,specificInformation.entries.*  where number ='" + number + "'");
        return coll;
    }

    private MakeInvoiceReqEntryInfo transmitEntry(Hashtable lineData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        MakeInvoiceReqEntryInfo entryInfo = new MakeInvoiceReqEntryInfo();
        this.setSeq(ctx, lineData, entryInfo);
        String productName = this.getString(lineData, "FEntries_productName");
        entryInfo.setProductName(productName);
        MaterialInfo materialInfo = this.doEntryMaterial(entryInfo, lineData, ctx);
        entryInfo.setSpecs(this.getString(lineData, "FEntries_specs"));
        MeasureUnitInfo unitInfo = this.doUnit(entryInfo, lineData, ctx);
        BigDecimal qty = this.getBigDecimal(lineData, "FEntries_qty", ctx);
        entryInfo.setQty(qty == null ? BigDecimal.ZERO : qty);
        entryInfo.setBaseQty(this.doBaseQty(ctx, qty, unitInfo, materialInfo));
        entryInfo.setIsQtyZero(this.getBoolean(ctx, "IsQtyZeroError", this.getString(lineData, "FEntries_isQtyZero")));
        entryInfo.setPrice(this.getBigDecimal(lineData, "FEntries_price", ctx));
        entryInfo.setNoTaxPrice(this.getBigDecimal(lineData, "FEntries_noTaxPrice", ctx));
        entryInfo.setTax(this.getBigDecimal(lineData, "FEntries_tax", ctx));
        entryInfo.setTaxRate(this.getBigDecimal(lineData, "FEntries_taxRate", ctx));
        entryInfo.setPriceExcludingTax(this.getBigDecimal(lineData, "FEntries_priceExcludingTax", ctx));
        entryInfo.setPriceIncludingTax(this.getBigDecimal(lineData, "FEntries_priceIncludingTax", ctx));
        entryInfo.setDiscountType(this.getDiscountModeEnum(ctx, lineData));
        entryInfo.setDeductRow(this.getDeductRow(ctx, lineData));
        entryInfo.setDiscountRate(this.getDiscountRate(entryInfo, lineData, "FEntries_discountRate", ctx));
        entryInfo.setDiscountAmount(this.getDiscountAmount(entryInfo, lineData, "FEntries_discountAmount", ctx));
        this.setTaxClassificationCode(entryInfo, ctx, lineData, "FEntries_taxClassificationCode");
        entryInfo.setRemark(this.getString(lineData, "FEntries_remark"));
        this.doEntryProductCode(entryInfo, lineData, ctx);
        this.matchProductCode(ctx, entryInfo, lineData);
        this.checkVehicleVolid(ctx, entryInfo);
        this.checkIsDiffTax(ctx, entryInfo);
        this.dealMath(ctx, entryInfo);
        return entryInfo;
    }

    private void checkIsDiffTax(Context ctx, MakeInvoiceReqEntryInfo entryInfo) throws TaskExternalException {
        boolean isDiffTax = this.makeInvoiceReqInfo.isIsDiffTax();
        if (!isDiffTax && entryInfo.getDeductRow() != null) {
            throw new TaskExternalException(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceReqResource", "IsNotDiffTaxDeductRowNull", ctx.getLocale()));
        }
    }

    private void checkVehicleVolid(Context ctx, MakeInvoiceReqEntryInfo entry) throws BOSException, EASBizException, TaskExternalException {
        if (this.makeInvoiceReqInfo.isIsVehicle()) {
            TaxClassificationCodeInfo tccInfo;
            StringBuffer vehicleLineMsg = new StringBuffer();
            String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_REQBILL", ctx.getLocale());
            if (entry.getPrice() == null || entry.getNoTaxPrice() == null || entry.getQty() == null || BigDecimal.ZERO.compareTo(entry.getPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getQty()) == 0) {
                throw new TaskExternalException(billMsg + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", ctx.getLocale()));
            }
            if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeInfo("where mergeCode = '" + entry.getTaxClassificationCode() + "'")) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                throw new TaskExternalException(billMsg + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", ctx.getLocale()));
            }
        }
    }

    private void matchProductCode(Context ctx, MakeInvoiceReqEntryInfo entryInfo, Hashtable lineData) throws EASBizException, BOSException, TaskExternalException {
        String materialID = null;
        String expenseTypeID = null;
        if (entryInfo.getMaterial() != null) {
            materialID = entryInfo.getMaterial().getId().toString();
        } else if (entryInfo.getExpenseItem() != null) {
            expenseTypeID = entryInfo.getExpenseItem().getId().toString();
        } else {
            return;
        }
        String customerId = null;
        if (this.makeInvoiceReqInfo.getAsstActType() != null && "T_BD_Customer".equalsIgnoreCase(this.makeInvoiceReqInfo.getAsstActType().getRealtionDataObject())) {
            customerId = this.makeInvoiceReqInfo.getAsstActID();
        }
        String taxRateSubKey = entryInfo.getTaxRate() == null ? null : entryInfo.getTaxRate().setScale(4, 1).toString();
        String key = customerId + this.makeInvoiceReqInfo.getCompany().getId().toString() + materialID + expenseTypeID + taxRateSubKey + this.makeInvoiceReqInfo.isIsVehicle() + this.makeInvoiceReqInfo.isIsDiffTax();
        ProductCodeInfo productCodeInfo = null;
        if (this.productCodeInfoMap.containsKey(key)) {
            productCodeInfo = this.productCodeInfoMap.get(key);
        } else {
            productCodeInfo = ProductCodeFactory.getLocalInstance(ctx).getMatchProduct(customerId, this.makeInvoiceReqInfo.getCompany().getId().toString(), materialID, expenseTypeID, entryInfo.getTaxRate(), this.makeInvoiceReqInfo.isIsVehicle(), this.makeInvoiceReqInfo.isIsDiffTax());
            this.productCodeInfoMap.put(key, productCodeInfo);
        }
        String productCodeNumber = this.getString(lineData, "FEntries$productCode_number");
        if (productCodeInfo != null) {
            String productName = this.getString(lineData, "FEntries_productName");
            String taxClassCode = this.getString(lineData, "FEntries_taxClassificationCode");
            if (!StringUtils.isEmpty((String)productCodeNumber) && !productCodeNumber.equals(productCodeInfo.getNumber())) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "PRODUCT_NUMBER_INVALID", ctx.getLocale()));
            }
            entryInfo.setProductCode(productCodeInfo);
            if (StringUtils.isEmpty((String)productName)) {
                entryInfo.setProductName(productCodeInfo.getName());
            }
            if (StringUtils.isEmpty((String)taxClassCode) && productCodeInfo.getTaxClassificationCode() != null) {
                entryInfo.setTaxClassificationCode(productCodeInfo.getTaxClassificationCode().getMergeCode());
            }
        } else if (!StringUtils.isEmpty((String)productCodeNumber)) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "PRODUCT_NUMBER_INVALID", ctx.getLocale()));
        }
    }

    private void doEntryProductCode(MakeInvoiceReqEntryInfo entryInfo, Hashtable lineData, Context ctx) throws TaskExternalException, BOSException {
        String productCodeNumber = this.getString(lineData, "FEntries$productCode_number");
        String productName = this.getString(lineData, "FEntries_productName");
        String taxClassCode = this.getString(lineData, "FEntries_taxClassificationCode");
        if (!StringUtils.isEmpty((String)productCodeNumber)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)productCodeNumber, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("material.number"));
            sic.add(new SelectorItemInfo("material.name"));
            sic.add(new SelectorItemInfo("expenseItem.name"));
            sic.add(new SelectorItemInfo("expenseItem.number"));
            sic.add(new SelectorItemInfo("taxClassificationCode.mergeCode"));
            view.setSelector(sic);
            ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
            if (coll != null && coll.size() > 0) {
                ProductCodeInfo productCodeInfo = coll.get(0);
                entryInfo.setProductCode(productCodeInfo);
                if (StringUtils.isEmpty((String)productName)) {
                    entryInfo.setProductName(productCodeInfo.getName());
                }
                if (StringUtils.isEmpty((String)taxClassCode) && productCodeInfo.getTaxClassificationCode() != null) {
                    entryInfo.setTaxClassificationCode(productCodeInfo.getTaxClassificationCode().getMergeCode());
                }
            } else {
                throw new TaskExternalException(IMUtils.getString(resClassName, "ProductCodeNumberIsNotExist", ctx.getLocale()));
            }
        }
    }

    private BigDecimal doBaseQty(Context ctx, BigDecimal qty, MeasureUnitInfo unitInfo, MaterialInfo materialInfo) throws EASBizException, BOSException {
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty == null || qty.compareTo(SysConstant.BIGZERO) == 0) {
            return qty;
        }
        MultiMeasureUnitInfo mulUnit = this.getMulUnit(ctx, unitInfo, materialInfo);
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            if (coefficient != null && materialInfo != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = materialInfo.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId())).getBaseUnit();
                }
                mulUnit = this.getMulUnit(ctx, baseUnit, materialInfo);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
        } else {
            baseQty = qty;
        }
        return baseQty;
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws EASBizException, BOSException {
        if (mui == null || mi == null) {
            return null;
        }
        String key = mui.getId().toString() + "_" + mi.getId().toString();
        IMultiMeasureUnit immu = null;
        MultiMeasureUnitInfo mulUnit = null;
        if (!this.multiMeasureUnitMap.containsKey(key)) {
            immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
            this.multiMeasureUnitMap.put(key, mulUnit);
        } else {
            mulUnit = this.multiMeasureUnitMap.get(key);
        }
        return mulUnit;
    }

    private void setSeq(Context ctx, Hashtable lineData, MakeInvoiceReqEntryInfo entryInfo) throws TaskExternalException {
        String seq = this.getString(lineData, "FEntries_seq");
        if (StringUtils.isEmpty((String)seq)) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "SEQ_ERROR", ctx.getLocale()));
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (Character.isDigit(seq.charAt(i))) continue;
            throw new TaskExternalException(IMUtils.getString(resClassName, "SEQ_ERROR", ctx.getLocale()));
        }
        MakeInvoiceReqEntryInfo info = null;
        for (int i = 0; i < this.makeInvoiceReqInfo.getEntries().size(); ++i) {
            info = this.makeInvoiceReqInfo.getEntries().get(i);
            if (info.getSeq() != Integer.valueOf(seq).intValue()) continue;
            this.makeInvoiceReqInfo.getEntries().remove(info);
            break;
        }
        entryInfo.setSeq(Integer.valueOf(seq));
    }

    private void setTaxClassificationCode(MakeInvoiceReqEntryInfo entryInfo, Context ctx, Hashtable lineData, String string) throws TaskExternalException {
        String taxClassCode = this.getString(lineData, "FEntries_taxClassificationCode");
        if (!IMUtils.isEmpty(taxClassCode)) {
            String sql = "select FMERGECODE from T_IM_TaxClassificationCode where (FMERGECODE = ? or FNUMBER = ?) and FSUMITEM = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{taxClassCode, taxClassCode, "N"});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "TaxClassificationCodeNotExists", ctx.getLocale()));
                }
                entryInfo.setTaxClassificationCode(rs.getString("FMERGECODE"));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
    }

    private void dealMath(Context ctx, MakeInvoiceReqEntryInfo entryInfo) throws TaskExternalException {
        this.importCheckNecessary(ctx, entryInfo);
        this.calculateBeforeProNagCal(entryInfo);
        MakeInvoiceReqEntryInfo cloneProEntry = (MakeInvoiceReqEntryInfo)entryInfo.clone();
        MakeInvoiceReqEntryInfo cloneNagEntry = (MakeInvoiceReqEntryInfo)entryInfo.clone();
        cloneProEntry = this.calculateEntry(cloneProEntry, true);
        cloneNagEntry = this.calculateEntry(cloneNagEntry, false);
        this.checkAfterCalculate(ctx, cloneProEntry, cloneNagEntry, entryInfo);
    }

    private void checkAfterCalculate(Context ctx, MakeInvoiceReqEntryInfo cloneProEntry, MakeInvoiceReqEntryInfo cloneNagEntry, MakeInvoiceReqEntryInfo entryInfo) throws TaskExternalException {
        boolean isInTax = this.makeInvoiceReqInfo.isIsInTax();
        if (isInTax) {
            HashMap<String, BigDecimal> compareMap = new HashMap<String, BigDecimal>();
            compareMap.put("proValue1", this.transToZero(cloneProEntry.getPrice()).setScale(pricePrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue1", this.transToZero(cloneNagEntry.getPrice()).setScale(pricePrecision, RoundingMode.HALF_UP));
            compareMap.put("proValue2", this.transToZero(cloneProEntry.getPriceIncludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue2", this.transToZero(cloneNagEntry.getPriceIncludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP));
            compareMap.put("proValue3", this.transToZero(cloneProEntry.getQty()).setScale(qtyPrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue3", this.transToZero(cloneNagEntry.getQty()).setScale(qtyPrecision, RoundingMode.HALF_UP));
            if (!this.compareValueEqual(compareMap)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "InTax_PriceQtyPriceIn_Error", ctx.getLocale()));
            }
        } else {
            HashMap<String, BigDecimal> compareMap = new HashMap<String, BigDecimal>();
            compareMap.put("proValue1", this.transToZero(cloneProEntry.getNoTaxPrice()).setScale(pricePrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue1", this.transToZero(cloneNagEntry.getNoTaxPrice()).setScale(pricePrecision, RoundingMode.HALF_UP));
            compareMap.put("proValue2", this.transToZero(cloneProEntry.getPriceExcludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue2", this.transToZero(cloneNagEntry.getPriceExcludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP));
            compareMap.put("proValue3", this.transToZero(cloneProEntry.getQty()).setScale(qtyPrecision, RoundingMode.HALF_UP));
            compareMap.put("nagValue3", this.transToZero(cloneNagEntry.getQty()).setScale(qtyPrecision, RoundingMode.HALF_UP));
            if (!this.compareValueEqual(compareMap)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "InNoTax_PriceQtyPriceIn_Error", ctx.getLocale()));
            }
        }
    }

    private boolean compareValueEqual(Map<String, BigDecimal> compareMap) {
        BigDecimal proValue1 = compareMap.get("proValue1");
        BigDecimal nagValue1 = compareMap.get("nagValue1");
        BigDecimal proValue2 = compareMap.get("proValue2");
        BigDecimal nagValue2 = compareMap.get("nagValue2");
        BigDecimal proValue3 = compareMap.get("proValue3");
        BigDecimal nagValue3 = compareMap.get("nagValue3");
        int i = 0;
        if (proValue1.equals(nagValue1)) {
            ++i;
        }
        if (proValue2.equals(nagValue2)) {
            ++i;
        }
        if (proValue3.equals(nagValue3)) {
            ++i;
        }
        return i >= 2;
    }

    private void calculateBeforeProNagCal(MakeInvoiceReqEntryInfo entryInfo) {
        if (entryInfo.getDiscountType().getValue() == 1 && entryInfo.getDiscountRate() != null && entryInfo.getDiscountAmount() == null) {
            BigDecimal entryDiscountRate = entryInfo.getDiscountRate().setScale(discountRatePrecision, RoundingMode.HALF_UP);
            entryDiscountRate = entryDiscountRate.divide(new BigDecimal(100), discountRatePrecision, 4);
            entryInfo.setDiscountAmount(entryDiscountRate.multiply(entryInfo.getQty()));
        }
    }

    private MakeInvoiceReqEntryInfo calculateEntry(MakeInvoiceReqEntryInfo cloneEntry, boolean proOrNag) {
        BigDecimal tax = this.transToZero(cloneEntry.getTax());
        BigDecimal priceIncludingTax = this.transToZero(cloneEntry.getPriceIncludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal priceExcludingTax = this.transToZero(cloneEntry.getPriceExcludingTax()).setScale(amtPrecision, RoundingMode.HALF_UP);
        BigDecimal price = this.transToZero(cloneEntry.getPrice()).setScale(pricePrecision, RoundingMode.HALF_UP);
        BigDecimal noTaxPrice = this.transToZero(cloneEntry.getNoTaxPrice()).setScale(pricePrecision, RoundingMode.HALF_UP);
        BigDecimal qty = this.transToZero(cloneEntry.getQty()).setScale(qtyPrecision, RoundingMode.HALF_UP);
        BigDecimal discountRate = this.transToZero(cloneEntry.getDiscountRate()).setScale(discountRatePrecision, RoundingMode.HALF_UP);
        boolean isQtyZero = cloneEntry.isIsQtyZero();
        if (isQtyZero) {
            cloneEntry.setDiscountType(DiscountModeEnum.NULL);
        }
        boolean isInTax = this.makeInvoiceReqInfo.isIsInTax();
        DiscountModeEnum discountType = cloneEntry.getDiscountType();
        if (proOrNag && isQtyZero) {
            cloneEntry.setPriceIncludingTax(priceExcludingTax.add(tax));
        } else if (!proOrNag && isQtyZero) {
            cloneEntry.setTax(priceIncludingTax.subtract(priceExcludingTax));
        } else if (proOrNag && !isQtyZero) {
            if (isInTax) {
                BigDecimal fakePrice = price;
                if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
                    fakePrice = price.subtract(discountRate);
                } else if (DiscountModeEnum.PERCENT.equals((Object)discountType)) {
                    fakePrice = price.multiply(BigDecimal.ONE.subtract(discountRate.divide(new BigDecimal(100), discountRatePrecision, 4))).setScale(pricePrecision, RoundingMode.HALF_UP);
                }
                cloneEntry.setPriceIncludingTax(fakePrice.multiply(qty).setScale(amtPrecision, RoundingMode.HALF_UP));
            } else {
                BigDecimal fakeNoTaxPrice = noTaxPrice;
                if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
                    fakeNoTaxPrice = price.subtract(discountRate);
                } else if (DiscountModeEnum.PERCENT.equals((Object)discountType)) {
                    fakeNoTaxPrice = noTaxPrice.multiply(BigDecimal.ONE.subtract(discountRate.divide(new BigDecimal(100), discountRatePrecision, 4))).setScale(pricePrecision, RoundingMode.HALF_UP);
                }
                cloneEntry.setPriceExcludingTax(fakeNoTaxPrice.multiply(qty).setScale(amtPrecision, RoundingMode.HALF_UP));
            }
        } else if (isInTax) {
            if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
                cloneEntry.setPrice(priceIncludingTax.divide(qty, pricePrecision, 4).add(discountRate));
            } else if (DiscountModeEnum.PERCENT.equals((Object)discountType)) {
                BigDecimal fakePrice = priceIncludingTax.divide(qty, pricePrecision, 4);
                if (fakePrice.intValue() == 0) {
                    cloneEntry.setPrice(fakePrice);
                } else {
                    cloneEntry.setPrice(fakePrice.divide(BigDecimal.ONE.subtract(discountRate.divide(new BigDecimal(100), discountRatePrecision, 4)), pricePrecision, 4));
                }
            } else {
                cloneEntry.setPrice(priceIncludingTax.divide(qty, pricePrecision, 4));
            }
        } else if (DiscountModeEnum.PERUNIT.equals((Object)discountType)) {
            cloneEntry.setNoTaxPrice(priceExcludingTax.divide(qty, pricePrecision, 4).add(discountRate));
        } else if (DiscountModeEnum.PERCENT.equals((Object)discountType)) {
            BigDecimal fakePrice = priceExcludingTax.divide(qty, pricePrecision, 4);
            if (fakePrice.intValue() == 0) {
                cloneEntry.setNoTaxPrice(fakePrice);
            } else {
                cloneEntry.setNoTaxPrice(fakePrice.divide(BigDecimal.ONE.subtract(discountRate.divide(new BigDecimal(100), discountRatePrecision, 4)), pricePrecision, 4));
            }
        } else {
            cloneEntry.setNoTaxPrice(priceExcludingTax.divide(qty, pricePrecision, 4));
        }
        return cloneEntry;
    }

    private BigDecimal transToZero(BigDecimal num) {
        if (num != null) {
            return num;
        }
        return BigDecimal.ZERO;
    }

    private boolean isNullOrZero(BigDecimal num) {
        return num == null || BigDecimal.ZERO.compareTo(num) == 0;
    }

    private void importCheckNecessary(Context ctx, MakeInvoiceReqEntryInfo entryInfo) throws TaskExternalException {
        if (entryInfo.isIsQtyZero()) {
            if (!this.isNullOrZero(entryInfo.getQty().setScale(qtyPrecision, RoundingMode.HALF_UP)) || this.isNullOrZero(entryInfo.getPriceExcludingTax())) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "ZeroQtyPriceDataError", ctx.getLocale()));
            }
        } else {
            if (this.isNullOrZero(entryInfo.getQty())) {
                String field = IMUtils.getString(resClassName, "Qty", ctx.getLocale());
                throw new TaskExternalException(IMUtils.getString(resClassName, "FieldNotNull", ctx.getLocale(), new Object[]{field}));
            }
            boolean isInTax = this.makeInvoiceReqInfo.isIsInTax();
            BigDecimal priceIncludingTax = entryInfo.getPriceIncludingTax();
            BigDecimal priceExcludingTax = entryInfo.getPriceExcludingTax();
            BigDecimal price = entryInfo.getPrice();
            BigDecimal noTaxPrice = entryInfo.getNoTaxPrice();
            if (isInTax) {
                if (priceIncludingTax == null) {
                    String field = IMUtils.getString(resClassName, "EntriesPriceIncludingTax", ctx.getLocale());
                    throw new TaskExternalException(IMUtils.getString(resClassName, "FieldNotNull", ctx.getLocale(), new Object[]{field}));
                }
                if (price == null) {
                    String field = IMUtils.getString(resClassName, "EntriesPrice", ctx.getLocale());
                    throw new TaskExternalException(IMUtils.getString(resClassName, "FieldNotNull", ctx.getLocale(), new Object[]{field}));
                }
            } else {
                if (priceExcludingTax == null) {
                    String field = IMUtils.getString(resClassName, "EntriesPriceExcludingTax", ctx.getLocale());
                    throw new TaskExternalException(IMUtils.getString(resClassName, "FieldNotNull", ctx.getLocale(), new Object[]{field}));
                }
                if (noTaxPrice == null) {
                    String field = IMUtils.getString(resClassName, "EntriesNoTaxPrice", ctx.getLocale());
                    throw new TaskExternalException(IMUtils.getString(resClassName, "FieldNotNull", ctx.getLocale(), new Object[]{field}));
                }
            }
            if (entryInfo.getDiscountType() == null || DiscountModeEnum.NULL.equals((Object)entryInfo.getDiscountType())) {
                if (!this.isNullOrZero(entryInfo.getDiscountAmount()) || !this.isNullOrZero(entryInfo.getDiscountRate())) {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "TypeNullRateAmtNotNull", ctx.getLocale()));
                }
            } else if (entryInfo.getDiscountRate() != null && entryInfo.getDiscountRate().intValue() == 100 && (isInTax && priceIncludingTax.intValue() != 0 || !isInTax && priceExcludingTax.intValue() != 0)) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DiscountRateNotHundred", ctx.getLocale()));
            }
        }
    }

    private DiscountModeEnum getDiscountModeEnum(Context ctx, Hashtable hsData) throws TaskExternalException {
        String discountType = this.getString(hsData, "FEntries_discountType");
        String percent = this.strMap.get("PERCENT");
        String perunit = this.strMap.get("PERUNIT");
        DiscountModeEnum discountTypeEnum = null;
        if (percent.equals(discountType) || "0".equals(discountType)) {
            discountTypeEnum = DiscountModeEnum.PERCENT;
        } else if (perunit.equals(discountType) || "1".equals(discountType)) {
            discountTypeEnum = DiscountModeEnum.PERUNIT;
        } else {
            try {
                discountTypeEnum = DiscountModeEnum.getEnum((String)discountType);
                if (discountTypeEnum == null || discountTypeEnum != null && !discountTypeEnum.equals((Object)DiscountModeEnum.NULL)) {
                    discountTypeEnum = DiscountModeEnum.NULL;
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        return discountTypeEnum;
    }

    private DeductRowEnum getDeductRow(Context ctx, Hashtable hsData) throws TaskExternalException {
        String deductRowdEnumStr = this.getString(hsData, "FEntries_deductRow");
        String deductRowStr = this.strMap.get("DeductRow");
        String notDeductRowStr = this.strMap.get("NotDeductRow");
        DeductRowEnum deductRowEnum = null;
        if (!StringUtils.isEmpty((String)deductRowdEnumStr)) {
            if (notDeductRowStr.equals(deductRowdEnumStr) || "2".equals(deductRowdEnumStr)) {
                deductRowEnum = DeductRowEnum.NotDeductRow;
            } else if (deductRowStr.equals(deductRowdEnumStr) || "1".equals(deductRowdEnumStr)) {
                deductRowEnum = DeductRowEnum.DeductRow;
            } else {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DEDUCTROW_ERROR", ctx.getLocale()));
            }
        }
        return deductRowEnum;
    }

    private BigDecimal getDiscountRate(MakeInvoiceReqEntryInfo entryInfo, Hashtable hsData, String key, Context ctx) throws TaskExternalException {
        BigDecimal field = this.getBigDecimal(hsData, key, ctx);
        if (0 == entryInfo.getDiscountType().getValue()) {
            if (field == null) {
                throw new TaskExternalException(IMUtils.getString(resClassName, "DiscountRate_NotNull", ctx.getLocale()));
            }
            return field;
        }
        return field;
    }

    private BigDecimal getDiscountAmount(MakeInvoiceReqEntryInfo entryInfo, Hashtable hsData, String key, Context ctx) throws TaskExternalException {
        BigDecimal field = this.getBigDecimal(hsData, key, ctx);
        return field;
    }

    private MeasureUnitInfo doUnit(MakeInvoiceReqEntryInfo entryInfo, Hashtable lineData, Context ctx) throws TaskExternalException, BOSException {
        String unitNumber = this.getString(lineData, "FEntries$unit_number");
        String unitName = this.getString(lineData, "FEntries_unitName");
        MeasureUnitInfo unitInfo = null;
        if (!IMUtils.isEmpty(unitNumber)) {
            if (this.measureUnitInfoMap.containsKey(unitNumber)) {
                unitInfo = this.measureUnitInfoMap.get(unitNumber);
                entryInfo.setUnit(unitInfo);
                qtyPrecision = unitInfo.getQtyPrecision();
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo info = new FilterInfo();
                info.getFilterItems().add(new FilterItemInfo("number", (Object)unitNumber, CompareType.EQUALS));
                view.setFilter(info);
                MeasureUnitCollection coll = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
                if (coll != null && coll.size() > 0) {
                    unitInfo = coll.get(0);
                    this.measureUnitInfoMap.put(unitNumber, unitInfo);
                    entryInfo.setUnit(unitInfo);
                    qtyPrecision = unitInfo.getQtyPrecision();
                } else {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "UnitNumberNotExists", ctx.getLocale()));
                }
            }
        }
        if (StringUtils.isEmpty((String)unitName)) {
            if (unitInfo != null) {
                entryInfo.setUnitName(unitInfo.getName());
            }
        } else {
            entryInfo.setUnitName(unitName);
        }
        return unitInfo;
    }

    private MaterialInfo doEntryMaterial(MakeInvoiceReqEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        String materialNumber = this.getString(hsData, "FEntries$material_number");
        String expenseItemNumber = this.getString(hsData, "FEntries$expenseItem_number");
        String productName = this.getString(hsData, "FEntries_productName");
        MaterialInfo materialInfo = null;
        if (!StringUtils.isEmpty((String)materialNumber)) {
            if (this.materialInfoMap.containsKey(materialNumber)) {
                materialInfo = this.materialInfoMap.get(materialNumber);
                entryInfo.setMaterial(materialInfo);
                entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                entryInfo.setUnit(materialInfo.getBaseUnit());
                if (materialInfo.getBaseUnit() != null) {
                    entryInfo.setUnitName(materialInfo.getBaseUnit().getName());
                }
                pricePrecision = materialInfo.getPricePrecision();
                if (StringUtils.isEmpty((String)productName)) {
                    entryInfo.setProductName(materialInfo.getName());
                }
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)materialNumber, CompareType.EQUALS));
                view.setFilter(filter);
                MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
                if (coll != null && coll.size() > 0) {
                    materialInfo = coll.get(0);
                    this.materialInfoMap.put(materialNumber, materialInfo);
                    entryInfo.setMaterial(materialInfo);
                    entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                    entryInfo.setUnit(materialInfo.getBaseUnit());
                    if (materialInfo.getBaseUnit() != null) {
                        entryInfo.setUnitName(materialInfo.getBaseUnit().getName());
                    }
                    pricePrecision = materialInfo.getPricePrecision();
                    if (StringUtils.isEmpty((String)productName)) {
                        entryInfo.setProductName(materialInfo.getName());
                    }
                } else {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "MaterialNumberIsNotExist", ctx.getLocale()));
                }
            }
        }
        if (!StringUtils.isEmpty((String)materialNumber) && !StringUtils.isEmpty((String)expenseItemNumber)) {
            throw new TaskExternalException(IMUtils.getString(resClassName, "ExpenseItemError", ctx.getLocale()));
        }
        ExpenseTypeInfo expenseItemInfo = null;
        if (!StringUtils.isEmpty((String)expenseItemNumber)) {
            if (this.expenseTypeInfoMap.containsKey(expenseItemNumber)) {
                expenseItemInfo = this.expenseTypeInfoMap.get(expenseItemNumber);
                entryInfo.setExpenseItem(expenseItemInfo);
                entryInfo.setBaseUnit(expenseItemInfo.getDefaultUnit());
                entryInfo.setUnit(expenseItemInfo.getDefaultUnit());
                if (expenseItemInfo.getDefaultUnit() != null) {
                    entryInfo.setUnitName(expenseItemInfo.getDefaultUnit().getName());
                }
                if (StringUtils.isEmpty((String)productName)) {
                    entryInfo.setProductName(expenseItemInfo.getName());
                }
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)expenseItemNumber, CompareType.EQUALS));
                view.setFilter(filter);
                ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance((Context)ctx).getExpenseTypeCollection(view);
                if (coll != null && coll.size() > 0) {
                    expenseItemInfo = coll.get(0);
                    this.expenseTypeInfoMap.put(expenseItemNumber, expenseItemInfo);
                    entryInfo.setExpenseItem(expenseItemInfo);
                    entryInfo.setBaseUnit(expenseItemInfo.getDefaultUnit());
                    entryInfo.setUnit(expenseItemInfo.getDefaultUnit());
                    if (expenseItemInfo.getDefaultUnit() != null) {
                        entryInfo.setUnitName(expenseItemInfo.getDefaultUnit().getName());
                    }
                    if (StringUtils.isEmpty((String)productName)) {
                        entryInfo.setProductName(expenseItemInfo.getName());
                    }
                } else {
                    throw new TaskExternalException(IMUtils.getString(resClassName, "ExpenseItemIsNotExist", ctx.getLocale()));
                }
            }
        }
        return materialInfo;
    }

    private void checkPermission(Context ctx, String companyId) throws TaskExternalException {
        String permItem = "im_makeInvoiceReq_new";
        if (this.isSltImportUpdate()) {
            permItem = "im_makeInvoiceReq_update";
        }
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(companyId, permItem);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.app.MkInReqImportQuery";
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof MakeInvoiceReqInfo)) {
            return;
        }
        try {
            IMakeInvoiceReq iMakeInvoiceReq = (IMakeInvoiceReq)this.getController(ctx);
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)coreBaseInfo;
            MakeInvoiceReqCollection makeInvoiceReqColl = this.getMakeInvoiceReqColl(ctx, info.getNumber());
            if (makeInvoiceReqColl.size() > 0) {
                iMakeInvoiceReq.delete((IObjectPK)new ObjectUuidPK(makeInvoiceReqColl.get(0).getId()));
                iMakeInvoiceReq.save((CoreBaseInfo)info);
            } else {
                iMakeInvoiceReq.save((CoreBaseInfo)info);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String yes = IMUtils.getResource(resClassName, "YES", ctx);
        String no = IMUtils.getResource(resClassName, "NO", ctx);
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FStatus", (Object)MakeInvoiceReqStatusEnum.getEnum(this.transString2Int(rs.getString("status"))));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FCompany_number", rs.getString("company.number"));
            this.putTable(result, "FPerson_number", rs.getString("person.number"));
            this.putTable(result, "FAsstActType_number", rs.getString("asstActType.number"));
            this.putTable(result, "FAsstActNumber", rs.getString("asstActNumber"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", new BigDecimal(IMUtils.isEmpty(rs.getString("exchangeRate")) ? "0" : rs.getString("exchangeRate")));
            this.putTable(result, "FIsInTax", Boolean.parseBoolean(rs.getString("isInTax")) ? yes : no);
            this.putTable(result, "FInvoiceType", PayInvoiceTypeEnum.getEnum((String)rs.getString("invoiceType")));
            this.putTable(result, "FSpecificService", (Object)SpecificServiceEnum.getEnum(rs.getString("specificService")));
            this.putTable(result, "FRecOrgName", rs.getString("recOrgName"));
            this.putTable(result, "FTaxNumber", rs.getString("taxNumber"));
            this.putTable(result, "FAddress", rs.getString("address"));
            this.putTable(result, "FBankAccount", rs.getString("bankAccount"));
            this.putTable(result, "FDisInvoicer", rs.getString("disInvoicer"));
            this.putTable(result, "FRecBillPhone", rs.getString("recBillPhone"));
            this.putTable(result, "FRecBillComName", rs.getString("recBillComName"));
            this.putTable(result, "FRecBillAdress", rs.getString("recBillAdress"));
            this.putTable(result, "FMailNumber", rs.getString("mailNumber"));
            this.putTable(result, "FRecBillEmail", rs.getString("recBillEmail"));
            this.putTable(result, "FIsPurchaseInvoice", Boolean.parseBoolean(rs.getString("isPurchaseInvoice")) ? yes : no);
            this.putTable(result, "FIsVehicle", Boolean.parseBoolean(rs.getString("isVehicle")) ? yes : no);
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$expenseItem_number", rs.getString("expenseItem.number"));
            this.putTable(result, "FEntries_productName", rs.getString("entries.productName"));
            this.putTable(result, "FEntries$productCode_number", rs.getString("productCode.number"));
            this.putTable(result, "FEntries_specs", rs.getString("entries.specs"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries_unitName", rs.getString("entries.unitName"));
            this.putTable(result, "FEntries_qty", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.qty")) ? "0" : rs.getString("entries.qty")));
            this.putTable(result, "FEntries_isQtyZero", Boolean.parseBoolean(rs.getString("entries.isQtyZero")) ? yes : no);
            this.putTable(result, "FEntries_price", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.price")) ? "0" : rs.getString("entries.price")));
            this.putTable(result, "FEntries_noTaxPrice", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.noTaxPrice")) ? "0" : rs.getString("entries.noTaxPrice")));
            this.putTable(result, "FEntries_taxRate", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.taxRate")) ? "0" : rs.getString("entries.taxRate")));
            this.putTable(result, "FEntries_tax", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.tax")) ? "0" : rs.getString("entries.tax")));
            this.putTable(result, "FEntries_priceExcludingTax", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.priceExcludingTax")) ? "0" : rs.getString("entries.priceExcludingTax")));
            this.putTable(result, "FEntries_priceIncludingTax", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.priceIncludingTax")) ? "0" : rs.getString("entries.priceIncludingTax")));
            this.putTable(result, "FEntries_discountType", DiscountModeEnum.getEnum((int)rs.getInt("entries.discountType")));
            this.putTable(result, "FEntries_discountRate", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.discountRate")) ? "0" : rs.getString("entries.discountRate")));
            this.putTable(result, "FEntries_discountAmount", new BigDecimal(IMUtils.isEmpty(rs.getString("entries.discountAmount")) ? "0" : rs.getString("entries.discountAmount")));
            this.putTable(result, "FEntries_taxClassificationCode", rs.getString("entries.taxClassificationCode"));
            this.putTable(result, "FEntries_remark", rs.getString("entries.remark"));
            this.putTable(result, "FAbstractName", rs.getString("abstractName"));
            this.putTable(result, "FIsDiffTax", Boolean.parseBoolean(rs.getString("isDiffTax")) ? yes : no);
            this.putTable(result, "FEntries_deductRow", (Object)DeductRowEnum.getEnum(rs.getString("entries.deductRow")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Integer transString2Int(String field) throws TaskExternalException {
        if (field != null) {
            try {
                Integer fieldNum = Integer.parseInt(field.trim());
                return fieldNum;
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return 0;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        if (this.getContextParameter().get("isConverParams") != null && "true".equals(this.getContextParameter().get("isConverParams"))) {
            Hashtable temp = firstData;
            firstData = currentData;
            currentData = temp;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public int getSubmitType() {
        return 1;
    }
}

