/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.tm.common.utils.TMParamUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceViewFacadeFactory;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.app.AbstractMakeInvoiceViewFacadeControllerBean;
import com.kingdee.eas.tm.im.util.EncryptUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceViewFacadeControllerBean
extends AbstractMakeInvoiceViewFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.MakeInvoiceViewFacadeControllerBean");

    @Override
    protected Map _buildInvoicePreviewParam(Context ctx, String billID) throws BOSException, EASBizException {
        MakeInvoiceInfo info = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectorForView());
        this.checkBeforeInvoicePreview(ctx, info);
        HashMap<String, Object> result = new HashMap<String, Object>();
        int previewType = -1;
        if (!StringUtils.isEmpty((String)info.getInvoiceUrl())) {
            previewType = 0;
            result.put("invoiceUrl", info.getInvoiceUrl());
        } else if (!StringUtils.isEmpty((String)info.getSnapShotUrl())) {
            previewType = 0;
            result.put("invoiceUrl", info.getSnapShotUrl());
        } else if (InvoiceBillStatus.MAKED.equals((Object)info.getStatus())) {
            previewType = 1;
            result.put("invoiceData", this.buildInvoiceData(ctx, info));
        }
        result.put("previewType", previewType);
        result.put("info", info);
        return result;
    }

    private PwySettingInfo getPwySetting(Context ctx, MakeInvoiceInfo info) throws BOSException, EASBizException {
        String orgid = info.getMakeInvoiceOrgID();
        if (StringUtils.isEmpty((String)orgid)) {
            orgid = info.getCompany().getId().toString();
        }
        PwySettingInfo setting = PwySettingFactory.getLocalInstance(ctx).getCollectionByCompany(orgid, OPTypeEnum.MakeInvoice, info.getId().toString(), null);
        return setting;
    }

    private void checkBeforeInvoicePreview(Context ctx, MakeInvoiceInfo info) throws EASBizException {
        if (InvoiceBillStatus.TEMPSTROE.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "VatInvoicePreviewStatusError1", new String[0])});
        }
    }

    @Override
    protected void _setInvoiceUrl(Context ctx, String billID, String invoiceUrl) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_IM_MakeInvoice set fsnapShotUrl = '").append(invoiceUrl).append("' ");
        sql.append(" where fid = '").append(billID).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected Map _checkBeforeElectricInvoicePreview(Context ctx, List ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        MakeInvoiceCollection invoiceColl = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
        MakeInvoiceInfo invoice = null;
        ArrayList<String> errorMsg = new ArrayList<String>();
        HashMap<String, String> orgMap = new HashMap<String, String>();
        String orgId = null;
        int size = invoiceColl.size();
        for (int i = 0; i < size; ++i) {
            String msg;
            invoice = invoiceColl.get(i);
            orgId = invoice.getCompany().getId().toString();
            if (!orgMap.containsKey(orgId)) {
                try {
                    orgMap.put(orgId, orgId);
                    IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoice.getCompany().getId().toString(), "im_makeInvoice_invoicepreview");
                }
                catch (Exception e) {
                    errorMsg.add(e.getMessage());
                }
            }
            if (!(PayInvoiceTypeEnum.ELECTRONICINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.equals((Object)invoice.getInvoiceType()) || PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.equals((Object)invoice.getInvoiceType()))) {
                msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceViewResource", "ElectricInvoicePreview_InvoiceTypeError", ctx.getLocale(), new Object[]{invoice.getNumber()});
                errorMsg.add(msg);
                continue;
            }
            if (InvoiceBillStatus.MAKED.equals((Object)invoice.getStatus()) || InvoiceBillStatus.DELETED.equals((Object)invoice.getStatus())) continue;
            msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceViewResource", "ElectricInvoicePreview_StatusError", ctx.getLocale(), new Object[]{invoice.getNumber()});
            errorMsg.add(msg);
        }
        String cacheKey = null;
        if (errorMsg.size() == 0 && StringUtils.isEmpty((String)(cacheKey = MakeInvoiceViewFacadeFactory.getLocalInstance(ctx).setIDCache(ids)))) {
            String msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceViewResource", "ElectricInvoicePreview_IDCacheError", ctx.getLocale());
            errorMsg.add(msg);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("errorMsg", errorMsg);
        result.put("cacheKey", cacheKey);
        return result;
    }

    @Override
    protected String _setIDCache(Context ctx, List idList) throws BOSException, EASBizException {
        String cacheKey;
        String tblName = MakeInvoiceViewFacadeControllerBean.getIdTempTable(ctx, "MakeInvoiceIDTemp", idList);
        try {
            cacheKey = EncryptUtil.encrypt(tblName, TMParamUtil.getValue((String)"pwy.secret.defaultkey"));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException("setIDCache error!");
        }
        return cacheKey;
    }

    @Override
    protected List _getIDCache(Context ctx, String cacheKey) throws BOSException, EASBizException {
        ArrayList<String> cacheValue = new ArrayList<String>();
        String tblName = null;
        try {
            tblName = EncryptUtil.decrypt(cacheKey, TMParamUtil.getValue((String)"pwy.secret.defaultkey"));
            StringBuffer sb = new StringBuffer();
            sb.append("select fid from " + tblName);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                cacheValue.add(rs.getString("fid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException("getIDCache error!");
        }
        finally {
            if (!StringUtils.isEmpty(tblName)) {
                TableManagerFacadeFactory.getRemoteInstance().releaseTableName(tblName);
            }
        }
        return cacheValue;
    }

    @Override
    protected void _batchUpdateInvoiceUrl(Context ctx, List params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_IM_MakeInvoice set fsnapShotUrl = ? ");
        sql.append(" where fid = ? ");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)params);
    }

    private Map buildInvoiceData(Context ctx, MakeInvoiceInfo info) throws EASBizException, BOSException {
        HashMap<String, Object> invoiceInfo = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = info.getCompany();
        PwySettingInfo setting = this.getPwySetting(ctx, info);
        invoiceInfo.put("isAsync", 0);
        invoiceInfo.put("machineNo", this.dealNullString(company.getInvoiceNumber()));
        invoiceInfo.put("type", info.isIsRedVoice() ? "1" : "0");
        invoiceInfo.put("invoiceType", 0);
        invoiceInfo.put("amountType", info.isIsContainTax() ? "1" : "0");
        invoiceInfo.put("invoiceCode", this.dealNullString(info.getInvoiceNumber()));
        invoiceInfo.put("invoiceNo", this.dealNullString(info.getInvoiceNo()));
        invoiceInfo.put("invoiceDate", this.dealDateString(info.getInvoiceDate()));
        invoiceInfo.put("totalAmount", this.dealBigDecimalString(info.getNoTaxAmtTotal()));
        invoiceInfo.put("totalTax", this.dealBigDecimalString(info.getTaxAmtTotal()));
        invoiceInfo.put("totalPriceTax", this.dealBigDecimalString(info.getPriceTaxTotal()));
        invoiceInfo.put("drawer", this.dealNullString(info.getDrawertxt()));
        invoiceInfo.put("payee", this.dealNullString(info.getPayeetxt()));
        invoiceInfo.put("reviewer", this.dealNullString(info.getChecktxt()));
        invoiceInfo.put("originalInvoiceCode", "");
        invoiceInfo.put("originalInvoiceNo", "");
        invoiceInfo.put("remark", this.dealNullString(info.getRemark()));
        invoiceInfo.put("salerTaxNo", this.dealNullString(company.getTaxNumber()));
        invoiceInfo.put("salerName", this.dealNullString(company.getRegisteredCode()));
        if (setting != null && !StringUtils.isEmpty((String)setting.getAddressPhone())) {
            invoiceInfo.put("salerAddressPhone", setting.getAddressPhone());
        } else {
            invoiceInfo.put("salerAddressPhone", this.dealNullString(company.getTaxAddress()) + this.dealNullString(company.getContactPhone()));
        }
        if (setting != null && !StringUtils.isEmpty((String)setting.getBankAccount())) {
            invoiceInfo.put("salerAccount", setting.getBankAccount());
        } else {
            invoiceInfo.put("salerAccount", company.getBank() == null ? "" : this.dealNullString(company.getBank().getName()) + this.dealNullString(company.getBankAccount()));
        }
        invoiceInfo.put("buyerTaxNo", this.dealNullString(info.getTaxNumber()));
        invoiceInfo.put("buyerName", this.dealNullString(info.getReceiveCompany()));
        invoiceInfo.put("buyerAddressPhone", this.dealNullString(info.getAddress()));
        invoiceInfo.put("buyerAccount", this.dealNullString(info.getBankAccount()));
        invoiceInfo.put("checkCode", "");
        invoiceInfo.put("secret", "");
        MakeInvoiceEntryCollection entries = info.getEntries();
        ArrayList items = new ArrayList();
        for (int i = 0; i < entries.size(); ++i) {
            MakeInvoiceEntryInfo entry = entries.get(i);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("goodsName", this.dealNullString(entry.getProduceName()));
            item.put("specModel", this.dealNullString(entry.getSpecs()));
            item.put("unit", this.dealNullString(entry.getMakeInvoiceUnit()));
            item.put("num", this.dealBigDecimalString(entry.getQuantity()));
            item.put("unitPrice", this.dealBigDecimalString(entry.getNoTaxPrice()));
            item.put("detailAmount", this.dealBigDecimalString(entry.getNoTaxAmt()));
            item.put("taxRate", this.dealBigDecimalString(entry.getTaxRate().multiply(new BigDecimal("100"))));
            item.put("taxAmount", this.dealBigDecimalString(entry.getTaxAmt()));
            item.put("goodsCode", this.dealNullString(entry.getTaxClassificationCode()));
            item.put("isDiscount", String.valueOf(entry.getBillRowType().getValue()));
            items.add(item);
        }
        invoiceInfo.put("items", items);
        return invoiceInfo;
    }

    private String dealNullString(String str) {
        return str == null ? "" : str.trim();
    }

    private String dealBigDecimalString(BigDecimal value) {
        if (value == null) {
            return "";
        }
        DecimalFormat format = new DecimalFormat("#####0.##########");
        return format.format(value);
    }

    private String dealDateString(Date value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(value);
    }

    private SelectorItemCollection getSelectorForView() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payee.name"));
        sic.add(new SelectorItemInfo("drawer.name"));
        sic.add(new SelectorItemInfo("checker.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.invoiceNumber"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        sic.add(new SelectorItemInfo("company.registeredCode"));
        sic.add(new SelectorItemInfo("company.taxAddress"));
        sic.add(new SelectorItemInfo("company.contactPhone"));
        sic.add(new SelectorItemInfo("company.bank.name"));
        sic.add(new SelectorItemInfo("company.bankAccount"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.measureUnit.name"));
        return sic;
    }

    public static String getIdTempTable(Context ctx, String tableName, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(tableName);
            StringBuffer createSql = new StringBuffer();
            createSql.append(" create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object id : idList) {
                stmt.setString(1, id.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tbl;
    }
}

