/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.message.common.util.Uuid;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IProductCode;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.ProductCompanyCollection;
import com.kingdee.eas.tm.im.ProductCompanyFactory;
import com.kingdee.eas.tm.im.ProductCompanyInfo;
import com.kingdee.eas.tm.im.ProductRelationCollection;
import com.kingdee.eas.tm.im.ProductRelationFactory;
import com.kingdee.eas.tm.im.ProductRelationInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.app.AbstractProductCodeControllerBean;
import com.kingdee.eas.tm.im.app.service.ProductCodeMatchTccCodeService;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.basedata.MatchTccStrategyEnum;
import com.kingdee.eas.tm.im.basedata.app.transformer.BaseDataTransformerFactory;
import com.kingdee.eas.tm.im.basedata.app.transformer.IBaseDataTransformer;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProductCodeControllerBean
extends AbstractProductCodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.ProductCodeControllerBean");
    private static final long serialVersionUID = 1L;
    private int modelLength = 40;
    private static final int NAME_MAX_LENGTH = 255;

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductCodeInfo productCodeInfo = (ProductCodeInfo)model;
        this.initDefaultProperty(productCodeInfo);
        FilterInfo idFilterInfo = new FilterInfo();
        idFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productCodeInfo.getId()));
        boolean ifIdExist = ProductCodeFactory.getLocalInstance(ctx).exists(idFilterInfo);
        ObjectUuidPK retValue = null;
        if (productCodeInfo.getCU() == null) {
            productCodeInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (!productCodeInfo.isIsVehicle()) {
            productCodeInfo.setVehicleType(null);
            productCodeInfo.setFacPlateModel(null);
            productCodeInfo.setOrigin(null);
            productCodeInfo.setTonnage(null);
            productCodeInfo.setLimitPopulation(null);
            productCodeInfo.setProductionEnterprise(null);
        }
        this.trimString(productCodeInfo);
        this.checkPopulationAndTonnage(ctx, productCodeInfo);
        String[] stringProperties = new String[]{"number", "name_l1", "name_l2", "name_l3", "simpleCode", "model", "vehicleType", "facPlateModel", "origin", "tonnage", "limitPopulation", "productionEnterprise", "remark"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)productCodeInfo, stringProperties);
        if (ifIdExist) {
            retValue = new ObjectUuidPK(productCodeInfo.getId());
            if (IMUtils.getStringlength(productCodeInfo.getModel()) > this.modelLength) {
                throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"model_overLength", (Locale)ctx.getLocale(), (Object[])new Object[]{productCodeInfo.getNumber()})});
            }
            super._update(ctx, (IObjectPK)retValue, model);
        } else {
            this.checkBeforeSaveOrUpdate(ctx, productCodeInfo, false);
            retValue = super._save(ctx, model);
            this.processRelation(ctx, (IObjectPK)retValue, productCodeInfo);
        }
        return retValue;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductCodeInfo productCodeInfo = (ProductCodeInfo)model;
        productCodeInfo.setId(BOSUuid.create((String)"268661B5"));
        IObjectPK logPk = LogUtils.beginLog(ctx, "save", BOSObjectType.create((String)"268661B5"), (IObjectPK)new ObjectUuidPK(productCodeInfo.getId().toString()), productCodeInfo.getNumber(), "im_productcode_add", productCodeInfo.getCU().getId().toString());
        this.checkBeforeSaveOrUpdate(ctx, productCodeInfo, false);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)productCodeInfo.getNumber(), CompareType.EQUALS));
        boolean ifExist = ProductCodeFactory.getLocalInstance(ctx).exists(filterInfo);
        if (ifExist) {
            throw new IMException(IMException.NUMBERDUPLICATED);
        }
        this.trimString(productCodeInfo);
        this.checkPopulationAndTonnage(ctx, productCodeInfo);
        String[] stringProperties = new String[]{"number", "name_l1", "name_l2", "name_l3", "simpleCode", "model", "vehicleType", "facPlateModel", "origin", "tonnage", "limitPopulation", "productionEnterprise", "remark"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)productCodeInfo, stringProperties);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)productCodeInfo);
        LogUtils.afterLog(ctx, logPk);
        return pk;
    }

    protected void trimString(ProductCodeInfo productCodeInfo) {
        String[] stringProperties = new String[]{"number", "name_l1", "name_l2", "name_l3", "simpleCode", "model", "vehicleType", "facPlateModel", "origin", "tonnage", "limitPopulation", "productionEnterprise", "remark"};
        String str = null;
        int length = stringProperties.length;
        for (int i = 0; i < length; ++i) {
            str = productCodeInfo.getString(stringProperties[i]) == null ? null : productCodeInfo.getString(stringProperties[i]).trim();
            productCodeInfo.put(stringProperties[i], str);
        }
    }

    protected void checkPopulationAndTonnage(Context ctx, ProductCodeInfo productCodeInfo) throws IMException {
        if (productCodeInfo.isIsVehicle()) {
            StringBuffer errorMsg = new StringBuffer();
            String limitPopulation = productCodeInfo.getLimitPopulation();
            String tonnage = productCodeInfo.getTonnage();
            if (!StringUtils.isEmpty((String)limitPopulation)) {
                try {
                    int intLimitPopulation = Integer.valueOf(limitPopulation);
                    if (intLimitPopulation < 0) {
                        errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"populationNotNegative", (Locale)ctx.getOriginLocale()));
                    }
                }
                catch (NumberFormatException e) {
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"populationNotNegative", (Locale)ctx.getOriginLocale()));
                }
            }
            if (!StringUtils.isEmpty((String)tonnage)) {
                try {
                    BigDecimal numberTonnage = new BigDecimal(tonnage);
                    if (BigDecimal.ZERO.compareTo(numberTonnage) > 0) {
                        if (errorMsg.length() > 0) {
                            errorMsg.append("\u3001");
                        }
                        errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"tonnageNotNegative", (Locale)ctx.getOriginLocale()));
                    }
                }
                catch (NumberFormatException e) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\u3001");
                    }
                    errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"tonnageNotNegative", (Locale)ctx.getOriginLocale()));
                }
            }
            if (errorMsg.length() > 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
            }
        }
    }

    private void initDefaultProperty(ProductCodeInfo productCodeInfo) {
        if (productCodeInfo.getStatus() == ProductCodeStatusEnum.USING) {
            productCodeInfo.setStatus(ProductCodeStatusEnum.USING);
        }
        if (!productCodeInfo.isIsTax()) {
            productCodeInfo.setIsTax(false);
        }
        if (productCodeInfo.getPrice() == null) {
            productCodeInfo.setPrice(BigDecimal.ZERO);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean ifExist;
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        treeBaseInfo.setName(treeBaseInfo.getName());
        FilterInfo filterInfo = new FilterInfo();
        ProductCodeInfo productCodeInfo = (ProductCodeInfo)model;
        IObjectPK logPk = LogUtils.beginLog(ctx, "update", BOSObjectType.create((String)"268661B5"), (IObjectPK)new ObjectUuidPK(productCodeInfo.getId().toString()), productCodeInfo.getNumber(), "im_productcode_update", productCodeInfo.getCU().getId().toString());
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)productCodeInfo.getNumber()));
        if (productCodeInfo.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)productCodeInfo.getId(), CompareType.NOTEQUALS));
        }
        if (ifExist = ProductCodeFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new IMException(IMException.NUMBERDUPLICATED);
        }
        if (IMUtils.getStringlength(productCodeInfo.getModel()) > this.modelLength) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"model_overLength", (Locale)ctx.getLocale(), (Object[])new Object[]{productCodeInfo.getNumber()})});
        }
        this.trimString(productCodeInfo);
        this.checkPopulationAndTonnage(ctx, productCodeInfo);
        String[] stringProperties = new String[]{"vehicleType", "facPlateModel", "origin", "tonnage", "limitPopulation", "productionEnterprise"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)productCodeInfo, stringProperties);
        super._update(ctx, pk, model);
        LogUtils.afterLog(ctx, logPk);
    }

    private ProductRelationCollection getProductCodeRelation(Context ctx, CoreBaseInfo info) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destId", (Object)info.getId().toString()));
        if (info.get("material") == null) {
            return null;
        }
        MaterialInfo material = (MaterialInfo)info.get("material");
        filter.getFilterItems().add(new FilterItemInfo("srcId", (Object)material.getId().toString()));
        if (info.get("customer") != null) {
            CustomerInfo customer = (CustomerInfo)info.get("customer");
            filter.getFilterItems().add(new FilterItemInfo("customerId", (Object)customer.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customerId", null));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setSelector(selector);
        ProductRelationCollection collection = ProductRelationFactory.getLocalInstance(ctx).getCollection(view);
        return collection;
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < pks.size(); ++i) {
            TreeBaseInfo info = null;
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)pks.get(i).toString()));
            info = this.getValueWithParent(ctx, (IObjectPK)pk);
            IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"268661B5"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_productcode_delete", info.getCU().getId().toString());
            if (ProductCodeStatusEnum.USING.equals((Object)this.getProductCodeInfo(ctx, (IObjectPK)pk).getStatus())) {
                errors.add(IMUtils.getIMResource(ctx, "CANNOTDELETE_USING", info.getNumber()));
                continue;
            }
            if (!info.isIsLeaf()) {
                errors.add(IMUtils.getIMResource(ctx, "CANNOTDELETE_NOTLEVEL", info.getNumber()));
            } else {
                Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(info.getId());
                if (isReference.booleanValue()) {
                    errors.add(IMUtils.getIMResource(ctx, "CANNOTDELETE_USED", info.getNumber()));
                } else {
                    this.deleteProductRelation(ctx, info);
                    this._delete(ctx, (IObjectPK)pk);
                }
            }
            LogUtils.afterLog(ctx, logPk);
        }
        return errors;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ProductCodeInfo info = this.getProductCodeInfo(ctx, pk);
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), "im_productcode_delete");
        super._delete(ctx, pk);
    }

    private void deleteProductRelation(Context ctx, TreeBaseInfo info) throws BOSException {
        ProductRelationCollection collection = this.getProductCodeRelation(ctx, (CoreBaseInfo)info);
        if (collection != null && collection.size() == 1) {
            ProductRelationFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(collection.get(0).getId()));
        }
    }

    private String getRandomTempId() {
        return Uuid.create().toString().replace("-", "");
    }

    @Override
    protected void _exchangId(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProductCodeInfo productCodeInfo = (ProductCodeInfo)model;
        String middle = this.getRandomTempId();
        String parentId = productCodeInfo.getParent().getId().toString();
        ProductCodeInfo parent = productCodeInfo.getParent();
        String middleSql = "update T_IM_PRODUCTCODE set fid = '" + middle + "',fisleaf = '" + 0 + "' where fnumber = '" + parent.getNumber() + "'";
        DbUtil.execute((Context)ctx, (String)middleSql);
        productCodeInfo.setParent(null);
        IObjectPK productId = ProductCodeFactory.getLocalInstance(ctx).save((CoreBaseInfo)productCodeInfo);
        String productSql = "update T_IM_PRODUCTCODE set fid = '" + parentId + "' where fnumber = '" + productCodeInfo.getNumber() + "'";
        DbUtil.execute((Context)ctx, (String)productSql);
        String parentSql = "update T_IM_PRODUCTCODE set fid = '" + productId + "' where fnumber = '" + parent.getNumber() + "'";
        DbUtil.execute((Context)ctx, (String)parentSql);
        parent.setId(BOSUuid.read((String)productId.toString()));
        productCodeInfo.setId(BOSUuid.read((String)parentId));
        productCodeInfo.setParent(parent);
        productCodeInfo.setIsLeaf(true);
        ProductCodeFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(parentId), productCodeInfo);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("productid.id"));
        coll.add(new SelectorItemInfo("companyid.id"));
        view.setSelector(coll);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("productid.id", (Object)parentId));
        view.setFilter(filter);
        ProductCompanyCollection collection = ProductCompanyFactory.getLocalInstance(ctx).getCollection(view);
        if (collection != null && collection.size() > 0) {
            ProductCodeInfo tempInfo = new ProductCodeInfo();
            tempInfo.setId(BOSUuid.read((String)productId.toString()));
            for (int i = 0; i < collection.size(); ++i) {
                ProductCompanyInfo info = collection.get(i);
                info.setId(null);
                info.setProductId(tempInfo);
                ProductCompanyFactory.getLocalInstance(ctx).addnew(info);
            }
        }
    }

    @Override
    protected void _impUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        ProductCodeInfo updateInfo = (ProductCodeInfo)model;
        this.checkBeforeSaveOrUpdate(ctx, updateInfo, true);
        this._update(ctx, pk, model);
    }

    protected void checkBeforeSaveOrUpdate(Context ctx, ProductCodeInfo info, boolean isImpCheck) throws BOSException, EASBizException {
        if (info.isHasPreferential() && (info.getPreferentialPolicies() == null || PreferentialPoliciesEnum.Null.equals((Object)info.getPreferentialPolicies()))) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getResource("com.kingdee.eas.tm.im.ProductCodeResource", "ERRORPOLICIES", ctx)});
        }
        if (ProductCodeStatusEnum.USING == info.getStatus() && !this.checkUnique(ctx, info, isImpCheck)) {
            throw new IMException(IMException.EXISTS_PRODUCT);
        }
        if (IMUtils.getStringlength(info.getModel()) > this.modelLength) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.ProductCodeResource", (String)"model_overLength", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()})});
        }
    }

    protected boolean checkUnique(Context ctx, ProductCodeInfo info, boolean isImpCheck) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (info.getCompany() != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("company.id", null));
        }
        boolean hasMaterial = true;
        if (info.getMaterial() != null) {
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)info.getMaterial().getId()));
        } else {
            hasMaterial = false;
        }
        if (info.getExpenseItem() != null) {
            filter.getFilterItems().add(new FilterItemInfo("expenseItem.id", (Object)info.getExpenseItem().getId()));
        } else if (!hasMaterial) {
            return true;
        }
        if (info.getCustomer() != null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)info.getCustomer().getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", null));
        }
        filter.getFilterItems().add(new FilterItemInfo("taxRate", (Object)info.getTaxRate()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isDiffTax", (Object)info.isIsDiffTax()));
        if (info.getFieldStr1() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr1", (Object)info.getFieldStr1()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr1", null));
        }
        if (info.getFieldStr2() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr2", (Object)info.getFieldStr2()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr2", null));
        }
        if (info.getFieldStr3() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr3", (Object)info.getFieldStr3()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr3", null));
        }
        if (info.getFieldStr4() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr4", (Object)info.getFieldStr4()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldStr4", null));
        }
        if (info.getFieldDecimal5() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal5", (Object)info.getFieldDecimal5()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal5", null));
        }
        if (info.getFieldDecimal6() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal6", (Object)info.getFieldDecimal6()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal6", null));
        }
        if (info.getFieldDecimal7() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal7", (Object)info.getFieldDecimal7()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal7", null));
        }
        if (info.getFieldDecimal8() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal8", (Object)info.getFieldDecimal8()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fieldDecimal8", null));
        }
        if (isImpCheck) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        ProductCodeCollection collection = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
        return collection == null || collection.size() <= 0;
    }

    private ProductCodeCollection getProductCodeColl(Context ctx, List pks) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(pks), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        ProductCodeCollection coll = this.getProductCodeCollection(ctx, viewInfo);
        return coll;
    }

    @Override
    protected ArrayList _setActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        ProductCodeCollection coll = null;
        coll = this.getProductCodeColl(ctx, pks);
        ProductCodeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement updateSql = null;
        try {
            String uniqueMsg = new IMException(IMException.EXISTS_PRODUCT).getMessage();
            conn = EJBFactory.getConnection((Context)ctx);
            updateSql = conn.prepareStatement("update t_im_productCode set FStatus = 0 where FID = ? ");
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                IObjectPK logPk = LogUtils.beginLog(ctx, "active", BOSObjectType.create((String)"268661B5"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_productcode_active", info.getCU().getId().toString());
                if (info.getTaxClassificationCode() == null) {
                    errors.add(IMUtils.getIMResource(ctx, "TCCNULL", info.getNumber()));
                    continue;
                }
                if (IMUtils.getStringlength(info.getModel()) > this.modelLength) {
                    errors.add(IMUtils.getIMResource(ctx, "model_overLength", info.getNumber()));
                    continue;
                }
                if (info.isHasPreferential() && (info.getPreferentialPolicies() == null || PreferentialPoliciesEnum.Null.equals((Object)info.getPreferentialPolicies()))) {
                    errors.add(IMUtils.getResource("com.kingdee.eas.tm.im.ProductCodeResource", "ERRORPOLICIES", ctx));
                    continue;
                }
                if (!this.checkUnique(ctx, info, true)) {
                    errors.add(info.getNumber() + ":" + uniqueMsg);
                    continue;
                }
                if (info.getStatus() == ProductCodeStatusEnum.USING) {
                    errors.add(IMUtils.getIMResource(ctx, "CANNOTACTIVE_ACTIVED", info.getNumber()));
                    continue;
                }
                if (info.getTaxRate() == null) {
                    errors.add(info.getNumber() + "\uff1a" + IMUtils.getIMResource(ctx, "TAXRATEISNULL", info.getNumber()));
                    continue;
                }
                updateSql.setString(1, info.getId().toString());
                updateSql.execute();
                LogUtils.afterLog(ctx, logPk);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateSql);
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateSql);
        SQLUtils.cleanup((Connection)conn);
        return errors;
    }

    @Override
    protected ArrayList _setUnActive(Context ctx, ArrayList pks) throws BOSException, EASBizException {
        ProductCodeCollection coll = this.getProductCodeColl(ctx, pks);
        ProductCodeInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement updateSql = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            updateSql = conn.prepareStatement("update t_im_productCode set FStatus = 1 where FID = ? ");
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                IObjectPK logPk = LogUtils.beginLog(ctx, "unactive", BOSObjectType.create((String)"268661B5"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_productcode_unavtive", info.getCU().getId().toString());
                if (info.getStatus() != ProductCodeStatusEnum.USING) {
                    errors.add(IMUtils.getIMResource(ctx, "CANNOTUNACTIVE_NOTACTIVED", info.getNumber()));
                    continue;
                }
                updateSql.setString(1, info.getId().toString());
                updateSql.execute();
                LogUtils.afterLog(ctx, logPk);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateSql);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateSql);
        SQLUtils.cleanup((Connection)conn);
        return errors;
    }

    @Override
    protected IObjectValue _combin(Context ctx, String[] billIds) throws BOSException, EASBizException {
        ProductCodeInfo productCodeInfo = this.getFirstProductInfo(ctx, billIds);
        productCodeInfo.setId(null);
        productCodeInfo.setNumber(null);
        productCodeInfo.setMaterial(null);
        return productCodeInfo;
    }

    private ProductCodeInfo getFirstProductInfo(Context ctx, String[] billIds) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = this.getSelector();
        FilterInfo filter = new FilterInfo();
        String id = billIds[0];
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        ev.setSelector(selector);
        ev.setFilter(filter);
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(ev);
        if (coll != null && coll.size() == 1) {
            return coll.get(0);
        }
        throw new BOSException("id not exist");
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("company.id");
        selector.add("company.name");
        selector.add("company.number");
        selector.add("unit.id");
        selector.add("unit.name");
        selector.add("superiorProductName");
        selector.add("simpleCode");
        selector.add("model");
        selector.add("taxRate");
        selector.add("price");
        selector.add("isTax");
        selector.add("status");
        selector.add("remark");
        selector.add("isLeaf");
        selector.add("level");
        selector.add("longNumber");
        selector.add("parent.id");
        selector.add("parent.name");
        selector.add("material.id");
        selector.add("material.name");
        selector.add("material.number");
        selector.add("expenseItem.id");
        selector.add("expenseItem.name");
        selector.add("expenseItem.number");
        selector.add("customer.id");
        selector.add("customer.name");
        selector.add("customer.number");
        selector.add("taxClassificationCode.id");
        selector.add("taxClassificationCode.name");
        selector.add("taxClassificationCode.number");
        selector.add("taxClassificationCode.taxRate");
        return selector;
    }

    @Override
    protected IObjectPK _saveCombin(Context ctx, IObjectValue model, String[] billIds) throws BOSException, EASBizException {
        IObjectPK retValue = this._save(ctx, model);
        this.reverseProductRelation(ctx, retValue, billIds);
        return retValue;
    }

    private void reverseProductRelation(Context ctx, IObjectPK retValue, String[] billIds) throws BOSException {
        StringBuffer sb = new StringBuffer();
        for (String id : billIds) {
            sb.append("'" + id + "',");
        }
        String updateIds = null;
        if (sb.length() > 0) {
            updateIds = sb.substring(0, sb.length() - 1);
        }
        this.updateProductIsCombinStatus(ctx, 1, updateIds);
        ProductRelationInfo relation = null;
        List<String> idList = Arrays.asList(billIds);
        ProductCodeCollection productCodeColl = this.getProductCodeColl(ctx, idList);
        for (int i = 0; i < productCodeColl.size(); ++i) {
            ProductCodeInfo productCodeInfo = productCodeColl.get(i);
            relation = new ProductRelationInfo();
            relation.setDestId(retValue.toString());
            relation.setSrcId(productCodeInfo.getId().toString());
            relation.setType("PRODUCTCODE");
            ProductRelationFactory.getLocalInstance(ctx).addnew(relation);
        }
    }

    private void updateProductIsCombinStatus(Context ctx, int bool, String updateIds) throws BOSException {
        String updateSql = "update t_im_productCode set FIsCombin = " + bool + " where fid in (" + updateIds + ")";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    private void processRelation(Context ctx, IObjectPK objectPk, ProductCodeInfo productInfo) throws BOSException {
        MaterialInfo material = productInfo.getMaterial();
        ExpenseTypeInfo expenseItem = productInfo.getExpenseItem();
        CustomerInfo customer = productInfo.getCustomer();
        ProductRelationInfo relation = new ProductRelationInfo();
        relation.setDestId(objectPk.toString());
        relation.setDestNumber(productInfo.getNumber());
        if (customer != null) {
            relation.setCustomerId(customer.getId().toString());
        }
        if (material != null) {
            relation.setType("MATERIAL");
            relation.setSrcId(material.getId().toString());
            relation.setSrcNumber(material.getNumber());
            ProductRelationFactory.getLocalInstance(ctx).addnew(relation);
        }
        if (expenseItem != null) {
            relation.setType("EXPENSEITEM");
            relation.setSrcId(expenseItem.getId().toString());
            relation.setSrcNumber(expenseItem.getNumber());
            ProductRelationFactory.getLocalInstance(ctx).addnew(relation);
        }
    }

    private IObjectValue getnotCombinProductCodeInfo(Context ctx, ProductCodeInfo productCodeInfo) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcId", (Object)productCodeInfo.getId().toString()));
        ev.setFilter(filter);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("destId");
        select.add("destNumber");
        select.add("type");
        select.add("srcId");
        ev.setSelector(select);
        ProductRelationCollection collection = ProductRelationFactory.getLocalInstance(ctx).getCollection(ev);
        if (collection.size() == 1) {
            ProductRelationInfo productRelationInfo = collection.get(0);
            String destId = productRelationInfo.getDestId();
            ProductCodeInfo product = ProductCodeFactory.getLocalInstance(ctx).getProductCodeInfo((IObjectPK)new ObjectUuidPK(destId));
            if (!product.isIsCombin()) {
                return product;
            }
            return this.getnotCombinProductCodeInfo(ctx, product);
        }
        return null;
    }

    @Override
    protected IObjectValue _getProductCodeInfoBySrcNumber(Context ctx, String srcNumber, String srcType) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcNumber", (Object)srcNumber));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)srcType));
        ev.setFilter(filter);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("destId");
        select.add("destNumber");
        select.add("type");
        select.add("srcId");
        select.add("model");
        select.add("*");
        ev.setSelector(select);
        ProductRelationCollection collection = ProductRelationFactory.getLocalInstance(ctx).getCollection(ev);
        if (collection.size() == 1) {
            ProductRelationInfo productRelationInfo = collection.get(0);
            String destId = productRelationInfo.getDestId();
            ProductCodeInfo productCodeInfo = ProductCodeFactory.getLocalInstance(ctx).getProductCodeInfo((IObjectPK)new ObjectUuidPK(destId));
            if (!productCodeInfo.isIsCombin()) {
                return productCodeInfo;
            }
            return this.getnotCombinProductCodeInfo(ctx, productCodeInfo);
        }
        return null;
    }

    @Override
    protected String _batchModify(Context ctx, Set idSet, Map param) throws BOSException, EASBizException {
        String productName = (String)param.get("productName");
        TaxClassificationCodeInfo taxClassificationCode = (TaxClassificationCodeInfo)param.get("taxClassificationCode");
        TaxClassificationCodeInfo taxClass = (TaxClassificationCodeInfo)param.get("taxClass");
        BigDecimal taxRate = (BigDecimal)param.get("taxRate");
        Boolean hasPreferential = (Boolean)param.get("hasPreferential");
        PreferentialPoliciesEnum preferentialPolicies = (PreferentialPoliciesEnum)((Object)param.get("preferentialPolicies"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        StringBuffer errorBuffer = new StringBuffer();
        ProductCodeCollection collection = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ProductCodeInfo productInfo = (ProductCodeInfo)iter.next();
            if (productName != null) {
                String productNameStr = IMUtils.cutStr(productName, 255);
                productInfo.setName(productNameStr);
            } else {
                productInfo.setTaxClassificationCode(taxClassificationCode);
                productInfo.setTaxClass(taxClass);
                productInfo.setTaxRate(taxRate);
                productInfo.setHasPreferential(hasPreferential);
                productInfo.setPreferentialPolicies(preferentialPolicies);
            }
            ObjectUuidPK retValue = new ObjectUuidPK(productInfo.getId());
            try {
                this._update(ctx, (IObjectPK)retValue, (IObjectValue)productInfo);
            }
            catch (EASBizException e) {
                errorBuffer.append(productInfo.getNumber() + ":" + e.getMessage() + "<br/>");
            }
        }
        return errorBuffer.toString();
    }

    @Override
    protected Map _batchSave(Context ctx, ProductCodeInfo[] model) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        HashMap<String, Object> result = new HashMap<String, Object>();
        int success = 0;
        int error = 0;
        for (int i = 0; i < model.length; ++i) {
            try {
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)model[i].getNumber()));
                boolean ifExist = ProductCodeFactory.getLocalInstance(ctx).exists(filterInfo);
                if (ifExist) {
                    throw new IMException(IMException.NUMBERDUPLICATED);
                }
                this.checkBeforeSaveOrUpdate(ctx, model[i], false);
                IObjectPK retValue = super._save(ctx, (IObjectValue)model[i]);
                this.processRelation(ctx, retValue, model[i]);
                ProductCodeFactory.getLocalInstance(ctx).save((CoreBaseInfo)model[i]);
                ++success;
                continue;
            }
            catch (Exception e) {
                errorMsg.append(model[i].getNumber()).append(":").append(e.getMessage()).append("\r\n");
                ++error;
            }
        }
        result.put("success", success);
        result.put("error", error);
        result.put("errorMsg", errorMsg.toString());
        return result;
    }

    @Override
    protected Map _addByTaxRate(Context ctx, Map rateMap) throws BOSException, EASBizException {
        CtrlUnitInfo currentCtrlUnit = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        UserInfo currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        StringBuffer instanceDeatil = new StringBuffer();
        Set keySet = rateMap.keySet();
        HashSet rateSet = new HashSet();
        for (Object o : keySet) {
            if ("suffix".equals(o.toString())) continue;
            rateSet.add(o);
            instanceDeatil.append(o.toString()).append("->").append(rateMap.get(o).toString()).append("\t");
        }
        String suffix = rateMap.get("suffix").toString();
        IObjectPK logPk = LogUtils.beginLog(ctx, "addByTaxRate", BOSObjectType.create((String)"268661B5"), null, instanceDeatil.toString(), "im_productcode_addByTaxRate", currentCtrlUnit.getId().toString());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxRate", rateSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0));
        view.setFilter(filter);
        ProductCodeCollection productCodeCollection = this.getProductCodeCollection(ctx, view);
        ProductCodeInfo[] newProducts = new ProductCodeInfo[productCodeCollection.size()];
        Timestamp nowTs = new Timestamp(System.currentTimeMillis());
        for (int i = 0; i < productCodeCollection.size(); ++i) {
            ProductCodeInfo productCodeInfo = productCodeCollection.get(i);
            productCodeInfo.setTaxRate((BigDecimal)rateMap.get(productCodeInfo.getTaxRate().setScale(4, RoundingMode.HALF_UP)));
            productCodeInfo.setId(BOSUuid.create((String)"268661B5"));
            productCodeInfo.setNumber(productCodeInfo.getNumber() + suffix);
            if (productCodeInfo.getTaxRate() != null && productCodeInfo.getTaxRate().intValue() == 0) {
                productCodeInfo.setHasPreferential(false);
                productCodeInfo.setPreferentialPolicies(PreferentialPoliciesEnum.Null);
            }
            productCodeInfo.setSourceType(ProductCodeSourceTypeEnum.MANUAL);
            productCodeInfo.setCU(currentCtrlUnit);
            productCodeInfo.setCreateTime(nowTs);
            productCodeInfo.setCreator(currentUserInfo);
            productCodeInfo.setLastUpdateTime(nowTs);
            productCodeInfo.setLastUpdateUser(currentUserInfo);
            newProducts[i] = productCodeInfo;
        }
        Map result = this._batchSave(ctx, newProducts);
        LogUtils.afterLog(ctx, logPk);
        return result;
    }

    @Override
    protected Map _syncProductCode(Context ctx, String bosType, Map param) throws BOSException, EASBizException {
        LowTimer timer = new LowTimer();
        HashMap result = new HashMap();
        try {
            IProductCode iProductCode = ProductCodeFactory.getLocalInstance(ctx);
            HashSet<Object> srcIdSet = new HashSet<Object>();
            if (param.containsKey("info")) {
                IObjectValue info = (IObjectValue)param.get("info");
                srcIdSet.add(info.get("id"));
            } else if (param.containsKey("idList")) {
                List idList = (List)param.get("idList");
                srcIdSet.addAll(idList);
            } else {
                throw new IMException(IMException.ERRORMSG, new Object[]{"param Error !"});
            }
            IBaseDataTransformer transformer = BaseDataTransformerFactory.getTransformer(ctx, bosType, "268661B5");
            IObjectCollection values = transformer.transform(srcIdSet, param);
            this.autoMatchTccCode(ctx, values);
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                iProductCode.saveRequiresNew(values.getObject(i));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            throw new BOSException(e);
        }
        finally {
            logger.error((Object)("[syncProductCode]\uff1aTotal Time :" + timer.msValue()));
        }
        return result;
    }

    protected void autoMatchTccCode(Context ctx, IObjectCollection productCodes) throws EASBizException, BOSException {
        try {
            ProductCodeCollection newColls = new ProductCodeCollection();
            ProductCodeInfo info = null;
            int size = productCodes.size();
            for (int i = 0; i < size; ++i) {
                info = (ProductCodeInfo)productCodes.getObject(i);
                if (!info.isAutoMatchTccCode()) continue;
                newColls.addObject((IObjectValue)info);
            }
            if (newColls.size() == 0) {
                return;
            }
            ProductCodeMatchTccCodeService service = new ProductCodeMatchTccCodeService();
            service.match(ctx, (IObjectCollection)newColls, MatchTccStrategyEnum.firstMatch, true);
        }
        catch (Exception e) {
            logger.error((Object)("\u3010autoMatchTccCode\u3011error:" + e.getMessage()), (Throwable)e);
        }
    }

    protected boolean filterExist(Context ctx, String bosType, Set idSet) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        String fieldName = "FMaterialID";
        if ("78E4BC94".equals(bosType)) {
            fieldName = "FExpenseItemID";
        }
        sql.append(" select ").append(fieldName).append(" from T_IM_ProductCode where ");
        sql.append(fieldName).append(" in ").append(IMUtils.getInStringFromSet(idSet));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            String id = rowSet.getString(1);
            idSet.remove(id);
            logger.error((Object)("[syncProductCode] filterExist id : " + id));
        }
        return idSet.size() > 0;
    }

    @Override
    protected IObjectValue _getMatchProduct(Context ctx, String customerID, String companyID, String materialID, String expenseTypeID, BigDecimal taxRate, boolean isVehicle, boolean isDiffTax) throws BOSException, EASBizException {
        ProductCodeInfo product = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (taxRate == null) {
            return product;
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxRate", (Object)taxRate.divide(new BigDecimal(100)).setScale(4, 4)));
        if (!StringUtils.isEmpty((String)materialID)) {
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialID));
        } else if (!StringUtils.isEmpty((String)expenseTypeID)) {
            filter.getFilterItems().add(new FilterItemInfo("expenseItem", (Object)expenseTypeID));
        }
        FilterInfo filterForBool = new FilterInfo();
        if (!isDiffTax) {
            filterForBool.getFilterItems().add(new FilterItemInfo("isDiffTax", (Object)false, CompareType.EQUALS));
            filterForBool.getFilterItems().add(new FilterItemInfo("isDiffTax", null, CompareType.EQUALS));
            filterForBool.setMaskString("(#0 or #1)");
        } else {
            filterForBool.getFilterItems().add(new FilterItemInfo("isDiffTax", (Object)true, CompareType.EQUALS));
        }
        if (isVehicle) {
            filter.getFilterItems().add(new FilterItemInfo("taxClassificationCode.simpleName", (Object)"\u673a\u52a8\u8f66", CompareType.EQUALS));
        }
        filter.mergeFilter(filterForBool, "AND");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("model"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("hasPreferential"));
        sic.add(new SelectorItemInfo("preferentialPolicies"));
        sic.add(new SelectorItemInfo("taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("taxClassificationCode.simpleName"));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("customer.id"));
        view.setSorter(sort);
        view.setFilter(filter);
        view.setSelector(sic);
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
        if (coll != null && coll.size() > 0) {
            ProductCodeCollection sameCustomer = new ProductCodeCollection();
            ProductCodeCollection sameCompany = new ProductCodeCollection();
            ProductCodeCollection allNull = new ProductCodeCollection();
            for (int i = 0; i < coll.size(); ++i) {
                ProductCodeInfo info = coll.get(i);
                if (info.getCustomer() != null && info.getCompany() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID) || !info.getCompany().getId().toString().equals(companyID)) continue;
                    return info;
                }
                if (info.getCompany() != null) {
                    if (!info.getCompany().getId().toString().equals(companyID)) continue;
                    sameCompany.add(info);
                    continue;
                }
                if (info.getCustomer() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID)) continue;
                    sameCustomer.add(info);
                    continue;
                }
                allNull.add(info);
            }
            if (sameCompany.size() > 0) {
                product = sameCompany.get(0);
            } else if (sameCustomer.size() > 0) {
                product = sameCustomer.get(0);
            } else if (allNull.size() > 0) {
                product = allNull.get(0);
            }
        }
        return product;
    }

    @Override
    protected Map _matchTccCode(Context ctx, Map params) throws BOSException, EASBizException {
        IObjectCollection productCodes = (IObjectCollection)params.get("productCodes");
        MatchTccStrategyEnum matchTccStrategy = (MatchTccStrategyEnum)((Object)params.get("matchTccStrategy"));
        boolean ignoreMatched = (Boolean)params.get("ignoreMatched");
        ProductCodeMatchTccCodeService service = new ProductCodeMatchTccCodeService();
        service.match(ctx, productCodes, matchTccStrategy, ignoreMatched);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("productCodes", productCodes);
        result.put("tccInfoMap", service.getTccInfoMap());
        return result;
    }

    @Override
    protected Map _batchSave(Context ctx, IObjectCollection productCodes) throws BOSException, EASBizException {
        BatchExecuteResult exeResult;
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)"268661B5"));
        HashMap<String, String> result = new HashMap<String, String>();
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[productCodes.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = new Class[]{CoreBaseInfo.class};
        int size = productCodes.size();
        for (int i = 0; i < size; ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            entry.add(0, (Object)productCodes.getObject(i));
            paramEntries[i] = entry;
        }
        try {
            ServiceStateManager.getInstance().enableNextCallServices();
            ServiceStateManager.getInstance().getServiceState().enableServices();
            exeResult = bizCtrl.batchExecute("save", new Class[]{CoreBaseInfo.class}, paramEntries);
        }
        catch (BaseException e) {
            if (e instanceof BOSException) {
                throw (BOSException)((Object)e);
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
        int errorCount = 0;
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                IObjectValue value = (IObjectValue)paramEntries[i].get(0);
                result.put(value.getString("number"), exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            errorCount = result.size();
            BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
            for (int i = 0; i < paramEntries.length; ++i) {
                IObjectValue value = (IObjectValue)paramEntries[i].get(0);
                ActionResult actionResult = actionResults.getActionResult((Object)"number");
                if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                result.put(value.getString("number"), actionResult.getMessage());
                ++errorCount;
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
        result.put("SUCCESS_COUNT", String.valueOf(productCodes.size() - errorCount));
        return result;
    }

    @Override
    protected IObjectPK _saveRequiresNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._save(ctx, model);
    }
}

