/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCompanyCollection;
import com.kingdee.eas.tm.im.ProductCompanyFactory;
import com.kingdee.eas.tm.im.ProductCompanyInfo;
import com.kingdee.eas.tm.im.app.AbstractProductCompanyControllerBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ProductCompanyControllerBean
extends AbstractProductCompanyControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.ProductCompanyControllerBean");

    @Override
    protected String _productAllocation(Context ctx, String productIds, String companyIds) throws BOSException, EASBizException {
        List<String> allNodes = this.getAllParentPks(ctx, productIds);
        CtrlUnitCollection cUColl = this.getAllParentCU(ctx, companyIds);
        for (String proId : allNodes) {
            for (int i = 0; i < cUColl.size(); ++i) {
                String comId = cUColl.get(i).getId().toString();
                boolean createCu = this.isCreateCu(ctx, proId, comId);
                boolean exist = this.isExist(ctx, proId, comId);
                if (exist || createCu) continue;
                ProductCompanyInfo pc = new ProductCompanyInfo();
                ProductCodeInfo product = new ProductCodeInfo();
                product.setId(BOSUuid.read((String)proId));
                pc.setProductId(product);
                CtrlUnitInfo company = new CtrlUnitInfo();
                company.setId(BOSUuid.read((String)comId));
                pc.setCompanyId(company);
                ProductCompanyFactory.getLocalInstance(ctx).addnew(pc);
            }
        }
        return "success";
    }

    @Override
    protected String _productReverseAllocation(Context ctx, String productIds, String companyId) throws BOSException, EASBizException {
        int result = 0;
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        CoreBaseCollection childColl = this.getAllChildColl(ctx, ctrlUnitInfo);
        String ctrlUnitIds = ctrlUnitInfo.getId().toString() + ",";
        for (int i = 0; i < childColl.size(); ++i) {
            ctrlUnitIds = ctrlUnitIds + childColl.get(i).getId().toString() + ",";
        }
        if (ctrlUnitIds.length() > 0) {
            ctrlUnitIds = ctrlUnitIds.substring(0, ctrlUnitIds.length() - 1);
        }
        result = this.reverseProductcode(ctx, productIds, ctrlUnitIds);
        List<String> allNodes = this.getAllParentPks(ctx, productIds);
        for (String proId : allNodes) {
            for (String comId : ctrlUnitIds.split(",")) {
                if (!this.isAllChildReverse(ctx, proId, comId)) continue;
                result += this.reverseProductcode(ctx, proId, comId);
            }
        }
        return String.valueOf(result);
    }

    private boolean isExist(Context ctx, String proId, String comId) throws BOSException {
        boolean result = false;
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyId.id", (Object)comId));
        filter.getFilterItems().add(new FilterItemInfo("productId.id", (Object)proId));
        ev.setSelector(coll);
        ev.setFilter(filter);
        ProductCompanyCollection collection = ProductCompanyFactory.getLocalInstance(ctx).getCollection(ev);
        if (collection.size() > 0) {
            result = true;
        }
        return result;
    }

    private boolean isCreateCu(Context ctx, String proId, String comId) throws EASBizException, BOSException {
        SelectorItemCollection select = new SelectorItemCollection();
        select.add(new SelectorItemInfo("company.longnumber"));
        ProductCodeInfo productCodeInfo = ProductCodeFactory.getLocalInstance(ctx).getProductCodeInfo((IObjectPK)new ObjectUuidPK(proId), select);
        String longNumber = productCodeInfo.getCompany().getLongNumber();
        if (longNumber != null && longNumber.length() > 0) {
            String[] numberArr = longNumber.split("!");
            CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(comId));
            String comNumber = ctrlUnitInfo.getNumber();
            for (String num : numberArr) {
                if (!comNumber.equals(num)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAllChildReverse(Context ctx, String productId, String companyId) throws BOSException {
        String childProductIds = "";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)productId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        viewInfo.setSelector(selector);
        viewInfo.setFilter(filter);
        ProductCodeCollection productCodeCollection = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(viewInfo);
        if (productCodeCollection != null && productCodeCollection.size() > 0) {
            for (int i = 0; i < productCodeCollection.size(); ++i) {
                ProductCodeInfo productCodeInfo = productCodeCollection.get(i);
                childProductIds = childProductIds + productCodeInfo.getId() + ",";
            }
        }
        if (childProductIds.length() > 0) {
            childProductIds = childProductIds.substring(0, childProductIds.length() - 1);
            viewInfo = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("companyId.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("productId.id", (Object)childProductIds, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            ProductCompanyCollection collection = ProductCompanyFactory.getLocalInstance(ctx).getCollection(viewInfo);
            if (collection != null && collection.size() > 0) {
                return false;
            }
        }
        return true;
    }

    private int reverseProductcode(Context ctx, String productId, String companyIds) {
        IObjectPK[] delete = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyId.id", (Object)companyIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("productId.id", (Object)productId, CompareType.INCLUDE));
        try {
            delete = ProductCompanyFactory.getLocalInstance(ctx).delete(filter);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return 0;
        }
        return delete.length;
    }

    private List<String> getAllParentPks(Context ctx, String productIds) throws EASBizException, BOSException {
        String[] proArr = productIds.split(",");
        ArrayList<String> productPks = new ArrayList<String>();
        for (int i = 0; i < proArr.length; ++i) {
            productPks.add(proArr[i]);
        }
        ArrayList<String> list = new ArrayList<String>();
        String updateNumbers = "";
        ProductCodeCollection productCodeColl = this.getProductCodeColl(ctx, productPks);
        for (int i = 0; i < productCodeColl.size(); ++i) {
            ProductCodeInfo info = productCodeColl.get(i);
            String[] parentNumbers = info.getLongNumber().split("\\!");
            for (int j = 0; j < parentNumbers.length; ++j) {
                updateNumbers = updateNumbers + "" + parentNumbers[j].toString() + ",";
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("id"));
        coll.add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterInfo = new FilterItemInfo("number", (Object)updateNumbers, CompareType.INCLUDE);
        filter.getFilterItems().add(filterInfo);
        ev.setSelector(coll);
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("longNumber");
        sorterItemInfo.setSortType(SortType.DESCEND);
        sorter.add(sorterItemInfo);
        ev.setSorter(sorter);
        CoreBaseCollection collection = ProductCodeFactory.getLocalInstance(ctx).getCollection(ev);
        for (int k = 0; k < collection.size(); ++k) {
            if (list.contains(collection.get(k).getId().toString())) continue;
            list.add(collection.get(k).getId().toString());
        }
        return list;
    }

    private CtrlUnitCollection getAllParentCU(Context ctx, String companyIds) throws BOSException {
        StringBuffer numbers = new StringBuffer();
        String oql = "select id,name,longNumber where id in (" + companyIds + ")";
        CtrlUnitCollection cUColl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(oql);
        for (int i = 0; i < cUColl.size(); ++i) {
            String[] numberArr;
            for (String number : numberArr = cUColl.get(i).getLongNumber().split("!")) {
                numbers.append("").append(number).append(",");
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("id");
        ev.getSelector().add("name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers.toString(), CompareType.INCLUDE));
        ev.setFilter(filter);
        CtrlUnitCollection cuColl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(ev);
        return cuColl;
    }

    private ProductCodeCollection getProductCodeColl(Context ctx, List pks) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(pks), CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        viewInfo.getSelector().add(new SelectorItemInfo("status"));
        viewInfo.getSelector().add(new SelectorItemInfo("CU.id"));
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(viewInfo);
        return coll;
    }

    private CoreBaseCollection getAllChildColl(Context ctx, CtrlUnitInfo ctrlUnitInfo) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        ev.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(ctrlUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        ev.setFilter(filter);
        CoreBaseCollection childColl = CtrlUnitFactory.getLocalInstance((Context)ctx).getCollection(ev);
        return childColl;
    }
}

