/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TM_FOG_CALCULAOR {
    private static Logger logger = Logger.getLogger(TM_FOG_CALCULAOR.class);
    public static final BigDecimal zeroValue = new BigDecimal("0.00");
    private ICalculateContextProvider provider = null;
    private Context ctx = null;
    private Connection conn = null;
    private PreparedStatement amtStat = null;
    public static final String NOTAXAMT = "NTA";
    public static final String TAXAMT = "TA";

    public TM_FOG_CALCULAOR(ICalculateContextProvider provider, Context ctx) {
        this.provider = provider;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(SortedParameterArray params, String methodName) {
        try {
            this.conn = EJBFactory.getConnection((Context)this.ctx);
            for (int i = 0; i < params.size(); ++i) {
                Parameter param = params.getParameter(i);
                Object[] inputsArray = param.getArgs();
                Object[] inputs = (Object[])inputsArray[0];
                BigDecimal result = zeroValue;
                String amtType = ((Variant)inputs[inputs.length - 1]).toString();
                String sql = "";
                try {
                    if (methodName.equalsIgnoreCase("TM_OutputVAT")) {
                        sql = this.getSql(((Variant)inputs[0]).toString(), ((Variant)inputs[1]).toString(), ((Variant)inputs[2]).toString(), ((Variant)inputs[3]).toString(), ((Variant)inputs[4]).toString(), NOTAXAMT.equals(amtType) ? "FNOTAXAMTTOTAL" : "FTAXAMTTOTAL");
                    } else if (methodName.equalsIgnoreCase("TM_InputVAT")) {
                        sql = this.getSql(((Variant)inputs[0]).toString(), ((Variant)inputs[1]).toString(), ((Variant)inputs[2]).toString(), ((Variant)inputs[3]).toString(), ((Variant)inputs[4]).toString(), ((Variant)inputs[5]).toString(), NOTAXAMT.equals(amtType) ? "FAmount" : "FTAX");
                    }
                    result = this.getAmt(this.ctx, sql);
                    param.setValue((Object)result);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"------------TM_FOG_CALCULAOR exception info start1---------------");
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    logger.error((Object)e.getCause());
                    logger.error((Object)"------------TM_FOG_CALCULAOR exception info end1--------------");
                    param.setValue((Object)(e.getCause() == null ? e.getCause().getMessage() : e.getMessage()));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"------------TM_FOG_CALCULAOR exception info start2---------------");
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)e.getCause());
            logger.error((Object)"------------TM_FOG_CALCULAOR exception info end2--------------");
        }
        catch (Exception e) {
            logger.error((Object)"------------TM_FOG_CALCULAOR exception info start3---------------");
            logger.error((Object)e.getMessage(), (Throwable)e);
            logger.error((Object)e.getCause());
            logger.error((Object)"------------TM_FOG_CALCULAOR exception info start3---------------");
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getAmt(Context ctx, String sql) {
        ResultSet rs = null;
        try {
            BigDecimal amountTotal;
            this.amtStat = this.conn.prepareStatement(sql);
            rs = this.amtStat.executeQuery();
            if (rs.next() && (amountTotal = rs.getBigDecimal("amountTotal")) != null) {
                BigDecimal bigDecimal = amountTotal;
                return bigDecimal;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Statement)this.amtStat);
        }
        return zeroValue;
    }

    private String getSql(String companyNum, String startDate, String endDate, String invoiceType, String status, String authenticStatus, String field) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("SELECT SUM(").append(field).append(") amountTotal");
        sbSql.append("\tFROM T_IM_INCOMEINVOICE invoice ");
        sbSql.append("\tWHERE 1=1 ");
        if (companyNum != null && companyNum.trim().length() > 0) {
            sbSql.append(" AND fcompanyid =(select fid from t_org_company where fnumber='").append(companyNum).append("')");
        }
        if (startDate != null && startDate.trim().length() > 0) {
            sbSql.append(" \tAND FBIZDATE >=").append(this.startDateConvert(startDate));
        }
        if (endDate != null && endDate.trim().length() > 0) {
            sbSql.append(" \tAND FBIZDATE <=").append(this.endDateConvert(endDate));
        }
        if (invoiceType != null && invoiceType.trim().length() > 0 && this.typeConvert(invoiceType) != null) {
            sbSql.append(" \tAND FINVOICETYPE=").append(this.typeConvert(invoiceType));
        }
        if (status != null && status.trim().length() > 0 && this.inputStatusConvert(status) != null) {
            sbSql.append(" \tAND FSTATUS=").append(this.inputStatusConvert(status));
        }
        if (authenticStatus != null && authenticStatus.trim().length() > 0 && this.authenticConvert(authenticStatus) != null) {
            sbSql.append(" \tAND FAuthenticateStatus=").append(this.authenticConvert(authenticStatus));
        }
        return sbSql.toString();
    }

    private String getSql(String companyNum, String startDate, String endDate, String invoiceType, String status, String field) {
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("SELECT SUM(").append(field).append(") amountTotal");
        sbSql.append("\tFROM T_IM_MAKEINVOICE invoice ");
        sbSql.append("\tWHERE 1=1 ");
        if (companyNum != null && companyNum.trim().length() > 0) {
            sbSql.append(" AND fcompanyid =(select fid from t_org_company where fnumber='").append(companyNum).append("')");
        }
        if (startDate != null && startDate.trim().length() > 0) {
            sbSql.append(" \tAND FAPPLICATEDATE >=").append(this.startDateConvert(startDate));
        }
        if (endDate != null && endDate.trim().length() > 0) {
            sbSql.append(" \tAND FAPPLICATEDATE <=").append(this.endDateConvert(endDate));
        }
        if (invoiceType != null && invoiceType.trim().length() > 0 && this.typeConvert(invoiceType) != null) {
            sbSql.append(" \tAND FINVOICETYPE=").append(this.typeConvert(invoiceType));
        }
        if (status != null && status.trim().length() > 0 && this.statusConvert(status) != null) {
            sbSql.append(" \tAND FSTATUS=").append(this.statusConvert(status));
        }
        return sbSql.toString();
    }

    private String startDateConvert(String str) {
        return "{ts'" + str + " 00:00:00'}";
    }

    private String endDateConvert(String str) {
        return "{ts'" + str + " 23:59:59'}";
    }

    private String typeConvert(String invoiceType) {
        PayInvoiceTypeEnum typeEnum = (PayInvoiceTypeEnum)PayInvoiceTypeEnum.getEnumMap().get(invoiceType);
        return "-1".equals(typeEnum.getValue()) ? null : typeEnum.getValue();
    }

    private String statusConvert(String status) {
        InvoiceBillStatus statusEnum = (InvoiceBillStatus)((Object)InvoiceBillStatus.getEnumMap().get(status));
        return statusEnum.getValue();
    }

    private String inputStatusConvert(String status) {
        IncomeStatusEnum statusEnum = (IncomeStatusEnum)((Object)IncomeStatusEnum.getEnumMap().get(status));
        return statusEnum.getValue();
    }

    private String authenticConvert(String authenticStatus) {
        IncomeAuthenticateStatusEnum authentic = (IncomeAuthenticateStatusEnum)((Object)IncomeAuthenticateStatusEnum.getEnumMap().get(authenticStatus));
        return authentic.getValue();
    }
}

